unit Grafx; {Contains all the Darkside Graphics Functions}
INTERFACE
uses General,Strings,Crt,IbmCom;

  PROCEDURE GoodBye(questions : BOOLEAN);
  FUNCTION  StrCat(str1, str2 : string) : string;
  PROCEDURE OpenAnsi;
  PROCEDURE CloseAnsi;
  PROCEDURE DispAnsi(filename: string);
  PROCEDURE GoXY(X,Y: integer);
  PROCEDURE WriteYN(yesno: Boolean);
  PROCEDURE WriteCh(toprint: char);
  FUNCTION  GetChar:char;
  PROCEDURE SendCR;
  PROCEDURE ClrScr;
  PROCEDURE WriteStr(toprint: string);
  PROCEDURE AnsiColor(color: byte; Blink: Boolean; Bright: Boolean);
  PROCEDURE GetStr(Dots : Boolean);
  FUNCTION  GetYN : Boolean;
  FUNCTION  StrComp(str1,str2 : string) : Boolean;
  FUNCTION  LoadUser(handle : string) : Boolean;
  PROCEDURE PressAnyKey;
  FUNCTION  StrUp(toupper : string) : string;

var
 ansisys:text;

IMPLEMENTATION

 PROCEDURE GoodBye(Questions : BOOLEAN);
  var test : Boolean;
  Begin
   if Questions then
    Begin
     ClrScr;
     WriteStr('Are You Sure that You Want to Go?');
     test := GetYN;
     if test then
      Begin
       DispAnsi('Goodbye.Ans');
       ClrScr;
       CloseAnsi;
       Com_Deinstall;
       SaveConfig;
       WriteUser;
       Writeln;
       Writeln;
       TextColor(WHITE);
       Writeln('                      Thank You for Using Darkside ' + Version);
       Writeln('                       (c) 1994,95 S+M Enterprises Inc.');
       Writeln('                      Written By: Adam Simnett (Mr.Happy)');
       Writeln;
       Writeln;
       Writeln;
       Writeln;
       Writeln;
       halt(0);
      End
    End
   else
    Begin
     ClrScr;
     CloseAnsi;
     Com_Deinstall;
     SaveConfig;
     WriteUser;
     Writeln;
     Writeln;
     TextColor(WHITE);
     Writeln('                      Thank You for Using Darkside ' + Version);
     Writeln('                       (c) 1994,95 S+M Enterprises Inc.');
     Writeln('                      Written By: Adam Simnett (Mr.Happy)');
     Writeln;
     Writeln;
     Writeln;
     Writeln;
     Writeln;
     halt(0);
    End;
  End;

 FUNCTION StrCat(str1, str2 : string) : string;
  var count : byte;
      temp  : byte;
      tempstr : string;
  Begin
   tempstr[0] := chr(length(str1) + length(str2));
   for count:= 1 to length(str1) do
    tempstr[count] := str1[count];
   for temp := 1 to length(str2) do
    tempstr[count + temp] := str2[temp];
   StrCat := Tempstr;
  End;

 FUNCTION StrUp(toupper : string) : string;
  var count : byte;
      tempstr : string;
  Begin
   tempstr[0] := toupper[0];
   for count := 1 to length(toupper) do
    tempstr[count] := Upcase(toupper[count]);
   StrUp := tempstr;
  End;


 PROCEDURE PressAnyKey;
  var inkey : char;
  Begin
   GoXY(1,24);
   WriteStr('~                        |14Press Any Key to Continue');
   Com_Flush_Rx;
   inkey := GetChar;
  End;

 FUNCTION LoadUser(handle : string) : BOOLEAN;
  var
   users : file of USERCARD;
   done : boolean;
   count : integer;
  Begin
   done := False;
   {$I-}
   Assign(Users,'Users.Dat');
   reset(Users);
   {$I+}
   if IORESULT <> 0 then
    Begin
     Close(Users);
     ClrScr;
     Writeln('USERS.DAT if Missing or Damaged!!!!');
     Halt(1);
    End
   else
    count := 1;
    while ((done <> TRUE) and (Eof(users) <> TRUE)) do
     Begin
      Read(Users,Usernfo);
      if StrComp(Usernfo.Handle,Handle) = TRUE then
        Done := TRUE
      else
       inc(count);
     end;
   close(Users);
   if Done = TRUE then
    Begin
     LoadUser := TRUE;
     UserNum := count;
    End
   else
    LoadUser := FALSE;
  End;

 FUNCTION StrComp(str1,str2 : string) : Boolean;
  var cnt:integer;
  begin
   StrComp:=false;
   if length(str1)<>length(str2) then exit;
   for cnt:=1 to length(str1) do
     if upcase(str1[cnt])<>upcase(str2[cnt])
       then exit;
   StrComp:=true
  end;

 PROCEDURE OpenAnsi;
  Begin
   Assign(Ansisys,'');
   Rewrite(Ansisys);
  End;

 PROCEDURE CloseAnsi;
  Begin
   Close(Ansisys);
  End;

 PROCEDURE DispAnsi(filename: String);
  var
   path: string;
   ansi: text;
   temp: char;
   shit: string;
   count: byte;
   lookpipe : boolean;
   pipecode : string[2];
   strs : string[3];
  Begin
   path := BBSnfo.AnsiDir + filename;
   WriteCh(#13);
   if exist(path) then
    Begin
     Assign(Ansi,path);
     reset(Ansi);
     count := 1;
      while Eof(Ansi)<>TRUE do
       Begin
        Read(Ansi,temp);
        if temp = '|' then
         Begin
          Read(Ansi,temp);
          pipecode[1] := temp;
          Read(ansi,temp);
       pipecode[2] := temp;
        if ((upcase(pipecode[1]) = 'U') and (upcase(pipecode[2]) = 'H')) then
	   Begin
	    WriteStr(Usernfo.Handle);
	   end
	 else
	 if ((upcase(pipecode[1]) = 'U') and (upcase(pipecode[2]) = 'P')) then
	   Begin
	    WriteStr(Usernfo.Password);
	   end
	 else
	 if ((upcase(pipecode[1]) = 'U') and (upcase(pipecode[2]) = 'N')) then
	  Begin
	   WriteStr(Usernfo.UserNote);
	  end
	 else
	  if ((upcase(pipecode[1]) = 'U') and (upcase(pipecode[2]) = 'V')) then
	   Begin
	    WriteStr(Usernfo.VoiceNum);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'U') and (upcase(pipecode[2]) = 'B')) then
	   Begin
	    WriteStr(Usernfo.DataNum);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'L') and (upcase(pipecode[2]) = 'F')) then
	   Begin
	    SendCR;
	   end
	 else
	  if ((upcase(pipecode[1]) = 'M') and (upcase(pipecode[2]) = 'L')) then
	   Begin
	    str(Usernfo.mainlevel,strs);
	    WriteStr(strs);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'U') and (upcase(pipecode[2]) = 'K')) then
	   Begin
	    str(Usernfo.BytesUp,strs);
	    WriteStr(strs);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'U') and (upcase(pipecode[2]) = 'F')) then
	   Begin
	    str(Usernfo.filesup,strs);
	    WriteStr(strs);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'D') and (upcase(pipecode[2]) = 'K')) then
	   Begin
	    str(Usernfo.BytesDn,strs);
	    WriteStr(strs);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'D') and (upcase(pipecode[2]) = 'F')) then
	   Begin
	    str(Usernfo.filesdn,strs);
	    WriteStr(strs);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'L') and (upcase(pipecode[2]) = 'C')) then
	   Begin
	    WriteStr(BBSnfo.LastCaller);
	    WriteStr(' (');
	    WriteStr(BBSnfo.LastCallerUN);
	    WriteStr(')');
	   end
	 else
	  if ((upcase(pipecode[1]) = 'A') and (upcase(pipecode[2]) = 'D')) then
	   Begin
	    WriteStr(Usernfo.Address);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'C') and (upcase(pipecode[2]) = 'T')) then
	   Begin
	    WriteStr(Usernfo.comptype);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'T') and (upcase(pipecode[2]) = 'O')) then
	   Begin
	    Str(Usernfo.timeson,strs);
	    WriteStr(strs);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'T') and (upcase(pipecode[2]) = 'L')) then
	   Begin
	    Str((Usernfo.TimeAllowed - TimeOn),strs);
	    WriteStr(strs);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'F') and (upcase(pipecode[2]) = 'B')) then
	   Begin
	    str(FileBatch,strs);
	    WriteStr(strs);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'L') and (upcase(pipecode[2]) = 'O')) then
	   Begin
	    WriteCh(Usernfo.Lastdateon[0]);
	    WriteCh(Usernfo.Lastdateon[1]);
	    WriteCh('/');
	    WriteCh(Usernfo.Lastdateon[3]);
	    WriteCh(Usernfo.Lastdateon[4]);
	    WriteCh('/');
	    WriteCh(Usernfo.Lastdateon[5]);
	    WriteCh(Usernfo.Lastdateon[6]);
	    WriteStr(' @ ');
	    WriteCh(Usernfo.LastTimeOn[0]);
	    WriteCh(Usernfo.LastTimeOn[1]);
	    WriteCh(':');
	    WriteCh(Usernfo.LastTimeOn[2]);
	    WriteCh(Usernfo.LastTimeOn[3]);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'X') and (upcase(pipecode[2]) = 'M')) then
	   Begin
	    WriteYN(Usernfo.expertmode);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'T') and (upcase(pipecode[2]) = 'P')) then
	   Begin
	    str(Usernfo.totalposts,strs);
	    WriteStr(strs);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'T') and (upcase(pipecode[2]) = 'E')) then
	   Begin
	    str(Usernfo.totalemail,strs);
	    WriteStr(strs);
           end
	 else
	  if ((upcase(pipecode[1]) = 'B') and (upcase(pipecode[2]) = 'D')) then
	   Begin
	    WriteCh(Usernfo.DOB[0]);
	    WriteCh(Usernfo.DOB[1]);
	    WriteCh('/');
	    WriteCh(Usernfo.DOB[2]);
	    WriteCh(Usernfo.DOB[3]);
	    WriteCh('/');
	    WriteCh(Usernfo.DOB[4]);
	    WriteCh(Usernfo.DOB[5]);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'C') and (upcase(pipecode[2]) = 'Y')) then
	   Begin
	    WriteStr(Usernfo.City);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'S') and (upcase(pipecode[2]) = 'T')) then
	   Begin
	    WriteStr(Usernfo.State);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'Z') and (upcase(pipecode[2]) = 'P')) then
	   Begin
	    WriteStr(Usernfo.Zip);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'F') and (upcase(pipecode[2]) = 'L')) then
	   Begin
	    str(Usernfo.filelevel,strs);
	    WriteStr(strs);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'C') and (upcase(pipecode[2]) = 'M')) then
	   Begin
	    WriteYN(Usernfo.ClearMsg);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'S') and (upcase(pipecode[2]) = 'M')) then
	   Begin
	    WriteYN(Usernfo.ScrollMsg);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'D') and (upcase(pipecode[2]) = 'K')) then
	   Begin
	    WriteYN(Usernfo.LongHeadr);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'F') and (upcase(pipecode[2]) = 'S')) then
	   Begin
	    WriteYN(Usernfo.FullScrEdit);
	   end
	 else
	  if ((pipecode[1] = '7') and (pipecode[2] = '9')) then
	   Begin
	    WriteYN(Usernfo.Column79);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'B') and (upcase(pipecode[2]) = 'R')) then
	   Begin
	    str(Usernfo.ByteRatio,strs);
	    WriteStr(strs);
	    WriteStr(':1');
	   end
	 else
	  if ((upcase(pipecode[1]) = 'C') and (upcase(pipecode[2]) = 'L')) then
	   Begin
	    WriteStr('[1D');
	   end
	 else
	  if ((upcase(pipecode[1]) = 'C') and (upcase(pipecode[2]) = 'R')) then
	   Begin
	    WriteStr('[1C');
	   end
	 else
	  if ((upcase(pipecode[1]) = 'C') and (upcase(pipecode[2]) = 'U')) then
	   Begin
	    WriteStr('[1A');
	   end
	 else
	  if ((upcase(pipecode[1]) = 'C') and (upcase(pipecode[2]) = 'D')) then
	   Begin
	    WriteStr('[1B');
	   end
	 else
	  if ((upcase(pipecode[1]) = 'S') and (upcase(pipecode[2]) = 'C')) then
	   Begin
	    ClrScr;
	   end
	 else
	  if ((upcase(pipecode[1]) = 'M') and (upcase(pipecode[2]) = 'S')) then
	   Begin
	    WriteStr(msg.title);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'M') and (upcase(pipecode[2]) = 'T')) then
	   Begin
	    WriteStr(msg.sendto);
	   end
	 else
	  if ((upcase(pipecode[1]) = 'M') and (upcase(pipecode[2]) = 'F')) then
	   Begin
	    if msg.Anon = FALSE then
              WriteStr(msg.note)
            else
              WriteStr('Anonymous Fucker!');
	   end
	 else
	  if ((upcase(pipecode[1]) = 'M') and (upcase(pipecode[2]) = 'P')) then
	   Begin
	   end
	 else
	  if ((upcase(pipecode[1]) = 'M') and (upcase(pipecode[2]) = 'C')) then
	   Begin
	    str(msg.numlines,strs);
	    WriteStr(strs);
	   end

       else
        Begin
         Write('der');
         WriteCh(pipecode[1]);
         WriteCh(pipecode[2]);
         lookpipe := FALSE;
         count := 1;
        End;
      end
     else
     if temp = '~' then
      SendCr
     else
      WriteCh(temp);
    End;
    close(Ansi);
    end
  End;

 PROCEDURE GoXY(X,Y: INTEGER);
  var
   xstr,ystr: string;
  Begin
   Str(X,XSTR);
   Str(Y,YSTR);
   Write(ansisys,'[' + YSTR + ';' + XSTR + 'f');
   if com_carrier then
     Com_TX_String('[' + YSTR + ';' + XSTR + 'f');
  End;

 PROCEDURE WriteYN(yesno: boolean);
  Begin
   if yesno = TRUE then
    WriteStr(BBSnfo.Yes)
   else
    WriteStr(BBSnfo.No);
  End;

 PROCEDURE WriteCh(toprint: char);
  Begin
   Write(Ansisys,toprint);
   if com_carrier then
     Com_Tx(toprint);
  End;

 PROCEDURE SendCR;
   Begin
    Write(#10);
    Write(#13);
    Com_Tx(#10);
    Com_Tx(#13);
    Com_Flush_Rx;
   End;

 PROCEDURE ClrScr;
   Begin
    Write(Ansisys,'[2J');
    WriteCh('');
    WriteCh('[');
    WriteCh('2');
    WriteCh('J');
   End;

 PROCEDURE AnsiColor(color: byte; Blink: boolean; Bright: boolean);
  var
   colors: string[3];
  Begin
   if ((Blink = FALSE) and (Bright = FALSE)) then
    WriteStr('[0;');
   if ((Blink = TRUE) and (Bright = TRUE)) then
    WriteStr('[1;5;');
   if ((Blink = FALSE) and (Bright = TRUE)) then
    WriteStr('[1;');
   if ((Blink = TRUE) and (Bright = FALSE)) then
    WriteStr('[5;');
   Str(color,colors);
   WriteStr(colors);
   WriteCh('m');
  End;

 PROCEDURE WriteStr(toprint : string);
  var
   count: byte;
   size: byte;
   strs: string[3];
  Begin
   count := 1;
   size := Length(toprint);
   while count <= size do
    Begin
     if toprint[count] = '~' then
       SendCr
     else
      if toprint[count] = '|' then
       Begin
        if (toprint[count+1]='0') then
	 Begin
	  if (toprint[count+2] = '0') then
	   Begin
	   AnsiColor(30,FALSE,FALSE);
	   count := count + 2;
	  End
	 else if (toprint[count+2] = '1') then
	  Begin
	   AnsiColor(31,FALSE,FALSE);
	   count := count + 2;
	  End
	 else if (toprint[count+2] = '2') then
	  Begin
	   AnsiColor(32,FALSE,FALSE);
	   count := count + 2;
	  End
	 else if (toprint[count+2] = '3') then
	  Begin
	   AnsiColor(33,FALSE,FALSE);
	   count := count + 2;
	  End
	 else if (toprint[count+2] = '4') then
	  Begin
	   AnsiColor(34,FALSE,FALSE);
	   count := count + 2;
	  End
	 else if (toprint[count+2] = '5') then
	  Begin	   AnsiColor(35,FALSE,FALSE);
	   count := count + 2;
	  End
	 else if (toprint[count+2] = '6') then
	  Begin	   AnsiColor(36,FALSE,FALSE);
	   count := count + 2;
	  End
	 else if (toprint[count+2] = '7') then
	  Begin	   AnsiColor(37,FALSE,FALSE);
	   count := count + 2;
	  End
         else
	  WriteCh('|');
	 End
       else if (toprint[count+1]='1') then
	Begin
	 if (toprint[count + 2] = '0')  then
	  Begin
	   AnsiColor(30,FALSE,TRUE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '1') then
	  Begin  AnsiColor(31,FALSE,TRUE);
	   count := count + 2;
          End
	 else if (toprint[count + 2] = '2') then
	  Begin  AnsiColor(32,FALSE,TRUE);
	   count := count + 2;
          End
	 else if (toprint[count + 2] = '3') then
	  Begin  AnsiColor(33,FALSE,TRUE);
	   count := count + 2;
          End
	 else if (toprint[count + 2] = '4') then
	  Begin  AnsiColor(34,FALSE,TRUE);
	   count := count + 2;
          End
	 else if (toprint[count + 2] = '5') then
	  Begin  AnsiColor(35,FALSE,TRUE);
	   count := count + 2;
          End
	 else if (toprint[count + 2] = '6') then
	  Begin  AnsiColor(36,FALSE,TRUE);
	   count := count + 2;
          End
	 else if (toprint[count + 2] = '7') then
	  Begin  AnsiColor(37,FALSE,TRUE);
	   count := count + 2;
          End
	 else
	  WriteCh('|');
        End
       else if (toprint[count+1]='2') then
	Begin
	 if (toprint[count + 2] = '0') then
	  Begin
	   AnsiColor(30,TRUE,FALSE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '1') then
	  Begin AnsiColor(31,TRUE,FALSE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '2') then
	  Begin AnsiColor(32,TRUE,FALSE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '3') then
	  Begin AnsiColor(33,TRUE,FALSE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '4') then
	  Begin AnsiColor(34,TRUE,FALSE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '5') then
	  Begin AnsiColor(35,TRUE,FALSE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '6') then
	  Begin AnsiColor(36,TRUE,FALSE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '7') then
	  Begin AnsiColor(37,TRUE,FALSE);
	   count := count + 2;
	  End
	 else
	  WriteCh('|');
        End
       else if (toprint[count+1]='3') then
	Begin
	 if (toprint[count + 2] = '0') then
	  Begin
	   AnsiColor(30,TRUE,TRUE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '1') then
	  Begin AnsiColor(31,TRUE,TRUE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '2') then
	  Begin AnsiColor(32,TRUE,TRUE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '3') then
	  Begin AnsiColor(33,TRUE,TRUE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '4') then
	  Begin AnsiColor(34,TRUE,TRUE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '5') then
	  Begin AnsiColor(35,TRUE,TRUE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '6') then
	  Begin AnsiColor(36,TRUE,TRUE);
	   count := count + 2;
	  End
	 else if (toprint[count + 2] = '7') then
	  Begin AnsiColor(37,TRUE,TRUE);
	   count := count + 2;
	  End
	 else
	  WriteCh('|');
	End
       else
        Begin
	 if ((upcase(toprint[count + 1]) = 'U') and (upcase(toprint[count +2]) = 'H')) then
	   Begin
	    WriteStr(Usernfo.Handle);
	    count := count + 2;
	   end
	 else
	 if ((upcase(toprint[count + 1]) = 'U') and (upcase(toprint[count +2]) = 'P')) then
	   Begin
	    WriteStr(Usernfo.Password);
	    count := count + 2;
	   end
	 else
	 if ((upcase(toprint[count + 1]) = 'U') and (upcase(toprint[count +2]) = 'N')) then
	  Begin
	   WriteStr(Usernfo.UserNote);
	   count := count + 2;
	  end
	 else
	  if ((upcase(toprint[count + 1]) = 'U') and (upcase(toprint[count +2]) = 'V')) then
	   Begin
	    WriteStr(Usernfo.VoiceNum);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'U') and (upcase(toprint[count + 2]) = 'B')) then
	   Begin
	    WriteStr(Usernfo.DataNum);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'L') and (upcase(toprint[count +2]) = 'F')) then
	   Begin
	    SendCR;
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'M') and (upcase(toprint[count +2]) = 'L')) then
	   Begin
	    str(Usernfo.mainlevel,strs);
	    WriteStr(strs);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'U') and (upcase(toprint[count +2]) = 'K')) then
	   Begin
	    str(Usernfo.BytesUp,strs);
	    WriteStr(strs);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'U') and (upcase(toprint[count +2]) = 'F')) then
	   Begin
	    str(Usernfo.filesup,strs);
	    WriteStr(strs);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'D') and (upcase(toprint[count +2]) = 'K')) then
	   Begin
	    str(Usernfo.BytesDn,strs);
	    WriteStr(strs);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'D') and (upcase(toprint[count +2]) = 'F')) then
	   Begin
	    str(Usernfo.filesdn,strs);
	    WriteStr(strs);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'L') and (upcase(toprint[count +2]) = 'C')) then
	   Begin
	    WriteStr(BBSnfo.LastCaller);
	    WriteStr(' (');
	    WriteStr(BBSnfo.LastCallerUN);
	    WriteStr(')');
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'A') and (upcase(toprint[count +2]) = 'D')) then
	   Begin
	    WriteStr(Usernfo.Address);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'C') and (upcase(toprint[count +2]) = 'T')) then
	   Begin
	    WriteStr(Usernfo.comptype);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'T') and (upcase(toprint[count +2]) = 'O')) then
	   Begin
	    Str(Usernfo.timeson,strs);
	    WriteStr(strs);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'T') and (upcase(toprint[count +2]) = 'L')) then
	   Begin
	    Str((Usernfo.TimeAllowed - TimeOn),strs);
	    WriteStr(strs);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'F') and (upcase(toprint[count +2]) = 'B')) then
	   Begin
	    str(FileBatch,strs);
	    WriteStr(strs);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'L') and (upcase(toprint[count +2]) = 'O')) then
	   Begin
	    WriteCh(Usernfo.Lastdateon[0]);
	    WriteCh(Usernfo.Lastdateon[1]);
	    WriteCh('/');
	    WriteCh(Usernfo.Lastdateon[3]);
	    WriteCh(Usernfo.Lastdateon[4]);
	    WriteCh('/');
	    WriteCh(Usernfo.Lastdateon[5]);
	    WriteCh(Usernfo.Lastdateon[6]);
	    WriteStr(' @ ');
	    WriteCh(Usernfo.LastTimeOn[0]);
	    WriteCh(Usernfo.LastTimeOn[1]);
	    WriteCh(':');
	    WriteCh(Usernfo.LastTimeOn[2]);
	    WriteCh(Usernfo.LastTimeOn[3]);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'X') and (upcase(toprint[count +2]) = 'M')) then
	   Begin
	    WriteYN(Usernfo.expertmode);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'T') and (upcase(toprint[count +2]) = 'P')) then
	   Begin
	    str(Usernfo.totalposts,strs);
	    WriteStr(strs);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'T') and (upcase(toprint[count +2]) = 'E')) then
	   Begin
	    str(Usernfo.totalemail,strs);
	    WriteStr(strs);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'B') and (upcase(toprint[count +2]) = 'D')) then
	   Begin
	    WriteCh(Usernfo.DOB[0]);
	    WriteCh(Usernfo.DOB[1]);
	    WriteCh('/');
	    WriteCh(Usernfo.DOB[2]);
	    WriteCh(Usernfo.DOB[3]);
	    WriteCh('/');
	    WriteCh(Usernfo.DOB[4]);
	    WriteCh(Usernfo.DOB[5]);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'C') and (upcase(toprint[count +2]) = 'Y')) then
	   Begin
	    WriteStr(Usernfo.City);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'S') and (upcase(toprint[count +2]) = 'T')) then
	   Begin
	    WriteStr(Usernfo.State);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'Z') and (upcase(toprint[count +2]) = 'P')) then
	   Begin
	    WriteStr(Usernfo.Zip);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'F') and (upcase(toprint[count +2]) = 'L')) then
	   Begin
	    str(Usernfo.filelevel,strs);
	    WriteStr(strs);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'C') and (upcase(toprint[count +2]) = 'M')) then
	   Begin
	    WriteYN(Usernfo.ClearMsg);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'S') and (upcase(toprint[count +2]) = 'M')) then
	   Begin
	    WriteYN(Usernfo.ScrollMsg);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'D') and (upcase(toprint[count +2]) = 'K')) then
	   Begin
	    WriteYN(Usernfo.LongHeadr);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'F') and (upcase(toprint[count +2]) = 'S')) then
	   Begin
	    WriteYN(Usernfo.FullScrEdit);
	    count := count + 2;
	   end
	 else
	  if ((toprint[count + 1] = '7') and (toprint[count +2] = '9')) then
	   Begin
	    WriteYN(Usernfo.Column79);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'B') and (upcase(toprint[count +2]) = 'R')) then
	   Begin
	    str(Usernfo.ByteRatio,strs);
	    WriteStr(strs);
	    WriteStr(':1');
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'C') and (upcase(toprint[count +2]) = 'L')) then
	   Begin
	    WriteStr('[1D');
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'C') and (upcase(toprint[count +2]) = 'R')) then
	   Begin
	    WriteStr('[1C');
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'C') and (upcase(toprint[count +2]) = 'U')) then
	   Begin
	    WriteStr('[1A');
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'C') and (upcase(toprint[count +2]) = 'D')) then
	   Begin
	    WriteStr('[1B');
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'S') and (upcase(toprint[count +2]) = 'C')) then
	   Begin
	    ClrScr;
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'M') and (upcase(toprint[count + 2]) = 'S')) then
	   Begin
	    WriteStr(msg.Title);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'M') and (upcase(toprint[count + 2]) = 'T')) then
	   Begin
	    WriteStr(msg.sendto);
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'M') and (upcase(toprint[count + 2]) = 'F')) then
	   Begin
	    if msg.anon = false then
             WriteStr(msg.note)
            else
             WriteStr('Anonymous Fucker!');
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'M') and (upcase(toprint[count + 2]) = 'P')) then
	   Begin
	    {msg Status}
	    count := count + 2;
	   end
	 else
	  if ((upcase(toprint[count + 1]) = 'M') and (upcase(toprint[count + 2]) = 'C')) then
	   Begin
	    str(msg.numlines,strs);
	    WriteStr(strs);
	    count := count + 2;
	   end
         else
          WriteCh('|');
	end;
       end
      else
       WriteCh(toprint[count]);
     inc(count);
    End;
  End;

 FUNCTION GetChar : Char;
  var
   inkey : Char;
  Begin
   inkey := #0;
   Com_Flush_Rx;
   while inkey = #0 do
    Begin
     if not ((Com_carrier) or (locallogon)) then Goodbye(False);
     if keypressed then
      inkey := readkey
     else
      if not Com_Rx_Empty then
       inkey := Com_Rx;
    End;
   GetChar := inkey;
  End;

 PROCEDURE GetStr(DOTS : Boolean);
  var
   count : byte;
   key : char;
   done : boolean;
  Begin
   key := #0;
   done := FALSE;
   count := 1;
   while not DONE do
    Begin
     key := GetChar;
     if key = #8 then
      Begin
       if count > 1 then
        Begin
         dec(count);
         WriteCh(key);
         WriteCh(' ');
         WriteCh(key);
        End
      End
     else
      if key = #13 then
       Begin
        input[0] := chr(count - 1);
        done := TRUE;
       End
     else
      Begin
       input[count] := key;
       inc(count);
       if DOTS then
        WriteCh(BBSnfo.echodot)
       else
        WriteCh(key);
      End;
    End;
  End;

 FUNCTION GetYN : BOOLEAN;
  var
   inkey : char;
  Begin
   inkey := #0;
   while inkey = #0 do
    Begin
     inkey := GetChar;
     if inkey in['Y','y'] then
      Begin
       WriteCh(inkey);
       GetYN := TRUE
      end
    else
     if inkey in['N','n'] then
      Begin
       WriteCh(inkey);
       GetYN := FALSE
      end
    else
      inkey := #0;
    End;
  End;

Begin
 OpenAnsi;
End.