{$I+,N-,V-,B-,S-,R-,D-,L-}


unit UserStuf;

interface

   uses crt,dos,
   gentypes,configrt,modem,statret,gensubs,subs1,subs2,mainr2;


   type
      pointer_rec = record
         offset:  word;
         segment: word;
      end;

   type
      dos_filename = string[64];
      dos_handle   = word;

      long_integer = record
         lsw: word;
         msw: word;
      end;

      seek_modes = (seek_start {0},
                    seek_cur   {1},
                    seek_end   {2});

      open_modes = (open_read  {h40},
                    open_write {h41},
                    open_update{h42});

      dos_time_functions = (time_get,
                            time_set);

   const
      dos_error    = $FFFF;

   var
      dos_regs:     registers;
      dos_name:     dos_filename;


   procedure dos_call;

   function dos_open(name:      dos_filename;
                     mode:      open_modes):  dos_handle;

   function dos_create(name:    dos_filename): dos_handle;

   function dos_read( handle:   dos_handle;
                      var       buffer;
                      bytes:    word): word;

   procedure dos_write(handle:  dos_handle;
                       var      buffer;
                       bytes:   word);

   function dos_write_failed:   boolean;

   procedure dos_lseek(handle:  dos_handle;
                       offset:  longint;
                       method:  seek_modes);

   procedure dos_rseek(handle:  dos_handle;
                       recnum:  word;
                       recsiz:  word;
                       method:  seek_modes);

   function dos_tell: longint;

   procedure dos_find_eof(fd:   dos_handle);

   procedure dos_close(handle:  dos_handle);

   procedure dos_unlink(name:   dos_filename);

   procedure dos_file_times(fd:       dos_handle;
                            func:     dos_time_functions;
                            var time: word;
                            var date: word);

   function dos_jdate(time,date: word): longint;

   function dos_exists(name: dos_filename): boolean;

   procedure discon;

   procedure allstatus;

   function dos_maxavail: longint;

   procedure dos_getmem(var ptrvar; size: word);

   procedure dos_freemem(var ptrvar);



implementation

procedure dos_call;
var
   msg:  string;
begin
   msdos(dos_regs);

   if (dos_regs.flags and Fcarry) <> 0 then
   begin
      case dos_regs.ax of
         2:   msg := 'file not found';
         3:   msg := 'dir not found';
         4:   msg := 'too many open files';
         5:   msg := 'access denied';
         else str(dos_regs.ax,msg);
      end;
{$I-}
      writeln(' DOS error [',msg,'] on file [',dos_name,'] ');
{$i+}
      dos_regs.ax := dos_error;
   end;
end;


procedure prepare_dos_name(name: dos_filename);
begin
   while (name <> '') and (name[length(name)] <= ' ') do
      dec(name[0]);
   if name = '' then
      name := 'Nul';
   dos_name := name;
   dos_name[length(dos_name)+1] := #0;
   dos_regs.ds := seg(dos_name);
   dos_regs.dx := ofs(dos_name)+1;
end;


function dos_open(name:    dos_filename;
                  mode:    open_modes):  dos_handle;
var
   try: integer;
const
   retry_count = 3;

begin
   for try := 1 to retry_count do
   begin
      dos_regs.ax := $3d40 + ord(mode);
      prepare_dos_name(name);
      msdos(dos_regs);

      if (dos_regs.flags and Fcarry) = 0 then
      begin
         dos_open := dos_regs.ax;
         exit;
      end;
   end;

   dos_open := dos_error;
end;


function dos_create(name:    dos_filename): dos_handle;
begin
   dos_regs.ax := $3c00;
   prepare_dos_name(name);
   dos_regs.cx := 0;   {attrib}
   dos_call;
   dos_create := dos_regs.ax;
end;


function dos_read( handle:  dos_handle;
                   var      buffer;
                   bytes:   word): word;
begin
   dos_regs.ax := $3f00;
   dos_regs.bx := handle;
   dos_regs.cx := bytes;
   dos_regs.ds := seg(buffer);
   dos_regs.dx := ofs(buffer);
   dos_call;
   dos_read := dos_regs.ax;
end;


procedure dos_write(handle:  dos_handle;
                    var      buffer;
                    bytes:   word);
begin
   dos_regs.ax := $4000;
   dos_regs.bx := handle;
   dos_regs.cx := bytes;
   dos_regs.ds := seg(buffer);
   dos_regs.dx := ofs(buffer);
   dos_call;
   dos_regs.cx := bytes;
end;

function dos_write_failed: boolean;
begin
   dos_write_failed := dos_regs.ax <> dos_regs.cx;
end;


procedure dos_lseek(handle:  dos_handle;
                    offset:  longint;
                    method:  seek_modes);
var
   pos:  long_integer absolute offset;

begin
   dos_regs.ax := $4200 + ord(method);
   dos_regs.bx := handle;
   dos_regs.cx := pos.msw;
   dos_regs.dx := pos.lsw;
   dos_call;
end;


procedure dos_rseek(handle:  dos_handle;
                    recnum:  word;
                    recsiz:  word;
                    method:  seek_modes);
var
   offset: longint;
   pos:    long_integer absolute offset;

begin
   offset := longint(recnum) * longint(recsiz);
   dos_regs.ax := $4200 + ord(method);
   dos_regs.bx := handle;
   dos_regs.cx := pos.msw;
   dos_regs.dx := pos.lsw;
   dos_call;
end;


function dos_tell: longint;
  {call immediately after dos_lseek or dos_rseek}
var
   pos:  long_integer;
   li:   longint absolute pos;
begin
   pos.lsw := dos_regs.ax;
   pos.msw := dos_regs.dx;
   dos_tell := li;
end;


procedure dos_find_eof(fd: dos_handle);
   {find end of file, skip backward over ^Z eof markers}
var
   b: char;
   n: word;
   i: word;
   p: longint;
   temp: array[1..128] of char;

begin
   dos_lseek(fd,0,seek_end);
   p := dos_tell-1;
   if p < 0 then
      exit;

   p := p and $FFFF80;
   {search forward for the eof marker}
   dos_lseek(fd,p,seek_start);
   n := dos_read(fd,temp,sizeof(temp));
   i := 1;

   while (i <= n) and (temp[i] <> ^Z) do
   begin
      inc(i);
      inc(p);
   end;

   {backup to overwrite the eof marker}
   dos_lseek(fd,p,seek_start);
end;


procedure dos_close(handle:  dos_handle);
begin
   dos_regs.ax := $3e00;
   dos_regs.bx := handle;
   msdos(dos_regs);  {dos_call;}
end;


procedure dos_unlink(name:    dos_filename);
   {delete a file, no error message if file doesn't exist}
begin
   dos_regs.ax := $4100;
   prepare_dos_name(name);
   msdos(dos_regs);
end;


procedure dos_file_times(fd:       dos_handle;
                         func:     dos_time_functions;
                         var time: word;
                         var date: word);
begin
   dos_regs.ax := $5700 + ord(func);
   dos_regs.bx := fd;
   dos_regs.cx := time;
   dos_regs.dx := date;
   dos_call;
   time := dos_regs.cx;
   date := dos_regs.dx;
end;


function dos_jdate(time,date: word): longint;
begin

(***
     write(' d=',date:5,' t=',time:5,' ');
     write('8',   (date shr 9) and 127:1); {year}
     write('/',   (date shr 5) and  15:2); {month}
     write('/',   (date      ) and  31:2); {day}
     write(' ',   (time shr 11) and 31:2); {hour}
     write(':',   (time shr  5) and 63:2); {minute}
     write(':',   (time shl  1) and 63:2); {second}
     writeln(' j=', (longint(date) shl 16) + longint(time));
 ***)

   dos_jdate := (longint(date) shl 16) + longint(time);
end;


function dos_exists(name: dos_filename): boolean;
var
   DirInfo:     SearchRec;

begin
   prepare_dos_name(name);
   FindFirst(dos_name,$21,DirInfo);
   if (DosError <> 0) then
      dos_exists := false
   else
      dos_exists := true;
end;


procedure allstatus;

var vot:integer;
var lev:real;
begin

 clearscr;
 movexy (1,8);
   writeln (^R'                    ͻ');
   writeln (^R'                            '^P'   User Main Level'^R'           ');
   writeln (^R'                     '^P'Name'^R'          :                     ');
   writeln (^R'                     '^P'Note'^R'          :                     ');
   writeln (^R'                     '^P'Level'^R'         :                     ');
   writeln (^R'                     '^P'Password'^R'      :                     ');
   writeln (^R'                     '^P'Phone'^R'         :                     ');
   writeln (^R'                     '^P'Time on'^R'       :                     ');
   writeln (^R'                     '^P'Time Left'^R'     :                     ');
   writeln (^R'                     '^P'Voting Record'^R' :                     ');
   writeln (^R'                     '^P'Wanted Status'^R' :                     ');
     if useqr then begin
      calcqr;
   writeln (^R'                     '^P'Quality Rating'^R':                     ');
  end;
   writeln (^R'                    ͼ');
  printxy (39,11,urec.handle);
  printxy (39,12,urec.note);
  printxy (39,13,strr(urec.level));
  printxy (39,14,urec.password);
  printxy (39,15,urec.phonenum);
  printxy (39,16,streal(urec.totaltime));
  printxy (39,17,strr(urec.timetoday));
  movexy (1,17);
   write (^R'                     '^P'Voting Record'^R' : ');
   for vot:=1 to maxtopics do begin          { x,y = 38,18 }
      if vot<>1 then write (',');
     write (^S,urec.voted[vot]);
   end;
  printxy (39,19,yesno(wanted in urec.config)+^R);
  if useqr then begin
     calcqr;
   printxy (39,20,strr(qr));
  end;
  printxy (1,1,^R+'ͻ');
  printxy (1,2,^R+'                            '^P'File Transfer Section'^R'                             ');
  printxy (1,3,^R+' '^P'Transfer Level '^R':                         '^P'Uploaded K  '^R':                       ');
  printxy (1,4,^R+' '^P'Transfer Points'^R':                         '^P'Downloaded K'^R':                       ');
  printxy (1,5,^R+' '^P'Uploads  '^R'      :                         '^P'File K Ratio'^R':                       ');
  printxy (1,6,^R+' '^P'Downloads'^R'      :                                                             ');
  printxy (1,7,^R+' '^P'U/D Ratio'^R'      :                                                             ');
  printxy (1,8,^R+'ͼ');
  printxy (20,3,strr(urec.udlevel));
  printxy (20,4,strr(urec.udpoints));
  printxy (20,5,strr(urec.uploads));
  printxy (20,6,strr(urec.downloads));
  printxy (20,7,strr(percent(urec.uploads,urec.downloads))+'%');
  printxy (58,3,streal(urec.upk/1000));
  printxy (58,4,streal(urec.downk/1000));
  printxy (58,5,streal(ratio(urec.upk,urec.downk))+'%');
  printxy (1,09,^R'Ŀ');
  printxy (1,10,^R'                  ');
  printxy (1,11,^R' '^P'Level '^R'   :       ');
  printxy (1,12,^R' '^P'Uploads  '^R':       ');
  printxy (1,13,^R' '^P'Downloads'^R':       ');
  printxy (1,14,^R' '^P'Ratio '^R'   :       ');
  printxy (1,15,^R'');
  printxy (5,10,^P+'Gfile Status');
  printxy (14,11,strr(urec.gflevel));
  printxy (14,12,strr(urec.gfuploads));
  printxy (14,13,strr(urec.gfdownloads));
  printxy (14,14,strr(percent(urec.gfuploads,urec.gfdownloads))+'%');
  printxy (60,09,^R'Ŀ');
  printxy (60,10,^R' '^P'Posts'^R'    :        ');
  printxy (60,11,^R' '^P'Calls'^R'    :        ');
  printxy (60,12,^R' '^P'PCR  '^R'    :        ');
  printxy (60,13,^R' '^P'Last Date'^R':        ');
  printxy (60,14,^R' '^P'Last Time'^R':        ');
  printxy (60,15,^R'');
  printxy (73,10,strr(urec.nbu));
  printxy (73,11,strr(urec.numon));
  printxy (73,12,strr(percent(urec.nbu,urec.numon))+'%');
  if laston<>0 then printxy (73,13,datestr(laston)) else
         printxy (73,13,'None.');
  if laston<>0 then printxy (73,14,timestr(laston)) else
         printxy (73,14,'None.');
  movexy (1,20);
   end;
procedure discon;
begin
       unum:=-1;
       disconnect;
end;
   function dos_maxavail: longint;
   var
      reg:     registers;
   begin
      reg.ah := $48;
      reg.bx := $FFFF;
      msdos(reg);
      dos_maxavail := longint(reg.bx) shl 4;
   end;

   procedure dos_getmem(var ptrvar; size: word);
   var
      block:   pointer_rec absolute ptrvar;
      reg:     registers;
   begin
      reg.ah := $48;
      reg.bx := (size+15) div 16;
      msdos(reg);

      if (reg.flags and Fcarry) <> 0 then
      begin
         writeln('dos_getmem: can''t allocate ',size,' bytes.');
         halt(99);
      end;

      block.segment := reg.ax;
      block.offset := 0;
   end;

   procedure dos_freemem(var ptrvar);
   var
      block:   pointer_rec absolute ptrvar;
      reg:     registers;
   begin
      if (block.segment = 0) and (block.offset = 0) then
         exit;

      reg.ah := $49;
      reg.es := block.segment;
      msdos(reg);

      if (reg.flags and Fcarry) <> 0 then
      begin
         writeln('dos_freemem: dispose failure');
         halt(99);
      end;

      block.segment := 0;
      block.offset := 0;
   end;

end.
