{$R-,S-,I-,D-,F+,V-,B-,N-,L+,O+ }
{$M 65500,0,0 }

unit rumorz;

interface

uses crt,dos,
     gentypes,configrt,modem,statret,gensubs,subs1,windows,subs2;

procedure rumormenu;
procedure randomrumor;

implementation

procedure rumormenu;
var r,ar:rumorrec;

  function numrumors:integer;
  begin
    numrumors:=filesize(rfile)
  end;

  procedure seekrfile (n:integer);
  begin
    seek (rfile,n-1)
  end;

  procedure openrfile;
  var n:integer;
  begin
    n:=ioresult;
    assign (rfile,'Rumors.Dat');
    reset (rfile);
    if ioresult<>0 then begin
      close (rfile);
      n:=ioresult;
      rewrite (rfile)
    end
  end;

  procedure listrumors;
  var cnt:integer;
      b:boolean;
      n1,n2:integer;
  begin
    writeln;
    ansireset;
    if numrumors<1 then begin
     writeln ('There are no Rumors!');
     exit;
    end;
    b:=true;
    seekrfile (1);
    writehdr ('Rumors List');
    parserange (numrumors,n1,n2);
    if n1=0 then exit;
     for cnt:=n1 to n2 do begin
        read (rfile,r);
        if b then begin
         writeln
         (^P'#'^S'   Title                         '^U'Date      '^R'Author');
         if ascii then
         writeln
         (^S''^M^R);
         b:=false
        end;
        ansicolor (urec.promptcolor);
        tab (strr(cnt),4);
        ansicolor (urec.statcolor);
        tab (r.title,30);
        ansicolor (urec.inputcolor);
        tab (datestr(r.when),10);
        ansicolor (urec.regularcolor);
        if r.author='...!@ANON#$...' then
        begin
         write ('< Anonymous >');
         if ulvl>=readanonlvl then write (^R,' ('^S,r.author2,^R')');
         writeln;
        end
        else writeln (^S,r.author);
        ansireset;
        if break then exit;
        ansicolor (urec.regularcolor);
    end;
    if b then writestr ('There are no Rumors!')
  end;

  function getrnum (txt:mstr):integer;
  var n:integer;
  begin
    getrnum:=0;
    repeat
      writeln;
      writestr ('Rumor Number to '+txt+' [?/List]? *');
      if length(input)=0 then exit;
      if upcase(input[1])='?'
        then listrumors
        else begin
          n:=valu(input);
          if (n<1) or (n>numrumors) then begin
            writestr (^M'Number out of range!');
            exit
          end;
          seekrfile (n);
          read (rfile,r);
          if (ulvl<r.level) and (not issysop) then exit;
          getrnum:=n;
          exit
        end
    until hungupon
  end;

procedure showrumor (n:integer);
var rr:rumorrec;
begin
   seekrfile (n);
   read (rfile,rr);
   if ulvl<rr.level then exit;
   writeln;
   ansicolor (11);
   write ('"');
   ansicolor (9);
   write (rr.rumor);
   ansicolor (11);
   writeln ('"');
   ansireset;
end;

  procedure addrumor;
  var x,b:boolean;
      y,t:text;
      cdir,cddir:lstr;
      n:integer;
      z:anystr;
      apecks:rumorrec;

  function matchtitle (f:sstr):integer;
  var cnt:integer;
      monark:rumorrec;
  begin
    for cnt:=1 to numrumors do begin
      seekrfile (cnt);
      read (rfile,monark);
      if match (monark.title,f) then begin
        matchtitle:=cnt;
        ansireset;
        exit
      end
    end;
    matchtitle:=0
  end;

    begin
    if ulvl<2 then begin
     reqlevel (2);
     exit
    end;
    if numrumors>=999 then begin
     writeln;
     writeln ('Sorry, there are too many rumors now!');
     writeln ('Ask your Sysop to delete some.');
     exit
    end;
    ansireset;
    writehdr ('Adding a Rumor');
    buflen:=30;
    writeln ('      ()');
    writestr('Title: &');
    apecks.title:=input;
    if length(input)=0 then exit;
    if matchtitle(apecks.title)>0 then begin
     writeln;
     writeln ('Sorry, that Rumor already exists! Try another Title!');
     exit
    end;
    apecks.level:=1;
    apecks.author:=unam;
    apecks.author2:=unam;
    writeln;
    if ulvl>=anonymouslevel then begin
     writestr ('Post Rumor Anonymous [y/n]? &');
     if yes then apecks.author:='...!@ANON#$...' else
     apecks.author:=unam;
    end;
    apecks.when:=now;
    ansireset;
    writeln;
    writestr ('Level required to read Rumor [CR/1]: &');
    if length(input)=0 then apecks.level:=1 else
    apecks.level:=valu(input);
    writeln;
    writeln ('Enter The Rumor Below (Enter Quits)');
    buflen:=78;
    writeln (' ()');
    writestr('> &');
    if input='' then exit;
    b:=true;
    apecks.rumor:=input;
    seekrfile (numrumors+1);
    write (rfile,apecks);
    if b then writeln (^M'Rumor created!');
    if not b then begin
    exit
    end;
  end;

  procedure deleterumor;
  var cnt,n:integer;
      f:file;
  begin
    n:=getrnum ('Delete');
    if n=0 then exit;
    seekrfile (n);
    read (rfile,r);
    if not issysop then
    if not match(r.author2,unam) then
    begin
     writeln;
     writeln ('You didn''t post that!!');
     writeln;
     exit
    end;
    writeln;
    ansicolor (11);
    write ('"');
    ansicolor (9);
    write (r.rumor);
    ansicolor (11);
    writeln ('"');
    writeln;
    writestr ('Delete this Rumor [y/N]? *');
    if not yes then exit;
    for cnt:=n+1 to numrumors do begin
     seekrfile (cnt);
     read (rfile,r);
     seekrfile (cnt-1);
     write (rfile,r);
    end;
    seekrfile (numrumors);
    truncate (rfile);
    writelog (1,8,r.title)
  end;

  const beenaborted:boolean=false;

  function aborted:boolean;
  begin
    if beenaborted then begin
      aborted:=true;
      exit
    end;
    aborted:=xpressed or hungupon;
    if xpressed then begin
      beenaborted:=true;
      writeln (^B'Newscan aborted!')
    end
  end;

  procedure rumorsnewscan;
  var first,cnt:integer;
      nd:boolean;
      re:rumorrec;
  begin
    writehdr ('Rumors Newscan');
    if numrumors<1 then exit;
    for cnt:=1 to numrumors do begin
     seekrfile (cnt);
     read (rfile,re);
     if (re.when>laston) and (ulvl>=re.level) then begin
      ansicolor (urec.inputcolor);
      tab (strr(cnt)+'.',4);
      ansicolor (urec.promptcolor);
      write  (re.title);
      ansicolor (urec.regularcolor);
      write (' by ');
      ansicolor (urec.inputcolor);
      if re.author='...!@ANON#$...' then
      write ('< Anonymous >') else write (re.author2);
      writeln;
      write (' "');
      ansicolor (urec.statcolor);
      write (re.rumor);
      ansicolor (urec.regularcolor);
      writeln ('"');
     end;
    end;
  end;

  procedure searchfortext;
  var x:integer;
      mixmasterfag:boolean;
      s:anystr;
      rr:rumorrec;
  begin
   if numrumors<1 then begin
    writeln (^M'No Rumors Exist!'^M);
    exit;
   end;
   writehdr ('Search for Text in all Rumors');
   writeln ('Enter Text to search for:');
   writestr ('-> &');
   writeln;
   if length(input)=0 then exit;
   s:=input;
   s:=upstring(s);
   for x:=1 to numrumors do begin
    mixmasterfag:=false;
    seekrfile (x);
    read (rfile,rr);
    if pos(s,upstring(rr.title))>0 then mixmasterfag:=true;
    if pos(s,upstring(rr.rumor))>0 then mixmasterfag:=true;
    if pos(s,upstring(rr.author))>0 then mixmasterfag:=true;
    if ((ulvl>=readanonlvl) and (pos(s,upstring(rr.author2))>0)) then mixmasterfag:=true;
    if (mixmasterfag=true) and (ulvl>=rr.level) then begin
     ansicolor (urec.inputcolor);
     tab (strr(x)+'.',4);
     ansicolor (urec.promptcolor);
     write  (rr.title);
     ansicolor (urec.regularcolor);
     write (' by ');
     ansicolor (urec.inputcolor);
     if rr.author='...!@ANON#$...' then
     write ('<Anonymous>') else write (rr.author2);
     writeln;
     write (' "');
     ansicolor (urec.statcolor);
     write (rr.rumor);
     ansicolor (urec.regularcolor);
     writeln ('"');
    end;
   end;
  end;

  procedure explainrumors;
  begin
   if exist (textfiledir+'Rumors.Hlp') then
   printfile (textfiledir+'Rumors.Hlp') else
  end;

label later;
var prompt:lstr;
    n,q,b:integer;
    k:char;
    mp:boolean;
begin
  if not userumor then begin
   writeln;
   writeln ('Rumors are not in use!');
   writeln;
   exit;
  end;
  openrfile;
  mp:=moreprompts in urec.config;
  if mp then urec.config:=urec.config-[moreprompts];
  repeat
    q:=menu ('Rumors Menu','RUMOR','LAD#EQNS');
    writeln;
    if q<0 then begin
     b:=-q;
     if (b<0) or (b>numrumors) then
     writeln (^M'Number out of range!') else
     showrumor (b);
    end else
    case q of
     1:listrumors;
     2:addrumor;
     3:deleterumor;
     5:explainrumors;
     7:rumorsnewscan;
     8:searchfortext;
    end;
  until (q=6) or (hungupon);
  later:
  close (rfile);
  if mp then urec.config:=urec.config+[moreprompts];
end;

procedure randomrumor;

  function numrumors:integer;
  begin
    numrumors:=filesize(rfile)
  end;

  procedure seekrfile (n:integer);
  begin
    seek (rfile,n-1)
  end;

  procedure openrfile;
  var n:integer;
  begin
    n:=ioresult;
    assign (rfile,'Rumors.Dat');
    reset (rfile);
    if ioresult<>0 then begin
      close (rfile);
      n:=ioresult;
      rewrite (rfile)
    end
  end;

procedure showit (n:integer);
var rr:rumorrec;
begin
   seekrfile (n);
   read (rfile,rr);
   if ulvl<rr.level then exit;
   writeln;
   ansicolor (11);
   write ('"');
   ansicolor (9);
   write (rr.rumor);
   ansicolor (11);
   writeln ('"');
   ansireset;
end;

var x:integer;
begin
 if not userumor then exit;
 openrfile;
 if numrumors<1 then begin
  writeln;
  ansicolor (9);
  write ('"');
  ansicolor (11);
  write ('No Rumors Exist! To Add one, Enter [R] At the Main Menu!');
  ansicolor (9);
  writeln ('"');
  ansireset;
 end else
 begin
  seekrfile (1);
  randomize;
  x:=random (numrumors+1);
  showit (x);
 end;
 close (rfile);
 ansireset;
end;

begin
end.
