(* Cyanide BBS Software Modem Stuff ][ *)

procedure setparam (comlame:byte;baud:longint;parity:boolean);
begin
  com_set_speed(baud);
  if parity then com_set_parity(com_even,7) else com_set_parity(com_none,8)
end;

procedure com_install (portnum:Word; var error:word);
var ier:byte;
begin
  if com_installed then error:=3 else
   if (portnum<1) or (portnum>max_port) then error:=1 else begin
      uart_data:=uart_base[portnum];
      uart_ier:=uart_data+1;
      uart_iir:=uart_data+2;
      uart_lcr:=uart_data+3;
      uart_mcr:=uart_data+4;
      uart_lsr:=uart_data+5;
      uart_msr:=uart_data+6;
      uart_spr:=uart_data+7;
      intnum:=intnums [portnum];
      i8259bit:=1 shl i8259levels [portnum];
      old_ier:=port[uart_ier];
      port [uart_ier]:=0;
      if port [uart_ier] <> 0 then
        error:=2 else begin
          error:=0;
          disable_interrupts;
          old_i8259_mask:=port[$21];
          port [$21]:=old_i8259_mask or i8259bit;
          enable_interrupts;
          com_flush_tx;
          com_flush_rx;
          getIntVec (intnum,old_vector);
          setIntVec (intnum,@com_interrupt_driver);
          com_installed:=true;
          port [uart_lcr]:=3;
          disable_interrupts;
          old_mcr:=Port[uart_mcr];
          port [uart_mcr]:=$A or (old_mcr and 1);
          enable_interrupts;
          port [uart_ier]:=1;
          disable_interrupts;
          port [$21]:=port [$21] and not i8259bit;
          enable_interrupts
        end
      end
end;

procedure com_deinstall;
begin
  if com_installed then begin
    com_installed:=false;
    port [uart_mcr]:=old_mcr;
    port [uart_ier]:=old_ier;
    disable_interrupts;
    port [$21]:=port [$21] and not i8259bit or old_i8259_mask and i8259bit;
    enable_interrupts;
    setintvec (intnum,old_vector)
  end
end;

