UNIT ibmcom;

{Version 3.0}

{This unit is the communications port interrupt driver for the IBM-PC.
It handles handles all low-level i/o through the serial port.  It is
installed by calling com_install.  It deinstalls itself automatically
when the program exits, or you can deinstall it by calling com_deinstall.

Donated to the public domain by Wayne E. Conrad, January, 1989.
If you have any problems or suggestions, please contact me at my BBS:

    Pascalaholics Anonymous
    (602) 484-9356
    2400 bps
    The home of WBBS
    Lots of source code
}


INTERFACE

USES
  Dos;


TYPE
  com_parity = (com_none, com_even, com_odd, com_zero, com_one);


FUNCTION  carrier: Boolean;
FUNCTION  getchar: Char;
FUNCTION  com_tx_ready: Boolean;
FUNCTION  com_tx_empty: Boolean;
FUNCTION  com_rx_empty: Boolean;
PROCEDURE sendchar (ch: Char);
PROCEDURE com_tx_string (st: String);
PROCEDURE hangup;
PROCEDURE setmodem;
PROCEDURE com_set_speed (speed: Word);
PROCEDURE com_set_parity (parity: com_parity; stop_bits: Byte);
PROCEDURE dontanswer;
PROCEDURE doanswer;
PROCEDURE setparam(comlame:byte;baud:integer;parity:boolean);
PROCEDURE com_install
  (
  portnum  : Word;
  VAR error: Word
  );
PROCEDURE com_deinstall;


IMPLEMENTATION


{Summary of IBM-PC Asynchronous Adapter Registers.  From:
  Compute!'s Mapping the IBM PC and PCjr, by Russ Davis
  (Greensboro, North Carolina, 1985: COMPUTE! Publications, Inc.),
  pp. 290-292.

Addresses given are for COM1 and COM2, respectively.  The names given
in parentheses are the names used in this module.


3F8/2F8 (uart_data) Read: transmit buffer.  Write: receive buffer, or baud
rate divisor LSB if port 3FB, bit 7 = 1.

3F9/2F9 (uart_ier) Write: Interrupt enable register or baud rate divisor
MSB if port 3FB, bit 7 = 1.
PCjr baud rate divisor is different from other models;
clock input is 1.7895 megahertz rather than 1.8432 megahertz.
Interrupt enable register:
    bits 7-4  forced to 0
    bit 3     1=enable change-in-mo