{$R-,S-,I-,D-,F+,V-,B-,N-,L+,O+ }
{$M 65500,0,0 }

unit configur;

interface

uses configrt,gentypes,userret,gensubs,subs1,subs2,flags,overlay;

procedure configure;

implementation

procedure configure;

const colorstr:array [0..7] of string[7]=
        ('Black','Blue','Green','Cyan','Red','Magenta','Yellow','White');

procedure options (c:configtype; var prompt,onstr,offstr:lstr);

  procedure ret (x1,x2,x3:lstr);
  begin
    prompt:=x1;
    onstr:=x2;
    offstr:=x3
  end;

begin
  case c of
    linefeeds:ret('Require Line Feeds','Yes','No');
    eightycols:ret('Screen Width','80 columns','40 columns');
    postprompts:ret('Post prompts during Newscan','Yes','No');
    moreprompts:ret('Pause every screen','Yes','No');
    asciigraphics:ret('Use IBM graphics characters','Yes','No');
    showtime:ret('Display time left at prompts','Yes','No');
    lowercase:ret('Upper/lower case','Upper or lower case','Upper case only');
    fseditor:ret('Use ANSI Full-Screen Editor','Yes','No')
  end
end;

function getattrib (fg,bk:integer; hi,bl:boolean):byte;
begin
  getattrib:=fg+(byte(hi) shl 3)+(bk shl 4)+(byte(bl) shl 7)
end;

procedure getcolorvar (attr:byte; var fg,bk:integer; var hi,bl:boolean);
begin
  fg:=attr and 7;
  hi:=(attr and 8)=8;
  bk:=(attr shr 4) and 7;
  bl:=(attr and 128)=128
end;

procedure getthing (c:configtype);
var n:integer;
    name,onstr,offstr:lstr;
begin
  options (c,name,onstr,offstr);
  writehdr (name);
  write ('Current setting: '^S);
  if c in urec.config then write (onstr) else write (offstr);
  writeln (^B^M^M'Would you like:');
  writeln (' [1]: ',onstr);
  writeln (' [2]: ',offstr);
  writestr (^M'Selection:');
  n:=valu(input);
  if (n>0) and (n<3) then begin
    if n=2
      then urec.config:=urec.config-[c]
      else urec.config:=urec.config+[c];
    writeurec
  end
end;

procedure writecolorstr (a:byte);
var fg,bk:integer;
    hi,bl:boolean;
begin
  getcolorvar (a,fg,bk,hi,bl);
  ansicolor (a);
  if bl then write ('Blinking ');
  if hi then write ('Highlighted ');
  write (colorstr[fg]);
  if bk>0 then write (' on ',colorstr[bk])
end;

function colorval (str:mstr):integer;
var cnt:integer;
begin
  colorval:=-1;
  if match(str,'None') then begin
    colorval:=0;
    exit
  end;
  for cnt:=0 to 7 do
    if match(str,colorstr[cnt]) then begin
      colorval:=cnt;
      exit
    end
end;

procedure badcolor;
var cnt:integer;
begin
  writeln ('Invalid color!  Valid colors are:');
  write ('Black, ');
  for cnt:=1 to 7 do begin
    ansicolor (cnt);
    write (colorstr[cnt]);
    if cnt=7
      then writeln ('.')
      else write (', ');
    if cnt=6
      then write (', and ');
  end;
  writestr ('')
end;

procedure getcolor (prompt:mstr; var a:byte);

  procedure getacolor (var q:integer; prompt:mstr);
  var n:integer;
  begin
    repeat
      writestr ('Enter new '+prompt+' Color:');
      if hungupon or (length(input)=0) then exit;
      n:=colorval(input);
      if n=-1
        then badcolor
        else q:=n
    until n<>-1
  end;

var fg,bk:integer;
    hi,bl:boolean;
begin
  if not (ansigraphics in urec.config) then begin
    writestr ('You must have ANSI emulation to see color.');
    exit
  end;
  getcolorvar (a,fg,bk,hi,bl);
  write ('Current ',prompt,' Color: ');
  writecolorstr (a);
  writestr (^M^M);
  getacolor (fg,'Foreground');
  getacolor (bk,'Background');
  writestr ('Highlight the Characters [y/n]? *');
  hi:=yes;
  writestr ('Should the Characters Blink [y/n]? *');
  bl:=yes;
  a:=getattrib (fg,bk,hi,bl)
end;

procedure emulation;
begin
  writeln (^B^M'Note:  ANSI is required for color.');
  writeln (    '       VT52 or ANSI is required for the Full-Screen Editor.');
  writeln;
  writeln (^B'Please choose your terminal type:'^M^M,
           '  [1]: ANSI Color'^M,
           '  [2]: VT52 Emulation'^M,
           '  [3]: None'^M);
  writestr ('Emulation:');
  if length(input)=0 then exit;
  urec.config:=urec.config-[ansigraphics,vt52];
  case valu(input) of
    1:urec.config:=urec.config+[ansigraphics];
    2:urec.config:=urec.config+[vt52]
  end
end;

procedure getdisplaylen;
var v:integer;
begin
  writeln ('Current display length is: '^S,urec.displaylen);
  writestr (^M'Enter new display length [21-43]:');
  if length(input)=0 then exit;
  v:=valu(input);
  if (v<21) or (v>43)
    then writeln ('Invalid!')
    else urec.displaylen:=v
end;

procedure configurenewscan;
var bd:boardrec;
    bn:integer;
    ac:accesstype;
begin
  opentempbdfile;
  seek (bdfile,0);
  for bn:=0 to filesize(bdfile)-1 do begin
    read (bdfile,bd);
    ac:=getuseraccflag(urec,bn);
    if (ac=letin) or ((ulvl>=bd.level) and (ac=bylevel)) then begin
      writestr ('Newscan ['^S+bd.boardname+^R'] (now '+
                yesno(not (bn in urec.newscanconfig))+'):');
      if length(input)<>0 then
        if yes
          then urec.newscanconfig:=urec.newscanconfig-[bn]
          else urec.newscanconfig:=urec.newscanconfig+[bn]
    end
  end;
  closetempbdfile
end;

procedure showit (s,v:lstr);
begin
  if break then exit;
  tab (s+':',30);
  writeln (^S,v)
end;

procedure showthing (c:configtype);
var n:integer;
    name,onstr,offstr:lstr;
begin
  if break then exit;
  options (c,name,onstr,offstr);
  tab (name+':',30);
  write (^S);
  if c in urec.config
    then write (^S,onstr)
    else write (^S,offstr);
  writeln
end;

procedure showemulation;
var q:lstr;
begin
  if ansigraphics in urec.config
    then q:='ANSI Color'
    else if vt52 in urec.config
      then q:='VT52 Emulation'
      else q:='None';
  showit ('Terminal type',q)
end;

procedure showdisplaylen;
begin
  showit ('Display length',strr(urec.displaylen))
end;

procedure showcolor (prompt:mstr; attr:byte);
begin
  if break then exit;
  tab ('  '+prompt+' Color:',30);
  writecolorstr (attr);
  ansicolor (urec.regularcolor);
  writeln
end;

procedure showmacros;
begin
 writeln;
 writeln (^R'Message Macro #1 currently shows:'^S);
 writeln (urec.macro1);
 writeln;
 writeln (^R'Message Macro #2 currently shows:'^S);
 writeln (urec.macro2);
 writeln;
 writeln (^R'Message Macro #3 currently shows:'^S);
 writeln (urec.macro3);
 writeln;
 writeln (^R);
end;

procedure newusernote;
begin
	writeln;
	writeln(^R'Your User Note currently reads: "'^S+urec.note+^R'"');
	writeln;
       writestr('Enter your new User Note:');
       if length(input)<>0 then urec.note:=input;
       writeln;
end;


procedure yourstatus;
begin
  writehdr ('Your Configuration');
  showthing (linefeeds);
  showthing (eightycols);
  showthing (postprompts);
  showthing (moreprompts);
  showthing (asciigraphics);
  showthing (showtime);
  showthing (lowercase);
  showemulation;
  showthing (fseditor);
  showdisplaylen;
  write (^R);
  tab ('Default Protocol:',30);
  write (^S);
  if urec.defproto in validprotos then begin
   case urec.defproto of
    'X':writeln ('Xmodem');
    'C':writeln ('Xmodem-CRC');
    'Y':writeln ('Ymodem');
    'Z':writeln ('Zmodem');
    'J':writeln ('Jmodem');
    'L':writeln ('Lynx');
    'G':writeln ('Ymodem-G');
    'O':writeln ('Xmodem OverThruster');
    '1':writeln ('Ymodem OverThruster');
    'S':writeln ('Super8k');
    'K':writeln ('K9Xmodem');
    'R':writeln ('Zmodem Crash Recovery');
    'P':writeln ('PCPursuit Zmodem');
    'T':writeln ('Punter');
   end
  end;
  write (^R);
  if ansigraphics in urec.config then begin
   showcolor ('Prompt',urec.promptcolor);
   showcolor ('Input',urec.inputcolor);
   showcolor ('Regular',urec.regularcolor);
   showcolor ('Statistic',urec.statcolor)
  end;
  writeln;
  writestr ('Show your Message Macros [y/n]? *');
  if yes then showmacros;
end;

procedure getmacros;
var mogigi:anystr;
begin
 repeat
 showmacros;
 writestr ('Macro # to change [CR/Quit]:');
 if length(input)=0 then begin
  writeln;
  exit
 end;
 mogigi:=input[1];
 if mogigi='?' then showmacros;
 if mogigi='1' then begin
       writeln;
       writestr ('Enter new Macro #1: *');
       if length(input)>0 then
        urec.macro1:=input;
       writeln;
      end;
 if mogigi='2' then begin
       writeln;
       writestr ('Enter new Macro #2: *');
       if length(input)>0 then
        urec.macro2:=input;
       writeln;
      end;
 if mogigi='3' then begin
       writeln;
       writestr ('Enter new Macro #3: *');
       if length(input)>0 then
        urec.macro3:=input;
       writeln;
      end;
 until (upstring(mogigi)='Q') or (length(mogigi)=0);
end;

{
procedure getansiwindows;
var n:integer;
begin
  writehdr ('ANSI Windows');
  write ('Current setting: '^S);
  if urec.ansiwindows=0 then write ('Off') else write ('On');
  writeln (^B^M^M'Would you like:');
  writeln (' [1]: On');
  writeln (' [2]: Off');
  writestr (^M'Your choice:');
  n:=valu(input);
  if (n>0) and (n<3) then begin
    if n=2
      then urec.ansiwindows:=0
      else urec.ansiwindows:=1;
    writeurec
  end
end;
}

procedure getmenutype;
var n:integer;
begin
  writehdr ('Menu Type');
  write ('Current setting: '^S);
  case urec.menutype of
   0:writeln ('Standard Menus');
   1:writeln ('Hotkey Menus');
   2:writeln ('Pulldown Menus');
  end;
  writeln (^B^M'Would you like:');
  writeln;
  writeln (' [0]: Standard Menus');
  writeln (' [1]: Hotkey Menus [one-key]');
  writeln (' [2]: Pulldown Menus [Ansi required]');
  writeln;
  writestr (^M'Your choice:');
  n:=valu(input);
  if (n>-1) and (n<3) then begin
   case n of
    0:urec.menutype:=0;
    1:urec.menutype:=1;
    2:urec.menutype:=2;
   end;
   writeurec
  end
end;

procedure changepassword;
var t:sstr;
begin
  writehdr ('Password Change');
  dots:=true;
  buflen:=15;
  writeln ('Enter your new password now, or');
  writeln ('Press [Return] to have on generated.');
  write ('-> ');
  if getpassword
    then begin
      writeurec;
      writestr ('Password changed.');
      writelog (1,1,'')
    end else
      writestr ('Not changed.')
end;

procedure changedefproto;
var c,k:char;
begin
if length(urec.defproto)>0 then writeln(^R'Current Default Protocol is '^S+urec.defproto+^R) else
		writeln(^R'No Default Protocol is defined.');
  writeln ('The complete protocol list is available in the transfer area.');
  writeln ('The protocol you choose here will be your default for all');
  writeln ('uploads and downloads.');
  writeln;
  writestr ('Enter new Default Protocol [CR/Quit]: *');
  if length(input)=0 then exit;
  urec.defproto:=upcase(input[1])
end;

var q:integer;
begin
  repeat
    if (not (lowercase in urec.config)) and (ansigraphics in urec.config)
      then begin
        urec.config:=urec.config+[lowercase];
        writestr ('You may not use ANSI in uppercase-only mode.')
      end;
    if (fseditor in urec.config) and
       (urec.config=urec.config-[ansigraphics,vt52])
      then begin
        urec.config:=urec.config-[fseditor];
        writestr ('You may not use the full-screen editor without ANSI or VT52 emulation.')
      end;
    q:=menu ('User Configuration','CONFIG','QLWOCGTUEDPIRSNYFHZAM!+B');
    case q of
      2:getthing (linefeeds);
      3:getthing (eightycols);
      4:getthing (postprompts);
      5:getthing (moreprompts);
      6:getthing (asciigraphics);
      7:getthing (showtime);
      8:getthing (lowercase);
      9:emulation;
      10:getdisplaylen;
      11:getcolor ('Prompt',urec.promptcolor);
      12:getcolor ('Input',urec.inputcolor);
      13:getcolor ('Regular',urec.regularcolor);
      14:getcolor ('Status',urec.statcolor);
      15:configurenewscan;
      16:yourstatus;
      17:getthing (fseditor);
      18:showmacros;
      19:getmacros;
      20:{getansiwindows};
      21:getmenutype;
      22:changepassword;
      23:changedefproto;
      24:newusernote;
    end;
    writeurec
  until (q=1) or hungupon
end;

begin
end.
