unit userret2;

interface

uses crt,
     gentypes,modem,configrt,gensubs,subs1,subs2,userret1,textret,mainr1,
     overret1,overret2;

{procedure help (fn:mstr);}
procedure edituser (eunum:integer);
{procedure sendmodemstr (ss:anystr; endifcarrier:boolean);}
function getlastcaller:mstr;
procedure showlastcallers;
procedure infoform;
function selectspecs (var us:userspecsrec):boolean; { True if user aborts }
procedure editoldspecs;
{procedure doanswer;
procedure dontanswer;}


implementation


{procedure help (fn:mstr);
var tf:text;
    htopic,cnt:integer;
begin
  fn:=textfiledir+fn;
  assign (tf,fn);
  reset (tf);
  if ioresult<>0 then
    begin
    writestr ('Sorry, no help is availiable!');
    if issysop then
      begin
      writeln ('Sysop: To make help, create a file called ',fn);
      writeln ('Group the lines into blocks separated by periods.');
      writeln ('The first group is the topic menu; the second is the');
      writeln ('help for topic 1; the third for topic 2; etc.')
    end;
    exit
  end;
  repeat
    textclose (tf);
    assign (tf,fn);
    reset (tf);
    writeln (^M);
    printtexttopoint (tf);
    repeat
      writestr (^M'Topic number [CR quits]:');
      if hungupon or (length(input)=0) then
        begin
        textclose (tf);
        exit
        end;
      htopic:=valu (input)
    until (htopic>0);
    for cnt:=2 to htopic do
      if not eof(tf)
        then skiptopoint (tf);
    if eof(tf)
      then writestr ('Sorry, no help on that topic!')
      else printtexttopoint (tf)
  until 0=1
end;}

procedure edituser (eunum:integer);
var eurec:userrec;
    ca:integer;
    k:char;

  procedure truesysops;
  begin
    writeln ('Sorry, you may not do that without true sysop access!');
    writelog (18,17,'')
  end;

  function truesysop:boolean;
  begin
    truesysop:=ulvl>=sysoplevel
  end;

  procedure eustatus;
  var cnt:integer;
      k:char;
  begin
    writehdr ('Status');
    with eurec do begin
      write (^M'User:               '^S,eunum,' - ',handle,' - ',realname,
             ^M'Birthdate:          '^S,birthdate.month,'/',birthdate.day,'/19',birthdate.year,
             ^M'Phone #:            '^S,voicenum,
             ^M'Password:           '^S);
      if truesysop
        then write (password)
        else write ('<*> Classified <*>');
      write (^M'System level:       '^S,level,
             ^M'Transfer level:     '^S,udlevel,
             ^M'Transfer points:    '^S,udpoints,
             ^M'Transfer uploads:   '^S,uploads,
             ^M'Transfer downloads: '^S,downloads,
             ^M'Message posts:      '^S,nbu,
             ^M'Time per day:       '^S,timeperday,
             ^M'Time on system:     '^S,totaltime,
             ^M'Number of calls:    '^S,numon,
             ^M'Wanted:             '^S,yesno(wanted in config),
             ^M'Voting record:      '^S);
      for cnt:=1 to maxtopics do
        begin
        if cnt<>1 then write (',');
        write (voted[cnt])
        end;
      writeln;
    end;
    writelog (18,13,'')
  end;

  procedure getmstr (t:mstr; var mm);
  var m:mstr absolute mm;
  begin
    writeln ('Old ',t,': '^S,m);
    writestr ('New '+t+'? *');
    if length(input)>0 then m:=input
  end;

  procedure getsstr (t:mstr; var s:sstr);
  var m:mstr;
  begin
    m:=s;
    getmstr (t,m);
    s:=m
  end;

  procedure getint (t:mstr; var i:integer);
  var m:mstr;
  begin
    m:=strr(i);
    getmstr (t,m);
    i:=valu(m)
  end;

  procedure euwanted;
  begin
    writestr ('Wanted status: '^S+yesno(wanted in eurec.config));
    writestr ('New wanted status:');
    if yes
      then eurec.config:=eurec.config+[wanted]
      else eurec.config:=eurec.config-[wanted];
    writelog (18,1,yesno(wanted in eurec.config))
  end;

  procedure eudel;
  begin
    writestr ('Delete user --- confirm:');
    if yes then
      begin
      deleteuser (eunum);
      seek (ufile,eunum);
      read (ufile,eurec);
      writelog (18,9,'')
      end
  end;

  procedure euname;
  var m:mstr;
  begin
    m:=eurec.handle;
    getmstr ('handle',m);
    if not match (m,eurec.handle) then
      if lookupuser (m)<>0 then
        begin
        writestr ('Already exists!  Are you sure? *');
        if not yes then exit
        end;
    eurec.handle:=m;
    writelog (18,6,m)
  end;

  procedure realname;
  var m:mstr;
  begin
    m:=eurec.realname;
    getmstr ('name',m);
    eurec.realname:=m;
  end;

  procedure eupassword;
  begin
    if not truesysop
      then truesysops
      else
        begin
        getsstr ('password',eurec.password);
        writelog (18,8,'')
        end
  end;

  procedure eulevel;
  var n:integer;
  begin
    n:=eurec.level;
    getint ('level',n);
    if (n>=sysoplevel) and (not truesysop)
      then truesysops
      else
        begin
        eurec.level:=n;
        writelog (18,15,strr(n))
        end
  end;

  procedure euphone;
  var m:mstr;
      p:integer;
  begin
    m:=eurec.voicenum;
    buflen:=15;
    getmstr ('phone number',m);
    p:=1;
    while p<=length(m) do
      if (m[p] in ['0'..'9'])
        then p:=p+1
        else delete (m,p,1);
    if length(m)>7 then
      begin
      eurec.voicenum:=m;
      writelog (18,16,m)
      end
  end;

  procedure getlogint (prompt:mstr; var i:integer; ln:integer);
  begin
    getint (prompt,i);
    writelog (18,ln,strr(i))
  end;

  procedure usercomment;
  var v:integer;
  begin
    writeln('10 - Sysop');
    writeln(' 9 - Co-SysOp');
    writeln(' 8 - High access');
    writeln(' 7 - Medium access');
    writeln(' 6 - Low access');
    writeln(' 5 - Special');
    writeln(' 4 - High trial');
    writeln(' 3 - Low trial');
    writeln(' 2 - New user');
    writeln(' 1 - Temp removal');
    writeln('-1 - Removed');
    writeln(^M'Choose one of the following or enter your own!');
    getsstr('Level comment',eurec.comment);
    v:=valu(eurec.comment);
    case v of
     10:eurec.comment:='SysOp';
     9:eurec.comment:='Co-SysOp';
     8:eurec.comment:='High access';
     7:eurec.comment:='Medium access';
     6:eurec.comment:='Low access';
     5:eurec.comment:='Special';
     4:eurec.comment:='High trial';
     3:eurec.comment:='Low trial';
     2:eurec.comment:='New user';
     1:eurec.comment:='Temp removal';
     -1:eurec.comment:='Removed';
     end;
  end;

  procedure allowchange;
  begin
    if eurec.handlechange then writeln('Allow handle change: Yes') else
      writeln('Allow handle change: No');
    writestr('New handle change:');
    if yes then eurec.handlechange:=true else eurec.handlechange:=false;
    if yes then writelog(18,18,'Yes')
    else writelog(18,18,'No');
  end;

  procedure allowrumors;
  begin
    if eurec.rumorchange then writeln('Allow user to add rumors: Yes') else
      writeln('Allow user to add rumors: No');
    writestr('New rumor add:');
    if yes then eurec.rumorchange:=true else eurec.rumorchange:=false;
    if yes then writelog(18,20,'Yes')
    else writelog(18,20,'No');
  end;

  procedure showfeedback;
  begin
    if showinfeedback in eurec.config then writeln('Show user in feedback list: Yes') else
      writeln('Show user in feedback list: No');
    writestr('New feedback stat:');
    if yes then eurec.config :=eurec.config + [showinfeedback] else
        eurec.config :=eurec.config - [showinfeedback];
    if yes then writelog(18,19,'Yes')
    else writelog(18,19,'No');
  end;

var q:integer;
begin
  writeurec;
  seek (ufile,eunum);
  read (ufile,eurec);
  writelog (2,3,eurec.handle);
  repeat
    q:=menu(command.commandstr[28],'UEDIT',menus.commands[28]);
    case q of
      1:eustatus;
      2:eudel;
      3:euname;
      4:eupassword;
      5:eulevel;
      6:getlogint ('u/d points',eurec.udpoints,7);
      7:getlogint ('u/d level',eurec.udlevel,14);
      8:euwanted;
      9:getlogint ('time for today',eurec.timetoday,12);
      10:;
      12:;
      13:euphone;
      14:showinfoforms(strr(eunum));
      15:realname;
      16:;
      17:usercomment;
      18:allowchange;
      19:showfeedback;
      20:allowrumors;
     end
  until hungupon or (q=11);
  writeufile (eurec,eunum);
  readurec
end;

{procedure sendmodemstr (ss:anystr; endifcarrier:boolean);
var cnt,ptr:integer;
    k:char;
label exit;
begin
  ptr:=0;
  while ptr<length(ss) do
    begin
    if keyhit or (carrier=endifcarrier) then goto exit;
    ptr:=ptr+1;
    k:=ss[ptr];
    case k of
      '|':sendchar (^M);
      '~':delay (500);
      '^':begin
          ptr:=ptr+1;
          if ptr>length(ss) then k:='^'
            else k:=upcase(ss[ptr]);
          if k in ['A'..'Z'] then sendchar (chr(ord(k)-64))
            else sendchar (k)
          end;
          else sendchar (k)
      end;
    delay (50);
    while numchars>0 do writecon (getchar)
    end;
  cnt:=0;
  repeat
    while numchars>0 do
      begin
      cnt:=0;
      writecon (getchar)
      end;
    cnt:=cnt+1
  until (cnt=1000) or keyhit or (carrier=endifcarrier);
  exit:
  break:=keyhit
end;}

function getlastcaller:mstr;
var qf:file of lastrec;
    l:lastrec;
begin
  getlastcaller:='';
  assign (qf,'Callers');
  reset (qf);
  if ioresult=0 then
    if filesize(qf)>0
      then
        begin
        seek (qf,0);
        read (qf,l);
        getlastcaller:=l.name
        end;
  close (qf)
end;

procedure showlastcallers;
var qf:file of lastrec;
    cnt:integer;
    l:lastrec;
begin
  assign (qf,'Callers');
  reset (qf);
  if ioresult=0 then
    begin
    writehdr ('Recent caller list');
    break:=false;
    for cnt:=0 to filesize(qf)-1 do
      if not break then
        begin
        read (qf,l);
        tab (l.name,33);
        writeln (datestr(l.when)+' '+timestr(l.when))
        end
    end;
  close (qf)
end;

procedure infoform;
var ff1,ff2:text;
    f1,f2:lstr;
    k:char;
begin
   writeln;
   f1:=textfiledir+'INFOFORM';
   f2:=infodir+'INFOFORM.'+strr(unum);
   if not exist (f1) then
   begin
      writestr ('ERROR: INFOFORM not located!');
      exit
   end;
   if exist (f2) then exit;
   assign (ff1,f1);
   reset (ff1);
   assign (ff2,f2);
   rewrite (ff2);
   writeln (ff2,'Name:  '+urec.handle);
   writeln (ff2,'Date:  '+datestr(now));
   writeln (ff2,'Time:  '+timestr(now));
   writeln (ff2);
   while not eof(ff1) do
   begin
      if hungupon then
      begin
         close (ff1);
         close (ff2);
         exit
      end;
      read (ff1,k);
      if k='*' then
      begin
         nochain:=true;
         getstr;
         writeln (ff2,input);
      end else
      begin
         writechar (k);
         write(ff2,k);
      end;
   end;
   textclose (ff1);
   textclose (ff2);
   writeurec;
end;

procedure openusfile;
const newusers:userspecsrec=(name:'New users';minlevel:1;maxlevel:1;
         minlaston:-maxint;maxlaston:maxint;minpcr:-maxint;maxpcr:maxint);
begin
  assign (usfile,'userspec');
  reset (usfile);
  if ioresult<>0 then
    begin
    rewrite (usfile);
    write (usfile,newusers)
    end
end;

procedure editspecs (var us:userspecsrec);

  procedure get (tex:string; var value:integer; min:boolean);
  var vstr:sstr;
  begin
    buflen:=6;
    if abs(value)=maxint then vstr:='None' else vstr:=strr(value);
    writestr (tex+' ['+vstr+']:');
    if input[0]<>#0
      then if upcase(input[1])='N'
        then if min
          then value:=-maxint
          else value:=maxint
        else value:=valu(input)
  end;

  procedure getreal (tex:string; var value:real; min:boolean);
  var vstr:sstr;
      s:integer;
  begin
    buflen:=10;
    if abs(value)=maxint then vstr:='None' else vstr:=streal(value);
    writestr (tex+' ['+vstr+']:');
    if length(input)<>0
      then if upcase(input[1])='N'
        then if min
          then value:=-maxint
          else value:=maxint
        else begin
          val (input,value,s);
          if s<>0 then value:=0
        end
  end;

begin
  writeln (^B^M'Enter specifications; N for none.'^M);
  buflen:=30;
  writestr ('Specification set name ['+us.name+']:');
  if length(input)<>0
    then if match(input,'N')
      then us.name:='Unnamed'
      else us.name:=input;
  get ('Lowest level',us.minlevel,true);
  get ('Highest level',us.maxlevel,true);
  get ('Lowest #days since last call',us.minlaston,true);
  get ('Highest #days since last call',us.maxlaston,true);
  getreal ('Lowest post to call ratio',us.minpcr,true);
  getreal ('Highest post to call ratio',us.maxpcr,true)
end;

function getspecs (var us:userspecsrec):integer; { -1:not saved   >0:in file }
begin
  with us do
    begin
    name:='Unnamed';                     { Assumes USFILE is open !! }
    minlevel:=-maxint;
    maxlevel:=maxint;
    minlaston:=-maxint;
    maxlaston:=maxint;
    minpcr:=-maxint;
    maxpcr:=maxint
    end;
  editspecs (us);
  writestr (^M'Save these specs to disk? *');
  if yes then
    begin
    seek (usfile,filesize(usfile));
    write (usfile,us);
    getspecs:=filesize(usfile)
    end
    else getspecs:=-1
end;

function searchspecs (var us:userspecsrec; name:mstr):integer;
var v,pos:integer;
begin
  v:=valu(name);
  seek (usfile,0);
  pos:=1;
  while not eof(usfile) do
    begin
    read (usfile,us);
    if match(us.name,name) or (valu(name)=pos) then
      begin
      searchspecs:=pos;
      exit
      end;
    pos:=pos+1
    end;
  searchspecs:=0;
  writestr (^M'Not found!')
end;

procedure listspecs;
var us:userspecsrec;
    pos:integer;

  procedure writeval (n:integer);
  begin
    if abs(n)=maxint then write ('   None') else write(n:7)
  end;

  procedure writevalreal (n:real);
  begin
    if abs(n)=maxint then write ('   None') else write(n:7:2)
  end;

begin
  writehdr ('User Specification Sets');
  seek (usfile,0);
  pos:=0;
  tab ('',35);
  tab ('    Level    ',14);
  tab ('  Last Call  ',14);
  writeln ('  Post/Call Ratio  ');
  while not (break or eof(usfile)) do
    begin
    pos:=pos+1;
    read (usfile,us);
    write (pos:3,'. ');
    tab (us.name,30);
    writeval (us.minlevel);
    writeval (us.maxlevel);
    writeval (us.minlaston);
    writeval (us.maxlaston);
    writevalreal (us.minpcr);
    writevalreal (us.maxpcr);
    writeln
  end
end;

function selectaspec (var us:userspecsrec):integer; {  0 = none         }
var done:boolean;                                   { -1 = not in file  }
    pos:integer;                                    { -2 = added to end }
begin
  selectaspec:=0;
  openusfile;
  if filesize(usfile)=0
    then selectaspec:=getspecs(us)
    else
      repeat
        if hungupon then exit;
        done:=false;
        writestr (^M'Specification set name (?=list, A=add):');
        if length(input)=0
          then done:=true
          else if match(input,'A')
            then
              begin
              pos:=getspecs(us);
              if pos>0
                then selectaspec:=-2
                else selectaspec:=-1;
              done:=true
              end
            else if match(input,'?')
              then listspecs
              else
                begin
                pos:=searchspecs (us,input);
                done:=pos<>0;
                selectaspec:=pos
                end
      until done;
  close (usfile)
end;

function selectspecs (var us:userspecsrec):boolean;
var dummy:integer;
begin
  dummy:=selectaspec (us);
  selectspecs:=dummy=0
end;

procedure deletespecs (pos:integer);
var cnt:integer;
    us:userspecsrec;
begin
  openusfile;
  for cnt:=pos to filesize(usfile)-1 do
    begin
    seek (usfile,cnt);
    read (usfile,us);
    seek (usfile,cnt-1);
    write (usfile,us)
    end;
  seek (usfile,filesize(usfile)-1);
  truncate (usfile);
  close (usfile)
end;

procedure editoldspecs;
var pos:integer;
    us:userspecsrec;
begin
  repeat
    pos:=selectaspec (us);
    if pos>0 then
      begin
      buflen:=1;
      writestr (^M'E)dit or D)elete? *');
      if length(input)=1 then case upcase(input[1]) of
        'E':begin
            editspecs (us);
            openusfile;
            seek (usfile,pos-1);
            write (usfile,us);
            close (usfile)
            end;
        'D':deletespecs (pos)
        end
      end
  until (pos=0) or hungupon
end;

{procedure doanswer;
begin
    port [icomoffset+mcr]:=ord(true) or 8;
end;

procedure dontanswer;
begin
    port [icomoffset+mcr]:=ord(false) or 8;
end;}


begin
end.
