{$O+ }                                                                            {

                    This module was written by
                    Silent Lord and Purloin Illusionist                                   }

unit rumors;

interface

uses overlay,crt,dos,gentypes,subs1,subs2,configrt,gensubs,overret1,overret2;

procedure rumorsection;

implementation

var r:rumorrec;

procedure rumorsection;

  function noentries:boolean;
  begin
     if numrumors>0
     then noentries:=false
     else
        begin
        writeln ('Sorry, no rumors exist.');
        noentries:=true
        end
  end;

  procedure listrumors(a:integer);
  var cnt,f,l:integer;
      d,t:sstr;
  begin
     writehdr('List rumors');
     openrfile;
     if noentries then exit;
     writeln;
     parserange (numrumors,f,l);
     if f=0 then exit;
     writeln;
     for cnt:=f to l do
        begin
        seek (rfile,cnt-1);
        read (rfile,r);
        write(cnt,': ');
        writeln(r.rumor);
        if a=2 then if ulvl>=sysoplevel then
           begin
           write('     By: ');
           tab (r.username,28);
           write ('At: ');
           d:=datestr(r.rdatetime);
           t:=timestr(r.rdatetime);
           tab (t,15);
           write('On: ');
           tab (d,15);
           writeln;
           end;
        if break then exit
        end;
   end;

   function checkrumor(x:integer):boolean;
   begin
      checkrumor:=false;
      if x>numrumors then
         begin
         writeln('Rumor number to large!');
         exit;
         end;
      if x<1 then
         begin
         writeln('Rumor number to small!');
         exit;
         end;
      seek (rfile,x-1);
      read (rfile,r);
      if (not (match(r.username,unam))) and (ulvl<sysoplevel) then
         begin
         writeln('You didn''t leave that rumor!');
         exit;
         end;
      checkrumor:=true;
   end;

   procedure delrumor(cnt:integer);
   var rnumber:integer;
   begin
      if cnt=numrumors then
         begin
         seek(rfile,numrumors-1);
         truncate(rfile);
         end
      else
         begin
         for rnumber:=cnt to numrumors do
            begin
            seek(rfile,rnumber);
            read(rfile,r);
            seek(rfile,rnumber-1);
            write(rfile,r);
            end;
         seek(rfile,numrumors-1);
         truncate(rfile);
         end;
   end;

   procedure deleterumor;
   var cnt:integer;
   begin
      writehdr('Delete rumor');
      openrfile;
      if noentries then exit;
      writeln;
      writestr('Delete rumor number: *');
      cnt:=valu(input);
      if cnt < 1 then exit;
      if not checkrumor(cnt) then exit;
      if (cnt<1) or (cnt>numrumors) then exit;
      writelog(23,2,'');
      delrumor(cnt);
   end;

   procedure massdelete;
   var cnt,f,l:integer;
       range:sstr;
   begin
      writehdr('Mass delete rumors');
      openrfile;
      if noentries then exit;
      writeln;
      parserange (numrumors,f,l);
      range:=strr(f)+'-'+strr(l);
      if (f=1) and (l=numrumors) then
         begin
         writestr('WARNING: You have chosen to destroy *ALL* rumors, continue? *');
         if not yes then exit;
         end;
      writelog(24,1,range);
      for cnt:=f to l do delrumor(cnt);
   end;

   procedure addrumor;
   var cnt:sstr;
   begin
      if not urec.rumorchange then
         begin
         writeln('Sorry, '+sysopname+' doesn''t want you adding rumors.');
         exit;
         end;
      writehdr('Add rumor');
      openrfile;
      seek(rfile,numrumors);
      writestr('Rumor: &');
      if length(input)<1 then exit;
      if length(input)>75 then
         begin
         writeln('Rumors must be 75 characters or less!');
         exit;
         end;
      r.rumor:=input;
      r.username:=unam;
      r.rdatetime:=now;
      write(rfile,r);
      cnt:=strr(numrumors);
      writelog(23,1,cnt);
   end;

   function yourrumor : integer;
   var cnt,num:integer;
   begin
     {openrfile;}
     yourrumor:=0;
     num:=0;
     if numrumors<1 then
       begin
       yourrumor:=0;
       exit;
       end;
     assign(rfile,'RUMORS');
     reset(rfile);
     for cnt:=1 to (numrumors) do
        begin
        seek (rfile,cnt-1);
        read (rfile,r);
        if match(r.username,unam) then num:=num+1;
        end;
     yourrumor:=num;
   end;

   procedure prestart;
   var num:integer;
    begin
      openrfile;
      num:=yourrumor;
      drawbox(19,'RUMOR SECTION');
      if asciigraphics in urec.config then
         begin
         ansicolor(urec.bordercolor);
         writeln('Ŀ');
         tab('',3);
         ansicolor(urec.regularcolor);
         write('Rumors: ');
         ansicolor(urec.statcolor);
         tab(strr(numrumors),7);
         ansicolor(urec.bordercolor);
         writeln('');
         tab('',3);
         ansicolor(urec.regularcolor);
         write('Yours:  ');
         ansicolor(urec.statcolor);
         tab(strr(num),7);
         ansicolor(urec.bordercolor);
         writeln('');
         writeln('');
         end
      else
         begin
         writeln;
         writeln('  Rumors: ',strr(numrumors));
         writeln('  Yours:  ',strr(num));
         end;
    end;

   procedure sysopmenu;
   var i:integer;
   label exit;
   begin
{   cursection:=rumorsysop;}
   if not issysop then goto exit;
{   if (ulvl<sysoplevel) then
      begin
      writeln (^B'Nice try, but level ',sysoplevel,' is required.');
      exit;
      end;}
   writelog(22,9,'');
      repeat
      input:='';
      close(rfile);
      i:=menu (command.commandstr[10],'SRUMOR',menus.commands[10]);
        case i of
          1:massdelete;
          2:listrumors(2);
        end;
      until hungupon or (i=3);
   exit:
   end;

var i:integer;
begin
  returnto:='R';
  if not fromdoor then prestart else fromdoor:=false;
  if ulvl<40 then exit;
  repeat
  input:='';
  close(rfile);
  i:=menu (command.commandstr[11],'RUMOR',menus.commands[11]);
    case i of
      2:addrumor;
      3:deleterumor;
      4:listrumors(1);
      5:sysopmenu;
    end
  until hungupon or (i=1);
end;

begin
end.