{$O+}
unit mainmenu;

interface

uses crt,dos,
     gentypes,configrt,statret,textret,userret1,userret2,mailret,gensubs,subs1,
     subs2,windows,chatstuf,mainr1,mainr2,mainr3,overret1,overret2;

procedure nochat;
procedure editusers;
procedure zapspecifiedusers;
procedure summonsysop;
procedure msgtonextuser;
procedure offtheboard;
procedure listusers;
procedure transfername;
procedure yourstatus;
procedure delerrlog;
procedure feedback(bobby:integer);
procedure settime;
procedure changepwd;
procedure makeuser;
procedure infoformhunt;
procedure donations;
procedure viewsyslog;
procedure delsyslog(a:boolean);
procedure showsystemstatus;
procedure showallsysops;
procedure otherbbs;
procedure readerrlog;
procedure showad;
procedure readfeedback;
implementation


procedure feedback(bobby:integer);
var m:mailrec;
    me:message;
    username:mstr;
    who,x:integer;
    y:array[1..300] of integer;
    u:userrec;
    outofrange:boolean;

  procedure showallsysopsfeedback;
  var n:integer;

    procedure showuserfeedback;
    begin
      x:=x+1;
      ansicolor(urec.promptcolor);
      write(x);
      ansicolor(urec.regularcolor);
      write(')   '^S,u.handle,' - ');
      ansicolor(urec.regularcolor);
      writeln(u.comment);
    end;


  begin
    x:=0;
    for n:=1 to numusers do
      begin
      seek (ufile,n);
      read (ufile,u);
      if ((u.level>=sysoplevel) and (showinfeedback in u.config)) then showuserfeedback;
      end;
  end;

begin
  who:=1;
  m.title:='';
  outofrange:=false;
  if bobby=0 then
  begin
     writestr ('Leave feedback to a SysOp? *');
     if not yes then exit;
     writeln;
  end;
  if bobby=0 then
  begin
     showallsysopsfeedback;
     writeln;
     writestr ('Send feedback to which SysOp? *');
     who:=valu(input);
     if length(input)=0 then exit;
     if ((who>1) and (who<=x)) then
     begin
        opentfile('Email');
        username:=lookupuname (y[who]);
        seek (ufile,y[who]);
        read (ufile,u);
        writehdr ('Sending feedback to '+username);
        doanon:=true;
        m.line:=editor(me,true);
        doanon:=false;
        if m.line<0 then exit;
        if m.line>=0 then addmail (y[who],m.line,me,false);
        m.title:=me.title;
        closetfile;
     end else outofrange:=true;
  end;
  if ((who=1) and (bobby<>1)) then
  begin
     opentfile('Feedback');
     writehdr ('Sending feedback to '+sysopname);
     doanon:=true;
     m.line:=editor(me,true);
     doanon:=false;
     if m.line<0 then exit;
     m.title:=me.title;
     m.sentby:=unam;
     m.anon:=false;
     m.when:=now;
     addfeedback (m);
     closetfile;
  end;
  if bobby=1 then
  begin
     opentfile('Feedback');
     writehdr ('Sending feedback to '+sysopname);
     doanon:=false;
     m.line:=editor(me,false);
     if m.line<0 then exit;
     m.title:='* NO NUP *';
     m.sentby:='* UNKNOWN *';
     m.anon:=false;
     m.when:=now;
     addfeedback (m);
     closetfile;
  end;
  if (((bobby=1) or (bobby=0)) and (length(m.title)>0)) and not outofrange
     then writestr ('Feedback sent.');
end;

procedure nochat;
var fn:lstr;
begin
	fn:=textfiledir+'nochat';
	display (fn);
	chatmode:=true;
	writelog (1,2,'');
     feedback(0);
end;

procedure editusers;
var eunum:integer;
    matched:boolean;

  procedure elistusers (getspecs:boolean);
  var cnt,f,l:integer;
      u:userrec;
      us:userspecsrec;

    procedure listuser;
    begin
      write (cnt:4,' ');
      tab (u.handle,31);
      write (u.level:6,' ');
      tab (datestr(u.laston),8);
      writeln (u.nbu:6,u.numon:6,postcallratio(u):7:2)
    end;

  begin
    if getspecs
      then if selectspecs(us)
        then exit
        else
          begin
            f:=1;
            l:=numusers
          end
      else parserange (numusers,f,l);
    seek (ufile,f);
    matched:=false;
    writeln (^B^M^M' Num Name                            Level ',
             'Last on  Posts Calls PCR');
    for cnt:=f to l do begin
      read (ufile,u);
      if (not getspecs) or fitsspecs(u,us) then begin
        listuser;
        matched:=true
      end;
      handleincoming;
      if break then exit
    end;
    if not matched then
      if getspecs
        then writeln (^B^M'No users match specifications!')
        else writeln (^B^M'No users found in that range!')
  end;

begin
  repeat
    writestr (^M'User to edit [?,??=list]:');
    if (length(input)=0) or (match(input,'Q')) then exit;
    if input[1]='?'
      then elistusers (input='??')
      else begin
        eunum:=lookupuser (input);
        if eunum=0
          then writestr ('User not found!')
          else edituser (eunum)
      end
  until hungupon
end;

procedure zapspecifiedusers;
var us:userspecsrec;
    confirm:boolean;
    u:userrec;
    cnt:integer;
    done:boolean;
begin
  if selectspecs (us) then exit;
  writestr ('Confirm each deletion individually? *');
  if length(input)=0 then exit;
  confirm:=yes;
  if not confirm then begin
    writestr (^M'Are you SURE you want to mass delete without confirmation? *');
    if not yes then exit
  end;
  for cnt:=1 to numusers do begin
    seek (ufile,cnt);
    read (ufile,u);
    if (length(u.handle)>0) and fitsspecs (u,us) then begin
      if confirm
        then
          begin
            done:=false;
            repeat
              writestr ('Delete '+u.handle+' (Y/N/X/E):');
              if length(input)>0 then case upcase(input[1]) of
                'Y':begin
                      done:=true;
                      writeln ('Deleting '+u.handle+'...');
                      deleteuser (cnt)
                    end;
                'N':done:=true;
                'X':exit;
                'E':begin
                      edituser(cnt);
                      writeln;
                      writeln
                    end
              end
            until done
          end
        else
          begin
            writeln ('Deleting '+u.handle+'...');
            if break then begin
              writestr ('Aborted!!');
              exit
            end;
            deleteuser (cnt)
          end
    end
  end
end;

procedure summonsysop;
var tf:text;
    k:char;
begin
  chatmode:=not chatmode;
  bottomline;
  if chatmode
    then
      if sysopisavail
        then
          begin
            writestr ('Enter a short reason: &');
            chatreason:=input;
            if length(input)=0 then begin
              chatmode:=false;
              exit
            end;
            writelog (1,3,chatreason);
            splitscreen (4);
            top;
            clrscr;
            writeln (usr,unam,' wants to chat!  His reason:');
            write (usr,chatreason);
            bottom;
            assign (tf,textfiledir+'Chat');
            reset (tf);
            if ioresult=0 then begin
              while (not (eof(tf) or hungupon)) and chatmode do
                begin
                  read (tf,k);
                  nobreak:=true;
                  if ord(k)=7 then summonbeep else writechar (k);
                  if keyhit then begin
                    k:=bioskey;
                    clearbreak;
                    chat (false)
                  end
                end;
              textclose (tf)
            end;
            if chatmode
              then writestr (^M'SysOp page - ON')
              else unsplit
          end
        else begin
	  nochat;
	  chatmode:=false;
	end
    else writestr ('SysOp page - OFF');
  clearbreak
end;

procedure msgtonextuser;
var q,n:integer;
    tn:file of integer;
    m:message;
    mes:messagerec;
begin
    writestr ('Leave message to next user? *');
    if yes then begin
        closetfile;
        opentfile('LastUser');
        q:=editor(m,false);
        if q>=0 then begin
            if tonext>=0 then deletetext (tonext);
            tonext:=q;
            writelog (0,6,'');
            assign(mesfile,'LASTUSER.');
            rewrite(mesfile);
            mes.username:=urec.handle;
            write(mesfile,mes);
            close(mesfile);
            closetfile;
           end;
       end;
end;

procedure offtheboard;
var q,n:integer;
    tn:file of integer;
    fn:lstr;
    m:message;
begin
  writestr ('Disconnect from '+longname+'? *');
  if yes then begin
      msgtonextuser;
      fn:=textfiledir+'GoodBye';
      display(fn);
      disconnect;
    end;
end;

procedure listusers;
var cnt:integer;
    u:userrec;
begin
  writeln (^B'User#   Name                       Level             Total calls   Last call'^M);
  if break then exit;
  for cnt:=1 to numusers do
    begin
      seek (ufile,cnt);
      read (ufile,u); che;
      if length(u.handle)>0 then begin
        tab (strr(cnt),8);
        if break then exit;
        tab (u.handle,27);
        if break then exit;
        tab (u.comment,18);
        if break then exit;
        tab (strr(u.numon),14);
        if break then exit;
        writestr (datestr(u.laston));
        if break then exit
      end
    end
end;

procedure transfername;
var un,nlvl,ntime,tmp:integer;
    u:userrec;
begin
  if tempsysop then begin
    writestr ('Disabling temporary sysop powers...');
    ulvl:=regularlevel;
    tempsysop:=false
  end;
  writestr ('Transfer to user name:');
  if length(input)=0 then exit;
  un:=lookupuser(input);
  if unum=un then begin
    writestr ('You can''t transfer to yourself!');
    exit
  end;
  if un=0 then begin
    writestr ('No such user.');
    exit
  end;
  seek (ufile,un);
  read (ufile,u);
  writelog (1,4,u.handle);
  updateuserstats (false);
  ntime:=0;
  if u.timetoday > u.timeperday then u.timetoday:=u.timeperday;
  if datepart(u.laston)<>datepart(now) then
    ntime:=u.timeperday;
  if u.timetoday<10
    then if issysop or (u.level>=sysoplevel)
      then
        begin
          writestr ('The user has '+strr(u.timetoday)+' min(s) left!');
          writestr ('New time left:');
          ntime:=valu(input)
        end
      else
        if u.timetoday>0
          then writeln ('Warning: You have ',u.timetoday,' minutes left!')
          else
            begin
              writestr ('Sorry, that user doesn''t have any time left!');
              exit
            end;
  unum:=un;
  readurec;
  if ntime<>0 then begin
    urec.timetoday:=ntime;
    writeurec
  end;
end;

procedure yourstatus;
begin
  writehdr ('Your Status');
  writeln ('Name:          '^S,unam,
         ^M'SLevel:        '^S,ulvl,
         ^M'XLevel:        '^S,urec.udlevel,
         ^M'GLevel:        '^S,urec.glevel,
         ^M'Comment:       '^S,urec.comment,
         ^M'Calls:         '^S,urec.numon,
         ^M'Posted:        '^S,urec.nbu,
       ^M^M'Transfer section',
         ^M'  Uploads:     '^S,urec.uploads,
         ^M'  Downloads:   '^S,urec.downloads,
       ^M^M'Total time on: '^S,urec.totaltime,
         ^M'Time per day:  '^S,urec.timeperday,
         ^M'Time left:     '^S,timeleft)
end;

procedure delerrlog;
var e:text;
    i:integer;
begin
  writestr ('Delete error log:  Confirm:');
  if not yes then exit;
  assign (e,'errlog');
  reset (e);
  i:=ioresult;
  if ioresult=1
    then writeln (^M'No error log!')
    else begin
      textclose (e);
      erase (e);
      writestr ('Error log deleted.');
      if ioresult>1
        then writeln ('I/O error ',i,' deleting error log!');
      writelog (2,2,'')
    end
end;

procedure settime;
var t:integer;
    n:longint;
    r:registers;
    d:datetime;
begin
  writestr ('Current time: '+timestr(now));
  writestr ('Current date: '+datestr(now));
  writestr ('Enter new time:');
  if length(input)<>0
    then begin
      t:=timeleft;
      unpacktime (timeval(input),d);
      r.ch:=d.hour;
      r.cl:=d.min;
      r.dh:=0;
      r.dl:=0;
      r.ah:=$2d;
      intr ($21,r);
      if r.al=$ff then writestr ('Invalid time!');
      settimeleft (t)
    end;
  writestr ('Enter new date:');
  if length(input)<>0
    then begin
      unpacktime (dateval(input),d);
      r.dl:=d.day;
      r.dh:=d.month;
      r.cx:=d.year;
      r.ah:=$2b;
      intr ($21,r);
      if r.al=$ff then writestr ('Invalid date!')
    end;
  writelog (2,4,'')
end;

procedure changepwd;
var t:sstr;
begin
  writehdr ('Password Change');
  dots:=true;
  buflen:=15;
  if getpassword
    then begin
      writeurec;
      writestr ('Password changed.');
      writelog (6,2,'')
    end else
      writestr ('No change.')
end;

procedure makeuser;
var u:userrec;
    un,ln:integer;
begin
  writehdr ('Add a user');
  writestr ('Name:');
  if length(input)=0 then exit;
  if lookupuser(input)<>0 then begin
    writestr ('Sorry!  Already exists!');
    exit
  end;
  u.handle:=input;
  writestr ('Password:');
  u.password:=input;
  writestr ('Level:');
  if length(input)=0 then exit;
  u.level:=valu(input);
  un:=adduser(u);
  if un=-1 then begin
    writestr ('Sorry, no room for new users!');
    exit
  end;
  u.timeperday :=deftime;
  u.timetoday:=u.timeperday;
  writeufile (u,un);
  writestr ('User added as #'+strr(un)+'.');
  writelog (2,8,u.handle)
end;

procedure infoformhunt;
begin
  writestr ('User to search for: ');
  writeln (^M);
  showinfoforms (input)
end;

procedure donations;
var fn:lstr;
begin
  fn:=textfiledir+'Donation';
  if exist (fn)
    then printfile (fn)
    else begin
      writestr ('I''m sorry, no information is currently available.');
      if issysop
        then writestr ('Sysop:  To create donation information text, make a file called '+fn)
    end
end;

procedure viewsyslog;
var n:integer;
    l:logrec;

  function lookupsyslogdat (m,s:integer):integer;
  var cnt:integer;
  begin
    for cnt:=1 to numsyslogdat do with syslogdat[cnt] do
      if (menu=m) and (subcommand=s) then begin
        lookupsyslogdat:=cnt;
        exit
      end;
    lookupsyslogdat:=0
  end;

  function firstentry:boolean;
  begin
    firstentry:=(l.menu=0) and (l.subcommand in [1..2])
  end;

  procedure backup;
  begin
    while n<>0 do begin
      n:=n-1;
      seek (logfile,n);
      read (logfile,l);
      if firstentry then exit
    end;
    n:=-1
  end;

  procedure showentry (includedate:boolean);
  var q:lstr;
      p:integer;
  begin
    q:=syslogdat[lookupsyslogdat(l.menu,l.subcommand)].text;
    p:=pos('%',q);
    if p<>0 then q:=copy(q,1,p-1)+l.param+copy(q,p+1,255);
    if includedate then q:=q+' on '+datestr(l.when);
    q:=q+' at '+timestr(l.when);
    writeln (q)
  end;

var b:boolean;
begin
  writehdr ('View system log');
  writeln ('Press space to advance to the previous caller, X to abort.');
  writeln;
  writelog (2,6,'');
  n:=filesize(logfile);
  repeat
    clearbreak;
    writeln (^M);
    backup;
    if n=-1 then exit;
    seek (logfile,n);
    read (logfile,l);
    showentry (true);
    b:=false;
    while not (eof(logfile) or break or xpressed or b) do begin
      read (logfile,l);
      b:=firstentry;
      if not b then showentry (false);
    end
  until xpressed
end;

procedure delsyslog(a:boolean);
var int4:datetime;
    t:word;
    logb : file of char;
    logbname : string[80];
    int1,int2,int6,int7: string[2];
    int3 : string[4];
    int5 : integer;
    finie : boolean;

begin
  if not a then
    begin
    writestr ('Delete system log: Confirm:');
    if not yes then exit;
    end;
  close (logfile);
  getdate (int4.year,int4.month,int4.day,t);
  str(int4.day,int1);
  str(int4.month,int2);
  str(int4.year,int3);
  int7 := copy(int3,3,2);
  logbname := (int2 + '-' + int1 + '-' + int7 + '.1');
  int5 := 0;
  finie := false;
  repeat
    assign (logb,logbname);
    if exist (logbname) then
      begin
      int5 := int5 + 1;
      str(int5,int6);
      logbname := (int2 + '-' + int1 + '-' + int7 + '.' + int6);
      end
    else
      begin
      rename (logfile,logbname);
      rewrite (logfile);
      reset (logfile);
      finie := true;
      end
  until finie;
  if a=false then writeln (^M'System log deleted.');
  writelog (2,7,unam);
end;

procedure showsystemstatus;
var totalused,totalidle,totalup,totaldown,totalmins,callsday:real;

  procedure percent (prompt:mstr; top,bot:real);
  var p:real;
  begin
    write (prompt);
    if bot<1 then begin
      writeln ('N/A');
      exit
    end;
    p:=round(1000*top/bot)/10;
    writeln (p:0:1,'%')
  end;

begin
  totalused:=numminsused.total+elapsedtime(numminsused);
  totalidle:=numminsidle.total;
  totalup:=totalidle+numminsused.total;
  totalmins:=1440.0*(numdaysup-1.0)+timer;
  totaldown:=totalmins-totalup;
  callsday:=round(10*numcallers/numdaysup)/10;
  writehdr ('System Status');
  writeln ('Time & date:       '^S,timestr(now),', ',datestr(now),
       ^M^J'Calls today:       '^S,callstoday,
       ^M^J'Total callers:     '^S,numcallers:0:0,
       ^M^J'Total days up:     '^S,numdaysup,
       ^M^J'Calls per day:     '^S,callsday:0:1,
       ^M^J'Total mins in use: '^S,numminsused.total:0:0,
       ^M^J'Total mins idle:   '^S,totalidle:0:0,
       ^M^J'Mins file xfer:    '^S,numminsxfer.total:0:0,
       ^M^J'Total mins up:     '^S,totalup:0:0,
       ^M^J'Total mins down:   '^S,totaldown:0:0);
  percent ('Percent in use:    '^S,totalused,totalmins);
  percent ('Percent idle:      '^S,totalidle,totalmins);
  percent ('Percent up:        '^S,totalup,totalmins);
  percent ('Percent down:      '^S,totaldown,totalmins);
end;

procedure showallsysops;
var n:integer;
    u:userrec;

  procedure showuser;
  begin
    writeln (^B^M'Name:  '^S,u.handle,
               ^M'Level: '^S,u.level,^M);
    writestr (^M'Edit user? *');
    if yes then edituser (n)
  end;

begin
  for n:=1 to numusers do begin
    seek (ufile,n);
    read (ufile,u);
    if (u.level>=sysoplevel) then showuser
  end
end;

procedure otherbbs;
begin
  printfile (textfiledir+'Otherbbs')
end;

procedure readerrlog;
begin
  if exist ('Errlog')
    then printfile ('Errlog')
    else writestr ('No error file!')
end;

procedure showad;
var fn:lstr;
begin
  fn:=textfiledir+'Brand-X.AD';
  if exist (fn) then printfile (fn)
end;

procedure readfeedback;
var ffile:file of mailrec;
    m:mailrec;
    me:message;
    cur:integer;

  function nummessages:integer;
  begin
    nummessages:=filesize(ffile)
  end;

  function checkcur:boolean;
  begin
    if length(input)>1 then cur:=valu(copy(input,2,255));
    if (cur<1) or (cur>nummessages) then begin
      writestr (^M'Message out of range!');
      cur:=0;
      checkcur:=true
    end else begin
      checkcur:=false;
      seek (ffile,cur-1);
      read (ffile,m)
    end
  end;

  procedure readnum (n:integer);
  begin
    cur:=n;
    input:='';
    if checkcur then exit;
    writeln (^B^M'Message: '^S,cur,
               ^M'Title:   '^S,m.title,
               ^M'Sent by: '^S,m.sentby,
               ^M'Sent on: '^S,datestr(m.when),' at ',timestr(m.when),^M);
    if break then exit;
    printtext (m.line)
  end;

  procedure writecurmsg;
  begin
    if (cur<1) or (cur>nummessages) then cur:=0;
    write (^B^M'Current msg: '^S);
    if cur=0 then write ('None') else begin
      seek (ffile,cur-1);
      read (ffile,m);
      write (m.title,' by ',m.sentby)
    end
  end;

  procedure delfeedback;
  var cnt:integer;
  begin
    if checkcur then exit;
    opentfile('Feedback');
    deletetext (m.line);
    for cnt:=cur to nummessages-1 do begin
      seek (ffile,cnt);
      read (ffile,m);
      seek (ffile,cnt-1);
      write (ffile,m)
    end;
    seek (ffile,nummessages-1);
    truncate (ffile);
    closetfile;
    cur:=cur-1
  end;

  procedure editusr;
  var n:integer;
  begin
    if checkcur then exit;
    n:=lookupuser (m.sentby);
    if n=0
      then writestr ('User disappeared!')
      else edituser (n)
  end;

  procedure infoform;
  begin
    if checkcur then exit;
    showinfoforms (m.sentby)
  end;

  procedure nextfeedback;
  begin
    cur:=cur+1;
    if cur>nummessages then begin
      writestr (^M'Sorry, no more feedback!');
      cur:=0;
      exit
    end;
    readnum (cur)
  end;

  procedure readagain;
  begin
    if checkcur then exit;
    readnum (cur)
  end;

  procedure replyfeedback;
  begin
    if checkcur then exit;
    sendmailto (m.sentby,false)
  end;

  procedure listfeedback;
  var cnt:integer;
  begin
    if nummessages=0 then exit;
    thereare (nummessages,'piece of feedback','pieces of feedback');
    if break then exit;
    writeln (^M'Num Title                          Left by'^M);
    seek (ffile,0);
    for cnt:=1 to nummessages do begin
      read (ffile,m);
      tab (strr(cnt),4);
      if break then exit;
      tab (m.title,31);
      writeln (m.sentby);
      if break then exit
    end
  end;

var q:integer;
label exit;
begin
  assign (ffile,'Feedback');
  reset (ffile);
  if ioresult<>0 then rewrite (ffile);
  cur:=0;
  repeat
  opentfile('Feedback');
    if nummessages=0 then begin
      writestr ('Sorry, no feedback!');
      goto exit
    end;
    writecurmsg;
    q:=menu (command.commandstr[4],'FEED',menus.commands[4]);
    if q<0
      then readnum (-q)
      else case q of
        3:delfeedback;
        4:editusr;
        5:infoform;
        6:replyfeedback;
        7:nextfeedback;
        8:readagain;
        9:listfeedback;
      end;
    closetfile;
  until (q=1) or hungupon;
  exit:
  close (ffile);
end;

begin
end.
