{$O+}
unit configur;

interface

uses gentypes,userret1,gensubs,subs1,subs2,mainmenu,userret2,configrt,
      overret1,overret2;

procedure configure;

implementation

procedure configure;

const colorstr:array [0..7] of string[7]=
        ('Black','Blue','Green','Cyan','Red','Magenta','Brown','White');

procedure options (c:configtype; var prompt,onstr,offstr:lstr);

  procedure ret (x1,x2,x3:lstr);
  begin
    prompt:=x1;
    onstr:=x2;
    offstr:=x3
  end;

begin
  case c of
    postprompts:ret('Post prompts during newscan','Yes','No');
    postbars:ret('Use post bar during newscan','Yes','No');
    moreprompts:ret('Pause every screen','Yes','No');
    asciigraphics:ret('Use IBM graphics characters','Yes','No');
    showtime:ret('Display time left at prompts','Yes','No');
    fseditor:ret('Use full-screen editor','Yes','No');
    usesysopmenus:ret('Use SysOp defined prompts','Yes','No');
  end
end;

function getattrib (fg,bk:integer; hi,bl:boolean):byte;
begin
  getattrib:=fg+(byte(hi) shl 3)+(bk shl 4)+(byte(bl) shl 7)
end;

procedure getcolorvar (attr:byte; var fg,bk:integer; var hi,bl:boolean);
begin
  fg:=attr and 7;
  hi:=(attr and 8)=8;
  bk:=(attr shr 4) and 7;
  bl:=(attr and 128)=128
end;

procedure getthing (c:configtype);
var n:integer;
    name,onstr,offstr:lstr;
begin
  options (c,name,onstr,offstr);
  writehdr (name);
  write ('Current setting: '^S);
  if c in urec.config then write (onstr) else write (offstr);
  writeln (^B^M^M'Would you like:');
  writeln ('  1. ',onstr);
  writeln ('  2. ',offstr);
  writestr (^M'Your choice:');
  n:=valu(input);
  if (n>0) and (n<3) then begin
    if n=2
      then urec.config:=urec.config-[c]
      else urec.config:=urec.config+[c];
    writeurec
  end
end;

procedure writecolorstr (a:byte);
var fg,bk:integer;
    hi,bl:boolean;
begin
  getcolorvar (a,fg,bk,hi,bl);
  ansicolor (a);
  if bl then write ('Blinking ');
  if hi then write ('Highlighted ');
  write (colorstr[fg]);
  if bk>0 then write (' on ',colorstr[bk])
end;

function colorval (str:mstr):integer;
var cnt:integer;
begin
  colorval:=-1;
  if match(str,'None') then begin
    colorval:=0;
    exit
  end;
  for cnt:=0 to 7 do
    if match(str,colorstr[cnt]) then begin
      colorval:=cnt;
      exit
    end
end;

procedure badcolor;
var cnt:integer;
begin
  writeln ('Invalid color!');
  write ('Valid colors are Black, ');
  for cnt:=1 to 7 do begin
    ansicolor (cnt);
    write (colorstr[cnt]);
    if cnt=7
      then writeln ('.')
      else if cnt < 6 then write (', ');
    if cnt=6
      then write (', and ');
  end;
  writestr ('')
end;

procedure getcolor (prompt:mstr; var a:byte);

  procedure getacolor (var q:integer; prompt:mstr);
  var n:integer;
  begin
    repeat
      writestr ('Enter new '+prompt+' color:');
      if hungupon or (length(input)=0) then exit;
      n:=colorval(input);
      if n=-1
        then badcolor
        else q:=n
    until n<>-1
  end;

var fg,bk:integer;
    hi,bl:boolean;
begin
  if not (ansigraphics in urec.config) then begin
    writestr ('You must have ANSI emulation to see color.');
    exit
  end;
  getcolorvar (a,fg,bk,hi,bl);
  write ('Current ',prompt,' color: ');
  writecolorstr (a);
  writestr (^M^M);
  getacolor (fg,'foreground');
  getacolor (bk,'background');
  writestr ('Highlight the characters? *');
  hi:=yes;
  writestr ('Should the characters blink? *');
  bl:=yes;
  a:=getattrib (fg,bk,hi,bl)
end;

procedure emulation;
begin
  writeln (^B^M'Note:  ANSI is required for color and the full-screen editor.');
  writeln;
  writeln (^B'Please choose your terminal type.'^M^M,
           '   1. ANSI Color'^M,
           '   2. None'^M);
  writestr ('Emulation type:');
  if length(input)=0 then exit;
  if valu(input)=1 then urec.config:=urec.config+[ansigraphics] else
    urec.config:=urec.config-[ansigraphics];
end;

procedure getdisplaylen;
var v:integer;
begin
  writeln ('Current display length is: '^S,urec.displaylen);
  writestr (^M'Enter new display length:');
  if length(input)=0 then exit;
  v:=valu(input);
  if (v<21) or (v>43)
    then writeln ('Invalid!')
    else urec.displaylen:=v
end;

procedure getrumors;
var v:integer;
begin
  writeln ('Current prompts per rumor: '^S,urec.rumors);
  writestr (^M'Enter new rumor occurance:');
  if length(input)=0 then exit;
  v:=valu(input);
  if (v<0) or (v>100)
    then writeln ('Invalid!')
    else urec.rumors:=v
end;


procedure configurenewscan;
var bd:boardrec;
    bn:integer;
begin
  opentempbdfile;
  seek (bdfile,0);
  for bn:=0 to filesize(bdfile)-1 do begin
    read (bdfile,bd);
    if (ulvl>=bd.level) then begin
      writestr ('Newscan '+bd.boardname+' (now '+
                yesno(not (bn in urec.newscanconfig))+'):');
      if length(input)<>0 then
        if yes
          then urec.newscanconfig:=urec.newscanconfig-[bn]
          else urec.newscanconfig:=urec.newscanconfig+[bn]
    end
  end;
  closetempbdfile
end;

procedure showit (s,v:lstr);
begin
  if break then exit;
  tab (s+':',30);
  writeln (^S,v)
end;

procedure showthing (c:configtype);
var n:integer;
    name,onstr,offstr:lstr;
begin
  if break then exit;
  options (c,name,onstr,offstr);
  tab (name+':',30);
  write (^S);
  if c in urec.config
    then write (^S,onstr)
    else write (^S,offstr);
  writeln
end;

procedure showemulation;
var q:lstr;
begin
  if ansigraphics in urec.config then q:='ANSI Color' else q:='None';
  showit ('Terminal type',q)
end;

procedure showdisplaylen;
begin
  showit ('Display length',strr(urec.displaylen))
end;

procedure showrumors;
begin
  write ('Rumors every '^S,strr(urec.rumors));
  ansicolor(urec.regularcolor);
  writeln (' prompts');
end;

procedure showcolor (prompt:mstr; attr:byte);
begin
  if break then exit;
  tab ('  '+prompt+' color:',30);
  writecolorstr (attr);
  ansicolor(urec.regularcolor);
  writeln
end;

procedure getmstr (t:mstr; var mm);
var m:mstr absolute mm;
begin
    writeln ('Old ',t,': '^S,m);
    writestr ('New '+t+'? *');
    if length(input)>0 then m:=input;
end;

procedure changehandle;
var m:mstr;
    okaychange,okaymatch:boolean;
    loop,loop2:integer;
    power:string[5];
begin
    if not urec.handlechange then
         begin
         writeln('Sorry, '+sysopname+' doesn''t want you changing your handle.');
         exit;
         end;
    writehdr('Change Handle');
    m:=urec.handle;
    getmstr ('name',m);
    if m=unam then exit;
    if length(m)>25 then
         begin
         writeln('Sorry, names must be 25 characters or less.');
         exit;
         end;
    if (not match(m,urec.handle)) and (unum<>1) then
         if lookupuser(m)<>0 then
              begin
              writeln('Sorry, name already exists!');
              exit;
              end;
    power:='SYSOP';
    okaymatch:=false;
    if (pos(upcasestr(m),power) >0) or (pos(power,upcasestr(m)) >0)
       or (pos(upcasestr(m),upcasestr(sysopname)) >0)
       or (pos(upcasestr(sysopname),upcasestr(m)) >0) then okaychange := false
        else okaychange := true;
    if unum=1 then okaychange:=true;
    if not okaychange then begin
       writeln ('Nice try, but that won''t work.');
       exit
       end;
    unam:=m;
    writelog(6,1,m);
end;

procedure yourstatus;
begin
  writehdr ('Your Configuration');
  showthing (postprompts);
  showthing (postbars);
  showthing (moreprompts);
  showthing (asciigraphics);
  showthing (showtime);
  showthing (usesysopmenus);
  showemulation;
  showthing (fseditor);
  showdisplaylen;
  showrumors;
  if ansigraphics in urec.config then begin
    showcolor ('Prompt',urec.promptcolor);
    showcolor ('Input',urec.inputcolor);
    showcolor ('Regular',urec.regularcolor);
    showcolor ('Statistic',urec.statcolor);
    showcolor ('Border',urec.bordercolor);
    showcolor ('Highlight',urec.highlightcolor);
    showcolor ('Background',urec.backgroundcolor);
  end
end;

procedure resetcolors;
begin
    writehdr('All colors reset!');
    urec.regularcolor:=regularcolor;
    urec.promptcolor:=promptcolor;
    urec.statcolor:=statcolor;
    urec.inputcolor:=inputcolora;
    urec.bordercolor:=bordercolor;
    urec.highlightcolor:=highlightcolor;
    urec.backgroundcolor:=backgroundcolor;
end;

Procedure Set_colors;
var q : integer;
Begin
   repeat
    q:=menu (command.commandstr[15],'COLOR',menus.commands[15]);
    case q of
      2:getcolor ('prompt',urec.promptcolor);
      3:getcolor ('input',urec.inputcolor);
      4:getcolor ('regular',urec.regularcolor);
      5:getcolor ('statistic',urec.statcolor);
      6:getcolor ('border',urec.bordercolor);
      7:getthing (asciigraphics);
      8:emulation;
      9:resetcolors;
      10:getcolor ('highlight',urec.highlightcolor);
      11:getcolor ('background',urec.backgroundcolor);
    end;
    writeurec
  until (q=1) or hungupon
end;

var q:integer;
begin
  returnto:='K';
  if not fromdoor then drawbox(26,'CONFIGURATION SYSTEM') else fromdoor:=false;
  repeat
    if (fseditor in urec.config) and
       (urec.config=urec.config-[asciigraphics])
      then begin
        urec.config:=urec.config-[fseditor];
        writestr ('You may not use the full-screen editor without ASCII graphics.')
      end;
    q:=menu (command.commandstr[16],'CONFIG',menus.commands[16]);
    case q of
      2:;
      3:;
      4:getthing (postprompts);
      5:getthing (moreprompts);
      6:getthing (asciigraphics);
      7:getthing (showtime);
      8:;
      9:emulation;
      10:getdisplaylen;
      11:configurenewscan;
      12:yourstatus;
      13:getthing (fseditor);
      14:;
      15:changepwd;
      16:changehandle;
      17:set_colors;
      18:getthing (postbars);
      19:getrumors;
      20:begin getthing (usesysopmenus); resetmenus; end;
    end;
    writeurec
  until (q=1) or hungupon
end;

begin
end.
