{$O+}
unit bulletin;

interface

uses crt,
     gentypes,configrt,statret,gensubs,subs1,subs2,overret1,overret2,
     userret1,userret2,textret,mainr1,mainr2,mainr3,modem;

procedure bulletinmenu;

implementation
var  Post_array : Top_poster_type;

procedure bulletinmenu;
var q,curbul,lastreadnum:integer;
    b:bulrec;
    starting:boolean;

  procedure makeboard; forward;

  procedure clearorder (var bo:boardorder);
  var cnt:integer;
  begin
    for cnt:=0 to 255 do bo[cnt]:=cnt
  end;

  procedure carryout (var bo:boardorder);
  var u:userrec;
      cnt,un:integer;

    procedure doone;
    var cnt,q:integer;
        ns,a1,a2:set of byte;
    begin
      fillchar (ns,32,0);
      fillchar (a1,32,0);
      fillchar (a2,32,0);
      for cnt:=0 to 255 do begin
        q:=bo[cnt];
        if q in u.newscanconfig then ns:=ns+[cnt];
        if q in u.access1 then a1:=a1+[cnt];
        if q in u.access2 then a2:=a2+[cnt]
      end;
      u.newscanconfig:=ns;
      u.access1:=a1;
      u.access2:=a2;
      seek (ufile,un);
      write (ufile,u)
    end;

  begin
    writeln (^B'Adjusting user access flags...');
    seek (ufile,1);
    for un:=1 to numusers do begin
      if (un mod 10)=0 then write (' ',un);
      read (ufile,u);
      if length(u.handle)>0 then doone
    end
  end;

  procedure switchboards (bnum1,bnum2:integer; var bo:boardorder);
  var bd1,bd2:boardrec;
      n1:integer;
  begin
    seekbdfile (bnum1);
    read (bdfile,bd1);
    seekbdfile (bnum2);
    read (bdfile,bd2);
    seekbdfile (bnum1);
    writebdfile (bd2);
    seekbdfile (bnum2);
    writebdfile (bd1);
    n1:=bo[bnum1];
    bo[bnum1]:=bo[bnum2];
    bo[bnum2]:=n1
  end;

  procedure setfirstboard; forward;

  procedure seekbfile (n:integer);
  begin
    seek (bfile,n-1); che
  end;

  function numbuls:integer;
  begin
    numbuls:=filesize(bfile)
  end;

  procedure getlastreadnum;
  var oldb:boolean;
      b:bulrec;
      lr:word;
  begin
    lastreadnum:=numbuls;
    oldb:=false;
    lr:=urec.lastread[curboardnum];
    if lr=0
      then lastreadnum:=0
      else
        while (lastreadnum>0) and (not oldb) do begin
          seekbfile (lastreadnum);
          read (bfile,b);
          oldb:=b.id=lr;
          if not oldb then lastreadnum:=lastreadnum-1
        end
  end;

  procedure assignbfile;
  begin
    assign (bfile,boarddir+curboardname+'.BUL')
  end;

  procedure formatbfile;
  begin
    assignbfile;
    rewrite (bfile);
    curboardnum:=searchboard(curboardname);
    if curboardnum=-1 then begin
      curboardnum:=filesize(bdfile);
      fillchar (curboard,sizeof(curboard),0);
      writecurboard
    end
  end;

  procedure openbfile;
  var b:bulrec;
      i:integer;
  begin
    curboardnum:=searchboard (curboardname);
    if curboardnum=-1 then begin
      makeboard;
      exit
    end;
    close (bfile);
    assignbfile;
    reset (bfile);
    i:=ioresult;
    if ioresult<>0 then formatbfile;
    seekbdfile (curboardnum);
    read (bdfile,curboard);
    getlastreadnum;
  end;

  function boardexist(n:sstr):boolean;
  begin
    boardexist:=not (searchboard(n)=-1)
  end;

  procedure addbul (var b:bulrec);
  var b2:bulrec;
  begin
    if numbuls=0 then b.id:=1 else begin
      seekbfile (numbuls);
      read (bfile,b2);
      if b2.id=65535
        then b.id:=1
        else b.id:=b2.id+1
    end;
    seekbfile (numbuls+1);
    write (bfile,b)
  end;

  function checkcurbul:boolean;
  begin
    if (curbul<1) or (curbul>numbuls) then begin
      checkcurbul:=false;
      curbul:=numbuls;
    end else checkcurbul:=true
  end;

  procedure getbrec;
  begin
    if checkcurbul then begin
      seekbfile (curbul);
      read (bfile,b); che
    end
  end;

  procedure delbul (bn:integer; deltext:boolean);
  var c,un:integer;
      b:bulrec;
      u:userrec;
  begin
    if (bn<1) or (bn>numbuls) then exit;
    seekbfile (bn);
    read (bfile,b);
    if deltext then deletetext (b.line);
    for c:=bn to numbuls-1 do begin
      seekbfile (c+1);
      read (bfile,b);
      seekbfile (c);
      write (bfile,b)
    end;
    seekbfile (numbuls);
    truncate (bfile);
    getlastreadnum;
  end;

  procedure delboard (bdn:integer);
  var bd1:boardrec;
      cnt,nbds:integer;
      bo:boardorder;
  begin
    clearorder (bo);
    nbds:=filesize(bdfile)-1;
    if nbds=0 then begin
      close (bdfile);
      rewrite (bdfile);
      exit
    end;
    for cnt:=bdn to nbds-1 do begin
      seekbdfile (cnt+1);
      read (bdfile,bd1);
      seekbdfile (cnt);
      writebdfile (bd1);
      bo[cnt]:=cnt+1
    end;
    seek (bdfile,nbds);
    truncate (bdfile);
    seek (bifile,nbds);
    truncate (bifile);
    carryout (bo)
  end;

  procedure readcurbul;
  var q:anystr;
      t:sstr;
      cnt:integer;
  begin
    if checkcurbul then begin
      getbrec;
      writeln (^B'Message  '^S,curbul,^M'Title:   '^S,b.title);
      q:='Left by  '^S;
      if b.anon
        then
          begin
            q:=q+anonymousstr;
            if issysop then q:=q+' ('+b.leftby+')'
          end
        else
          begin
            if b.plevel=-1
              then t:='unknown'
              else t:=b.pcomment;
            q:=q+b.leftby+' ('+t+')'
          end;
      if issysop or (not b.anon)
        then writeln ('When:    '^S,datestr(b.when),' at ',timestr(b.when));
      writeln (q);
      if break then exit;
      printtext (b.line)
    end;
    if curbul>lastreadnum then begin
      lastreadnum:=curbul;
      urec.lastread[curboardnum]:=b.id
    end
  end;

  procedure autodelete;
  var cnt:integer;
  begin
    for cnt:=6 downto 2 do delbul (cnt,true)
  end;

Procedure Add_name(User : Mstr; Posts : WORD);
VAR L_pos : INTEGER;
    c1    : BYTE;
    Temp  : Top_poster_rec;

Procedure Insert_name(Ins_num : BYTE; User_n : Mstr; Posts : WORD);
VAR c1 : BYTE;
Begin
  If (Ins_num > MaxTopPosters) OR (Ins_num < 0) THEN Exit;
  For c1 := MaxTopPosters DOWNTO Ins_num+1 DO
      Post_array[c1] := Post_array[c1-1];
  Post_array[Ins_num].User_name := User_n;
  Post_array[Ins_num].Num_posts := Posts;
End;

Begin
   For c1 := 0 TO MaxTopPosters DO
      If Post_array[c1+1].Num_Posts < Posts then
         Begin
         Insert_Name(c1+1,User,Posts);
         Exit;
         End;
End;

Procedure Show_top_posters;
VAR IO_c       : INTEGER;
    c2         : INTEGER;
    Post_user  : UserRec;
begin
   Writeln('Creating top poster list.');
   Write('Please wait');
   fillchar(post_array,sizeof(post_array),0);
   For c2 := 1 TO NumUsers DO
      Begin
      If c2 MOD 6 = 0 THEN Write('.');
      Seek(Ufile,c2);
      Read(Ufile,Post_user);
      Add_name(Post_user.Handle,Post_user.Nbu);
      End;
  Writeln;
  WriteHdr(LongName+' Top Posters');
  writeln;
  For c2 := 1 TO MaxTopPosters DO
   Begin
    Tab('',2);
    Tab(Strr(c2)+'. ',4);
    Tab(Post_array[c2].User_name,25);
    Writeln('[',Post_array[c2].Num_posts,' posts]');
   End;
End;

  procedure postbul;
  var l:integer;
      m:message;
      b:bulrec;
  begin
    if ulvl<postlevel then begin
      reqlevel(postlevel);
      exit
    end;
    l:=editor(m,true);
    if l>=0 then
      begin
        urec.nbu:=urec.nbu+1;
        writeurec;
        b.anon:=m.anon;
        b.title:=m.title;
        b.when:=now;
        b.leftby:=unam;
        b.line:=l;
        b.plevel:=ulvl;
        b.pcomment:=urec.comment;
        addbul (b);
        newposts:=newposts+1;
        writelog (4,7,b.title);
        with curboard do
          if autodel<=numbuls then autodelete
      end
  end;

  procedure getbnum (txt:mstr);
  var q:boolean;
  begin
    if length(input)>1
      then curbul:=valu(copy(input,2,255))
      else begin
        writestr (^M'Message to '+txt+':');
        {if length(input)>0 then curbul:=valu(input);}
	curbul:=valu(input);
      end;
    q:=checkcurbul
  end;

  procedure readnextbul;
  var t:integer;
  begin
    t:=curbul;
    curbul:=curbul+1;
    readcurbul;
    if curbul=0 then curbul:=t
  end;

  procedure readnum (n:integer);
  begin
    curbul:=n;
    readcurbul
  end;

  function haveaccess (n:integer):boolean;
  begin
    curboardnum:=n;
    seekbdfile (n);
    read (bdfile,curboard);
    haveaccess:=ulvl>=curboard.level
  end;

  procedure makeboard;
  begin
    formatbfile;
    with curboard do begin
      shortname:=curboardname;
      buflen:=30;
      writestr (^M'Board name: &');
      boardname:=input;
      writestr ('Minimum level for entry:');
      level:=valu(input);
      writestr ('Autodelete after:');
      autodel:=valu(input);
      if autodel<10 then begin
        writeln ('Must be at least 10!');
        autodel:=10
      end;
      writecurboard;
      writeln ('Board created.');
      writelog (4,4,boardname+' ['+shortname+']')
    end
  end;

  procedure setactive (nn:sstr);

    procedure doswitch;
    var hey:lstr;
        x:integer;
    begin
      openbfile;
      curbul:=lastreadnum;
      if asciigraphics in urec.config then
         begin
         if not starting then writeln;
         ansicolor(urec.bordercolor);
         writeln('Ŀ');
         tab('',2);
         ansicolor(urec.regularcolor);
         tab('Sub-board:',11);
         ansicolor(urec.statcolor);
         for x:=1 to length(nn) do nn[x]:=upcase(nn[x]);
         hey:=curboard.boardname+' ['+nn+']';
         tab(hey,37);
         ansicolor(urec.bordercolor);
         writeln('');
         tab('',2);
         ansicolor(urec.regularcolor);
         tab('Messages:',11);
         ansicolor(urec.statcolor);
         tab(strr(numbuls),37);
         ansicolor(urec.bordercolor);
         writeln('');
         tab('',2);
         ansicolor(urec.regularcolor);
         tab('Last read:',11);
         ansicolor(urec.statcolor);
         tab(strr(lastreadnum),37);
         ansicolor(urec.bordercolor);
         writeln('');
         writeln('');
         if curboardnum=filesize(bdfile)-1 then
              begin
              ansicolor(urec.statcolor);
              writeln('  -> Last sub board! <-');
              end;
         ansicolor(urec.regularcolor);
         end else

         begin
            with curboard do
            writeln (^M'Sub-board: '^S,boardname,
                     ^M'Messages:  '^S,numbuls,
                     ^M'Last read: '^S,lastreadnum,^M)
         end;
    end;

    procedure tryswitch;
    var n,s:integer;

      procedure denyaccess;
      var b:bulrec;
      begin
        writeln('No such board!');
        setfirstboard
      end;

    begin
      curboardname:=nn;
      curboardnum:=searchboard(nn);
      if haveaccess(curboardnum)
        then doswitch
        else denyaccess;
    if starting then starting:=false;
    end;

  var b:bulrec;
  begin
    curbul:=0;
    close (bfile);
    curboardname:=nn;
    if boardexist(nn) then tryswitch else begin
      writeln ('No such board!');
      if issysop
        then
          begin
            writestr (^M'Create one (Y/N)? *');
            if yes
              then
                begin
                  makeboard;
                  setactive (curboardname)
                end
              else setfirstboard
          end
        else setfirstboard
    end
  end;

  function validbname (n:sstr):boolean;
  var cnt:integer;
  begin
    validbname:=false;
    if (length(n)=0) or (length(n)>8) then exit;
    for cnt:=1 to length(n) do
      if not (upcase(n[cnt]) in ['0'..'9','A'..'Z']) then exit;
    validbname:=true
  end;

  procedure listboards;
  var cnt,oldcurboard:integer;
      printed:boolean;
      fn:lstr;
  begin
    fn:=textfiledir+'arealist.msg';
    if exist (fn) then
    begin
    printfile (fn);
    exit;
    end
    else begin
    oldcurboard:=curboardnum;
    sendchar('');
    clrscr;
    if asciigraphics in urec.config then
     begin
       ansicolor(urec.bordercolor);
       writeln('Ŀ');
       tab('',2);
       ansicolor(urec.statcolor);
       write ('  Active   Name                      Level ');
       ansicolor(urec.bordercolor);
       writeln('');
       writeln('');
       writeln;
       if break then exit;
       for cnt:=0 to filesize(bdfile)-1 do
        if haveaccess(cnt) then
          with curboard do begin
          write ('    ');
            ansicolor(urec.statcolor);
            tab (shortname,9);
            ansicolor (urec.regularcolor);
            tab (boardname,26);
            writeln (level);
            if break then exit
          end
     end
    else begin
      writeln (^M'Active   Name                      Level'^M);
      if break then exit;
      for cnt:=0 to filesize(bdfile)-1 do
        if haveaccess(cnt) then
          with curboard do begin
            tab (shortname,9);
            tab (boardname,26);
            writeln (level);
            if break then exit
          end;
      end;
    curboardnum:=oldcurboard;
    seekbdfile (curboardnum);
    read (bdfile,curboard)
  end;
  end;

  procedure activeboard;
  begin
    if length(input)>1
      then input:=copy(input,2,255)
      else
        repeat
          writestr (^M^M'Board number [?=List]:');
          if input='?' then listboards;
          if (input = 'q') or (input = 'Q') then exit;
        until (input<>'?') or hungupon;
    if hungupon or (length(input)=0) then exit;
    if input[1]='*' then input:=copy(input,2,255);
    if validbname(input)
      then  setactive(input)
      else
        begin
          writeln (^M'Invalid board name!');
          setfirstboard
        end
  end;

  procedure setfirstboard; { FORWARD }
  var fbn:sstr;
  begin
    if filesize(bdfile)=0 then exit;
    if not haveaccess(0)
      then error ('User can''t access first board','','');
    seek (bifile,0);
    read (bifile,fbn);
    setactive (fbn)
  end;

  procedure listbuls;
  var cnt,bn:integer;
      q:boolean;
  begin
    if length(input)>1 then begin
      curbul:=valu(copy(input,2,255));
      q:=checkcurbul
    end;
    if curbul=0
      then
        begin
          writestr (^M'List titles starting at #*');
          curbul:=valu(input)
        end
      else
        if length(input)>1
          then curbul:=valu(input)
          else curbul:=curbul+10;
    if not checkcurbul then curbul:=1;
    writeln ('Titles:'^M);
    for cnt:=0 to 9 do
      begin
        bn:=curbul+cnt;
        if (bn>0) and (bn<=numbuls) then
          begin
            seekbfile (bn);
            read (bfile,b);
            write (bn,'. ',b.title,' by ');
            if b.anon
              then writeln (anonymousstr)
              else writeln (b.leftby);
            if break then exit
          end
      end
  end;

  procedure killbul;
  var un:integer;
      u:userrec;
  begin
    writehdr ('Message Deletion');
    getbnum ('delete');
    if not checkcurbul then exit;
    getbrec;
    if (not match(b.leftby,unam)) and (not issysop)
      then begin
        writeln ('You didn''t post that!');
        pausenow;
        exit
      end;
    writeln ('Title:   ',b.title,
             ^M'Left by: ',b.leftby,^M^M);
    writestr ('Delete this? *');
    if not yes then exit;
    un:=lookupuser (b.leftby);
    if un<>0 then begin
      writeurec;
      seek (ufile,un);
      read (ufile,u);
      u.nbu:=u.nbu-1;
      seek (ufile,un);
      write (ufile,u);
      readurec;
    end;
    delbul (curbul,true);
    writeln ('Message deleted.');
    writelog (4,5,b.title)
  end;

  procedure editbul;
  var me:message;
  begin
    getbnum ('edit');
    if not checkcurbul then exit;
    getbrec;
    if (not match(b.leftby,unam)) and (not issysop)
      then begin
        writeln ('You didn''t post that!');
        pausenow;
        exit
      end;
    reloadtext (b.line,me);
    me.title:=b.title;
    me.anon:=b.anon;
    if reedit (me,true) then begin
      writelog (4,6,b.title);
      deletetext (b.line);
      b.line:=maketext (me);
      if b.line<0 then begin
        writestr (^M'Deleting message...');
        delbul (curbul,false)
      end else begin
        seekbfile (curbul);
        write (bfile,b)
      end
    end
  end;


  procedure sendbreply;
  begin
    if checkcurbul then begin
      getbrec;
      sendmailto (b.leftby,b.anon)
    end else begin
      getbnum ('reply to');
      if checkcurbul then sendbreply
    end
  end;

  procedure boardsponsor;

    procedure getbgen (txt:mstr; var q);
    var s:lstr absolute q;
    begin
      writeln (^B'Current ',txt,': ',s);
      buflen:=30;
      writestr ('Enter new '+txt+':');
      if length(input)>0 then s:=input
    end;

    procedure getbint (txt:mstr; var i:integer);
    var a:anystr;
    begin
      a:=strr(i);
      getbgen (txt,a);
      i:=valu(a);
      writecurboard
    end;

    procedure getbstr (txt:mstr; var q);
    begin
      getbgen (txt,q);
      writecurboard
    end;

    procedure getblevel;
    var b:bulrec;
    begin
      getbint ('level',curboard.level);
      writelog (5,12,strr(curboard.level))
    end;

    procedure getautodel;
    var b:bulrec;
    begin
      with curboard do begin
        getbint ('auto-delete',autodel);
        if autodel<10
          then
            begin
              writeln (^B'Notice: Autodelete set to ten!');
              autodel:=numbuls+1;
              if autodel<10 then autodel:=10;
              writeln (^B'Setting autodelete to ',autodel);
              writecurboard
            end
          else
            if autodel<=numbuls
              then
                begin
                  writeln (^B'Deleting messages...');
                  while autodel<=numbuls do delbul (2,true)
                end
      end;
      writelog (5,11,strr(curboard.autodel))
    end;

    procedure movebulletin;
    var b:bulrec;
        tcb:boardrec;
        tcbn,dbn,bnum:integer;
        tcbname,dbname:sstr;
    begin
      writehdr ('Message Move');
      getbnum ('move');
      if not checkcurbul then exit;
      bnum:=curbul;
      seekbfile (bnum);
      read (bfile,b);
      writestr ('Move "'+b.title+'" posted by '+b.leftby+
        ' to which board? *');
      if length(input)=0 then exit;
      tcbname:=curboardname;
      dbname:=input;
      dbn:=searchboard(dbname);
      if dbn=-1 then begin
        writeln ('No such board!');
        exit
      end;
      writeln ('Moving...');
      delbul (bnum,false);
      close (bfile);
      curboardname:=dbname;
      openbfile;
      addbul (b);
      close (bfile);
      curboardname:=tcbname;
      openbfile;
      writelog (5,13,b.title);
      writeln (^B'Done!')
    end;

    procedure renameboard;
    var sn:sstr;
        nfp,nbf,nff:lstr;
        qf:file;
        d:integer;
    begin
      getbstr ('board name',curboard.boardname);
      sn:=curboard.shortname;
      getbgen ('access name/number',sn);
      writelog (5,5,curboard.boardname+' ['+sn+']');
      if match(sn,curboard.shortname) then exit;
      if not validbname(sn) then begin
        writeln ('Invalid board name!');
        exit
      end;
      if boardexist(sn) then begin
        writeln ('Sorry!  Board already exists!');
        exit
      end;
      curboard.shortname:=sn;
      writecurboard;
      close (bfile);
      nfp:=boarddir+sn+'.';
      nbf:=nfp+'BUL';
      assign (qf,nbf);
      erase (qf);
      d:=ioresult;
      rename (bfile,nbf);
      setfirstboard;
      q:=9
    end;

    procedure killboard;
    var cnt:integer;
        f:file;
        fr:filerec;
        bd:boardrec;
    begin
      writestr ('Kill board:  Are you sure? *');
      if not yes then exit;
      writelog (5,10,'');
      writeln (^B^M'Deleting messages...');
      for cnt:=numbuls downto 1 do
        begin
          delbul(cnt,true);
          write (cnt,' ')
        end;
      writeln (^B^M'Deleting sub-board files...');
      close (bfile);
      assignbfile;
      erase (bfile);
      writeln (^M'Removing sub-board...');
      delboard (curboardnum);
      writeln (^B'Sub-board erased!');
      setfirstboard;
      q:=9
    end;

    procedure sortboards;
    var cnt,mark,temp:integer;
        bd1,bd2:boardrec;
        bn1,bn2:sstr;
        bo:boardorder;
    begin
      writestr ('Sort sub-boards: Are you sure? *');
      if not yes then exit;
      clearorder (bo);
      mark:=filesize(bdfile)-1;
      repeat
        if mark<>0 then begin
          temp:=mark;
          mark:=0;
          for cnt:=0 to temp-1 do begin
            seek (bifile,cnt);
            read (bifile,bn1);
            read (bifile,bn2);
            if upstring(bn1)>upstring(bn2) then begin
              mark:=cnt;
              switchboards (cnt,cnt+1,bo)
            end
          end
        end
      until mark=0;
      carryout (bo);
      writelog (5,16,'');
      setfirstboard;
      q:=9
    end;

    procedure orderboards;
    var numb,curb,newb:integer;
        bo:boardorder;
    label exit;
    begin
      clearorder (bo);
      writehdr ('Re-order sub-boards');
      numb:=filesize (bdfile);
      thereare (numb,'sub-board','sub-boards');
      for curb:=0 to numb-2 do begin
        repeat
          writestr ('New board #'+strr(curb+1)+' [?=List, CR to quit]:');
          if length(input)=0 then goto exit;
          if input='?'
            then
              begin
                listboards;
                newb:=-1
              end
            else
              begin
                newb:=searchboard(input);
                if newb<0 then writeln ('Not found!  Please re-enter...')
              end
        until (newb>=0);
        switchboards (curb,newb,bo)
      end;
      exit:
      carryout (bo);
      writelog (5,14,'');
      q:=9;
      setfirstboard
    end;

  begin
    if (not issysop) then begin
      writeln ('Nice try, except you aren''t the SysOp.');
      exit
    end;
    writelog (22,1,'');
    writelog (4,3,curboard.boardname+' ['+curboard.shortname+']');
    repeat
      q:=menu (command.commandstr[26],'SPONSOR',menus.commands[26]);
      case q of
        1:getautodel;
        2:getblevel;
        3:;
        4:;
        5:;
        6:;
        7:;
        8:;
        10:renameboard;
        11:killboard;
        12:sortboards;
        13:movebulletin;
        14:orderboards;
        15:;
        16:;
        17:;
      end
    until (q=9) or hungupon
  end;

  var beenaborted:boolean;

  function aborted:boolean;
  begin
    if beenaborted then begin
      aborted:=true;
      exit
    end;
    aborted:=xpressed or hungupon;
    if xpressed then begin
      beenaborted:=true;
      writeln (^B'Newscan aborted!')
    end
  end;

  procedure newscanboard;

  var newmsgs:boolean;
      oldb:boolean;
      postbar:string[1];

      label quiter;
  begin
    beenaborted:=false;
    newmsgs:=false;
    curbul:=lastreadnum+1;
    while curbul<=numbuls do begin
     if (postbars in urec.config) then begin
      getbrec;
      if b.when>urec.lastonm then begin
      allclear;
      writeln('Scanning ',curboard.boardname,'...'^M);
      readnum (curbul);
      newmsgs :=true;
         ansicolor(urec.promptcolor);
         write('[');
         ansicolor(urec.statcolor);
         write('CR');
         ansicolor(urec.regularcolor);
         write('-Next ');
         ansicolor(urec.statcolor);
         write('P');
         ansicolor(urec.regularcolor);
         write('-Post ');
         ansicolor(urec.statcolor);
         write('M');
         ansicolor(urec.regularcolor);
         write('-Email reply ');
         ansicolor(urec.statcolor);
         write('E');
         ansicolor(urec.regularcolor);
         write('-Edit ');
         ansicolor(urec.statcolor);
         write('K');
         ansicolor(urec.regularcolor);
         write('-Kill ');
         ansicolor(urec.statcolor);
         write('+');
         ansicolor(urec.regularcolor);
         write('-Skip ');
         ansicolor(urec.statcolor);
         write('Q');
         ansicolor(urec.regularcolor);
         write('-Quit');
         ansicolor(urec.promptcolor);
         writestr(']: *');
         postbar:=input;
         if (postbar='p') or (postbar='P') then postbul;
         if (postbar='m') or (postbar='M') then sendbreply;
         if (postbar='e') or (postbar='E') then editbul;
         if (postbar='k') or (postbar='K') then killbul;
         if (postbar='+') then exit;
         if (postbar='q') or (postbar='Q') then
           begin
           beenaborted := true;
           goto quiter;
           end;
        end;
       end
       else begin
        getbrec;
        if b.when>urec.lastonm then begin
        readnum (curbul);
        newmsgs :=true;
       end;
      end;
      curbul:=curbul+1;
      quiter:
      if aborted then exit
    end;
    if (postprompts in urec.config) and newmsgs and (ulvl>=postlevel)
      then begin
        writestr (^M'Leave message now? *');
        writeln;
        if yes then postbul
      end;
  end;

  procedure newscanall;
  var cb:integer;
  begin
    beenaborted:=false;
    writehdr ('New-scanning...');
    if aborted then exit;
    for cb:=0 to filesize(bdfile)-1 do begin
      if aborted then exit;
      if haveaccess(cb) and (not (cb in urec.newscanconfig)) then begin
        curboardname:=curboard.shortname;
        openbfile;
        if aborted then exit;
        if (postbars in urec.config) then
         begin
         writeln('Scanning ',curboard.boardname,'...');
         end else
        writeln ('Scanning ',curboard.boardname,'...');
        if aborted then exit;
        newscanboard
      end
    end;
    setfirstboard
  end;

  procedure noboards;
  begin
    writeln ('No sub-boards exist!');
    if not issysop then exit;
    writestr ('Create the first sub-board now? *');
    if not yes then exit;
    writestr ('Enter its access name/number:');
    if not validbname(input) then writeln (^B'Invalid board name!') else begin
      curboardname:=input;
      makeboard
    end
  end;

  procedure togglenewscan;
  begin
    write ('Newscan this board: ');
    if curboardnum in urec.newscanconfig
      then
        begin
          writeln ('Yes');
          urec.newscanconfig:=urec.newscanconfig-[curboardnum]
        end
      else
        begin
          writeln ('No');
          urec.newscanconfig:=urec.newscanconfig+[curboardnum]
        end
  end;

  procedure prevsubboard;
  var cb:integer;
      obn:sstr;
  begin
    obn:=curboardname;
    cb:=curboardnum;
    if cb=1 then exit;
    while cb<filesize(bdfile) do begin
      cb:=cb-1;
      if haveaccess (cb) then begin
        seek (bifile,cb);
        read (bifile,obn);
        setactive (obn);
        exit
      end
    end;
  end;

  procedure nextsubboard;
  var cb:integer;
      obn:sstr;
  begin
    obn:=curboardname;
    cb:=curboardnum;
    while cb<filesize(bdfile)-1 do begin
      cb:=cb+1;
      if haveaccess (cb) then begin
        seek (bifile,cb);
        read (bifile,obn);
        setactive (obn);
        exit
      end
    end;
  end;

var boo:boolean;
label exit;
begin
  opentfile('Messages');
  returnto:='B';
  if not fromdoor then allclear;
  starting:=true;
{  cursection:=bulletinsysop;}
  openbdfile;
  if filesize(bdfile)=0 then begin
    noboards;
    if filesize(bdfile)=0 then begin
      closebdfile;
      goto exit
    end
  end;
  if not haveaccess(0)
    then
      begin
        writeln (^B'You do not have access to the first sub-board!');
        closebdfile;
        goto exit
      end;
  if not fromdoor then drawbox(51,'MESSAGE BASES');
  setfirstboard;
  repeat
    boo:=checkcurbul;
    if not fromdoor then
    with curboard do
      writeln (^M,'Current message: ',curbul,' of ',numbuls)
      else fromdoor:=false;
    q:=menu (command.commandstr[27],'MESSAGE',menus.commands[27]);
    case q of
      1:postbul;
      2:;
      3:show_top_posters;
      4,22:;
      5:;
      6:killbul;
      8,16,17:activeboard;
      7:listbuls;
      9:begin
        closetfile;
        sendbreply;
        opentfile('Messages');
        end;
      12:if not hungupon then readnextbul;
      13:boardsponsor;
      14:;
      15:newscanall;
      18:;
      19:togglenewscan;
      20:;
      21:editbul;
      23:nextsubboard;
      24:prevsubboard;
      25:readnum (lastreadnum+1);
      26:setlastcall('M');
      else if q<0 then readnum (-q)
    end
  until (q=10) or hungupon or (filesize(bdfile)=0);
  exit:
  urec.lastonm:=now;
  close (bfile);
  closebdfile;
  closetfile;
end;

begin
  FillChar(Post_array,SizeOf(Top_poster_Type),0);
end.
