(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2C .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "C" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2c;

interface

uses
  crt, dos, overlay,
  common;

procedure poslsettings;

implementation

function qq(s:string):string;
var ss:string[22];
begin
  ss:='"'+s+'"';
  if (length(ss)<16) then ss:=mln(ss,16);
  qq:=ss;
end;

procedure poslsettings;
var s:acstring;
    c:char;
    abort,next,done:boolean;
begin
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint(#3#5+'System ACS settings');
      nl;
      abort:=FALSE; next:=FALSE;
      printacr('A. Full SysOp Access        :'+qq(sop)+
               'B. Full Co-SysOp Access     :'+qq(csop),abort,next);
      printacr('C. Message base SysOp Access:'+qq(msop)+
               'D. File base SysOp Access   :'+qq(fsop),abort,next);
      printacr('E. SysOp Password at logon  :'+qq(spw)+
               'F. See Password''s remotely  :'+qq(seepw),abort,next);
      printacr('G. Post public Access       :'+qq(normpubpost)+
               'H. Send e-mail Acccess       :'+qq(normprivpost),abort,next);
      printacr('I. See anon pub post Access :'+qq(anonpubread)+
               'J. See anon E-mail Access   :'+qq(anonprivread),abort,next);
      printacr('K. Post anon ANY base Access:'+qq(anonpubpost)+
               'L. E-mail anon Access       :'+qq(anonprivpost),abort,next);
      printacr('M. See unval. files Access  :'+qq(seeunval)+
               'N. DL unval. files Access   :'+qq(dlunval),abort,next);
      printacr('O. No UL/DL ratio Access    :'+qq(nodlratio)+
               'P. No post/call ratio Access:'+qq(nopostratio),abort,next);
      printacr('R. No file pt checking Access:'+qq(nofilepts)+
               'S. ULs auto-credited Access :'+qq(ulvalreq),abort,next);
      nl;
      prt('Enter your selection (A-S) [Q]uit : ');
      onek(c,'QABCDEFGHIJKLMNOPRS'^M);

      if (c='Q') then done:=TRUE;

      nl;
      if (not done) then
        if (c in ['A'..'P','R'..'S']) then begin
          prt('New ACS: '); inputl(s,20);
          if (s<>'') then
            case c of
              'A':sop:=s;           'B':csop:=s;
              'C':msop:=s;          'D':fsop:=s;
              'E':spw:=s;           'F':seepw:=s;
              'G':normpubpost:=s;   'H':normprivpost:=s;
              'I':anonpubread:=s;   'J':anonprivread:=s;
              'K':anonpubpost:=s;   'L':anonprivpost:=s;
              'M':seeunval:=s;      'N':dlunval:=s;
              'O':nodlratio:=s;     'P':nopostratio:=s;
              'R':nofilepts:=s;     'S':ulvalreq:=s;
            end;
        end;
    end;
  until (done) or (hangup);
end;

end.
