{$I DEFINES.INC}
{.$V-,R-,S-,O+}
{ PoorMan's replacement for certain Turbo Power routines used in PingAnsi. }
{ The routines in this unit are adapted from routines supplied by          }
{ Robert Mashlan (1:147/34.33) and Trevor Carlsen (3:690/644) for this     }
{ very purpose.                                                            }

Unit PoorMan;

Interface
Uses Overlay,Crt;

Procedure StuffString(Var St : String);
Function Long2Str(n : LongInt) : String;
Procedure ScrollWindowDown(XLo, YLo, XHi, YHi, Lines : Byte);

Implementation

  Function InsertKey(key : Word) : Boolean;
  {-Insert a key into the keyboard buffer. Key must be passed
    with the MSB being the scan code of the key you want inserted
    and the LSB being the ascii code. For keys that return an
    extended code (cursor keys function keys etc.) the LSB must be
    zero and the MSB the scan code. Returns true if successfull. }
  Var
    OldTail        : Word;
    BufferStart    : Word absolute $40:$80;         {-Address of the keyboard buffer  }
    BufferEnd      : Word absolute $40:$82;
    Head           : Word absolute $40:$1A;
    Tail           : Word absolute $40:$1C;

  Begin
    InsertKey := True;
    MemW[$0040:tail] := key;      {-Insert the keypress             }
    OldTail := tail;              {-Keep record of tail position in }
    {-case the key buffer was full    }
    If tail = BufferEnd Then      {-wrap around to Start of buffer  }
      tail := BufferStart
    Else
      Inc(tail, 2);               {-To allow for newly inserted key }
    If tail = head Then
    Begin {-No room for inserting the key so}
      tail := OldTail;            {-restore the status quo          }
      InsertKey := False;
    End;                          {-if tail = head}
  End;                            {-InsertKey}

  Procedure StuffString(Var St : String);
    {-stuff st into the keyboard buffer}
  Var
    x              : Byte;
    sa             : Array[0..16] Of Byte Absolute St;
  Begin
    x := 0;
    Repeat                        {-until the buffer is full or }
      Inc(x);
    Until Not InsertKey(sa[x]) Or (x = sa[0]);
  End;

  Function Long2Str(n : LongInt) : String;
  Var s          : String;
  Begin
    Str(n, s);
    Long2Str := s;
  End;

  Procedure ScrollWindowDown(XLo, YLo, XHi, YHi, Lines : Byte);
  Var
    SavedWindMax, SavedWindMin : Word;
    SavedX, SavedY, i : Byte;
  Begin
    SavedWindMax := WindMax;
    SavedWindMin := WindMin;
    SavedX := wherex;
    SavedY := wherey;
    window(XLo, YLo, XHi, YHi);
    For i := 1 To Lines Do insline;
    WindMax := SavedWindMax;
    WindMin := SavedWindMin;
    GotoXY(SavedX, SavedY);
  End {ScrollWindowDown} ;

End.

