{-
   Demo program for QMSGBASE.PAS
   Written by P.J. Muller

   Display all origin and tear lines, with a frequency count

   Usage:  Origin [BoardRange ...]

   BoardRange is A-B to include boards A to B.
        or        A  to include board A.

   E.g.  Origin 1-5 6 23-40
-}

{$N-}

USES
  Crt,
  QText,
  QMsgbase;

TYPE
  Tree = ^Node;
  Node = Record
    Left,Right :Tree;
    Value :String[80];
    Count :Word;
  End;
  BoardSet = Set of 1..BoardLim;

VAR
  Stdout :Text;

PROCEDURE Insert(Var Root :Tree;  Var Val :String);
  Begin
    If Root=Nil then Begin
      New(Root);
      Root^.Left := Nil;
      Root^.Right := Nil;
      Root^.Value := Val;
      Root^.Count := 1;
    End else If (Val > Root^.Value) then
      Insert(Root^.Right,Val)
    else If (Val < Root^.Value) then
      Insert(Root^.Left,Val)
    else Inc(Root^.Count);
  End; {Insert}

PROCEDURE Scan(Var T :TextBuffer;  Var Origin :String;  Var Tear :String);
  Var
    Step :TextNodePtr;
    Line :String;

  PROCEDURE Strip(Var Temp :String);
    Const Out :Array[1..3] of Char=#13#10#141;
    Var P,D :Byte;
    Begin
      For D := 1 to 3 do Begin
        P := Pos(Out[D],Temp);
        While (P <> 0) do Begin
          Delete(Temp,P,1);
          P := Pos(Out[D],Temp);
        End; {While}
      End; {For}
    End; {Strip}

  Begin
    Tear := '';
    Origin := '';
    Step := T.First;
    While (Step <> Nil) do Begin
      Line := GetTextLine(T,Step);	{Retrieve the line}
      If (Copy(Line,1,11)=' * Origin: ') then Begin
        Origin := Copy(Line,12,255);
        Strip(Origin);
      End else If (Copy(Line,1,4)='--- ') then Begin
        Tear := Line;
        Strip(Tear);
      End; {Else}
      Step := Step^.Next;
    End; {While}
  End; {Scan}

PROCEDURE Fatal(Str :String);
  Begin
    WriteLn('Error: ',Str);
    Halt(1);
  End; {Fatal}

PROCEDURE ShowTree(Root :Tree);
  Begin
    If (Root=Nil) then Exit;
    ShowTree(Root^.Left);
    WriteLn(Stdout,Root^.Count:4,' ',Root^.Value);
    ShowTree(Root^.Right);
  End; {ShowTree}

FUNCTION Interrupted :Boolean;
  Const Already :Boolean=False;
  Begin
    Interrupted := True;

    While KeyPressed do
      If (ReadKey=#27) then Already := True;

    If Already then Exit;
    Interrupted := False;
  End; {Interrupted}

PROCEDURE ScanBoard(Var Config :ConfigRecord;  Board :Byte;  Var Root :Tree);
  Var
    Num,Total,Count,Result :Integer;
    Per,Prev :Byte;
    Org,Tear :String;
    Hdr :HdrRecord;
    Buf :TextBuffer;

  Begin
    If (Config.BoardRec[Board].Name='') then Exit;	{Unused}
    If (Config.BoardRec[Board].Typ <> 3) then Exit;	{Not echomail}

    Num := FirstMsg(Board);
    Total := CountMsg(Board);
    Count := 0;
    Prev := 255;

    WriteLn('Scanning ',Config.BoardRec[Board].Name,' (',Total,' messages)');
    While (Num > 0) and Not Interrupted do Begin
      Per := LongInt(Count)*100 div Total;
      If (Per <> Prev) then Begin
        Write(^M,Per:3,'% completed');
        Prev := Per;
      End;

      Result := ReadHeader(Num,Hdr);	{Don't use ReadMessage}
      If (Result <> Ok) then		{ we don't want to make}
        Fatal('Cannot read header');	{ the user's messages}
      Result := ReadText(Hdr,Buf);	{ as "received"}
      If (Result <> Ok) then
        Fatal('Cannot read text');

      WrapBuffer(Buf,100);		{reasonable}

      Scan(Buf,Org,Tear);
      If (Org <> '') then
        Insert(Root,Org);
      If (Tear <> '') then
        Insert(Root,Tear);

      DeleteBuffer(Buf);

      Num := MsgNext(Board,Num);	{will be zero at end}
      Inc(Count);
    End; {While}
    Write(^M,'':15,^M);

  End; {ScanBoard}

PROCEDURE SetSet(Var Boards :BoardSet;  Param :String);
  Var
    A,B,C,P :Integer;
  Begin
    P := Pos('-',Param);
    If (P = 0) then Begin
      Val(Param,A,C);
      If (C <> 0) then Exit;
      Boards := Boards+[A];
    End else Begin
      Val(Copy(Param,1,P-1),A,C);
      If (C <> 0) then Exit;
      Val(Copy(Param,P+1,255),B,C);
      If (C <> 0) then Exit;
      Boards := Boards+[A..B];
    End; {Else}
  End; {SetSet}

VAR
  Board,C :Byte;
  Root :Tree;
  Config :ConfigRecord;
  Result :Integer;
  Boards :BoardSet;

BEGIN
  Assign(Stdout,'');
  ReWrite(Stdout);

  Root := Nil;

  Boards := [];
  For C := 1 to ParamCount do
    SetSet(Boards,ParamStr(C));
  If Boards=[] then
    Boards := [1..BoardLim];

  If (ReadConfig(Config) <> Ok) then
    Fatal('Could not open CONFIG.BBS');

  SetUserSupport('',False,False);	{Won't need any}
  If (OpenMsgbase <> Ok) then
    Fatal('Cannot open message base');

  WriteLn(Config.SysopName, ' @',Config.MatrixZone,':',Config.MatrixNet,'/',
          Config.MatrixNode,'.',Config.MatrixPoint);
  WriteLn(Config.OriginLine);

  WriteLn(^M^J'Scanning origin/tear lines, press Esc to interrupt.'^M^J);

  Board := 1;
  While (Board <= BoardLim) and Not Interrupted do Begin
    If (Board in Boards) then
      ScanBoard(Config,Board,Root);
    Inc(Board);
  End; {While}

  ShowTree(Root);
  If (CloseMsgbase <> Ok) then
    Fatal('Cannot close message base');

  Close(Stdout);
END.
