/* ************************************************* */
/* TestUpload.Cmd by Koen Koster (Alias CliP)        */
/* ************************************************* */
/* fname      = complete filename to work on         */
/* linenumber = line number                          */
/* handle     = com port handle                      */
/* name       = just filename (no path, no extension */
/* extension  = just extension                       */
/* ************************************************* */

Parse Upper Arg fname linenumber handle name extension
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

curdir  = directory()
olddir  = curdir
newdir  = directory('.\System\Line'linenumber)

arctest = 'arc t'
arjtest = 'unarj t'
lzhtest = 'lh32 T'
rartest = 'rar t -c- -std'
ziptest = 'pkzip  /test'
zootest = 'zoo -test'

signature = charin(fname,1,5)
rc = Stream(fname, 'c', 'close')
if stream(name'.'||extension||'.error', 'c', 'query exist') <> '' then call SysFileDelete name'.'||extension||'.error'

TestArchive:
   /* Arc file */
   if (substr(signature,2,1)  = "")    then signal TestARC

   /* Arj file */
   if (substr(signature,1,2) = "`")    then signal TestARJ

   /* Arj SE file */
   if (substr(signature,1,3) = "MZ")   then signal TestARJ

   /* Lzh lh/2 file */
   if (substr(signature,3,3) = "-lh")   then signal TestLZH

   /* Lh/2 2.22 SE file */
   if (substr(signature,1,5) = "MZ-") then signal TestLZH

   /* Zip 2.0x file */
   if (substr(signature,1,5) = "PK") then signal TestZIP

   /* Zip 1.0x file */
   if (substr(signature,1,4) = "PK")  then signal TestZIP

   /* Zip SE type 1 file */
   if (substr(signature,1,4) = "MZ")  then signal TestZIP

   /* Zip SE type 2 file */
   if (substr(signature,1,4) = "MZ")  then signal TestZIP

   /* Zip SE type 3 file */
   if (substr(signature,1,4) = "MZ")  then signal TestZIP

   /* Rar file */
   if (substr(signature,1,4) = "Rar!")  then signal TestRAR

   /* Rar SE file */
   if (substr(signature,1,2) = "MZ")    then signal TestRAR

   /* Zoo 2.x file */
   if (substr(signature,1,3) = "ZOO")   then signal TestZOO

   signal BackToBBS

TestARC:
   arctest' 'fname
   if rc = 1 then signal Error
   else signal noError

TestARJ:
   arjtest' 'fname
   if rc = 1 then signal Error
   else signal noError

TestLZH:
   lzhtest' 'fname
   if rc = 1 then signal Error
   else signal noError

TestRAR:
   rartest' 'fname
   if rc = 1 then signal Error
   else signal noError

TestZIP:
   ziptest' 'fname
   if rc = 1 then signal Error
   else signal noError

TestZOO:
   zootest' 'fname
   if rc = 1 then signal Error
   else signal noError

Error:
   error = lineout(name'.'||extension||'.Error','ERROR')
   signal BackToBBS

NoError:
   'f:\ut\os2scan /noexpire ' fname
   if rc \= 0 then signal Error
  /* do something like virus scanning */

BackToBBS:
  curdir = directory(olddir)
