/*
	PAKDEFN.H	Definitions for .PAK file handling utils.
*/

/*
From APPNOTE.TXT in PKxPAK distribution file:

The general format for an archive file is:

[[archive-mark + header_version + file header + file data]...] + 
archive-mark + end-of-arc-mark

The archive-mark is 1 byte and is the value 1A hex.  The file header
can be defined by the following 'C' structure, and is 27 bytes in size.
Note that this is a "packed" structure with fields aligned on odd-address
boundries.
*/

#define uchar	unsigned char
#define uint	unsigned int
#define ushort	unsigned short

typedef struct		/* format of a .PAK file header: */
{
    char	type;		/* file type, or 0 for end of archive */
    char	fname[13];	/* file name */
    long	slen;		/* stored length of file in bytes */
    ushort	ddate;		/* DOS file date */
    ushort	dtime;		/* DOS file time */
    ushort	crc;		/* CRC-16 of original data */
    long	olen;		/* original length of file in bytes */
} pak_hdr;

#define PAK_HDRLEN	(1+13+4+2+2+2+4)
				/* size of packed header */

#define PAK_MARK	'\x1A'	/* character marking start of ARC file */

int pak_dosort(char *fpath, char *fn, int sort);

#ifdef AMIGA
#	define SEEK_SET 0
#	define SEEK_CUR 1
#	define SEEK_END 2
extern	int		_NEAR_	errno;
extern	int		_NEAR_	_OSERR;
#endif
/*
	End of PAKDEFN.H header file.
*/
