/*--------------------------------------------------------------------------*/
/* Include files															*/
/*--------------------------------------------------------------------------*/

#include	<ctype.h>
#include	<errno.h>

#include	<stdlib.h>
#include	<fcntl.h>
#include	<sys\types.h>
#include	<sys\stat.h>
#include	<io.h>

#define 	INCL_DOSPROCESS
#include	<os2.h>

#include	<string.h>
#include	<dos.h>
#include	<time.h>

/*--------------------------------------------------------------------------*/
/* Static function declarations 											*/
/*--------------------------------------------------------------------------*/

/*	... NONE ...  */

/*--------------------------------------------------------------------------*/
/* Static variable definitions												*/
/*--------------------------------------------------------------------------*/

static struct _FILEFINDBUF InfoBuf;
static struct find_t dta;

/*--------------------------------------------------------------------------*/
/* External variable declarations											*/
/*--------------------------------------------------------------------------*/

/*	... NONE ...  */

/*--------------------------------------------------------------------------*/
/* Locally defined globals													*/
/*--------------------------------------------------------------------------*/

HDIR					hDir;
USHORT					cSearch;
USHORT					usAttrib;

/*--------------------------------------------------------------------------*/
/* Local constants															*/
/*--------------------------------------------------------------------------*/

#	define	FILENAMELEN 13

/****************************************************************************/


/*--------------------------------------------------------------------------*/
/* DIR_FINDFIRST									 FOR PORTABILITY		*/
/*--------------------------------------------------------------------------*/

int dir_findfirst(char * filename, int attribute, struct find_t * dta)
{
	hDir	 = 0x0001;
	usAttrib = attribute;
	cSearch  = 1;

#ifdef DEBUG
	printf("\nDIR_FINDFIRST Inputs: '%s' %d.\n", filename, attribute);
#endif
	if (DosFindFirst( filename
					, &hDir
					, usAttrib
					, &InfoBuf
					, (USHORT)( sizeof(InfoBuf) * cSearch )
					, &cSearch
					, (ULONG)NULL ) != 0 )
	{
#ifdef DEBUG
	printf("DIR_FINDFIRST:  DosFindFirst returned <>0.\n");
#endif
		DosFindClose( hDir );
		errno = ENOENT;
		return (-1);
	} else {
#ifdef DEBUG
	printf("DIR_FINDFIRST:  DosFindFirst returned 0.\n");
	printf("DIR_FINDFIRST:  attrFile = %d.\n", InfoBuf.attrFile);
#endif
		dta->attrib    = (char) InfoBuf.attrFile;
		dta->size	   = InfoBuf.cbFile;
		strcpy( dta->name, InfoBuf.achName);
		errno = 0;
		return (0);
	}
}

/*--------------------------------------------------------------------------*/
/* DIR_FINDNEXT 									 FOR PORTABILITY		*/
/*--------------------------------------------------------------------------*/

int dir_findnext(struct find_t * dta)
{

	if ((DosFindNext( hDir
					, &InfoBuf
					, (USHORT)(FILENAMELEN + 23)
					, &cSearch)
					) || (cSearch != 1))
	{
		DosFindClose( hDir );
		errno = ENOENT;
		return (-1);
	} else {
		dta->attrib    = (char) InfoBuf.attrFile;
		dta->size	   = InfoBuf.cbFile;
		strcpy(  dta->name, InfoBuf.achName);
		errno = 0;
		return (0);
	}
}

/*--------------------------------------------------------------------------*/
/*								  END OF FILE								*/
/*--------------------------------------------------------------------------*/
