page 55, 132
Title   Avatar test
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;      Check for the presence of an AVATAR console driver
;;
;;      Copyright (C) 1990 G. Adam Stanislav
;;      All Rights Reserved
;;
;;      AVATAR and AVATAR console are trademarks of G. Adam Stanislav
;;      and Stanislav Publishing
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

data    segment para    public  'DATA'


        db      'Copyright (C) 1990 G. Adam Stanislav', 13, 10, 10, 26 ; ^Z
msg     db      'AVATAR console not found.', 13, 10
        db      'Make sure to place the following in your CONFIG.SYS:'
        db      13, 10, 10, 9
        db      'DEVICE=AVATAR.SYS', 13, 10, 10, '$'
slpmsg  db      'Warning: AVATAR console present but asleep.', 13
twolfs  db      10, 10
        db      '$'

active  db      'AVATAR console present and active.', 13, 10, 10, '$'

tm      db      'AVATAR and AVATAR console are trademarks of G. Adam Sta'
        db      'nislav', 13, 10, 'and Stanislav Publishing.', 13, 10, 10
        db      '$'

query   db      16h, 11h, 11h           ; ^V ^Q ^Q = Query the driver
        db      13                      ; CR = if no Avatar, delete the query
        db      '   ', 13               ; 3 blanks, another CR
        db      '$'                     ; End of string

qsleep  db      16h, 11h, 1Ch           ; ^V ^Q FS = Query the sleep state
        db      '$'

data    ends

code    segment para    public  'CODE'

        assume  cs:code, ds:data, ss:stack

begin:
        mov     ax, data
        mov     ds, ax          ; Find our data

        ; Print the query, hopefully via AVATAR.SYS
        lea     dx, query
        mov     ah, 9
        int     21h

        ; If AVATAR console is in control, it will reply with a
        ; string that starts "AVT"

        mov     ah, 0Bh
        int     21h             ; Anything there?
        inc     al
        jne     noAVT

        ; see if we got an 'A'
        mov     ah, 01h         ; Read with echo
        int     21h
        cmp     al, 'A'
        jne     noAVT

        ; is 'V' next?
        mov     ah, 0Bh
        int     21h
        inc     al
        jne     noAVT
        mov     ah, 01h
        int     21h
        cmp     al, 'V'
        jne     noAVT

        ; is 'T' next?
        mov     ah, 0Bh
        int     21h
        inc     al
        jne     noAVT
        mov     ah, 01h
        int     21h
        cmp     al, 'T'
        jne     noAVT

        ; We have received 'AVT'. This is followed by more text
        ; and ends with a CR. If not, this is not an AVATAR console.

checkmore:
        mov     ah, 0Bh
        int     21h
        inc     al
        jne     noAVT
        mov     ah, 01h
        int     21h
        cmp     al, 13          ; CR?
        jne     checkmore

        lea     dx, twolfs
        mov     ah, 9
        int     21h             ; move two lines down

        mov     si, 4C00h       ; no-error exit value
        call    sleeptest       ; check if Avatar is active
        jnc     commonexit
        inc     si              ; Avatar there but inactive, errorlevel = 1

commonexit:
        lea     dx, tm
        mov     ah, 9
        int     21h

        mov     ax, si
        int     21h

noAVT:
        lea     dx, msg
        mov     ah, 9
        int     21h

        mov     si, 4C02h       ; errorlevel = 2
        jmp     commonexit

sleeptest:
        lea     dx, qsleep      ; Query the sleep state
        mov     ah, 9
        int     21h

        mov     ah, 8
        int     21h             ; Character input without echo
        cmp     al, 16h         ; ^V?
        jne     asleep          ; this should never happen, but...

        mov     ah, 8
        int     21h             ; Next character
        cmp     al, 1Ch
        je      asleep

        lea     dx, active
        mov     ah, 9
        int     21h

        clc                     ; active, clear carry
        ret

asleep:
        lea     dx, slpmsg
        mov     ah, 9
        int     21h

        stc                     ; asleep, set carry
        ret

code    ends

stack   segment stack

        dw      128 dup(1990h)

stack   ends

        end     begin



