     FILE$ = "PASSIVE": PRINT FILE$, DATE$

'   By D. C. Rife, for IBM PC
'   This program is free and has no warranty.

'   Thu  02-04-1993 added shunt L and R.
'   Wed  02-27-1991 added complex load impedance
'   Sat  02-16-1991 corrected date statement
'   08/31/94 Removed crystal analysis section.
'   12-19-2000 Removed complex load option.
'   12-29-2001 Added analysis from a data file "passive.dat".
'   02-04-2003 Added input file name question and input file format.


'   Input file format:
'   number of sections
'   for each section, starting at output end of network:
'       section type
'       inductance (in Henries)
'       capacitance (in farads)
'       capacitance in parallel with series L and C
'       resistance of section
'   use zero values for missing components

'   Variables:
'   N = number of sections
'   k = section number
'   I(k) = section k type
'   L(k) = inductance of section k
'   C(k) = capacitance of section k
'   V(k) = capacitance in parallel with series L and C
'   Z(k) = resistance of section k

'   Note: Coil resistance is computed from coil Q.


CLS
PRINT
PRINT "PASSIVE by David Rife"
PRINT "Evolved from a program Rife developed in 1974. Program will"
PRINT "synthesize matching networks and regular passive filters of up to"
PRINT "20 sections, and attenuators. Program will also analyze passive"
PRINT "ladder networks with up to 20 sections."
     IFILE$ = COMMAND$
     DIM A(2, 2), B(2, 2), D(2, 2), F(2, 2), E(2, 2), H(2, 2), M(2, 2)
     DIM G(20), R(20), L(20), C(20), I(20), U(20), T(20), V(20), Z(20)
     DEF FNA (X) = SGN(X) * INT(K0 * ABS(X) + .5) / K0
     DEF FNB (X) = SGN(X) * INT(100 * ABS(X) + .5) / 100 '   ADDED 10-21-85.
     K0 = 10000
     K2 = 10 / LOG(10)
     K3 = 1             ' inductance factor
     K4 = 1000000!      ' capacitance factor
     K5 = 1             ' frequency factor
     P2 = 8 * ATN(1)
     P3 = P2 / 2
     P4 = P2 / 4
     P0 = P3 / 180
     PRINT
     INPUT "DIMENSIONS: NORMAL (1) OR RF (2)"; S2
     IF S2 = 0 THEN END
     PRINT
     IF S2 = 1 THEN
        PRINT "DIMENSIONS ARE OHMS, HENRYS, MICROFARADS, AND HERTZ."
        ENDIF
     IF S2 = 2 THEN
        K3 = 1000000!: K4 = 1E+12: K5 = 1000000!
        PRINT "DIMENSIONS ARE OHMS, MICROHENRIES, PICOFARADS, ";
        PRINT "AND MEGAHERTZ."
        ENDIF
     IF NOT IFILE$ = "" THEN S0 = 5: GOTO 440
RESTART:
     PRINT ' START OVER ENTRY POINT
     PRINT "MATCHING NETWORK (1), FILTER (2), ATTENUATOR (3),";
     PRINT " ANALYSIS WITH MANUAL INPUT (4), OR ANALYSIS  FROM FILE (5) ";
     INPUT S0
440:
     IF S0 = 1 THEN GOTO 660
     IF S0 = 2 THEN GOTO 1760
     IF S0 = 3 THEN GOTO 500
     IF S0 = 4 THEN JOB = 1: GOTO 3000
     IF S0 = 5 THEN JOB = 4: GOSUB DATAIN : GOTO 3000
     END

     '    ATTENUATOR SYNTHESIS ADDED 10-21-85
500  INPUT "IMPEDANCE IS"; R0
510  INPUT "LOSS IN DB"; X
     IF X <= 0 THEN GOTO RESTART
     K = 10 ^ (X / 20)
     A = (K - 1) / (K + 1)
     B = 2 * K / ((K + 1) * (K - 1))
     R1 = R0 * A
     R2 = R0 * B
     R3 = R0 / A
     R4 = R0 / B
     PRINT
     PRINT "T SERIES R", "T SHUNT R", "Pi SHUNT R", "Pi SERIES R"
     PRINT R1, R2, R3, R4
     PRINT
     GOTO 510

     '    MATCHING NETWORK SYNTHESIS
660  N = 3
670  PRINT "SELECT: Pi (1), BP T (2), HP T (3), Q WAVE (4), OR H WAVE (5)";
     INPUT S5
     IF S5 = 0 THEN GOTO RESTART
     PRINT "ENTER THE FREQUENCY";
     INPUT F0: F0 = K5 * F0
     W0 = P2 * F0
     IF S5 = 5 THEN GOTO 1540
740  PRINT "ENTER SOURCE R0 AND LOAD R";
     INPUT R0, R
     IF S5 = 1 THEN GOTO 880
     IF S5 = 2 THEN GOTO 1090
     IF S5 = 3 THEN GOTO 1380
     IF S5 = 4 THEN GOTO 830
     PRINT "WRONG TYPE SELECTION"
     GOTO 670

     '    QUARTER WAVE SYNTHESIS
830  R1 = R0 * R / (R0 + R)
     C(2) = 0
     GOTO 920

     '    Pi SYNTHESIS
870  PRINT "VIRTUAL R IS TOO LARGE"
880  PRINT "ENTER VIRTUAL R AND SERIES C";
     INPUT R1, C(2): C(2) = C(2) / K4
     IF R1 > R0 THEN GOTO 870
     IF R1 > R THEN GOTO 870
920  L3 = SQR(R1 * (R - R1)) / W0
     C(1) = L3 / (R * R1)
     L2 = SQR(R1 * (R0 - R1)) / W0
     C(3) = L2 / (R0 * R1)
     IF C(2) > 0 THEN GOTO 1010
     I(2) = 2
     C(2) = 0
     L(2) = L2 + L3
     GOTO 1030
1010 I(2) = 4
     L(2) = L2 + L3 + 1 / (W0 * W0 * C(2))
1030 I(1) = 1
     I(3) = 1
     L(1) = 0
     L(3) = 0
     GOTO 2920

     '    BANDPASS T SYNTHESIS
1090 IF R >= R0 THEN GOTO 1120
     PRINT "SOURCE R MUST NOT EXCEED LOAD R"
     GOTO 740
1120 L = SQR(R0 * (R - R0)) / W0
     PRINT "MIN INDUCTANCE IS "; L * K3
     PRINT "ENTER INDUCTANCE ";
     INPUT L(3): L(3) = L(3) / K3
     A = W0 * L(3) / R0
     R1 = R0 * (1 + A * A)
     B = R1 / R
     IF B > 1 THEN GOTO 1220
     PRINT "INDUCTANCE IS TOO SMALL"
     GOTO 1090
1220 X = R * SQR(B - 1)
     C(1) = 1 / (W0 * X)
     Y = (X / W0) / (R * R + X * X)
     C = L(3) / (R0 * R1)
     C(2) = C - Y
     IF R > R0 THEN GOTO 1290
     C(2) = 0
1290 I(1) = 4
     I(2) = 1
     I(3) = 2
     L(1) = 0
     L(2) = 0
     C(3) = 0
     GOTO 2920

     '    HIPASS T SYNTHESIS
1370 PRINT "VIRTUAL R IS TOO SMALL"
1380 PRINT "ENTER VIRTUAL R AND PARALLEL C";
     INPUT R1, C(2): C(2) = C(2) / K4
     IF R1 <= R0 THEN GOTO 1370
     IF R1 <= R THEN GOTO 1370
     C(3) = 1 / (W0 * SQR(R0 * (R1 - R0)))
     L1 = C(3) * R0 * R1
     C(1) = 1 / (W0 * SQR(R * (R1 - R)))
     L2 = C(1) * R1 * R
     L(2) = 1 / ((1 / L1) + (1 / L2) + W0 * W0 * C(2))
     I(1) = 4
     I(2) = 3
     I(3) = 4
     L(1) = 0
     L(3) = 0
     GOTO 2920

     '    HALFWAVE SYNTHESIS
1540 PRINT "ENTER BRANCH REACTANCE";
     INPUT X
     N = 5
     C = 1 / (X * W0)
     L = X / W0
     I(1) = 1
     I(2) = 2
     I(3) = 1
     I(4) = 2
     I(5) = 1
     L(1) = 0
     C(1) = C
     L(2) = L
     C(2) = 0
     L(3) = 0
     C(3) = 2 * C
     L(4) = L
     C(4) = 0
     L(5) = 0
     C(5) = C
     GOTO 2920

     '    FILTER SYNTHESIS
1760 P = P2 / 2
1770 PRINT "LOWPASS (1), HIPASS (2), BANDPASS (3), OR BANDSTOP (4)";
     INPUT S
     IF S = 0 THEN GOTO RESTART
     PRINT "BUTTERWORTH (1) OR CHEBYSCHEV (2) ";
     INPUT S1
     IF S1 = 0 THEN GOTO 1770
1830 PRINT "NUMBER OF SECTIONS IS";
     INPUT N
     IF N < 21 THEN GOTO 1880
     PRINT "LIMIT OF 20 SECTIONS"
     GOTO 1830
1880 IF S1 = 2 THEN GOTO 1960
     '    LOWPASS PROTOTYPES
     '    REFERENCE: "ELECTRICAL FILTERS" BY WHITE ELECTROMAGNETICS, INC.
     FOR K = 1 TO N
     G(K) = 2 * SIN((2 * K - 1) * P3 / (2 * N))
     NEXT K
     R0 = 1
     GOTO 2150
1960 PRINT "PEAK-TO-PEAK RIPPLE IN DB ";
     INPUT D
     IF INT(N / 2) = N / 2 THEN GOTO 2010
     R0 = 1
     GOTO 2040
2010 R0 = 10 ^ (D / 10)
     R0 = 2 * R0 - 1
     R0 = R0 - SQR(R0 ^ 2 - 1)
2040 X = EXP(D / 17.37) ^ 2
     A = LOG((X + 1) / (X - 1))
     X = EXP(A / (2 * N))
     B = (X - 1 / X) / 2
     K = 1
     GOSUB 2880
     G(1) = 2 * T(1) / B
     FOR K = 2 TO N
     GOSUB 2880
     G(K) = 4 * T(K - 1) * T(K) / (U(K - 1) * G(K - 1))
     NEXT K
2150 IF S > 2 THEN GOTO 2520
     PRINT "CUTOFF FREQUENCY IS";
     INPUT F0: F0 = F0 * K5
     PRINT "LOAD RESISTANCE IS ";
     INPUT R
     W0 = P2 * F0
     L0 = R / W0
     C0 = 1 / (R * W0)
     I = 1
     IF S = 2 THEN GOTO 2390
     '    DENORMALIZE LOWPASS
     FOR K = 1 TO N
     IF I = -1 THEN GOTO 2320
     C(K) = C0 * G(K)
     L(K) = 0
     I(K) = 1
     GOTO 2350
2320 L(K) = L0 * G(K)
     C(K) = 0
     I(K) = 2
2350 I = -I
     NEXT K
     GOTO 2850

     '    TRANSFORM HIPASS
2390 FOR K = 1 TO N
     IF I = -1 THEN GOTO 2450
     C(K) = C0 / G(K)
     L(K) = 0
     I(K) = 4
     GOTO 2480
2450 L(K) = L0 / G(K)
     C(K) = 0
     I(K) = 3
2480 I = -I
     NEXT K
     R0 = 1 / R0
     GOTO 2850
2520 PRINT "CENTER FREQUENCY AND BANDWIDTH ARE";
     INPUT F0, B: F0 = F0 * K5: B = B * K5
     W0 = P2 * F0
     B = P2 * B
     PRINT "LOAD RESISTANCE IS";
     INPUT R
     I = 1
     IF S = 4 THEN GOTO 2740
     '    TRANSFORM BANDPASS
     FOR K = 1 TO N
     IF I = -1 THEN GOTO 2670
     C(K) = G(K) / (R * B)
     L(K) = 1 / (W0 * W0 * C(K))
     I(K) = 3
     GOTO 2700
2670 L(K) = G(K) * R / B
     C(K) = 1 / (W0 * W0 * L(K))
     I(K) = 4
2700 I = -I
     NEXT K
     GOTO 2850

     '    TRANSFORM BANDSTOP
2740 FOR K = 1 TO N
     IF I = -1 THEN GOTO 2800
     L(K) = R / (G(K) * B)
     C(K) = 1 / (W0 * W0 * L(K))
     I(K) = 1
     GOTO 2830
2800 C(K) = 1 / (G(K) * R * B)
     L(K) = 1 / (W0 * W0 * C(K))
     I(K) = 2
2830 I = -I
     NEXT K
2850 R0 = R * R0
     PRINT "SOURCE R IS "; R0
     GOTO 2920
2880 U(K) = B ^ 2 + SIN(K * P3 / N) ^ 2
     T(K) = SIN((2 * K - 1) * P3 / (2 * N))
     RETURN

2920 JOB = 0: GOSUB 3000
     PRINT
     INPUT "ANOTHER SYNTHESIS (1) OR ANALYSIS (2)"; X
     IF X = 1 THEN GOTO 440
     IF X = 2 THEN JOB = 3: GOTO 3000
     GOTO RESTART

3000 '   *****  ANALYSIS SECTION  *****
     IF JOB = 0 THEN GOSUB 4100: RETURN
     IF JOB = 1 THEN GOTO 3200 ' ANALYSIS WITH MANUAL INPUT
     IF JOB = 2 THEN GOTO 3060 ' PRINT SECTIONS THEN ON TO ANALYSIS
     IF JOB = 3 THEN GOTO 3400 ' ANALYSIS FROM SYNTHESIS SECTION
     IF JOB = 4 THEN GOTO 3400 ' ANALYSIS FROM FILE INPUT

3050 GOTO RESTART  ' COMMON RETURN TO START OVER

3060 GOSUB 4100 ' PRINT SECTIONS THEN ON TO ANALYSIS
     GOTO 3400  ' ANALYSIS FROM SYNTHESIS SECTION

3200 GOSUB 7000

3280 PRINT "NUMBER OF SECTIONS";
     INPUT N
     IF N > 20 THEN PRINT "LIMIT OF 20 SECTIONS" : GOTO 3280
     IF N < 1 THEN CLOSE : END
     FOR K = 1 TO N
     PRINT "SECTION"; K, "ENTER TYPE";
     INPUT I(K)
     GOSUB 3970
     NEXT K

     PRINT
     PRINT "COIL Q REFERENCE FREQUENCY ";
     INPUT F0: F0 = F0 * K5

3400 PRINT "ANALYSIS:"
     S3 = 0
     S4 = 1
     GOSUB 6420
     W0 = P2 * F0

3450 INPUT "LOSS TYPE: TRANSDUCER (1) OR INSERTION (2) "; TY
     IF TY = 0 THEN GOTO 3050
     IF ABS(TY - 1.5) <> .5 THEN GOTO 3450
     S6 = 0

3480 X = 0: INPUT "SOURCE R, LOAD R, AND COIL Q ARE "; R0, R, Q

3500 IF TY = 1 THEN K1 = .25 * R / R0
     IF TY = 2 THEN K1 = (R / (R + R0)) ^ 2
3520 PRINT "FREQ SWEEP: MIN, MAX, DELTA ";
     INPUT F1, F2, F3
     FOR K = 1 TO N
     IF I(K) = 5 THEN GOTO 3590
     IF I(K) = 6 THEN GOTO 3590
     IF I(K) = 8 THEN GOTO 3590
     R(K) = W0 * L(K) / Q
3590 NEXT K
     PRINT
     PRINT "FREQUENCY", "LOSS (DB)", "PHASE (DEG)", "INPUT R", "INPUT X"
     FOR F4 = F1 TO F2 STEP F3
     F = K5 * F4
     GOSUB 5280
     Z7 = FNB(Z7): L = FNB(L)
     PRINT F / K5, L, -Z7, FNA(RIN), FNA(XIN)
     IF S4 = 1 THEN PRINT #1, F / K5, L, -Z7, FNA(RIN), FNA(XIN)
     NEXT F4

3760 PRINT
     PRINT "ANOTHER SWEEP (1), CHANGE SECTIONS (2), LIST SECTIONS (3),"
     PRINT "CHANGE LOADING (4), OR START OVER (5)";
     INPUT X
     IF X = 1 THEN GOTO 3520
     IF X = 2 THEN GOSUB 7000: GOSUB 3870: GOTO 3480
     IF X = 3 THEN GOSUB 4100: GOTO 3760
     IF X = 4 THEN GOTO 3480
     IF X = 5 THEN CLOSE : GOTO 3050
     CLOSE : END

3870 PRINT "NUMBER OF SECTIONS YOU WANT TO CHANGE IS ";
     INPUT N1
     IF N1 <= 0 THEN RETURN
     IF N1 > N THEN PRINT "TOO MANY": RETURN
     FOR J = 1 TO N1
     PRINT "ENTER SECTION AND TYPE";
     INPUT K, I(K)
     GOSUB 3970
     NEXT J
     RETURN

3970 IF I(K) < 5 THEN GOTO 4040
     IF I(K) = 7 THEN GOTO 4070
     IF I(K) = 8 THEN INPUT "ENTER R AND C"; Z(K), C(K): C(K) = C(K) / K4: RETURN
     IF I(K) = 9 THEN INPUT "ENTER R AND C"; Z(K), C(K): C(K) = C(K) / K4: RETURN
     IF I(K) = 10 THEN INPUT "ENTER R AND L"; Z(K), L(K): L(K) = L(K) / K3: RETURN
     PRINT "ENTER R";
     INPUT Z(K)
     RETURN

4040 PRINT "ENTER L AND C";
     INPUT L(K), C(K): L(K) = L(K) / K3: C(K) = C(K) / K4
     RETURN
4070 PRINT "ENTER L, SERIES C, AND PARALLEL C ";
     INPUT L(K), C(K), V(K): L(K) = L(K) / K3: C(K) = C(K) / K4: V(K) = V(K) / K4
     RETURN

4100 PRINT
     PRINT "SECTIONS FROM LOAD END:"
     PRINT "TYPE", "INDUCTANCE", "CAPACITANCE", "RESISTANCE"
     FOR K = 1 TO N
     IF I(K) < 5 THEN GOTO 4250
     IF I(K) = 7 THEN GOTO 4220
     IF I(K) = 8 THEN PRINT I(K), , C(K) * K4, Z(K): GOTO 4260
     IF I(K) = 9 THEN PRINT I(K), , C(K) * K4, Z(K): GOTO 4260
     IF I(K) = 10 THEN PRINT I(K), L(K) * K3, , Z(K): GOTO 4260
     PRINT I(K), "", "", Z(K)
     GOTO 4260
     PRINT I(K), , C(K) * K4, Z(K)
     GOTO 4260
4220 PRINT I(K), L(K) * K3, C(K) * K4
     PRINT "SHUNT C IS "; V(K) * K4
     GOTO 4260
4250 PRINT I(K), L(K) * K3, C(K) * K4
4260 NEXT K
     GOSUB DATAOUT
     RETURN

     '    LADDER NETWORK ANALYSIS SUBROUTINE
5280 W = P2 * F
     FOR I = 1 TO 2
     FOR J = 1 TO 2
     B(I, J) = 0
     A(I, J) = 0
     F(I, J) = 0
     H(I, J) = 0
     NEXT J
     NEXT I
     A(1, 1) = 1
     A(2, 2) = 1
     A(2, 1) = 1 / R

     '    MULTIPLY TRANSMISSION MATRICES
     FOR K = 1 TO N
     GOSUB 6320
     GOSUB 5760
     GOSUB 5620
     NEXT K

     '    COMPUTE INPUT IMPEDANCE
     H9 = A(2, 1) * A(2, 1) + B(2, 1) * B(2, 1)
     RIN = (A(1, 1) * A(2, 1) + B(1, 1) * B(2, 1)) / H9
     XIN = (A(2, 1) * B(1, 1) - A(1, 1) * B(2, 1)) / H9

     '    COMPUTE MATRIX OF SOURCE
     GOSUB 6320
     D(1, 2) = R0
     GOSUB 5620
     X = K1 * (A(1, 1) ^ 2 + B(1, 1) ^ 2)
     L = K2 * LOG(X)
     '   PHASE COMPUTATION ADDED 8-23-83, EDITED 11-15-83.
     IF A(1, 1) = 0 THEN Z7 = 90 * SGN(B(1, 1))
     IF A(1, 1) > 0 THEN Z7 = ATN(B(1, 1) / A(1, 1)) / P0
     IF A(1, 1) < 0 THEN Z7 = 180 * SGN(B(1, 1)) + ATN(B(1, 1) / A(1, 1)) / P0
     RETURN

     '    COMPLEX MATRIX MULTIPLICATION
5620 FOR I = 1 TO 2
     FOR J = 1 TO 2
     F(I, J) = D(I, 1) * A(1, J) + D(I, 2) * A(2, J) - E(I, 1) * B(1, J) - E(I, 2) * B(2, J)
     H(I, J) = E(I, 1) * A(1, J) + E(I, 2) * A(2, J) + D(I, 1) * B(1, J) + D(I, 2) * B(2, J)
     NEXT J
     NEXT I
     FOR I = 1 TO 2
     FOR J = 1 TO 2
     A(I, J) = F(I, J)
     B(I, J) = H(I, J)
     NEXT J
     NEXT I
     RETURN

     '    COMPUTE NEXT MATRIX.  D IS REAL PART, E IS IMAG. PART.
5760 IF I(K) = 1 THEN GOTO 5870
     IF I(K) = 2 THEN GOTO 5960
     IF I(K) = 3 THEN GOTO 6060
     IF I(K) = 4 THEN GOTO 6100
     IF I(K) = 5 THEN GOTO 6130
     IF I(K) = 6 THEN GOTO 6150
     IF I(K) = 7 THEN GOTO 6170
     IF I(K) = 8 THEN GOTO 6230
     IF I(K) = 9 THEN GOTO 6270
     IF I(K) = 10 THEN GOTO 6302
     PRINT "SECTION TYPE ERROR.  SECTION"; K
     CLOSE : END

5870 IF L(K) = 0 THEN GOTO 5940
     IF W = 0 THEN RETURN '   ADDED TO FIX BUG ON 10-21-85.
     Z = W * L(K) - 1 / (W * C(K))
     Z2 = R(K) ^ 2 + Z ^ 2
     D(2, 1) = R(K) / Z2
     E(2, 1) = -Z / Z2
     RETURN

5940 E(2, 1) = W * C(K)
     RETURN

5960 IF C(K) = 0 THEN GOTO 6030
     Z1 = 1 - W * W * L(K) * C(K)
     Z2 = W * R(K) * C(K)
     Z = Z1 ^ 2 + Z2 ^ 2
     D(1, 2) = R(K) / Z
     E(1, 2) = (W * L(K) * Z1 - R(K) * Z2) / Z
     RETURN
6030 D(1, 2) = R(K)
     E(1, 2) = W * L(K)
     RETURN

6060 Z = R(K) ^ 2 + (W * L(K)) ^ 2
     D(2, 1) = R(K) / Z
     E(2, 1) = W * C(K) - W * L(K) / Z
     RETURN

6100 D(1, 2) = R(K)
     E(1, 2) = W * L(K) - 1 / (W * C(K))
     RETURN

6130 D(2, 1) = 1 / Z(K)
     RETURN

6150 D(1, 2) = Z(K)
     RETURN

6170 Z1 = W * V(K)
     Z2 = W * L(K) - 1 / (W * C(K))
     Z3 = R(K) ^ 2 * Z1 ^ 2 + (1 - Z1 * Z2) ^ 2
     D(1, 2) = R(K) / Z3
     E(1, 2) = (Z2 * (1 - Z1 * Z2) - R(K) ^ 2 * Z1) / Z3
     RETURN

6230 E(1, 1) = W * Z(K) * C(K) '   ADDED 8-11-86
     D(1, 2) = Z(K)
     E(2, 1) = W * C(K)
     RETURN

6270 Z = 1 + (W * Z(K) * C(K)) ^ 2
     D(2, 1) = W * W * C(K) * C(K) * Z(K) / Z
     E(2, 1) = W * C(K) / Z
     RETURN

6302 Z = Z(K) ^ 2 + (W * L(K)) ^ 2
     D(2, 1) = Z(K) / Z
     E(2, 1) = -W * L(K) / Z
     RETURN

     '    INITIALIZATION ROUTINE
6320 E(1, 1) = 0
     E(1, 2) = 0
     E(2, 1) = 0
     E(2, 2) = 0
     D(1, 1) = 1
     D(2, 1) = 0
     D(1, 2) = 0
     D(2, 2) = 1
     RETURN
     CLOSE : END

6420
    N$ = "PASSIVE.OUT"
     PRINT "OUTPUT FILE NAME IS "; N$
     PRINT
     OPEN N$ FOR OUTPUT AS 1
     PRINT #1, "Freq", "Loss", "Phase", "Rin", "Xin"
     RETURN

7000 PRINT "PROGRAM WILL ANALYZE PASSIVE LADDER NETWORKS WITH"
     PRINT "UP TO 20 SECTIONS.  THE TYPES OF SECTIONS ARE:"
     PRINT "(1)  SHUNT BRANCH OF L AND C IN SERIES"
     PRINT "(2)  SERIES BRANCH OF L AND C IN PARALLEL"
     PRINT "(3)  SHUNT BRANCH OF L AND C IN PARALLEL"
     PRINT "(4)  SERIES BRANCH OF L AND C IN SERIES"
     PRINT "(5)  SHUNT BRANCH R"
     PRINT "(6)  SERIES BRANCH R"
     PRINT "(7)  SERIES BRANCH OF L AND C IN SERIES, WITH PARALLEL C"
     PRINT "(8)  SERIES R FOLLOWED BY SHUNT C AT LOAD END"
     PRINT "(9)  SHUNT BRANCH OF R AND C IN SERIES"
     PRINT "(10) SHUNT BRANCH OF R AND L IN SERIES"
     PRINT "SECTION 1 IS AT THE LOAD END."
     PRINT
     RETURN

DATAIN:

    IF IFILE$ = "" THEN INPUT "Enter data file name (default is passive.dat): ";IFILE$
    IF IFILE$ = "" THEN IFILE$ = "PASSIVE.DAT"
    OPEN IFILE$ FOR INPUT AS #4
    INPUT #4,N
    FOR k = 1 to N
    INPUT #4,I(k)
    INPUT #4,L(k)
    INPUT #4,C(k)
    INPUT #4,V(k)
    INPUT #4,Z(k)
    NEXT k
    CLOSE #4
    RETURN

DATAOUT:
     OPEN "PASSIVE.DAT" FOR OUTPUT AS #4
     PRINT #4,N
     FOR k = 1 TO N
     PRINT #4, I(k)
     PRINT #4, L(k)
     PRINT #4, C(k)
     PRINT #4, V(k)
     PRINT #4, Z(k)
     NEXT k
     CLOSE #4
     RETURN

     END


