#include "opendoor.h"

#include <stdio.h>
#include <ctype.h>
#include <bios.h>

void SilentPersonalityFunction(unsigned char which);

int main(int argc, char *argv[])
{
   char chReceived;
   int nKey;
   char szToDisplay[2] = "-";

   if(argc != 3)
   {
      printf("Format: TERMINAL [port] [baud]\n");
      return(1);
   }

   od_control.port = atoi(argv[1]);
   od_control.baud = atoi(argv[2]);
   od_control.od_disable = DIS_INFOFILE | DIS_CARRIERDETECT | DIS_TIMEOUT |
      DIS_LOCAL_INPUT | DIS_SYSOP_KEYS;
   od_control.od_nocopyright = TRUE;
   od_control.od_default_personality = SilentPersonalityFunction;
   od_control.od_in_buf_size = 10000;
   od_control.od_inactivity = 0;

   strcpy(od_registered_to, "");
   od_registration_key = 0;

   od_init();

   for(;;)
   {
      chReceived = od_get_key(FALSE);
      if(chReceived != 0)
      {
         szToDisplay[0] = chReceived;
         od_disp_emu(szToDisplay, FALSE);
      }
      if(bioskey(1))
      {
         nKey = bioskey(0) & 0xff;
         if(nKey == 27) break;
         szToDisplay[0] = (char)nKey;
         od_disp(szToDisplay, 1, FALSE);
      }
   }

   return(0);
}


void SilentPersonalityFunction(unsigned char which)
{
   switch(which)
   {
      case 20:
         od_set_statusline(STATUS_NONE);
         break;
   }
}
