#include "opendoor.h"                  /* Include opendooor.h */
                        /* Prototype for custom line function */
void custom_line_function(char *keyword, char *options);

unsigned long key=0L; /* Variables for our own config option */
unsigned char default_colour=0x07;
char display_winners=FALSE;

main()                     /* Program's execution begins here */
   {            /* Begin door operations, reading config file */
   od_control.od_config_file = INCLUDE_CONFIG_FILE;
   od_control.od_config_function = custom_line_function;
   od_init();

                         /* Main program's operations go here */

   return(10);                                   /* Exit door */
   }

                             /* Code for custom line function */
void custom_line_function(char *keyword, char *options)
   {                         /* If option is registration key */
   if(stricmp(keyword,"REGISTRATIONKEY")==0)
      {
      key=atol(options);             /* Store key in variable */
      }                           /* If option is text colour */
   else if(stricmp(keyword,"DEFAULTCOLOUR")==0)
      {          /* Get colour value using od_colour_config() */
      default_colour=od_colour_config(options);
      }      /* Example of option enabled by just the keyword */
   else if(stricmp(keyword,"DISPLAYWINNERS")==0)
      {              /* If keyword is present, turn on option */
      display_winners=TRUE;
      }
   }

