/* OpenDoors BBS Framework 1.00
 * Written 1995 - 1996 by Brian Pirie. Released to the public domain.
 *
 *
 *        File: ex_bbs.h
 *
 * Description: Defines public data types and functions that are part of the
 *              OpenDoors BBS Framework.
 *
 *   Revisions: Date          Ver   Who  Change
 *              ---------------------------------------------------------------
 *              Mar 12, 1996  1.00  BP   New file header format.
 */

#ifndef _INC_EX_BBS
#define _INC_EX_BBS

#include <time.h>

/* DATA TYPES AND STRUCTURES. */

/* User file record format. */
typedef struct
{
   DWORD dwUserNumber;
   char szName[36];
   char szLocation[26];
   char szPhone[16];
   char szPassword[16];
   time_t FirstCallTime;
   time_t LastCallTime;
   INT32 nTimeUsed;
   DWORD dwSecurity;
   DWORD dwNumCalls;
   BYTE btUnusedSpace[256];
} tUserRecord;


/* BBS configuration information. To make this information configurable by  */
/* the sysop, you would store this information in an external file, and     */
/* provide a separate configuration program to edit this file. As the BBS   */
/* framework is provided, these things can only be configured in the source */
/* code.                                                                    */
typedef struct
{
   char szModemInit[80];
   char szRingString[80];
   char szAnswerString[80];
   char szConnectString[80];
   char szLogfileName[80];
   DWORD dwMaximumInactivity;
   DWORD dwNewUserSecurity;
   DWORD dwDailyTimeLimit;
   DWORD dwLoginTimeLimit;
   DWORD dwPasswordRetries;
} tConfigurationRecord;


/* FUNCTION PROTOTYPES. */

/* Modem handling. */
void EstablishConnection(void);
void SendCommandToModem(char *pszModemCommand);

/* BBS session handling. */
void BBSSession(void);
BOOL BBSLogin(tUserRecord *pCurrentUserRecord);
BOOL NewUser(tUserRecord *pCurrentUserRecord);
void EndBBSSession(void);
BOOL LogoutUser(tUserRecord *pCurrentUserRecord);

/* User file handling. */
BOOL ReadUser(tUserRecord *pCurrentUserRecord, char *pszUserName);
BOOL CreateUser(tUserRecord *pCurrentUserRecord);
BOOL WriteUser(tUserRecord *pCurrentUserRecord);

/* Common utility functions. */
void PromptForEnter(void);
FILE *ExclusiveFileOpen(char *pszFileName, char *pszMode, int *phHandle);
void ExclusiveFileClose(FILE *pfFile, int hHandle);
void PasswordInput(char *pszInput, INT nMaxLength);

#endif /* !_INC_EX_BBS */
