/* REXX */

/*

   Program to create list of file descriptions from file_id.diz files in
   zip archives, in directory defined by inpath.

   This a Regina script.

   by David Rife 01-10-2009

*/

    inpath = "c:\host\"

    filelist = "FILELIST.$$$"  /*  file list */
    outfile = inpath"FILES.BBS"     /*  output file */
    onefile = "TEMPDIR.$$$"   /*  directory listing of one file from list */
    dizfile = "file_id.diz"

    SIGNAL ON HALT NAME shutdown
    ADDRESS SYSTEM "del "outfile
    ADDRESS SYSTEM "if exist "dizfile" del "dizfile

    count = 0

    ADDRESS SYSTEM "dir "inpath"*.* /ogn /a:-d /b > " filelist

    CALL LINEOUT outfile, ""
    CALL LINEOUT outfile, " ------------------------------------------------------------------------------"
    CALL LINEOUT outfile, " Descriptions of files in "inpath
    CALL LINEOUT outfile, " Created by Regina makelist.rex on "DATE()" at "TIME()
    CALL LINEOUT outfile, " ------------------------------------------------------------------------------"

    DO WHILE LINES(filelist) > 0
        line1 = TRANSLATE(LINEIN(filelist))
        CALL workone
    END

    CALL LINEOUT outfile, " ------------------------------------------------------------------------------"
    IF count = 1 THEN
        CALL LINEOUT outfile, " 1 file."
    ELSE
        CALL LINEOUT outfile, " "count" files."
    CALL LINEOUT outfile, " "
    CALL close outfile
    ADDRESS SYSTEM "del "filelist

    IF count = 0 THEN DO
        ADDRESS SYSTEM "del "outfile
        SAY " "
        SAY "There are no files to list."
        SAY " "
        END
    SIGNAL shutdown

workone:
    IF POS(filelist,line1) > 0 THEN RETURN
    IF POS(outfile,line1) > 0 THEN RETURN
    IF POS(onefile,line1) > 0 THEN RETURN
    u = POS(".",line1)
    nline = SUBSTR(line1, 1, u - 1)
    ADDRESS SYSTEM 'dir "'inpath||line1'" > 'onefile
    DO WHILE LINES(onefile) > 0
        xline = LINEIN(onefile)
        yline = TRANSLATE(xline)
        IF POS(nline, yline) = 1 | POS(line1, yline) > 0 THEN DO
            CALL LINEOUT outfile, " "xline
            CALL LINEOUT outfile, " "
            count = count + 1
            END
        END
    CALL close onefile
    ADDRESS SYSTEM "del " onefile
    ADDRESS SYSTEM "if exist "dizfile" del "dizfile
    IF POS(".ZIP",line1) > 0 THEN DO
        ADDRESS SYSTEM "pkunzip.exe "inpath||line1" file_id.diz > nul"
        IF STREAM(dizfile, "C", "QUERY EXISTS")\="" THEN DO
            DO WHILE LINES(dizfile) > 0
                cline = LINEIN(dizfile)
                CALL LINEOUT outfile, "                  "cline
                END
            CALL close dizfile
            CALL LINEOUT outfile, " "
            END
        END
        RETURN

shutdown:
    ADDRESS SYSTEM "if exist "dizfile" del "dizfile
    EXIT

close: PROCEDURE
    CALL STREAM arg(1), "C", "CLOSE"
    RETURN


