unit Tetris;

interface

procedure itPlayTetris;
procedure itShowScores(cms : String);

implementation

uses
   Global, ShowFile, Output, Misc, Strings, Input, Comm, DateTime, Logs,
   FileSort;

const
   maxGridY  = 50;
   maxGridX  = 40;
   maxPlayer = 2;
   maxPtY    = 5;
   maxPtX    = 5;
   maxShape  = 7;
   maxLevel  = 18;

type
   tGrid = array[1..maxGridY,1..maxGridX] of Byte;
   pGrid = ^tGrid;

   tPlayer = record
       Local   : Boolean;
       Name    : String[36];
       Grid    : pGrid;
       Idx     : array[1..maxGridY] of Byte;
       gXp     : Byte;
       gYp     : Byte;
       gXs     : Byte;
       gYs     : Byte;
       gYl     : Byte;
       curB    : Byte;
       curF    : Byte;
       bX      : Integer;
       bY      : Integer;
       Lines   : Word;
       Level   : Byte;
       Score   : LongInt;
       nShape  : Byte;
       lastM   : Real;
   end;

   tShape = array[1..4,1..maxPtY,1..maxPtX] of Byte;

const
   sPts : array[1..maxShape] of Byte = (4,6,6,5,6,5,5);
   S : array[1..maxShape] of tShape =
      ((((0,0,1,0,0),
         (0,0,1,0,0),      {      }
         (0,0,1,0,0),      {      }
         (0,0,1,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,0,0,0,0),      {       }
         (0,1,1,1,1),      {   }
         (0,0,0,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,0,1,0,0),      {      }
         (0,0,1,0,0),      {      }
         (0,0,1,0,0),      {      }
         (0,0,1,0,0)),

        ((0,0,0,0,0),
         (0,0,0,0,0),      {       }
         (1,1,1,1,0),      {   }
         (0,0,0,0,0),      {       }
         (0,0,0,0,0))),

       (((0,0,1,0,0),
         (0,0,1,0,0),      {      }
         (0,1,1,0,0),      {     }
         (0,0,0,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,0,1,0,0),      {      }
         (0,0,1,1,1),      {    }
         (0,0,0,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,0,0,0,0),      {       }
         (0,0,1,1,0),      {     }
         (0,0,1,0,0),      {      }
         (0,0,1,0,0)),

        ((0,0,0,0,0),
         (0,0,0,0,0),      {       }
         (1,1,1,0,0),      {    }
         (0,0,1,0,0),      {       }
         (0,0,0,0,0))),

       (((0,0,1,0,0),
         (0,0,1,0,0),      {      }
         (0,0,1,1,0),      {     }
         (0,0,0,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,0,0,0,0),      {       }
         (0,0,1,1,1),      {    }
         (0,0,1,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,0,0,0,0),      {       }
         (0,1,1,0,0),      {     }
         (0,0,1,0,0),      {      }
         (0,0,1,0,0)),

        ((0,0,0,0,0),
         (0,0,1,0,0),      {      }
         (1,1,1,0,0),      {    }
         (0,0,0,0,0),      {       }
         (0,0,0,0,0))),

       (((0,0,0,0,0),
         (0,0,1,0,0),      {      }
         (0,1,1,1,0),      {    }
         (0,0,0,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,0,1,0,0),      {      }
         (0,0,1,1,0),      {     }
         (0,0,1,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,0,0,0,0),      {       }
         (0,1,1,1,0),      {    }
         (0,0,1,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,0,1,0,0),      {      }
         (0,1,1,0,0),      {     }
         (0,0,1,0,0),      {       }
         (0,0,0,0,0))),

       (((0,0,0,0,0),
         (0,1,1,0,0),      {     }
         (0,1,1,0,0),      {     }
         (0,0,0,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,1,1,0,0),      {     }
         (0,1,1,0,0),      {     }
         (0,0,0,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,1,1,0,0),      {     }
         (0,1,1,0,0),      {     }
         (0,0,0,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,1,1,0,0),      {     }
         (0,1,1,0,0),      {     }
         (0,0,0,0,0),      {       }
         (0,0,0,0,0))),

       (((0,0,0,0,0),
         (0,0,1,0,0),      {      }
         (0,0,1,1,0),      {     }
         (0,0,0,1,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,0,0,0,0),      {       }
         (0,0,1,1,0),      {    }
         (0,1,1,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,1,0,0,0),      {      }
         (0,1,1,0,0),      {     }
         (0,0,1,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,0,0,0,0),      {       }
         (0,0,1,1,0),      {    }
         (0,1,1,0,0),      {       }
         (0,0,0,0,0))),

       (((0,0,0,0,0),
         (0,0,1,0,0),      {      }
         (0,1,1,0,0),      {     }
         (0,1,0,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,1,1,0,0),      {     }
         (0,0,1,1,0),      {     }
         (0,0,0,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,0,1,0,0),      {      }
         (0,1,1,0,0),      {     }
         (0,1,0,0,0),      {       }
         (0,0,0,0,0)),

        ((0,0,0,0,0),
         (0,1,1,0,0),      {     }
         (0,0,1,1,0),      {     }
         (0,0,0,0,0),      {       }
         (0,0,0,0,0))));

   Lev : array[1..maxLevel] of record t : Real; l : Word; end =
        ((t:0.60;l:0),
         (t:0.55;l:10),
         (t:0.50;l:20),
         (t:0.45;l:30),
         (t:0.40;l:40),
         (t:0.32;l:50),
         (t:0.30;l:60),
         (t:0.27;l:70),
         (t:0.23;l:80),
         (t:0.20;l:90),
         (t:0.18;l:100),
         (t:0.15;l:110),
         (t:0.13;l:120),
         (t:0.10;l:130),
         (t:0.08;l:150),
         (t:0.05;l:160),
         (t:0.04;l:175),
         (t:0.02;l:200));


var
   P : array[1..maxPlayer] of tPlayer;
   numP, q : Byte;
   itdone, Ans : Boolean;
   iCh : Char;

procedure itAddHiScore;
var F : file of tTetrisHiRec; t : tTetrisHiRec; z : Word;
begin
   Assign(F,Cfg^.pathData+fileTetris);
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then
   begin
      {$I-}
      Rewrite(F);
      {$I+}
      if ioResult <> 0 then Exit;
      FillChar(t,SizeOf(t),0);
      with t do
      begin
         Name := '---';
         Level := 0;
         Lines := 0;
         Score := 0;
      end;
      for z := 1 to maxTetris do Write(f,t);
   end else Seek(F,FileSize(F));
   FillChar(t,SizeOf(t),0);
   with t do
   begin
      Name := P[1].Name;
      Level := P[1].Level;
      Lines := P[1].Lines;
      Score := P[1].Score;
   end;
   Write(f,t);
   Close(f);
   fsSortTetrisScores;
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then Exit;
   Seek(F,maxTetris);
   Truncate(F);
   Close(F);
end;

procedure itShowScores(cms : String);
var Ans : Boolean; B : file of tTetrisHiRec; t : tTetrisHiRec; N, td : Word;
begin
   td := strToInt(cms);
   if (td < 1) or (td > maxTetris) then td := 10;
   logWrite('Displayed Tetris high scores');
   Assign(B,Cfg^.pathData+fileTetris);
   {$I-}
   Reset(B);
   {$I+}
   if ioResult <> 0 then Exit;
   if FileSize(B) < 1 then
   begin
      Close(B);
      Exit;
   end;
   PausePos := 1;
   PauseAbort := False;
   Ans := (sfGetTextFile(txHiScoreTop,ftTopLine) <> '') and
          (sfGetTextFile(txHiScoreMid,ftHiScore) <> '') and
          (sfGetTextFile(txHiScoreBot,ftNormal)  <> '');
   if Ans then
   begin
      sfShowTextFile(txHiScoreTop,ftTopLine);
      oUpPause(ansiRows-1);
      sfGotoPos(1);
      sfLoadRepeat(txHiScoreMid);
   end else
   begin
      oClrScr;
      oDnLn(1);
      oSetCol(colInfo);
      oWriteLn(' '+Resize('Rank',4)+
               ' '+Resize('Username',36)+
               ' '+Resize('Level',8)+
               ' '+Resize('Lines',8)+
               ' '+strSquish('Score',14));
      oSetCol(colBorder);
      oWriteLn(sRepeat('',79));
      oUpPause(3);
      oSetCol(colText);
   end;
   N := 0;
   while (not HangUp) and (N < td) and (not Eof(B)) and (not PauseAbort) do
   begin
      Read(B,t);
      Inc(N);
      if Ans then
      begin
         sfStr[1] := St(N);
         sfStr[2] := t.Name;
         sfStr[3] := St(t.Level);
         sfStr[4] := St(t.Lines);
         sfStr[5] := Stc(t.Score);
         sfShowRepeat(ftHiScore);
         if oWhereX <> 1 then oDnLn(1);
         oUpPause(1);
      end else
      begin
         oWriteLn(' '+Resize(St(N),4)+
                  ' '+Resize(t.Name,36)+
                  ' '+Resize(St(t.Level),8)+
                  ' '+Resize(St(t.Lines),8)+
                  ' '+strSquish(Stc(t.Score),14));
         oUpPause(1);
      end;
   end;
   sfKillRepeat;
   Close(B);
   if Ans then
   begin
      sfShowTextFile(txHiScoreBot,ftNormal);
      oUpPause(ansiRows);
   end else
   begin
      oSetCol(colBorder);
      oWriteLn(sRepeat('',79));
      oUpPause(1);
   end;
   PausePos := 0;
end;

procedure itWriteScore(n : Byte);
begin
   sfGotoPos(3);
   oWrite(stc(P[n].Score));
end;

procedure itWriteLines(n : Byte);
begin
   sfGotoPos(4);
   oWrite(st(P[n].Lines));
end;

procedure itWriteLevel(n : Byte);
begin
   sfGotoPos(5);
   oWrite(stc(P[n].Level));
end;

procedure itDrawBlock(n : Byte; Erase : Boolean);
var z, x, y, yp : Integer; top : Boolean; ch : Char;
begin
   oSetColRec(sfPos[1].C);
   with P[n] do
   begin
      for x := 1 to maxPtX do for y := 1 to maxPtY do if s[curB,curF,y,x] = 1 then
      begin
         yp := Idx[bY+y-1];
         top := Odd(bY+y-1);
         oGotoXY(gXp+bX+x-2,gYp+yp-1);
         if Erase then Grid^[bY+y-1,bX+x-1] := 0 else
         begin
            if Grid^[bY+y-1,bX+x-1] = 1 then itDone := True;
            Grid^[bY+y-1,bX+x-1] := 1;
         end;
         if top then
         begin
            if (Grid^[bY+y-1,bX+x-1] = 1) and (Grid^[bY+y,bX+x-1] = 1) then ch := '' else
            if (Grid^[bY+y-1,bX+x-1] = 1) and (Grid^[bY+y,bX+x-1] = 0) then ch := '' else
            if (Grid^[bY+y-1,bX+x-1] = 0) and (Grid^[bY+y,bX+x-1] = 1) then ch := '' else
                                                                            ch := ' ';
         end else
         begin
            if (Grid^[bY+y-2,bX+x-1] = 1) and (Grid^[bY+y-1,bX+x-1] = 1) then ch := '' else
            if (Grid^[bY+y-2,bX+x-1] = 1) and (Grid^[bY+y-1,bX+x-1] = 0) then ch := '' else
            if (Grid^[bY+y-2,bX+x-1] = 0) and (Grid^[bY+y-1,bX+x-1] = 1) then ch := '' else
                                                                              ch := ' ';
         end;
         oWriteChar(Ch);
      end;
   end;
end;

procedure itUpdateLine(n, l : Byte);
var x : Integer; top : Boolean; ch : Char;
begin
   oSetColRec(sfPos[1].C);
   top := Odd(l);
   with P[n] do
   begin
      oGotoXY(gXp,gYp+Idx[l]-1);
      for x := 1 to gXs do
      begin
         if top then
         begin
            if (Grid^[l,x] = 1) and (Grid^[l+1,x] = 1) then ch := '' else
            if (Grid^[l,x] = 1) and (Grid^[l+1,x] = 0) then ch := '' else
            if (Grid^[l,x] = 0) and (Grid^[l+1,x] = 1) then ch := '' else
                                                            ch := ' ';
         end else
         begin
            if (Grid^[l-1,x] = 1) and (Grid^[l,x] = 1) then ch := '' else
            if (Grid^[l-1,x] = 1) and (Grid^[l,x] = 0) then ch := '' else
            if (Grid^[l-1,x] = 0) and (Grid^[l,x] = 1) then ch := '' else
                                                            ch := ' ';
         end;
         oWriteChar(Ch);
      end;
   end;
end;

procedure itNewBlock(n : Byte);
begin
   with P[n] do
   begin
      curB := nShape;
      nShape := Random(maxShape)+1;
      curF := Random(4)+1;
      bX := Random(gXs-4)+1;
      bY := 1;
      lastM := dtTimer;
   end;
   itDrawBlock(n,False);
end;

function itZapLine(n, l : Byte) : Boolean;
var ok : Boolean; z : Byte;
begin
   itZapLine := False;
   if (l < 1) or (l > P[n].gYs) then Exit;
   ok := True;
   for z := 1 to P[n].gXs do if P[n].Grid^[l,z] = 0 then ok := False;
   itZapLine := ok;
end;

function itLineEmpty(n, l : Byte) : Boolean;
var ok : Boolean; z : Byte;
begin
   itLineEmpty := False;
   if (l < 1) or (l > P[n].gYs) then Exit;
   ok := True;
   for z := 1 to P[n].gXs do if P[n].Grid^[l,z] = 1 then ok := False;
   itLineEmpty := ok;
end;

procedure itCheckLines(n : Byte);
var y, x, b, l : Byte;
begin
   with P[n] do
   begin
      Inc(Score,sPts[curB]);
      itWriteScore(n);
      l := 0;
      for y := 1 to maxPtY do if itZapLine(n,bY+y-1) then
      begin
         Inc(l);
         for b := bY+y-1 downto 2 do Grid^[b] := Grid^[b-1];
         for x := 1 to gXs do Grid^[1,x] := 0;
         b := bY+y-1;
         Inc(Lines);
         itWriteLines(n);
      end;
      if l > 0 then
      begin
         for y := 1 to b do itUpdateLine(n,y);
         Inc(Score,(l*l)*Level*100);
         oBeep;
         itWriteScore(n);
         if (Level < maxLevel) and (Lines >= Lev[Level+1].l) then
         begin
            Inc(Level);
            itWriteLevel(n);
            oBeep;
            oBeep;
         end;
      end;
   end;
end;

procedure itMoveDown(n : Byte);
var ny, x, y : Integer; stop : boolean;
begin
   with P[n] do
   begin
      ny := bY+1;
      stop := False;
      for x := 1 to maxPtX do for y := 1 to maxPtY do
         if (s[curB,curF,y,x] <> 0) and
           (((Grid^[ny+y-1,bX+x-1] = 1) and
             (not ((y < 5) and (S[curB,curF,y+1,x] = 1)))) or
            (ny+y-1 > gYs)) then stop := True;
      if not stop then
      begin
         itDrawBlock(n,True);
         bY := bY+1;
         itDrawBlock(n,False);
      end else
      begin
         itCheckLines(n);
         itNewBlock(n);
      end;
   end;
end;

procedure itFastDown(n : Byte);
var ny, x, y, oy : Integer; stop : boolean;
begin
   with P[n] do
   begin
      stop := False;
      oy := bY;
      repeat
         ny := oY+1;
         for x := 1 to maxPtX do for y := 1 to maxPtY do
            if (s[curB,curF,y,x] <> 0) and
              (((Grid^[ny+y-1,bX+x-1] = 1) and
                (not ((y < 5) and (S[curB,curF,y+1,x] = 1)))) or
               (ny+y-1 > gYs)) then stop := True;
         if not Stop then oY := oY+1;
      until stop;
      itDrawBlock(n,True);
      bY := oY;
      itDrawBlock(n,False);
      itCheckLines(n);
      itNewBlock(n);
   end;
end;

procedure itMoveRight(n : Byte);
var nx, x, y : Integer; ok : Boolean;
begin
   with P[n] do
   begin
      nx := bX+1;
      ok := True;
      for x := 1 to maxPtX do for y := 1 to maxPtY do
         if (s[curB,curF,y,x] <> 0) and
           (((Grid^[bY+y-1,nx+x-1] = 1) and
             (not ((x < 5) and (S[curB,curF,y,x+1] = 1)))) or
            (nx+x-1 > gXs)) then ok := False;
      if ok then
      begin
         itDrawBlock(n,True);
         bX := bX+1;
         itDrawBlock(n,False);
      end;
   end;
end;

procedure itMoveLeft(n : Byte);
var nx, x, y : Integer; ok : Boolean;
begin
   with P[n] do
   begin
      nx := bX-1;
      ok := True;
      for x := 1 to maxPtX do for y := 1 to maxPtY do
         if (s[curB,curF,y,x] <> 0) and
           (((Grid^[bY+y-1,nx+x-1] = 1) and
             (not ((x > 1) and (S[curB,curF,y,x-1] = 1)))) or
            (nx+x-1 < 1)) then ok := False;
      if ok then
      begin
         itDrawBlock(n,True);
         bX := bX-1;
         itDrawBlock(n,False);
      end;
   end;
end;

procedure itRotate(n : Byte; add : Integer);
var nf, x, y : Integer; ok : Boolean;
begin
   with P[n] do
   begin
      nf := curF+add;
      if nf < 1 then nf := 4 else if nf > 4 then nf := 1;
      ok := True;
      for x := 1 to maxPtX do for y := 1 to maxPtY do
         if (s[curB,nf,y,x] <> 0) and
           (((Grid^[bY+y-1,bX+x-1] = 1) and
             (not (S[curB,curF,y,x] = 1))) or
            (bX+x-1 < 1) or (bX+x-1 > gXs) or (bY+y-1 > gYs)) then ok := False;
      if ok then
      begin
         itDrawBlock(n,True);
         curF := nf;
         itDrawBlock(n,False);
      end;
   end;
end;

procedure itPlayTetris;
begin
   Ans := sfShowTextFile(txTetris,ftTetris);

   FillChar(P,SizeOf(P),0);

   itDone := False;

   numP := 1;

   with P[1] do
   begin
      Name := User^.UserName;
      New(Grid);
      FillChar(Grid^,SizeOf(Grid^),0);
      gYl := 0;
      if Ans then
      begin
         gXp := sfPos[1].X;
         gYp := sfPos[1].Y;
         gXs := sfPos[2].X-gXp+1;
         gYs := sfPos[2].Y-gYp+1;
         gYs := gYs*2;
         if Odd(gYs) then Dec(gYs);
      end else
      begin
         gXp := 10;
         gYp := 4;
         gXs := 20;
         gYs := 30;
      end;
      Local := True;
      for q := 1 to gYs do
      begin
         if Local then Inc(gYl);
         Local := not Local;
         Idx[q] := gYl;
      end;
      curB := 1;
      curF := 1;
      bX := 1;
      bY := 1;
      Lines := 0;
      Score := 0;
      Level := 1;
      nShape := Random(maxShape)+1;
      Local := True;
   end;

   itWriteLevel(1);
   itWriteLines(1);
   itWriteScore(1);

   itNewBlock(1);

   repeat
      if iKeypressed then
      begin
         iCh := UpCase(iReadKey);
         if extKey <> #0 then
         case extKey of
            dnArrow : itFastDown(1);
            lfArrow : itMoveLeft(1);
            rtArrow : itMoveRight(1);
            upArrow : itRotate(1,1);
         end else
         case iCh of
            ' ','X','5' : itRotate(1,1);
            #13,'2'     : itFastDown(1);
            'Z'         : itRotate(1,-1);
            '4'         : itMoveLeft(1);
            '6'         : itMoveRight(1);
            '0'         : itMoveDown(1);
            #27         : itDone := True;
         end;
      end;
      for q := 1 to numP do with P[q] do
      begin
         if dtRealDiff(lastM,dtTimer) > Lev[Level].t then
         begin
            itMoveDown(q);
            lastM := dtTimer;
         end else cCheckUser;
      end;
   until (HangUp) or (itDone);

   with P[1] do
   begin
      Dispose(Grid);
   end;
   sfGotoPos(maxPos);
   logWrite('Played Tetris ['+St(P[1].Lines)+' lines, '+Stc(P[1].Score)+
            ' points; level '+St(P[1].Level)+']');
   itAddHiScore;
end;

end.