(*



          
           
                
              
                
                 
                                  
    t h e    i n i q u i t y    b u l l e t i n    b o a r d    s y s t e m




*)

{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,D+,L-,N-,E+}
{$M 65000,0,450000}
{$DEFINE iniRegistered}

program Iniquity;

uses
   Apply,        { New user application system                            }
   Archive,      { Archiver handling routines (ZIP / ARJ / UC2)           }
   Attach,       { Message file inclusion system                          }
   AutoMsg,      { AutoMessage Display / Creation Routines                }
   AutoSig,      { User auto-signiture system                             }
   BbsInit,      { BBS Initialization Process                             }
   BbsList,      { BBS Listing Module                                     }
   Callers,      { Call record accessing routines                         }
   ChatMode,     { User / SysOp Online Chatmode System                    }
   Comm,         { High Level Communication Routines                      }
   Conf,         { Conference system routines                             }
   Config,       { Configuration Operation Routines                       }
   Config1,      { System Configuration Module                            }
   Config2,      { Communication Setup Module                             }
   Config3,      { Online String Editing Module                           }
   Config4,      { Menu Editor Module                                     }
   Config5,      { Message Area Editor Module                             }
   Config6,      { Security Access Level Configuration System             }
   Config7,      { The Protocol Editor                                    }
   Config8,      { System User Editor                                     }
   Config9,      { File Area Editing Ssytem                               }
   Config10,     { Archiver editor                                        }
   Config11,     { Event editor                                           }
   Config12,     { Message and file conference editor                     }
   Config13,     { File editor                                            }
   Config14,     { Statistics editor                                      }
   Config15,     { BBS list editor                                        }
   Config16,     { Text library [*.TFL] editor                            }
   Config17,     { Infoform editor                                        }
   Crt,          { Standard TP7 Direct Screen Interface Unit              }
   DateTime,     { Date and time routines                                 }
   Detect,       { Emulation Detection Unit (ie ANSi, RIP, AVT)           }
   Doors,        { Door drop file creation and execution system           }
   Email,        { Electroic Private Mail System                          }
   Emulate,      { ANSI Color Graphics Emulation System                   }
   FastIO,       { Enhanced Screen IO - Super FAST                        }
   FileArea,     { File section stuff...                                  }
   Files,        { File Initialization, Creation, and Handling Routines   }
   FileSort,     { File directory sorting system                          }
   Fossil,       { Fossil Modem Communication System                      }
   FsEditor,     { Full Screen Message Editor                             }
   Global,       { Global Procedures, Functions, Variables, and Constants }
   HardAnsi,     { Hard-Coded Crunched ANSi Graphics (ie WFC Screen)      }
   History,      { History log file updation system                       }
   Infoform,     { Infoform management                                    }
   Input,        { High Level Input Routines                              }
   Iplx,         { Iniquity Programming Language - execution system       }
   Levels,       { User validating / updation system                      }
   Logon,        { BBS Logon System                                       }
   Logs,         { Logging System                                         }
   MciCodes,     { MCI Code Control and Replacement System                }
   MenuCmd,      { All Menu Command Procedures and Functions              }
   Menus,        { Menu Control Unit                                      }
   MicroDOS,     { Internal DOS Micro DOS-Emulator                        }
   Misc,         { Miscelleaneaus Peocedures and Functions                }
   MsgArea,      { Message Loading/Saving/Writing/Reading System          }
   Nodes,        { Multinode support and interaction routines             }
   Nuv,          { New user voting system                                 }
   Output,       { High Level Output Routines                             }
   Overlay,      { Standard TP7 Overlay Control Unit                      }
   QwkMail,      { QWK/REP offline mail processing system                 }
   Sauce,        { Sauce description loader [sauce by Tasmaniac <acid>]   }
   Screen,       { Screen Save / Restore Procedures                       }
   ShowFile,     { Text File Viewing System                               }
   StatBar,      { Status Bar Updation System                             }
   Stats,        { BBS statistics management                              }
   Strings,      { String Handling Procedures and Functions               }
   Swap,         { Disk / EMS Memory Swapping System                      }
   Terminal,     { Terminal Mode Module                                   }
   Tetris,       { Iniquity's internal Tetris!                            }
   Transfer,     { File Transfer System                                   }
   Users,        { User record i/o                                        }
   Wait4Cal;     { Wait-For-Call (WFC) Operations System                  }

   {$O Apply   } {$O Archive } {$O Attach  } {$O AutoMsg } {$O AutoSig }
   {$O bbsInit } {$O bbsList } { O Callers } {$O ChatMode} { O Comm    }
   {$O Conf    } { O Config  } {$O Config1 } {$O Config2 } {$O Config3 }
   {$O Config4 } {$O Config5 } {$O Config6 } {$O Config7 } {$O Config8 }
   {$O Config9 } {$O Config10} {$O Config11} {$O Config12} {$O Config13}
   {$O Config14} {$O Config15} {$O Config16} {$O Config17} { O Crt     }
   { O DateTime} {$O Detect  } {$O Doors   } {$O Email   } { O Emulate }
   { O FastIO  } {$O FileArea} { O Files   } {$O FileSort} { O Fossil  }
   {$O FsEditor} { O Global  } {$O HardANSI} {$O History } {$O Infoform}
   { O Input   } {$O Iplx    } {$O Levels  } {$O Logon   } {$O Logs    }
   {$O MciCodes} {$O MenuCmd } {$O Menus   } {$O MicroDOS} { O Misc    }
   {$O MsgArea } {$O Nodes   } {$O Nuv     } { O Output  } { O Overlay }
   {$O QwkMail } {$O Sauce   } { O Screen  } { O ShowFile} { O StatBar }
   {$O Stats   } { O Strings } { O Swap    } {$O Terminal} {$O Tetris  }
   {$O Transfer} {$O Users   } {$O Wait4Cal}

var
   I : Integer; S : String; L : LongInt; D : tDateTimeRec; ExitSave : Pointer;

procedure bbsInitError(S : String; El : Byte);
begin
   WriteLn('Error: '+S);
   Halt(El);
end;

procedure bbsLoadConfiguration(var aCfg : tCfgRec);
var fCfg : file of tCfgRec;
begin
   Assign(fCfg,fileConfig);
   {$I-} Reset(fCfg); {$I+}
   if ioResult <> 0 then
   begin
      TextMode(co80);
      WriteLn;
      WriteLn('The file "'+fileConfig+'" was not found in the current directory.');
      WriteLn('This is the '+bbsTitle+' configuration file, and is REQUIRED to load the BBS.');
      WriteLn('Please either recreate this file using the '+bbsTitle+' initalization system,');
      WriteLn('or obtain it from the original archive.');
      Halt(errFatal);
   end else
   begin
      {$I-} Read(fCfg,aCfg); {$I+}
      if ioResult <> 0 then
      begin
         TextMode(co80);
         WriteLn;
         WriteLn('The file "'+fileConfig+'" is incompatible with the current version');
         WriteLn('of '+bbsTitle+'.');
         WriteLn;
         WriteLn('Please either recreate this file using the '+bbsTitle+' initalization system,');
         WriteLn('or obtain it from the original archive.');
         Close(fCfg);
         Halt(errFatal);
      end;
      Close(fCfg);
   end;
   MultiNode := aCfg.MultiNode;  { check if bbs is multinode }
end;

procedure bbsErrorHandler; far;
var F : Text; vidSeg : Word; Y,X : Byte; S : String[80]; C : Char;
begin
   ExitProc := ExitSave;
   if (ErrorAddr <> nil) then
   begin
      Assign(F,fileError);
      {$I-}
      Append(F);
      {$I+}
      if (ioResult <> 0) then
      begin
         Rewrite(F);
         Append(F);
         WriteLn(F,'- '+bbsTitle+' '+bbsVersion+' Critical Error Log - Created '+dtTimeStr12+', '+dtDateString);
         WriteLn(F,'');
      end;
      WriteLn(F);
      if (Mem[$0000:$0449] = 7) then vidSeg := $B000 else vidSeg := $B800;
      for y := 1 to 25 do
      begin
         s := '';
         for x := 1 to 80 do
         begin
            c := Chr(Mem[vidSeg:(160*(y-1)+2*(x-1))]);
            if (c = #0) then c := #32;
            if ((x = WhereX) and (y = WhereY)) then c := #240;
            if ((x <> 80) or ((x = 80) and (c <> #32))) then s := s + c;
         end;
         WriteLn(F,S);
      end;
      WriteLn(F,'%% Runtime error '+St(ExitCode)+' at '+dtTimeStr12+', '+dtDateString);
      WriteLn(F,'================================================================================');
      Close(F);
      logWrite('xRuntime error '+St(ExitCode)+' at '+dtTimeStr12+', '+dtDateString);
      if UserOn then logWrite('x'+User^.Username+' online when error occured');
      if not asDoor then cHangUp;
      ErrorLevel := errRuntime;
      killTerminateBBS;
   end;
end;

procedure bbsInitOverlays;
var theCfg : tCfgRec; sBuf : LongInt;
begin
   bbsLoadConfiguration(theCfg);
   mWriteInit('initializing overlay file');
   ovrInit(fileOverlay);
   mWriteInit('checking overlay status');
   case ovrResult of
      ovrError       : S := 'Error Loading Overlay File';
      ovrNotFound    : S := bbsTitle+' Overlay File Not Found: "'+fileOverlay+'"';
      ovrNoMemory    : S := 'Insufficient Available Memory to Load Overlay File';
      ovrIOError     : S := 'Overlay File I/O Error';
   end;
   if ovrResult <> ovrOk then bbsInitError(S+'|',errFatal);
   mWriteInit('initializing expanded memory');
   if theCfg.OverlayToEMS then
   begin
      ovrInitEMS;
      ovrInEMS := ovrResult = ovrOK;
   end;
   mWriteInit('setting overlay i/o buffer');
   if not ovrInEMS then
   begin
      sBuf := strToInt(mGetParam(paramOverlayBuf));
      if (sBuf > 0) and (sBuf < 64) then sBuf := sBuf*1024 else sBuf := 0;
      ovrSetBuf(maxOvrSize+sBuf);
      ovrSetRetry((maxOvrSize+sBuf) div 3);
   end;
   mWriteInit('initializing configuration');
   New(Cfg);
   FillChar(Cfg^,SizeOf(Cfg^),0);
   mWriteInit('checking memory');
   Cfg^ := theCfg;
end;

begin
   ExitSave := ExitProc;
   ExitProc := @bbsErrorHandler;
   initNum := 0;
   fileMode := 66;
   TextMode(Co80);
   mCursor(False);
   S := '|12t|04he |15i|07niquit|08y |12b|04ulletin |12b|04oard |12s|04ystem|08; '+
        '|07v|08ersion |07'+bbsVersion;
{$IFDEF iniRegistered}
   S := S+'|08; |07r|08egistered .';
{$ENDIF}
   cFwrite(1,1,S);
   cFwrite(67,1,'|12l|04oading|08:');
   cFwrite(1,2,'|12s|04tatus|08:');
   mWriteInit('---');
   mWriteInit('preparing system');
   CheckBreak := False;
   Randomize;
   OvrInEMS := False;
   mWriteInit('loading configuration');

   bbsInitOverlays;
   mWriteInit('initializing variables');
   initVariables;
   mWriteInit('initializing screen i/o');
   ioInitFastIO;
{  fixUsers;}
   mWriteInit('checking system config');
   initFiles;
   statLoad;
   mWriteInit('loading history file');
   hisLoad;
   mWriteInit('checking for fossil');
   initCommPort;
   mWriteInit('checking for direct video');

   DirectVideo := Cfg^.DirectWrites;
   mWriteInit('checking for cga snow');
   CheckSnow   := Cfg^.SnowChecking;
   mWriteInit('checking vga effects');

   if (mParam(paramNoEffects)) or     { Check for disable parameter...    }
      (not (vidType in [5..8])) or    { Check video card...               }
      (oprType <> oprDOS)             { Check if multitasking...          }
      then Cfg^.VgaEffects := False;  { Disable VGA fades if nessesary... }

{  resetVariables;}
   mWriteInit('loading sysop info');
   userReset;
   mWriteInit('updating logfiles');

{  UseEMSIfAvailable := Cfg^.SwapToEMS;
   SwapOk := InitExecSwap(HeapPtr,fileSwap);}

   logWrite('-');
   mWriteInit('analyzing command line');
   logWrite('>'+bbsTitle+' version '+bbsVersion+' loaded.');
   mWriteInit('initializion complete');
   mCursor(True);

   initParameters;


   UserOn := False;

   if mParam(paramTerminalMode) then tmTerminalMode;

   S := mGetParam(paramOnlineBaud);
   if (not modemOff) and (S <> '') then
   begin
      L := strToInt(S);
      if (L >= 300) and (L <= 115200) then wfcOnline(L);
   end else
   if (s = '0') or (mParam(paramLocalLogon)) then wfcOnline(0);

   curStat := Cfg^.DefWFCstat;
   repeat
      wfcWaitForCall;
      userPrelogonInit;
      sbReset;
      if Cfg^.StatOnDefault then
      begin
         Cfg^.StatBarOn := False;
         sbStatBar(True);
      end else Cfg^.StatBarOn := False;
      if not menuLaunch then
      begin
         logonInit;
         if (not ((Cfg^.SysOpAutoLogin) and (LocalIO))) and (Cfg^.MatrixLogin) then
         begin
            curMenu := 'MATRIX';
            menuInstall;
            NewMenuCmd := '';
            ExecFirst := False;
            while (not HangUp) and (not LoggedIn) do menuExec;
         end else logonSystem;
      end else
      begin
         userReset;
         LoggedIn := True;
      end;
      if LoggedIn then
      begin
         oString(strInitBBS);
         userLogonInit;
         nodeUpdate('User online');
         logWrite(User^.Username+' ('+User^.Realname+') logged in');

         maFindAreaWithAccess;
         faFindAreaWithAccess;
         confLoad(True);  { Load message conference }
         confLoad(False); { Load file conference }
         timeCheck := True;

         if not menuLaunch then
         begin
            curMenu := User^.StartMenu;
            if not fExists(Cfg^.pathMenu+curMenu+'.MNU') then curMenu := Cfg^.StartMenu;
         end;
         menuInstall;
         NewMenuCmd := '';
         I := 1;
         while (I <= numCmds) and (NewMenuCmd = '') do
         begin
            if (Cmd^[I].Keys = cmdFirst) and
               (acsOk(Cmd^[I].ACS)) then NewMenuCmd := cmdFirst;
            Inc(I,1);
         end;
         ExecFirst := NewMenuCmd = cmdFirst;
         oDnLn(1);
         while not Hangup do menuExec;
         if not asDoor then cHangUp;
         User^.timeToday := mTimeLeft('M');
         if TempSysOp then
         begin
            User^.SL := realSL;
            User^.DSL := realDSL;
            TempSysOp := False;
         end;
         dtGetDateTime(D);
         dtTimeDiff(D,TimeOn,D);
         if HungUp then logWrite(User^.Username+' hung up [online for '+dtTimeRecStr(D)+']') else
                        logWrite(User^.Username+' logged off [online for '+dtTimeRecStr(D)+']');
         userSave(User^);
      end else if not asDoor then cHangUp;
      UserOn := False;
      fSaveCfg;
      if QuitAfter then killTerminateBBS;
      resetVariables(False);
      userReset;
   until False;
end.