program RealTerm;

uses Dos, Crt, Fossil, MF_Strs, MF_Color, MF_ANSi, MF_Input, TPZ;

const
    rtBufSize    = 255;
    rtInitString : String  = 'ATZ|~ATE1M1L3&C1&D2&F1S11=37|';
    rtUploadPath : String  = 'C:\';
    rtDownldPath : String  = 'C:\COMM\DOWN\';
    rtBaudRate   : Word    = 38400;
    rtComPort    : Byte    = 2;
    rtAutoZmodem : Boolean = True;

var P : Byte;
    Buf : array[1..rtBufSize] of Char;


(******************************************* FOSSIL Comm System ******)
procedure rtInitPort;
begin
   ActivatePort(P);
end;

procedure rtTerminatePort;
begin
   DTR(P,Lower);
   DeactivatePort(P);
end;

function rtSetPort(Bd : Word) : Boolean;
begin
   rtSetPort := SetBaud(P,38400,N81);
end;

function rtCarrier : Boolean;
begin
   rtCarrier := CarrierDetected(P);
end;

procedure rtWriteCh(C : Char);
begin
   ComWriteChar(P,C);
end;

procedure rtWrite(S : String);
begin
   ComWrite(P,S);
end;

procedure rtWriteLn(S : String);
begin
   ComWriteLn(P,S);
end;

function rtCharWaiting : Boolean;
begin
   rtCharWaiting := CharWaiting(P);
end;

function rtReadChar : Char;
begin
   rtReadChar := ComReadChar(P);
end;

procedure rtDTR(On : Boolean);
begin
   if On then DTR(P,Raise) else DTR(P,Lower);
end;
(*********************************************************************)

procedure rtClrScr;
var N : Byte;
begin
   N := TextAttr;
   TextColor(15);
   TextBackground(0);
   ClrScr;
   TextAttr := N;
end;

procedure rtInitModem;
var N : Byte;
begin
   for N := 1 to Length(rtInitString) do
   if rtInitString[N] = '|' then rtWriteCh(#13) else
   if rtInitString[N] = '~' then Delay(500) else
   if rtInitString[N] = '^' then begin rtDTR(False); Delay(100); rtDTR(True); end else
      rtWriteCh(rtInitString[N]);
end;

procedure rtShowBuf;
var N : Word;
begin
   for N := 1 to rtBufSize do Write(Buf[N]);
end;

function rtBufStr(S : String) : Boolean;
var N : Word; OK : Boolean;
begin
   OK := True;
   for N := 1 to Length(S) do if Buf[rtBufSize-Length(S)+N-1] <> S[N] then OK := False;
   rtBufStr := OK;
end;

function rtExists(S : String) : Boolean;
var F : file;
begin
   Assign(F,S);
   {$I-}
   Reset(F);
   {$I+}
   rtExists := (IOResult = 0) and (S <> '');
   Close(F);
end;

procedure rtUploadFile;
var Fs : String; X, Y, A : Byte;
begin
   X := WhereX; Y := WhereY;
   A := TextAttr;
   GotoXY(1,1);
   TextColor(15);
   TextBackground(4);
   ClrEol;
   Write(' Enter filename to Upload: ');
   TextColor(14);
   Fs := iReadLn(rtUploadPath,rUpper,45);
   if rtExists(Fs) then Zmodem_Send(Fs,True,rtComPort,rtBaudRate);
   TextColor(15);
   TextBackground(0);
   GotoXY(1,1);
   ClrEol;
   GotoXY(X,Y);
   TextAttr := A;
end;

procedure rtDownloadFile;
begin
   Zmodem_Receive(rtDownldPath,True,rtComPort,rtBaudRate);
end;

procedure rtCheckBuffer;
begin
   if rtBufStr(#27+'[6n') then rtWrite(#27+'[1h'+#27+'[1h') else
   if rtBufStr(#22#6) then rtWrite(#27+'[AVT'+#22#6) else
   if rtBufStr('rz'+#13+'**') then rtDownloadFile;
end;

procedure rtHangup;
begin
   rtDTR(False);
   Delay(600);
   rtDTR(True);
end;

procedure realTerminal;
var Ch : Char; Done : Boolean;
begin
   Done := False;
   repeat
      while (rtCharWaiting) and (not Keypressed) do
      begin
         Ch := rtReadChar;
         ANSiWrite(Ch);
         Move(Buf[2],Buf[1],rtBufSize-1);
         Buf[rtBufSize] := Ch;
         rtCheckBuffer;
      end;
      while Keypressed do
      begin
         Ch := ReadKey;
         if Ch <> #0 then rtWriteCh(Ch) else
         begin
            Ch := ReadKey;
            case Ch of
              #45 : Done := True;
              #23 : rtInitModem;
              #46 : rtClrScr;
              #35 : rtHangup;
              #32 : rtShowBuf;
              #73 : rtUploadFile;
              #81 : rtDownloadFile;
              else rtWrite(Ch);
            end;
         end;
      end;
   until Done;
end;

begin
   TextMode(co80);
   CheckSnow := False;
   FillChar(Buf,rtBufSize,#0);
   P := rtComPort-1;

   rtInitPort;
   rtSetPort(rtBaudRate);

   rtInitModem;
   realTerminal;

   rtTerminatePort;
   TextMode(Co80);
end.