unit Wait4Cal;

interface

procedure wfcOnline(Bd : LongInt);
procedure wfcWaitForCall;

implementation

uses Crt, Dos, Overlay,
     Global, Strings, Comm, Fossil, Output, Input, HardANSI, Misc, BBSInit,
     Config1, Config2, Config3, Config4, Config5, Config6, Files, MicroDOS,
     FsEditor, Message, Detect, Screen;

const MaxWFCItem = 4; MaxCmds = 8;

type ItemRec = array[1..MaxWFCItem,1..MaxCmds] of String[17];
     ConfRec = record
                 nAttr, fAttr, hAttr : Byte;
                 XPos, YPos : Byte;
               end;

const WFCCom : ItemRec =
      (('local logon',
        'exit iniquity',
        'jump to dos',
        'init modem',
        'hangup modem',
        'offhook modem',
        'answer modem',
        'terminal mode'),
       ('system config',
        'modem setup',
        'string editor',
        'menu editor',
        'enter microdos',
        'msgarea editor',
        'pack msgareas',
        'level editor'),
       ('---',
        '---',
        '---',
        '---',
        '---',
        '---',
        '---',
        '---'),
       ('system info',
        'drive info',
        '---',
        '---',
        '---',
        '---',
        '---',
        'iniquity info'));
      WFCConfig : ConfRec =
      (nAttr : 2; fAttr: $07; hAttr : $0F; xPos : 3; yPos : 7);

   maxSB       = 200;

   terX1       = 26;
   terY1       = 13;
   terX2       = 77;
   terY2       = 15;

   colItem : Byte = 2;
   colLo   : Byte = 5;
   colHi   : Byte = 4;

var Mnu, Pos, Res : Integer;
    SB : array[1..maxSB] of Char;
    Ch : Char;
    LocalMode, Saver : Boolean;
    Cnct, Try, Blank : LongInt;
    fIn : Boolean;
    tX,tY : Byte;

procedure wfcReadModem;
begin
   if ModemOff then Exit;
   if CharWaiting(Modem^.ComPort) then
   begin
      Move(SB[2],SB[1],maxSB-1);
      SB[maxSB] := ComReadChar(Modem^.ComPort);
      if not Saver then Write(SB[maxSB]);
   end;
end;

procedure wfcFadefxOut;
var N : Byte;
begin
   if not Cfg^.VgaEffects then Exit;
   for N := 21 downto 0 do begin Delay(12); mSetColor(colItem,N,N,N); end;
end;

procedure wfcFadefxIn;
var N : Byte;
begin
   if not Cfg^.VgaEffects then Exit;
   for N := 0 to 21 do begin Delay(12); mSetColor(colItem,N,N,N); end;
end;

procedure wfcFadefx;
begin
   if not Cfg^.VgaEffects then Exit;
   mSetColor(colItem,21,21,21);
   mSetColor(colLo,30,30,30+5);
   mSetColor(colHi,40,40,40+10);
end;

procedure wfcFadefxNormal;
begin
   if not Cfg^.VgaEffects then Exit;
   mSetColor(colItem,0,42,0);
   mSetColor(colLo,42,0,42);
   mSetColor(colHi,42,0,0);
end;

procedure wfcFadefxInit;
begin
   if not Cfg^.VgaEffects then Exit;
   mSetColor(colItem,0,0,0);
   mSetColor(colLo,0,0,0);
   mSetColor(colHi,0,0,0);
end;

procedure wfcFadeStatOut;
var N : Byte;
begin
   if not Cfg^.VgaEffects then Exit;
   for N := 40 downto 0 do
   begin
      Delay(12);
      if N <= 30 then mSetColor(colLo,N,N,N);
      mSetColor(colHi,N,N,N+5);
   end;
   fIn := False;
end;

procedure wfcFadeStatIn;
var N : Byte;
begin
   if not Cfg^.VgaEffects then Exit;
   for N := 0 to 40 do
   begin
      Delay(12);
      if N <= 30 then mSetColor(colLo,N,N,N+5);
      mSetColor(colHi,N,N,N+10);
   end;
   fIn := True;
end;

function wfcInSB(S : String) : Boolean;
var N, L : Byte; F : Boolean;
begin
   wfcInSB := False;
   if S = '' then Exit;
   F := True;
   L := Length(S);
   for N := 1 to Length(S) do
   begin
      if (SB[maxSB-L+N] = #13) or
         (SB[maxSB-L+N] = #10) or
         (SB[maxSB-L+N] = '/') then SB[maxSB-L+N] := '|';
      if UpCase(SB[maxSB-L+N]) <> UpCase(S[N]) then F := False;
   end;
   wfcInSB := F;
end;

function wfcResult(S : String) : Boolean;
var N : Word; OK : Boolean;
begin
   if ModemOff then Exit;
   Delay(300);
   N := 0;
   OK := False;
   repeat
      wfcReadModem;
      Inc(N,1);
      OK := wfcInSB(S);
   until (OK) or (N = 5000) or ((KeyPressed) and (ReadKey = #27));
   wfcResult := OK;
   while (not KeyPressed) and (CharWaiting(Modem^.ComPort)) do wfcReadModem;
   while Keypressed do ReadKey;
   tX := WhereX; tY := WhereY;
end;

procedure wfcInitModem;
begin
   cModemWrite(Modem^.sInit1);
   cModemWrite(Modem^.sInit2);
   cModemWrite(Modem^.sInit3);
   wfcResult(Modem^.rOk);
end;

procedure wfcDrawStats;
const sx = 27;
      sy = 2;
      ax = 19;
var S : String; B : Byte; W : Word;
begin
   Window(sx,sy,78,10);
   ClrScr;
   Window(terX1,terY1,terX2,terY2);
   GotoXY(tX,tY);
   TextAttr := $07;
   case curStat of
     1:
   begin
      fWrite(sx,sy+0,'CPU Processor',colLo);
      fWrite(sx,sy+1,'Video Card Type',colLo);
      fWrite(sx,sy+2,'Overlay Buffer',colLo);
      fWrite(sx,sy+3,'Free Diskspace',colLo);
      fWrite(sx,sy+4,'Availible Memory',colLo);
      fWrite(sx,sy+5,'Total Disk Size',colLo);
      fWrite(sx,sy+6,'Sound Card Type',colLo);
      fWrite(sx,sy+7,'Running Under',colLo);
      fWrite(sx,sy+8,'UART Comm Type',colLo);

      case cpuType of
         cpu8088    : S := '8088';
         cpu8086    : S := '8086';
         cpu80286   : S := '80286';
         cpu80386   : S := '80386';
         cpu80486   : S := '80486';
         cpuPentium : S := 'Pentium';
         cpuFuture  : S := 'Unknown';
      end;

      fWrite(sx+ax,sy+0,S,colHi);

      case vidType of
         vidNone     : S := 'None';
         vidMDA      : S := 'Monochrome';
         vidCGA      : S := 'CGA';
         vidEGA      : S := 'EGA';
         vidEGAmono  : S := 'EGA Mono';
         vidVGAmono  : S := 'VGA Mono';
         vidVGA      : S := 'VGA';
         vidMCGA     : S := 'MCGA';
         vidMCGAmono : S := 'MCGA Mono';
      end;

      fWrite(sx+ax,sy+1,S,colHi);

{$IFDEF iniOverlay}
      if OvrinEMS then S := 'EMS' else S := 'Disk';
      S := S+' ('+St(ovrGetBuf div 1024)+'kb)';
{$ELSE}
      S := 'None';
{$ENDIF}
      fWrite(sx+ax,sy+2,S,colHi);

      S := St(fFreeSpace div (1024*1000))+'mb';
      fWrite(sx+ax,sy+3,S,colHi);

      S := St(maxAvail div 1024)+'kb';
      fWrite(sx+ax,sy+4,S,colHi);

      S := St(DiskSize(0) div (1024*1000))+'mb';
      fWrite(sx+ax,sy+5,S,colHi);

      case sndType of
         sndNone            : S := 'None';
         sndAdlib           : S := 'AdLib';
         sndSoundBlaster    : S := 'Sound Blaster ('+strHex(sndPort,3)+'h)';
         sndSoundBlasterPro : S := 'Sound Blaster Pro ('+strHex(sndPort,3)+'h)';
         sndSoundBlaster16  : S := 'Sound Blaster 16 ('+strHex(sndPort,3)+'h)';
         sndUltraSound      : S := 'Gravis UltraSound ('+strHex(sndPort,3)+'h)';
      end;
      fWrite(sx+ax,sy+6,S,colHi);

      case oprType of
         oprDOS             : S := 'MS-DOS v'+oprVersion;
         oprWindows         : S := 'Windows v'+oprVersion;
         oprOS2             : S := 'OS/2 v'+oprVersion;
         oprDesqView        : S := 'DESQview';
         oprTopView         : S := 'TopView';
      end;
      fWrite(sx+ax,sy+7,S,colHi);

      S := '';
      for B := 1 to 4 do
      begin
         W := detUART(B);
         if W > 0 then
         begin
            if S <> '' then S := S +', ';
            S := S+'Com'+St(B)+': ';
            case W of
               1 : S := S+'8250';
              else S := S+'16550a';
            end;
         end;
      end;
      fWrite(sx+ax,sy+8,S,colHi);
   end;
     2:
   begin
      for W := (Ord('A') - Ord('A') + 1) to (Ord('Z') - Ord('A') + 1) do
      begin
         B := mGetDriveType(W);
         if (B <> drvError) and (W <= 6) then
         begin
            case B of
               drvRemovable : S := 'Floppy';
               drvFixed     : S := 'Hard Disk ('+St(DiskFree(W) div (1024*1024))+'mb/'+St(DiskSize(W) div (1024*1024))+'mb)';
               drvRemote    : S := 'Network (Remote)';
               drvCDROM     : S := 'CD-ROM System';
               drvDblSpace  : S := 'DoubleSpace ('+St(DiskFree(W) div (1024*1024))+'mb/'+St(DiskSize(W) div (1024*1024))+'mb)';
            end;
            fWrite(sx,sy+W,'Drive '+Chr(W + Ord('A') - 1)+':',colLo);
            fWrite(sx+12,sy+W,S,colHi);
         end;
      end;
   end;
     8:
     begin
        fWrite(sx,sy+0,'--',colLo);
        fWrite(sx,sy+1,'The '+bbsTitle+' Bulletin Board System',colHi);
        fWrite(sx,sy+2,'(c)Copyright 1994-1995, RealSoft',colLo);
        fWrite(sx,sy+3,'Written by Mike Fricker [Fiend]',colLo);
        fWrite(sx,sy+4,'Release: '+bbsRelease+' - Version '+bbsVersion,colLo);
        fWrite(sx,sy+5,'Preliminary Alpha Testing Version',colLo);
        fWrite(sx,sy+6,'--',colLo);
     end;
   end;
end;

procedure wfcAnswerModem;
var Z : Byte;
begin
   if ModemOff then Exit;
   cModemWrite(Modem^.sAnswer);
{  Window(TerX1,TerY1,TerX2,TerY2);
   GotoXY(tX,tY);}
   while CharWaiting(Modem^.ComPort) do wfcReadModem;
   Cnct := 0;
   Try := 0;
   cClearInBuffer;
   while (not CharWaiting(Modem^.ComPort)) and (Try < 60) and (not Keypressed) do
   begin
      Inc(Try,1);
      Delay(100);
   end;
   while (Cnct = 0) and (Try < 10000) and (not Keypressed) do
   begin
      wfcReadModem;
      if wfcInSB(Modem^.c300+'|') then Cnct := 300 else
      if wfcInSB(Modem^.c1200+'|') then Cnct := 1200 else
      if wfcInSB(Modem^.c1275+'|') then Cnct := 1275 else
      if wfcInSB(Modem^.c2400+'|') then Cnct := 2400 else
      if wfcInSB(Modem^.c4800+'|') then Cnct := 4800 else
      if wfcInSB(Modem^.c9600+'|') then Cnct := 9600 else
      if wfcInSB(Modem^.c12000+'|') then Cnct := 12000 else
      if wfcInSB(Modem^.c14400+'|') then Cnct := 14400 else
      if wfcInSB(Modem^.c16800+'|') then Cnct := 16800 else
      if wfcInSB(Modem^.c19200+'|') then Cnct := 19200 else
      if wfcInSB(Modem^.c21600+'|') then Cnct := 21600 else
      if wfcInSB(Modem^.c24000+'|') then Cnct := 24000 else
      if wfcInSB(Modem^.c26400+'|') then Cnct := 26400 else
      if wfcInSB(Modem^.c28800+'|') then Cnct := 28800 else
      if wfcInSB(Modem^.c38400+'|') then Cnct := 38400 else
      if wfcInSB(Modem^.c57600+'|') then Cnct := 57600 else
      if wfcInSB(Modem^.c64000+'|') then Cnct := 64000 else
      if wfcInSB(Modem^.c115200+'|') then Cnct := 115200;
      Inc(Try,1);
   end;
   cClearInBuffer;
   cClearOutBuffer;
   if (cNoCarrier) or (Try = 10000) then Cnct := 0;
   if Cnct = 0 then wfcInitModem else
   begin
      { Carrier Detected }
      BaudRate := Cnct;
      if not Modem^.LockedPort then cSetBaud(BaudRate);
      while CharWaiting(Modem^.ComPort) do wfcReadModem;
      Delay(2000);
   end;
   while KeyPressed do ReadKey;
   tX := WhereX; tY := WhereY;
end;

function wfcGetSel(var I : ItemRec; var Cf : ConfRec; Mnu : Integer) : Integer;
var N, CI : Integer; Cnt : LongInt; S : String; C : Char; W : Integer;
    wcDone : Boolean; LastRing : LongInt;

 procedure wfcClearSB;
 begin
    FillChar(SB,SizeOf(SB),#0);
 end;

 procedure wfcCheckRing;
 begin
    if ((LastRing > 0) and (Modem^.MultiRing) and (Round(mTimer)-LastRing <= 2))
       or (not Modem^.MultiRing) then wfcAnswerModem;
    LastRing := Round(mTimer);
 end;
 procedure wfcDrawSelBar;
 begin
    S := Resize(' f'+St(CI),4);
    fWrite(Cf.Xpos,Cf.Ypos+CI,S,Cf.fAttr);
    S := Resize(I[Mnu,CI],15);
    fWrite(Cf.Xpos+4,Cf.Ypos+CI,S,Cf.hAttr);
 end;
 procedure wfcDrawNorBar;
 begin
    S := ' f'+St(CI);
    S := Resize(S,4);
    S := S + I[Mnu,CI];
    S := Resize(S,16+3);
    fWrite(Cf.Xpos,Cf.Ypos+CI,S,Cf.nAttr);
 end;

 procedure wfcKillSaver;
 var Z : Word;
 begin
    if not Saver then Exit;
    Saver := False;
    TextMode(Co80);
    TextAttr := $07;
    mClearScr(True);
    Blank := Round(mTimer);
    wfcFadefx;
    scrRestoreScreen(2);
    Window(terX1,terY1,terX2,terY2);
    tX := 1;
    tY := 1;
    GotoXY(tX,tY);
    mCursor(True);
    fIn := True;
 end;

 procedure wfcBlankSaver;
 begin
    repeat
       wfcReadModem;
    until (Keypressed) or (wfcInSB(Modem^.rRing+'|'));
 end;

 procedure wfcCopperSaver;
 var Pal     : array[0..2000-1] of Byte;
     sTab    : array[0..255] of Word;
     barTab  : array[0..10-1] of Word;
     Size    : Word;
     Step    : Word;
     Bars    : Word;
     a,b,c,d : Word;
 begin
    ansiHead;
    Size := 300+Random(100);
    Bars := 1+Random(4);
    Step := 5+Random(30);
    FillChar(Pal,SizeOf(Pal),0);
    for a := 0 to Bars-1 do barTab[a] := Step*a;
    for a := 0 to 255 do sTab[a] := Round(Sin(2*Pi*a/255)*86)+86;
    repeat
       FillChar(Pal,3*Size,0);
       for a := 0 to Bars-1 do
       begin
          for b:=0 to 63 do Pal[a mod 3+3*sTab[barTab[a]]+3*b] := b;
          for b:=0 to 63 do Pal[a mod 3+3*sTab[barTab[a]]+3*64+3*b] := 63-b;
          barTab[a] := 1+barTab[a] mod 255;
       end;

       asm cli end;
       while (Port[$3da] and 8) <> 0 do;
       while (Port[$3da] and 8) = 0 do;
       c := 0;
       for d := 0 to Size-1 do
       begin
          Port[$3c8] := 0;
          Port[$3c9] := Pal[c];
          Port[$3c9] := Pal[c+1];
          while (Port[$3da] and 1) <> 0 do;
          while (Port[$3da] and 1) = 0 do;
          Port[$3c9] := Pal[c+2];
          Inc(c,3);
       end;
       asm sti end;
       wfcReadModem;
    until (Keypressed) or (wfcInSB(Modem^.rRing+'|'));
 end;

begin
   wfcClearSB;
   Cf.nAttr := colItem;
   Cnt := 0;
   fWrite(1,6,'',$08);
   fWrite(1+Mnu-1,6,'',$07);
   for CI := 1 to MaxCmds do if CI = Pos then wfcDrawSelBar else wfcDrawNorBar;
   wfcFadefxIn;
   CI := Pos;
   Blank := Round(mTimer);
   wcDone := False;
   LastRing := 0;
   if not fIn then
   begin
      wfcDrawStats;
      wfcFadeStatIn;
   end;
   repeat
{     if Random(64000) = Random(400) then wcInitModem;}
      if (not Saver) and (Cfg^.ScreenSaver > 0) and (Round(mTimer)-Blank >= Cfg^.BlankSeconds) then
      begin
         Saver := True;
         scrStoreScreen(2);
         TextAttr := $07;
         mCursor(False);
         oClrScr;
         case Cfg^.ScreenSaver of
            1 : wfcBlankSaver;
            2 : wfcCopperSaver;
         end;
         wfcKillSaver;
         while Keypressed do ReadKey;
      end;
      if Keypressed then
      begin
         Ch := Readkey;
         Blank := Round(mTimer);
      end else Ch := #1;
      if Ch = #0 then
      begin
         Ch := ReadKey;
         case Ch of
           #72 : begin wfcDrawNorBar; Dec(CI,1); if CI < 1 then CI := MaxCmds; Pos := CI; wfcDrawSelBar; end;
           #80 : begin wfcDrawNorBar; Inc(CI,1); if CI > MaxCmds then CI := 1; Pos := CI; wfcDrawSelBar; end;
           #59 : begin wfcDrawNorBar; CI :=  1; Pos := CI; wfcDrawSelBar; wcDone := True; end;
           #60 : begin wfcDrawNorBar; CI :=  2; Pos := CI; wfcDrawSelBar; wcDone := True; end;
           #61 : begin wfcDrawNorBar; CI :=  3; Pos := CI; wfcDrawSelBar; wcDone := True; end;
           #62 : begin wfcDrawNorBar; CI :=  4; Pos := CI; wfcDrawSelBar; wcDone := True; end;
           #63 : begin wfcDrawNorBar; CI :=  5; Pos := CI; wfcDrawSelBar; wcDone := True; end;
           #64 : begin wfcDrawNorBar; CI :=  6; Pos := CI; wfcDrawSelBar; wcDone := True; end;
           #65 : begin wfcDrawNorBar; CI :=  7; Pos := CI; wfcDrawSelBar; wcDone := True; end;
           #66 : begin wfcDrawNorBar; CI :=  8; Pos := CI; wfcDrawSelBar; wcDone := True; end;
           #67 : begin wfcDrawNorBar; CI :=  9; Pos := CI; wfcDrawSelBar; wcDone := True; end;
           #68 : begin wfcDrawNorBar; CI := 10; Pos := CI; wfcDrawSelBar; wcDone := True; end;
           #75 : if Mnu > 1 then begin CI := 11; wcDone := True; end;
           #77 : if Mnu < 4 then begin CI := 12; wcDone := True; end;
         end;
      end else
      case Ch of
         #13 : wcDone := True;
         #27 : if Cfg^.ESCtoExit then
               begin
                  mClearScr(True);
                  wfcFadefxNormal;
                  killTerminateBBS;
               end;
      end;
      wfcReadModem;
      if wfcInSB(Modem^.rRing+'|') then wfcCheckRing;
   until ((ModemIO) and (not cNoCarrier)) or (wcDone);
   if (not cNoCarrier) and (ModemIO) then CI := 0 else wfcFadefxOut;
   wfcGetSel := CI;
end;

procedure wfcHangUpModem;
begin
   cModemWrite(Modem^.sHangUp);
   wfcResult(Modem^.rOK);
end;

procedure wfcOffHookModem;
begin
   cModemWrite(Modem^.sOffHook);
   wfcResult(Modem^.rOK);
end;

procedure wfcTerminalMode;
var terDone : Boolean; C : Char;
begin
   terDone := False;
   repeat
      wfcReadModem;
      if Keypressed then
      begin
         C := ReadKey;
         if C = #27 then terDone := True else ComWriteChar(Modem^.ComPort,C);
      end;
   until terDone;
end;

procedure wfcWaitForCall;
begin
   if UserOn then Exit;
   LocalIO := False;
   LocalMode := False;
   RemoteOut := True;
   RemoteIn := True;
   LoggedIn := False;
   HangUp := False;
   HungUp := False;
   ModemIO := not ModemOff;
   mClearScr(True);
   Pos := 1;
   Mnu := 1;
   Res := 12;
   Saver := False;
   tX := 1; tY := 1;
   wfcFadefxInit;
   ansiWFCscreen;
   Window(terX1,terY1,terX2,terY2);
   TextAttr := $07;
   fIn := False;
   wfcInitModem;
   repeat
       HangUp := False;
       ModemIO := not ModemOff;
       if Cfg^.VgaEffects then
       begin
          colItem := 2;
          colLo   := 5;
          colHi   := 4;
       end else
       begin
          colItem := 8;
          colLo   := 3;
          colHi   := 11;
       end;
       if ((Mnu = 1) and (Res in [3])) or
          ((Mnu = 2) and (Res in [1..8])) then
       begin
          wfcFadefxInit;
          mClearScr(True);
          ansiWFCscreen;
          Window(terX1,terY1,terX2,terY2);
          tX := 1;
          tY := 1;
          GotoXY(tX,tY);
          TextAttr := $07;
          fIn := False;
       end;
       Res := wfcGetSel(WFCCom, WFCConfig, Mnu);
       if not (Res in [11,12]) then resetUser;
       if ((Mnu = 1) and (Res in [3])) or
          ((Mnu = 2) and (Res in [1..8])) then LocalIO := True;
       if Mnu = 1 then case Res of
         1  : LocalMode := True;
         2  : begin mClearScr(True); wfcFadefxNormal; killTerminateBBS; end;
         3  : begin mClearScr(True); wfcFadefxNormal; fJumpToDOS(False); end;
         4  : wfcInitModem;
         5  : wfcHangupModem;
         6  : wfcOffHookModem;
         7  : wfcAnswerModem;
         8  : wfcTerminalMode;
         12 : Mnu := 2;
       end else if Mnu = 2 then
       case Res of
         1  : begin mClearScr(True); wfcFadefxNormal; cfgSystemConfig; end;
         2  : begin mClearScr(True); wfcFadefxNormal; cfgCommunicationsSetup; end;
         3  : begin mClearScr(True); wfcFadefxNormal; cfgStringEditor; end;
         4  : begin mClearScr(True); wfcFadefxNormal; cfgMenuEditor; end;
         5  : begin mClearScr(True); wfcFadefxNormal; dosExecuteMicroDOS; end;
         6  : begin mClearScr(True); wfcFadefxNormal; cfgMsgAreaEditor; end;
         7  : begin
                 wfcFadefxNormal;
                 oClrScr;
                 msgPackAreas(True,0);
                 oPromptKey;
              end;
         8  : begin mClearScr(True); wfcFadefxNormal; cfgLevelEditor; end;
         11 : Mnu := 1;
         12 : Mnu := 3;
       end else if Mnu = 3 then
       case Res of
         11 : Mnu := 2;
         12 : Mnu := 4;
       end else if Mnu = 4 then
       case Res of
          1..2,8 : begin wfcFadeStatOut; curStat := Res; wfcDrawStats; wfcFadeStatIn; end;
         11 : Mnu := 3;
       end;
       LocalIO := False;
   until (ModemIO) and (not cNoCarrier) or (LocalMode);
   if (LocalMode) and (Cfg^.OffhookLocal) then wfcOffhookModem;
   LocalIO := LocalMode;
   ModemIO := (not ModemOff) and (not LocalMode);
   UserOn := True;
   mClearScr(True);
   mClearScr(False);
   wfcFadefxNormal;
end;

procedure wfcOnline(Bd : LongInt);
begin
   RemoteOut := True;
   RemoteIn := True;
   LoggedIn := False;
   HangUp := False;
   HungUp := False;
   LocalIO := False;
   ModemIO := not ModemOff;
   mClearScr(True);
   mClearScr(False);
   Cnct := Bd;
   BaudRate := Cnct;
   if not Modem^.LockedPort then cSetBaud(BaudRate);
   cClearInBuffer;
   cClearOutBuffer;
   UserOn := True;
end;

end.