unit bbsInit;

interface

procedure killTerminateBBS;
procedure killVariables;
procedure initCommPort;
procedure initFiles;
procedure initParameters;
procedure initPaths;
procedure initVariables;
procedure resetCfg;
procedure resetEmailArea;
procedure resetMessage;
procedure resetModem;
procedure resetMsgArea;
procedure resetProtocols;
procedure resetStrings;
procedure resetUser;
procedure resetVariables;

implementation

uses Crt, Global, Strings, Files, Comm, Misc, Swap, Screen, Message, Detect,
     Config1, Config2, Config3, Config4;

procedure resetVariables;
begin
   DetANSi := False;
   DetAVATAR := False;
   DetRIP := False;
   Hangup := False;
   Hungup := False;
{  LocalOut := True;}
   LocalIO := False;
   LocKey := True;
   LoggedIn := False;
   RemoteIn := True;
   RemoteOut := False;

   extKey := #0;

   FillChar(MenuStack,SizeOf(MenuStack),#0);
   LastMenu := Cfg^.StartMenu;
   CurMenu := Cfg^.StartMenu;
   MenuPtr := 0;

   posX := 1;
   posY := 1;
end;

procedure resetCfg;
var I : Word;
begin
   FillChar(Cfg^,SizeOf(tCfgRec),0);
   with Cfg^ do
   begin

      bbsName         := 'iNiQUiTY BBS';
      bbsPhone        := '(000)000-0000';
      SysOpAlias      := 'SysOp';
      SysOpName       := 'System Operator';
      SystemPW        := 'SYSTEM';
      NewUserPW       := '';
      NoBaudPW        := '';
      NoChatPW        := '';

      pathData        := StartDir+'\DATA\';
      pathText        := StartDir+'\TEXT\';
      pathMenu        := StartDir+'\MENU\';
      pathMsgs        := StartDir+'\MSGS\';
      pathSwap        := StartDir+'\SWAP\';
      pathDoor        := StartDir+'\DOOR\';
      pathProt        := StartDir+'\PROT\';
      pathTemp        := StartDir+'\TEMP\';
      StartMenu       := 'STARTUP';

      SnowChecking    := False;
      DirectWrites    := True;
      OverlayToEMS    := True;
      SwapInShell     := True;
      SwapToEMS       := True;
      ESCtoExit       := True;
      AskApply        := True;
      RemovePause     := True;
      OffhookLocal    := True;
      AbortMandOk     := False;
      VgaEffects      := True;
      StatOnDefault   := False;
      SysOpAutoLogin  := False;

      for I := 0 to maxColor do
      begin
         DefaultCol[I].Fore := 7;
         DefaultCol[I].Back := 0;
         DefaultCol[I].Blink := False;
      end;

      DefaultCol[colError].Fore  := 12;

      DefaultCol[colText].Fore   := 5;
      DefaultCol[colTextLo].Fore := 8;
      DefaultCol[colTextHi].Fore := 13;

      DefaultCol[colInfo].Fore   := 9;
      DefaultCol[colInfoLo].Fore := 1;
      DefaultCol[colInfoHi].Fore := 15;

      DefaultCol[colItem].Fore := 3;
      DefaultCol[colItemSel].Fore := 11;
      DefaultCol[colItemSel].Back := 3;

      DefaultCol[colBorder].Fore := 8;

      DefaultCol[colEdit].Fore := 10;
      DefaultCol[colEdit].Back := 2;

      CallsBirth := 10;
      CallsPhone := 5;
      LoginTrys := 5;
      DefaultPageLen := 24;
      BlankSeconds := 300;

      acsSysOp            := 's255';
      acsCoSysOp          := 's250';
      acsSystemPWLogin    := 's250';
      acsPostEmail        := 's50';
      acsAnonymous        := 's50';
      acsAnonAutoMsg      := 's50';

      PwEchoChar := '';
      ScreenSaver := 2;

      Origin[1] := bbsTitle+' -- '+bbsPhone;

      StatBarOn := True;
      StatType  := sbBot;
      StatBar   := 1;
      StatLo    := $4C;
      StatTxt   := $4F;
      StatHi    := $4E;
   end;
end;

procedure resetMsgArea;
begin
   FillChar(mArea^,SizeOf(tMsgAreaRec),0);
   with mArea^ do
   begin
      Name          := 'New '+bbsTitle+' Message Area';
      Filename      := 'NEWAREA';
      MsgPath       := '';
      Sponsor       := Cfg^.SysOpAlias;
      Acs           := 's25';
      PostAcs       := 's50';
      MaxMsgs       := 200;
      Msgs          := 0;
      Password      := '';
      AreaType      := mareaNormal;
      Origin        := 1;
      Address       := 1;
      Flag          := [mbPrivate,mbAnonymous];
   end;
end;

procedure resetModem;
begin
   FillChar(Modem^,SizeOf(tModemRec),0);
   with Modem^ do
   begin
      ComPort       := 4; { Local }
      BaudRate      := 38400;
      Parity        := 'N';
      StopBits      := 1;
      DataBits      := 8;
      LockedPort    := True;
      MultiRing     := False;
      irqNumber     := 3;
      irqString     := '02F8';

      sInit1        := 'ATH0E1&C1&D2&A3S0=0|';
      sInit2        := '';
      sInit3        := '';
      sExitStr      := '';
      sAnswer       := 'ATA|';
      sHangup       := 'ATH0|';
      sOffhook      := 'ATH1|';

      rError        := 'ERROR';
      rNoCarrier    := 'NO CARRIER';
      rOK           := 'OK';
      rRing         := 'RING';

      c300          := 'CONNECT';
      c1200         := 'CONNECT 1200';
      c1275         := 'CONNECT 1275';
      c2400         := 'CONNECT 2400';
      c4800         := 'CONNECT 4800';
      c7200         := 'CONNECT 7200';
      c9600         := 'CONNECT 9600';
      c12000        := 'CONNECT 12000';
      c14400        := 'CONNECT 14400';
      c16800        := 'CONNECT 16800';
      c19200        := 'CONNECT 19200';
      c21600        := 'CONNECT 21600';
      c24000        := 'CONNECT 24000';
      c26400        := 'CONNECT 26400';
      c28800        := 'CONNECT 28800';
      c38400        := 'CONNECT 38400';
      c57600        := 'CONNECT 57600';
      c64000        := 'CONNECT 64000';
      c115200       := 'CONNECT 115200';
   end;
end;

procedure resetUser;
var N : Word;
begin
   User^.Number := 1;
   if not fLoadUser(User^) then
   with User^ do
   begin
      Number       := 1;
      UserName     := 'SysOp';
      RealName     := 'System Operator';
      Password     := 'SYSOP';
      BaudRate     := 0;
      TotalCalls   := 1;
      curMsgArea   := 1;
      PhoneNum     := '(000)000-0000';
      BirthDate    := '01/01/80';
      Location     := '';
      Address      := '';
      UserNote     := 'SysOp';
      SL           := 255;
      DSL          := 255;
      Sex          := 'M';
      acFlag       := [acANSi,acYesNoBar,acHotKey];
      Color        := Cfg^.DefaultCol;
      LastCall     := 0;
      EmailWaiting := 0;
   end;
end;

procedure resetEmailArea;
begin
   with mArea^ do
   begin
      Name := 'Private Mail';
      Filename := 'EMAIL';
      MsgPath := '';
      Sponsor := Cfg^.SysOpName;
      Acs := '';
      PostAcs := '';
      MaxMsgs := 64000;
      Msgs := 0;
      Password := '';
      Flag := [];
      AreaType := mareaEmail;
      Origin := 1;
      Address := 1;
   end;
end;

procedure resetStrings;
var N : Word; S : String;
begin
   FillChar(Strs^,SizeOf(Strs^),#0);
   for N := 1 to maxStrings do
   begin
     S := '';
     case N of
       strDetectEmu         : S := '-- Detecting Emulation --';
       strDetectNone        : S := '-- No Terminal Emulation Detected ---';
       strDetectANSi        : S := '|12|04-|08- |04<|12A|04N|08Si> |12D|04e|08tected |12-|04-|08-';
       strDetectAVATAR      : S := '|12|04-|08- |04<|12A|04V|08ATAR/|12A|04N|08Si> |12D|04e|08tected |12-|04-|08-';
       strDetectRIP         : S := '|12|04-|08- |04<|12R|04I|08P/|12A|04N|08Si> |12D|04e|08tected |12-|04-|08-';
       strConnectedAt       : S := '|12|04-|08- |12C|04o|08nnected |12A|04t |12%S1 B|04a|08ud |12-|04-|08-';
       strLoginSystemPW     : S := '|15|07-|08- |15E|07n|08ter |15S|07y|08stem |15P|07a|08ssword: ';
       strAskSystemPW       : S := '|15|07-|08- |15S|07y|08stem |15P|07a|08ssword: ';
       strPause             : S := '|10|02-|08- |10P|02a|08used |10-|02-|08';
       strHitAKey           : S := '|02=|10P|02r|08ess |10A|02n|08y |10K|02e|08y |10T|02o |10C|02o|08ntinue=';
       strMenuPassword      : S := 'Enter Menu Access Password: ';
       strMenuAccessDenied  : S := 'Access to Menu Denied';
       strCmdAccessDenied   : S := 'Command Access Denied';
       strInvalidCommand    : S := 'Invalid Command!';
       strInvalidMnuCmd     : S := 'Invalid Menu Command: "%S1"';
       strLoginName         : S := '|15|07-|08- |15L|07o|08gin: |07';
       strLoginPassword     : S := '|15|07-|08- |15P|07a|08ssword: |07';
       strLoginPhone        : S := '|15L|07a|08st |154 P|07h|08one |15# D|07i|08gits |07[|15x|07x|08x]xxx-';
       strLoginBDate        : S := '|15E|07n|08ter |15Y|07o|08ur |15B|07i|08rthdate |07[|15m|07m|08/dd/yy] ';
       strLoginUnknown      : S := '|12|04-|08- |12U|04s|08er |12N|04o|08t |12F|04o|08und |12-|04-|08-';
       strLoginError        : S := '|12|04-|08- |12I|04n|08valid |12L|04o|08gin |12-|04-|08-';
       strLoginAskApply     : S := '|10D|02o |10Y|02o|08u |10W|02i|08sh |10T|02o |10A|02p|08ply? ';
       strNuHandle          : S := '|09E|01n|08ter |09Y|01o|08ur |09A|01l|08ias: ';
       strNuName            : S := '|09E|01n|08ter |09Y|01o|08ur |09R|01e|08al |09N|01a|08me: ';
       strNuBirthDate       : S := '|09E|01n|08ter |09Y|01o|08ur |09B|01i|08rthdate =|01[|09m|01m|08/dd/yy]= ';
       strNuPhoneNum        : S := '|09E|01n|08ter |09Y|01o|08ur |09V|01o|08ice |09P|01h|08one |09N|01u|08mber: ';
       strNuAddress         : S := '|09E|01n|08ter |09Y|01o|08ur |09S|01t|08reet |09A|01d|08dress: ';
       strNuLocation        : S := '|09E|01n|08ter |09Y|01o|08ur |09C|01i|08ty, |09S|01t|08ate/|09P|01r|08ovince: ';
       strNuYesNoBar        : S := '|09U|01se |09Y|01e|08s/|09N|01o |09B|01a|08rs? ';
       strNuHotKey          : S := '|09U|01s|08e |09H|01o|08t|09K|01e|08ys |09F|01o|08r |09I|01n|08put? ';
       strNuExpertMode      : S := '|09U|01s|08e |01"|09E|01x|08pert" |09M|01o|08de? ';
       strNuPassword        : S := '|09E|01n|08ter |09A P|01a|08ssword |09T|01o |09U|01s|08e: ';
       strNuBadAlias        : S := '|12|04-|08- |12I|04n|08valid |12U|04s|08ername.';
       strNuDupUser         : S := '|12T|04h|08at |12A|04l|08ias |12I|04s |12A|04l|08ready |12U|04s|08ed.';
       strNuBadName         : S := '|12|04-|08- |12I|04n|08valid |12U|04s|08ername.';
       strNuFullName        : S := '|09Y|01o|08u |09M|01u|08st |09E|01n|08ter |09Y|01o|08ur |09F|01i|08rst |09A|0'+
                                   '1n|08d |09L|01a|08st |09N|01a|08me.';
       strNuBadBirth        : S := '|12|04-|08- |12I|04n|08valid |12B|04i|08rthdate.';
       strNuSmallPassword   : S := '|12|04-|08- |12Y|04o|08ur |12P|04a|08ssword |12M|04u|08st |12B|04e |12A|04t '+
                                   '|12L|04e|08ast |124 C|04h|08aracters |12L|04o|08ng';
       strNuValidatePW      : S := '       |09V|01e|08rification |09P|01a|08ssword: ';
       strNuPWnoMatch       : S := '|12Y|04o|08ur |12P|04a|08sswords |12D|04o |12N|04o|08t |12M|04a|08tch.';
       strNuSavingInfo      : S := '|12|04-|08- |12S|04a|08ving |12Y|04o|08ur |12I|04n|08formation.|04.|12.';
       strNuYourAgeIs       : S := '|12|04-|08- |12Y|04o|08u |12A|04r|08e |12%S1 Y|04e|08ars |12O|04l|08d.';
       strNuAskSex          : S := '|09Y|01o|08ur |09S|01e|08x? |01[|09m|01/|08f] ';
       strNuEnterNewUserPW  : S := '|09E|01n|08ter |09N|01U|08P: ';
       strNuBadNewUserPW    : S := '|12|04-|08- |12N|04U|08P |12I|04n|08correct.';
       strChatInitiate      : S := '|LF|12|04-|08- |12C|04h|08at |12M|04o|08de |12I|04n|08itiated |12-|04-|08-|L'+
                                   'F';
       strChatTerminate     : S := '|LF|12|04-|08- |12C|04ha|08t |12M|04o|08de |12T|04e|08rminated |12-|04-|08-|'+
                                   'LF';
       strJumpToDOS         : S := '|LF|15|07-|08- |12S|04y|08sOp |12I|04n |12D|04O|08S |15-|07-|08-';
       strBackFromDOS       : S := '|LF|15|07-|08- |12S|04y|08sOp |12I|04s |12B|04l|08ack |15-|07-|08-';
       strFsAskAbort        : S := '|10|02-|08- |10A|02b|08ort |10M|02e|08ssage? ';
       strFsAskCommand      : S := '|15|07-|08- |15C|07o|08mmand |07[|15?|07|15H|07e|08lp] ';
       strFsCommandHelp     : S := '|15|07-|08- |15E|07d|08itor |15C|07o|08mmand? |07[|15?|07|15H|07e|08lp] ';
       strFsSavingMsg       : S := '|15|07-|08- |15S|07a|08ving |15M|07e|08ssage.|07.|15.';
       strMsgNoPostAcs      : S := '|12Y|04o|08u |12D|04o |12N|04o|08t |12H|04a|08ve |12A|04c|08cess To This Area'+
                                   '.';
       strMsgAskWhoTo       : S := '|CS|11T|03o|08                 : |07';
       strMsgAskPrivate     : S := '|11P|03r|08ivate |11M|03e|08ssage? ';
       strMsgAskTitle       : S := '|11E|03n|08ter |11M|03e|08ssage |11T|03i|08tle: |07';
       strMsgReadNoMsgs     : S := '|12|04-|08- |12M|04e|08ssage |12B|04a|08se |12I|04s |12E|04m|08pty';
       strMsgReadStartAt    : S := '|12|04-|08- |12S|04t|08art |12R|04e|08ading |12A|04t |08|04[|121|04-|08%S1] ';
       strMsgReadPrompt     : S := '|15|07-|08- |15R|07e|08ading |15M|07e|08ssage |07[|15%S1|07/|08%S2] - |15C|0'+
                                   '2o|08mmand |07[|15?|08=|07Help|08, |15CR|08=|07Next|08]: ';
       strMsgReadAskPost    : S := '|10|02-|08- |10P|02o|08st |10I|02n |10T|02h|08is |10A|02r|08ea? ';
       strMsgAlterTitle     : S := '|15|07-|08- |15E|07n|08ter |15N|07e|08w |15M|07e|08ssage |15T|07i|08tle.';
       strMsgQuoteFirst     : S := '|10|02-|08- |10E|02n|08ter |10F|02i|08rst |10L|02i|08ne |10O|02f |10M|02e|08'+
                                   'ssage |10T|02o |10Q|02u|08ote |02[|101|02-|08%S1]: ';
       strMsgQuoteSecond    : S := '|10|02-|08- |10E|02n|08ter |10S|02e|08cond |10L|02i|08ne |10O|02f |10M|02e|0'+
                                   '8ssage |10T|02o |10Q|02u|08ote |02[|10%S1|02-|08%S2]: ';
       strMsgDeleted        : S := '|12|04-|08- |12M|04e|08ssage |12D|04e|08leted |12-|04-|08-';
       strMsgUndeleted      : S := '|12|04-|08- |12M|04e|08ssage |12U|04n|08deleted |12-|04-|08-';
       strMsgNewScanInit    : S := '|CS|LF|15|07-|08- |11G|03l|08obal |11N|03e|08wScan |11I|03n|08itiated.|LF';
       strMsgNewScanDone    : S := '|15|07-|08- |11G|03l|08obal |11N|03e|08wScan |11C|03o|08mpleted.|LF';
       strMsgNewScanStart   : S := '|12|04-|08- |12A|04r|08ea |12%S1 |08- |04[|12%S2 M|04s|08gs] - |12S|04c|08an'+
                                   'ning...|12-|04-|08-';
       strMsgNewScanEnd     : S := '|12|04-|08- |12A|04r|08ea |12%S1 |08- |04[|12%S2 M|04s|08gs] - |12C|04o|08mp'+
                                   'lete...|12-|04-|08-|LF';
       strMsgNewScanAskAll  : S := '|15|07-|08- |13N|05e|08wScan |13A|05l|08l |13M|05e|08ssage |13A|05r|08eas? ';
       strMsgPackStart      : S := '|12|04-|08- |12P|04a|08cking |12A|04r|08ea: |12%S1 |04[|12%S2 |04Msgs|08]..|'+
                                   'LF';
       strMsgPackEnd        : S := '|12|04-|08- |12C|04o|08mplete |12-|04-|08-';
       strMsgPackAskAll     : S := '|10|02-|08- |10P|02a|08ck |10A|02l|08l |10M|02e|08ssage |10A|02r|08eas? ';
       strAnonymous         : S := '|12|04-|08- |12A|04n|08onymous |12-|04-|08-';
       strNoAutoMsg         : S := '|12|04-|08- |12T|04h|08e |12A|04u|08tomessage |12I|04s |12E|04m|08pty |12-|'+
                                   '04-|08-';
       strMsgAskAnonymous   : S := '|11|03-|08- |11P|03o|08st |11A|03n|08onymously? ';
       strBBSaskName        : S := '|15B|07B|08S |15N|07a|08me         : ';
       strBBSexists         : S := '|12|04-|08- |12T|04h|08at |12B|04B|08S |12I|04s |12A|04l|08ready |12I|04n |'+
                                   '12T|04h|08ere.';
       strBBSaskPhone       : S := '|15P|07h|08one |15N|07u|08mber     : ';
       strBBSaskSysOp       : S := '|15S|07y|08sOp''s |15A|07l|08ias    : ';
       strBBSaskBaud        : S := '|15M|07a|08ximum |15B|07a|08udrate : ';
       strBBSaskSoftware    : S := '|15B|07B|08S |15S|07o|08ftware     : ';
       strBBSaskStorage     : S := '|15M|07a|08x |15S|07t|08orage |07(|15m|07b|08) : ';
       strBBSaskInfo        : S := '|15O|07t|08her |15I|07n|08fo       : ';
       strBBSsavingEntry    : S := '|12|04-|08- |12S|04a|08ving |12E|04n|08try |12-|04-|08-';
       strBBSaskSaveBBS     : S := '|10|02-|08- |10S|02a|08ve |10E|02n|08try? ';
       strEchoImportingArea : S := '|12|04-|08- |12A|04r|08ea - |04[|12%S1|08] - |12I|04m|08porting |12E|04c|08'+
                                   'ho|12M|04a|08il...';
       strMsgReadMandatory  : S := '|LF|12|04-|08- |12Y|04o|08u |12M|04u|08st |12R|04e|08ad |12A|04l|08l |12O|0'+
                                   '4f |12T|04h|08e |12M|04e|08ssages |12I|04n |12T|04h|08is |12B|04a|08se |12-|'+
                                   '04-|08-';
       strBBSnoSystems      : S := '|12|04-|08- |12T|04h|08ere |12A|04r|08e |12N|04o |12E|04n|08tries |12-|04-|'+
                                   '08-';
       strBBSshowOne        : S := '|10|02-|08- |10D|02i|08splay |10W|02h|08ich |10B|02B|08S? |02[|101|02-|08%S'+
                                   '1]: ';
       strNuAskPageLen      : S := '|09|01-|08- |09S|01c|08reen |09L|01e|08ngth |09I|01n |09R|01o|08ws |01(|09D'+
                                   '|01e|08fault=24): ';
       strBBSdeleteOne      : S := '|10|02-|08- |10D|02e|08lete |10W|02h|08ich |10E|02n|08try? |02[|101|08-%S1]: ';
       strBBSverifyKill     : S := '|10|02-|08- |10D|02e|08lete |10T|02h|08is |10E|02n|08try? ';
       strBBSclearAll       : S := '|10|02-|08- |10D|02e|08lete |10E|02n|08tire |10L|02i|08st? ';
       strEmailUserUnknown  : S := '|12|04-|08- |12U|04s|08er |12N|04o|08t |12F|04o|08und |12-|04-|08-';
       strEmailNoMail       : S := '|12|04-|08- |12Y|04o|08u |12H|04a|08ve |12N|04o |12M|04a|08il |12W|04a|08it'+
                                   'ing |12-|04-|08-';
       strEmailSelectToRead : S := '|15|07-|08- |15B|07e|08gin |15R|07e|08ading |15A|07t |15W|07h|08ich |15M|07'+
                                   'e|08ssage |07[|151|07-|08%S1]: ';
       strEmailReadPrompt   : S := '|08= |15Rea|07di|08ng |15Em|07ai|08l |15%S1 |08of |07%S2 |08 |11Com|03ma|08'+
                                   'nd [|'+
                                   '15?|08/|07Help|08|15CR|08/|07Next|08]: |07';
       strEmailNoAccess     : S := '|15E|07mai|08l |15A|07cces|08s |15D|07enie|08d.';
     end;
     Strs^[N] := S;
   end;
end;

procedure resetMessage;
begin
   with Msg^ do
   begin
      with FromInfo do
      begin
         UserNum := 1;
         Alias := 'Unknown';
         RealName := 'None';
         Name := 'None';
         UserNote := 'None';
      end;
      with ToInfo do
      begin
         UserNum := 1;
         Alias := 'Unknown';
         RealName := 'None';
         Name := 'None';
         UserNote := 'None';
      end;
      Pos := 1;
      Size := 0;
      Date := mDateTimePacked;
      Status := [];
      Replies := 0;
      Subject := 'Untitled';
   end;
end;

procedure initVariables;
var Z : String;
begin
{$IFNDEF iniOverlay}
   New(Cfg);
   FillChar(Cfg^,SizeOf(Cfg^),0);
{$ENDIF}
   New(User);
   New(Modem);
   New(Strs);
   New(Menu);
   New(Cmd);
   New(mArea);
   New(Msg);
   New(Scan);

   FillChar(User^,SizeOf(User^),0);
   FillChar(Modem^,SizeOf(Modem^),0);
   FillChar(Strs^,SizeOf(Strs^),0);
   FillChar(Menu^,SizeOf(Menu^),0);
   FillChar(Cmd^,SizeOf(Cmd^),0);
   FillChar(mArea^,SizeOf(mArea^),0);
   FillChar(Msg^,SizeOf(Msg^),0);
   FillChar(Scan^,SizeOf(Scan^),0);

   GetDir(0,StartDir);

   resetVariables;
   resetStrings;

   Node := 1;
   Z := mGetParam(paramNodeNum);
   if Z <> '' then Node := strToInt(Z);
   if Node < 1 then Node := 1 else if Node > maxNode then Node := 1;

   scrInitPages(2);

   ErrorLevel := errNormal;
   posX := 1;
   posY := 1;
   detProcessor;
   detVideoCard;
   detOperator;
   sndPort := detUltraSound;
   if sndPort <> 0 then sndType := sndUltraSound else detAnySoundBlaster;
   if sndType = sndNone then if detAdlib then sndType := sndAdlib;
end;

procedure initPaths;
begin
   fCreateDir(Cfg^.pathData,True);
   fCreateDir(Cfg^.pathText,True);
   fCreateDir(Cfg^.pathMenu,True);
   fCreateDir(Cfg^.pathMsgs,True);
   fCreateDir(Cfg^.pathSwap,True);
   fCreateDir(Cfg^.pathDoor,True);
   fCreateDir(Cfg^.pathProt,True);
   fCreateDir(Cfg^.pathTemp,True);
end;

procedure resetProtocols;
var F : file of tProtRec; P : tProtRec; N : Word;
begin
   Assign(F,Cfg^.pathData+fileProt);
   {$I-}
   Rewrite(F);
   {$I+}
   if ioResult <> 0 then Exit;
   N := 0;
   repeat
      Inc(N,1);
      FillChar(P,SizeOf(P),0);
      with P do
      begin
         Desc := 'Unused';
         Key  := 'X';
         codeIs := 1;
         posFile := 1;
         posStat := 1;
      end;
      case N of
         1 : with P do
             begin
                Desc      := 'Xmodem';
                Flag      := [protActive];
                Key       := 'X';
                Log       := '%M\DSZ%N.LOG';
                cmdUL     := 'dsz portx %C,%E estimate 0 %A rx %F';
                cmdDL     := 'dsz portx %C,%E estimate 0 %A sx %F';
                cmdEnv    := 'SET DSZLOG=%L';
                codeUL[1] := 'R';
                codeUL[2] := 'r';
                codeUL[3] := 'r';
                codeUL[4] := 'r';
                codeUL[5] := 'r';
                codeUL[6] := 'r';
                codeDL[1] := 'S';
                codeDL[2] := 's';
                codeDL[3] := 's';
                codeDL[4] := 's';
                codeDL[5] := 's';
                codeDL[6] := 's';
                codeIs    := xferOk;
                posFile   := 51;
                posStat   := 1;
             end;
         2 : with P do
             begin
                Desc      := 'Ymodem';
                Flag      := [protActive];
                Key       := 'Y';
                Log       := '%M\DSZ%N.LOG';
                cmdUL     := 'dsz portx %C,%E estimate 0 %A rb -k %F';
                cmdDL     := 'dsz portx %C,%E estimate 0 %A sb -k %F';
                cmdEnv    := 'SET DSZLOG=%L';
                codeUL[1] := 'R';
                codeUL[2] := 'r';
                codeUL[3] := 'r';
                codeUL[4] := 'r';
                codeUL[5] := 'r';
                codeUL[6] := 'r';
                codeDL[1] := 'S';
                codeDL[2] := 's';
                codeDL[3] := 's';
                codeDL[4] := 's';
                codeDL[5] := 's';
                codeDL[6] := 's';
                codeIs    := xferOk;
                posFile   := 51;
                posStat   := 1;
             end;
         3 : with P do
             begin
                Desc      := 'Ymodem';
                Flag      := [protBatch];
                Key       := 'Y';
                Log       := '%M\DSZ%N.LOG';
                cmdUL     := 'dsz portx %C,%E estimate 0 %A restrict rb';
                cmdDL     := 'dsz portx %C,%E estimate 0 %A sb @%D';
                cmdEnv    := 'SET DSZLOG=%L';
                codeUL[1] := 'R';
                codeUL[2] := 'r';
                codeUL[3] := 'r';
                codeUL[4] := 'r';
                codeUL[5] := 'r';
                codeUL[6] := 'r';
                codeDL[1] := 'S';
                codeDL[2] := 's';
                codeDL[3] := 's';
                codeDL[4] := 's';
                codeDL[5] := 's';
                codeDL[6] := 's';
                codeIs    := xferOk;
                listDL    := '%M\BATCH%N.LST';
                posFile   := 51;
                posStat   := 1;
             end;
         4 : with P do
             begin
                Desc      := 'Ymodem-G';
                Flag      := [protActive];
                Key       := 'G';
                Log       := '%M\DSZ%N.LOG';
                cmdUL     := 'dsz portx %C,%E estimate 0 %A rb -g %F';
                cmdDL     := 'dsz portx %C,%E estimate 0 %A sb -g %F';
                cmdEnv    := 'SET DSZLOG=%L';
                codeUL[1] := 'R';
                codeUL[2] := 'r';
                codeUL[3] := 'r';
                codeUL[4] := 'r';
                codeUL[5] := 'r';
                codeUL[6] := 'r';
                codeDL[1] := 'S';
                codeDL[2] := 's';
                codeDL[3] := 's';
                codeDL[4] := 's';
                codeDL[5] := 's';
                codeDL[6] := 's';
                codeIs    := xferOk;
                posFile   := 51;
                posStat   := 1;
             end;
         5 : with P do
             begin
                Desc      := 'Zmodem';
                Flag      := [protActive];
                Key       := 'Z';
                Log       := '%M\DSZ%N.LOG';
                cmdUL     := 'dsz portx %C,%E estimate 0 %A rz -m %F';
                cmdDL     := 'dsz portx %C,%E estimate 0 %A sz -m %F';
                cmdEnv    := 'SET DSZLOG=%L';
                codeUL[1] := 'Z';
                codeUL[2] := 'z';
                codeUL[3] := 'z';
                codeUL[4] := 'z';
                codeUL[5] := 'z';
                codeUL[6] := 'z';
                codeDL[1] := 'Z';
                codeDL[2] := 'z';
                codeDL[3] := 'Z';
                codeDL[4] := 'z';
                codeDL[5] := 'Z';
                codeDL[6] := 'z';
                codeIs    := xferOk;
                posFile   := 51;
                posStat   := 1;
             end;
         6 : with P do
             begin
                Desc      := 'Zmodem';
                Flag      := [protActive,protBatch];
                Key       := 'Z';
                Log       := '%M\DSZ%N.LOG';
                cmdUL     := 'dsz portx %C,%E estimate 0 %A restrict rz -m';
                cmdDL     := 'dsz portx %C,%E estimate 0 %A sz -m @%D';
                cmdEnv    := 'SET DSZLOG=%L';
                codeUL[1] := 'z';
                codeUL[2] := 'Z';
                codeUL[3] := 'z';
                codeUL[4] := 'z';
                codeUL[5] := 'z';
                codeUL[6] := 'z';
                codeDL[1] := 'Z';
                codeDL[2] := 'z';
                codeDL[3] := 'z';
                codeDL[4] := 'z';
                codeDL[5] := 'z';
                codeDL[6] := 'z';
                codeIs    := xferOk;
                listDL    := '%M\BATCH%N.LST';
                posFile   := 51;
                posStat   := 1;
             end;
         7 : with P do
             begin
                Desc      := 'Hydra';
                Flag      := [protActive,protBiDir];
                Key       := 'H';
                Log       := '%M\DSZ%N.LOG';
                cmdUL     := 'HYDRACOM port %P speed %A line %B nobell handshake hard get';
                cmdDL     := 'HYDRACOM port %P speed %A line %B nobell handshake hard send %D';
                cmdEnv    := 'SET DSZLOG=%L';
                codeUL[1] := 'R';
                codeUL[2] := 'r';
                codeUL[3] := 'H';
                codeUL[4] := 'h';
                codeUL[5] := 'h';
                codeUL[6] := 'h';
                codeDL[1] := 'H';
                codeDL[2] := 'h';
                codeDL[3] := 'h';
                codeDL[4] := 'h';
                codeDL[5] := 'h';
                codeDL[6] := 'h';
                codeIs    := xferOk;
                posFile   := 51;
                posStat   := 1;
             end;
         8 : with P do
             begin
                Desc      := 'Hydra';
                Flag      := [protActive,protBatch,protBiDir];
                Key       := 'H';
                Log       := '%M\DSZ%N.LOG';
                cmdUL     := 'HYDRACOM port %P speed %A line %B nobell handshake hard get';
                cmdDL     := 'HYDRACOM port %P speed %A line %B nobell handshake hard send @%D';
                cmdEnv    := 'SET DSZLOG=%L';
                codeUL[1] := 'R';
                codeUL[2] := 'r';
                codeUL[3] := 'h';
                codeUL[4] := 'h';
                codeUL[5] := 'h';
                codeUL[6] := 'h';
                codeDL[1] := 'H';
                codeDL[2] := 'h';
                codeDL[3] := 'h';
                codeDL[4] := 'h';
                codeDL[5] := 'h';
                codeDL[6] := 'h';
                codeIs    := xferOk;
                listDL    := '%M\BATCH%N.LST';
                posFile   := 51;
                posStat   := 1;
             end;
         9 : with P do
             begin
                Desc      := 'HS/Link';
                Flag      := [protActive,protBiDir];
                Key       := 'S';
                Log       := '%M\DSZ%N.LOG';
                cmdUL     := 'HSLINK -! -E%A -I1 -K -PB$%C -PI%E';
                cmdDL     := 'HSLINK -! -A -E%A -I1 -K -PB$%C -PI%E %F';
                cmdEnv    := 'SET DSZLOG=%L';
                codeUL[1] := 'H';
                codeUL[2] := 'h';
                codeUL[3] := 'h';
                codeUL[4] := 'h';
                codeUL[5] := 'h';
                codeUL[6] := 'h';
                codeDL[1] := 'H';
                codeDL[2] := 'h';
                codeDL[3] := 'h';
                codeDL[4] := 'h';
                codeDL[5] := 'h';
                codeDL[6] := 'hh';
                codeIs    := xferOk;
                posFile   := 51;
                posStat   := 1;
             end;
        10 : with P do
             begin
                Desc      := 'HS/Link';
                Flag      := [protActive,protBatch,protBiDir];
                Key       := 'S';
                Log       := '%M\DSZ%N.LOG';
                cmdUL     := 'HSLINK -! -A -E%A -I1 -K -PB$%C -PI%E';
                cmdDL     := 'HSLINK -! -A -E%A -I1 -K -PB$%C -PI%E @%D';
                cmdEnv    := 'SET DSZLOG=%L';
                codeUL[1] := 'h';
                codeUL[2] := 'H';
                codeUL[3] := '';
                codeUL[4] := '';
                codeUL[5] := '';
                codeUL[6] := '';
                codeDL[1] := 'H';
                codeDL[2] := 'h';
                codeDL[3] := '';
                codeDL[4] := '';
                codeDL[5] := '';
                codeDL[6] := '';
                codeIs    := xferOk;
                listDL    := '%M\BATCH%N.LST';
                posFile   := 51;
                posStat   := 1;
             end;
      end;
      Write(F,P);
   until N = maxProt;
   Close(F);
end;

procedure killVariables;
begin
   Dispose(Cfg);
   Dispose(User);
   Dispose(Modem);
   Dispose(Strs);
   Dispose(Menu);
   Dispose(Cmd);
   Dispose(mArea);
   Dispose(Msg);
   Dispose(Scan);
   scrDeInitPages;
end;

procedure killTerminateBBS;
begin
   ModemIO := not ModemOff;
   TextAttr := $07;
   TextMode(Co80);
   fWrite(1,1,bbsTitle+' v'+bbsVersion+' Terminated.  Errorlevel '+St(ErrorLevel),$08);
   GotoXY(1,22);
   cTerminateFossil;
  {if SwapOk then ShutDownExecSwap;}
   killVariables;
   {$I-}
   ChDir(StartDir);
   {$I+}
   mCursor(True);
   Halt(ErrorLevel);
end;

procedure initParameters;
var Quit : Boolean;
begin
   if ParamCount = 0 then Exit;
   Quit := False;
   LocalIO := True;
   ModemIO := False;
   HangUp := False;
   HungUp := False;
   UserOn := False;
   QuitAfter := mParam(paramQuitAfter);
   if mParam(paramPackAreas) then
   begin
      msgUpdateAllScanFiles;
      msgPackAreas(True,0);
      Quit := True;
   end;
   if mParam(paramModemConfig) then
   begin
      cfgCommunicationsSetup;
      Quit := True;
   end;
   if mParam(paramSystemConfig) then
   begin
      cfgSystemConfig;
      Quit := True;
   end;
   if mParam(paramMenuEdit) then
   begin
      cfgMenuEditor;
      Quit := True;
   end;
   if mParam(paramStringEdit) then
   begin
      cfgStringEditor;
      Quit := True;
   end;
   ModemIO := not ModemOff;
   if Quit then killTerminateBBS;
end;

function ModemFile : String;
var P : String; Ps : Byte;
begin
   P := fileModem;
   Ps := Pos('%',P);
   if Ps < 1 then Exit;
   Delete(P,Ps,1);
   Insert(St(Node),P,Ps);
   ModemFile := Cfg^.pathData+P;
end;

procedure initFiles;
var fCfg : file of tCfgRec;
    fModem : file of tModemRec;
    fUsers : file of tUserRec;
    fStrs : file of tStrings;
    fMArea : file of tMsgAreaRec;
begin
{$IFNDEF iniOverlay}
   if not fExists(fileConfig) then fResetCfg;
   Assign(fCfg,fileConfig);
   {$I-} Reset(fCfg); {$I+}
   if (ioResult <> 0) then
   begin
     WriteLn;
     WriteLn('The file "'+fileConfig+'" was not found in the current directory.');
     WriteLn('This is the '+bbsTitle+' configuration file, and is REQUIRED to load the BBS.');
     WriteLn('Please either recreate this file using the '+bbsTitle+' initalization system,');
     WriteLn('or obtain it from the original archive.');
     Halt(errFatal);
   end else
   begin
     {$I-} Read(fCfg,Cfg^); {$I+}
     if ioResult <> 0 then fResetCfg;
     Close(fCfg);
   end;
{$ENDIF}
   initPaths;
   Assign(fModem,ModemFile);
   {$I-} Reset(fModem); {$I+}
   if ioResult <> 0 then fResetModem(1);
   {$I-} Read(fModem,Modem^); {$I+}
   if ioResult <> 0 then fResetModem(1) else Close(fModem);

   Assign(fUsers,Cfg^.pathData+fileUsers);
   {$I-} Reset(fUsers); {$I+}
   if ioResult <> 0 then
   begin
      resetUser;
      fAddUser(User^);
      numUsers := 1;
   end else
   begin
      {$I-} Read(fUsers,User^); {$I+}
      if ioResult <> 0 then
      begin
         resetUser;
         Close(fUsers);
         Rewrite(fUsers);
         Write(fUsers,User^);
      end;
      numUsers := FileSize(fUsers);
      Close(fUsers);
   end;
   Assign(fStrs,Cfg^.pathData+fileStrings);
   {$I-}
   Reset(fStrs);
   {$I+}
   if ioResult <> 0 then
   begin
      resetStrings;
      fSaveStrings;
   end else
   begin
      {$I-}
      Read(fStrs,Strs^);
      {$I+}
      if ioResult <> 0 then
      begin
         resetStrings;
         fSaveStrings;
      end;
      Close(fStrs);
   end;
   Assign(fMArea,Cfg^.pathData+fileMsgArea);
   {$I-}
   Reset(fMArea);
   {$I+}
   if ioResult <> 0 then
   begin
      resetMsgArea;
      Rewrite(fMArea);
      Write(fMArea,mArea^);
      Close(fMArea);
      numMsgArea := 1;
   end else
   begin
      Read(fMArea,mArea^);
      numMsgArea := FileSize(fMArea);
      Close(fMArea);
   end;

   if not fExists(Cfg^.pathData+fileProt) then resetProtocols;

   msgUpdateAllScanFiles;
end;

procedure initCommPort;
begin
   ModemOff := (Modem^.ComPort = 4) or (mParam(paramNoModemIO));
   ModemIO := not ModemOff;

   if not cFossilInstalled then
   begin
      WriteLn;
      WriteLn(bbsTitle+' requires a FOSSIL communications driver.  Please ensure');
      WriteLn('that a compatible driver is installed before attempting to load '+bbsTitle+'.');
      Halt(errFatal);
   end;
   if not cSetupCommunications then
   begin
      WriteLn;
      WriteLn(bbsTitle+' encountered an error while attempting to initialize the');
      WriteLn('communications port.  Please ensure that '+bbsTitle+'''s modem setup');
      WriteLn('is configured properly.');
      Halt(errFatal);
   end;
end;

end.