{$I DIRECT.INC}
Unit Heretic;

(*
   Heretic Message Base Structure By Matthew Stanley.  Heretic is a new
   concept message base structure, incorporating the many advancements
   of message base structures into *1* format which is easily usable
   by other people.  The following file, the structures included, and
   any procedures I release are free to be used in whatever manner you
   see fit.  If you like them, find a bug, or just want to chat, look
   for me on IRC as NetDist or email me at netdist@interstate.net.

                                     Matthew Stanley
                                     Net Distortion

   A Description of Heretic's Basic Structure (2 File System):

      File 1: The Index File
        This is a file of longints (4 bytes) which store the position
        in File 2 where the message can be found.

        For Example:  Lets say we want to find the position for message 2
                      we would search to 2 - 1 in the index since files
                      are 0 based.  It would give us the LongInt file
                      position of the first header in the file.

      File 2: The Header / Text File
        This is a file of 384 byte increments which store header's and
        text for messages.  Each Header whether it contains an actual
        header or just text starts out with a 4 byte index number (longint)
        This longint tells us important information about this header
        as follows.

            -100 = Record not in use.
            -200 = Last record in message.
            >= 0 = Position of next record.

        Some of the down falls to most common Forum Style BBS systems is
        that they require you to run a packer to pack the message base
        structures.  With Heretic, after a message is deleted its records
        will be used again, and again!

        Headers will be stored in zero-position string format (Pascal)
        since most Forum style BBS's are written in Pascal.  The header
        will be 384 bytes long.

        In the Text, #227 is EndOfLn.  This means that each line only
        takes up line + 1.  The advantage of storing this way is that
        some ansi files which get saved with max. line length can easily
        be shown on a system using Heretic since there is no max line
        length, also since a longint is big  (-2147483648..2147483647)
        you should be able to use as many 384 byte records as you want.

        Here is a basic layout of the header / text file.

        Header Record
             0..3     LongInt Position #
             4..383   Header
        Text Record
             0..3     LongInt Position #
             4..383   Text

        Flags will be stored in longints to save space.
*)

Interface

Uses GenTypes;

Const MsgAnon = $00000001;  {Message was sent Anonymous}
      MsgFido = $00000002;  {Message is for Fido Style Networks}
      MsgRecv = $00000004;  {Message has been seen by MsgHdr.Reciever}
      MsgScan = $00000010;  {Message has been scanned by tosser once}

Type MsgHdr = Record
       NextIndex    : LongInt;       {Next File Position}
       Author       : String[30];    {Who wrote message}
       Reciever     : String[30];    {Message sent to this person}
       UserNote     : String[30];    {System User Note - If Used}
       When         : LongInt;       {When the message was wrote - Packed}
       PIDLine      : String[80];    {ie.  --- GEcho v1.11+}
       OriginLine   : String[80];    {ie.  My System (69:69/69) }
       NumReplied   : Word;          {How many replies made to this post}
       Flag         : LongInt;       {Flag variable}
       ExtraFlag    : LongInt;       {An Extra Flag variable - not used}
       NotUsed      : Array[1..111] of Byte;
     End;

Function IsFlag (LongFlag, TestFlag : LongInt) : Boolean;
Procedure FlagOn (Var LongFlag : LongInt; NewFlag : LongInt);
Procedure FlagOff (Var LongFlag : LongInt; OldFlag : LongInt);
Procedure WriteMsg (Conf, Base : Word; MH : MsgHdr; M : Message);

Implementation

Uses FileLock, ConfigRt, Dos, GenSubs;

Var  MsgIndex : File of LongInt;
     MsgFile  : File;



Function IsFlag (LongFlag, TestFlag : LongInt) : Boolean;
Begin
  If (LongFlag) And (TestFlag) <> 0 Then IsFlag := True Else IsFlag := False;
End;

Procedure FlagOn (Var LongFlag : LongInt; NewFlag : LongInt);
Begin
  LongFlag := (LongFlag) Or (NewFlag);
End;

Procedure FlagOff (Var LongFlag : LongInt; OldFlag : LongInt);
Begin
  LongFlag := (LongFlag) And Not (OldFlag);
End;

Procedure CloseDown;
Begin
  If FileRec(MsgIndex).Handle > 0 Then System.Close(MsgIndex);
  If FileRec(MsgFile).Handle > 0 Then System.Close(MsgFile);
  FileRec(MsgIndex).Handle := 0;
  FileRec(MsgFile).Handle := 0;
End;

Procedure AssignBases (Conf, Base : Word);
Begin
  CloseDown;
  Assign(MsgIndex, Cfg.TextDir + 'C' + Strr(Conf) + 'B' + Strr(Base) + '.IDX');
  ResetOrRewrite(MsgIndex, 4);
  Assign(MsgFile, Cfg.TextDir + 'C' + Strr(Conf) + 'B' + Strr(Base) + '.MSG');
  ResetOrRewrite(MsgFile, 384);
End;

Function FindNextSpot (Start : LongInt) : LongInt;
Var NextAvail : LongInt;
    TempArray : Array[1..384] of Byte;
    Result    : Word;
    Done      : Boolean;

Begin
  Done := False;
  Seek(MsgFile, Start);
  While (Not Done) AND (Not EOF(MsgFile)) Do
  Begin
    NBlockRead(MsgFile, TempArray, 1, Result);
    Move(TempArray[1], NextAvail, 4);
    If NextAvail = -100 Then
    Begin
      NextAvail := Pred(FilePos(MsgFile));
      Done := True;
    End;
  End;
  If Not Done Then NextAvail := FileSize(MsgFile);
  FindNextSpot := NextAvail;
End;


Procedure WriteMsg (Conf, Base : Word; MH : MsgHdr; M : Message);
Var Current : LongInt;
    Next    : LongInt;
    Result  : Word;
    Done    : Boolean;
    XX      : Byte;
    A       : Array[1..8000];
    AA      : Word;

Begin
  AssignBases(Conf, Base);
  Current := FindNextSpot(0);
  Seek(MsgIndex, FileSize(MsgIndex));
  NWrite(MsgIndex, Current);
  Next := FindNextSpot(Succ(Current));
  MH.NextIndex := Next;
  Seek(MsgFile, Current);
  NBlockWrite(MsgFile, MH, 1, Result);
  Current := Next;
  For XX := 1 to M.NumLines Do
  Begin
    If M.Text[XX] <> '' Then
    Begin
      Move(M.Text[X][1], B[L], BYTE(M.Text[X][0]));
      Inc(L, BYTE(M.Text[X][0]));
    End;
    B[L] := #227;
    Inc(L);
  End;


  CloseDown;
End;

End.