{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,D-,L-,N-,E+}
unit EchoMail;

interface

uses Global;

procedure echoImportAllEchoMail;

implementation

uses Dos,
     Files, Misc, Output, Strings, MsgArea, Logs;

type tFidoHeadRec = record
        maFrom,
        maTo           : array[1..36] of Char;
        maSubject      : array[1..72] of Char;
        maDate         : array[1..20] of Char;
        maTimesRead,
        nodeDest,
        nodeOrig,
        maCost,
        netOrig,
        netDest         : Integer;
        dateWritten,
        dateArrived     : LongInt;
        maRef          : Integer;
        maAttr         : Word;
        UnReply         : Integer;
     end;

function echoEchoDate(S : String) : LongInt;
var Dt : DateTime; L : LongInt; Z : String;
begin
   echoEchoDate := 0;
   Z := S[1]+S[2];
   Delete(S,1,3);
   Dt.Day := StrToInt(Z);

   Z := UpStr(S[1]+S[2]+S[3]);
   Delete(S,1,4);

   Dt.Month := 1;
   if Z = 'JAN' then Dt.Month := 1 else
   if Z = 'FEB' then Dt.Month := 2 else
   if Z = 'MAR' then Dt.Month := 3 else
   if Z = 'APR' then Dt.Month := 4 else
   if Z = 'MAY' then Dt.Month := 5 else
   if Z = 'JUN' then Dt.Month := 6 else
   if Z = 'JUL' then Dt.Month := 7 else
   if Z = 'AUG' then Dt.Month := 8 else
   if Z = 'SEP' then Dt.Month := 9 else
   if Z = 'OCT' then Dt.Month := 10 else
   if Z = 'NOV' then Dt.Month := 11 else
   if Z = 'DEC' then Dt.Month := 12;

   Z := S[1]+S[2];
   Delete(S,1,3);
   Dt.Year := 1900+StrToInt(Z);

   if S[1] = ' ' then Delete(S,1,1);

   Z := S[1]+S[2];
   if Z[1] = ' ' then Delete(Z,1,1);
   Delete(S,1,3);
   Dt.Hour := StrToInt(Z);

   Z := S[1]+S[2];
   Delete(S,1,3);
   Dt.Min := StrToInt(Z);

   Z := S[1]+S[2];
   Dt.Sec := StrToInt(Z);

   PackTime(Dt,L);

   echoEchoDate := L;
end;

function echoImportEchoMail(Fn : String; var Head : tMsgHeaderRec; var Txt : tMessage) : Boolean;
var mHead : tFidoHeadRec; fH : file of tFidoHeadRec; C : Char; fT : file;
    N, Z : Word;
begin
   echoImportEchoMail := False;
   Assign(fH,Fn);
   {$I-}
   Reset(fH);
   {$I+}
   if ioResult <> 0 then Exit;
   oStr(strCode(Strs^[strEchoImportingArea],1,mArea^.Name));
   {$I-}
   Read(fH,mHead);
   {$I+}
   if ioResult <> 0 then begin Close(fH); Exit; end;
   Close(fH);
   Assign(fT,Fn);
   Reset(fT,1);
   Seek(fT,SizeOf(mHead));
   FillChar(Txt,SizeOf(Txt),0);
   FillChar(Head,SizeOf(Head),0);
   N := 1;
   while (ioResult = 0) and (not Eof(fT)) do
   begin
      BlockRead(fT,C,1);
      if not (C in [#10,#13]) then Txt[N] := Txt[N]+C else if C = #13 then Inc(N,1);
   end;
   with Head.FromInfo do
   begin
      UserNum := 0;
      Alias := 'None';
      RealName := 'None';
      for Z := 1 to 36 do if mHead.maFrom[Z] in [' ',#0] then mHead.maFrom[Z] := ' ';
      Name := CleanUp(mHead.maFrom);
      UserNote := 'None';
      Address := Cfg^.Address[mArea^.Address];
{     Address.Node :=}
   end;
   with Head.ToInfo do
   begin
      UserNum := 0;
      Alias := 'None';
      RealName := 'None';
      for Z := 1 to 36 do if mHead.maTo[Z] in [' ',#0] then mHead.maTo[Z] := ' ';
      Name := CleanUp(mHead.maTo);
      UserNote := 'None';
      Address := Cfg^.Address[mArea^.Address];
   end;
   Head.Size := N;
   Head.Date := echoEchoDate(mHead.maDate);
   for Z := 1 to 72 do if mHead.maSubject[Z] in [' ',#0] then mHead.maSubject[Z] := ' ';
   Head.Subject := strSquish(CleanUp(mHead.maSubject),40);
   Head.Status := [msgEchoMail];
   Head.NetFlag := [];
   Z := mHead.maAttr;
   if mGetBit(Lo(Z),00) then Head.netFlag := Head.netFlag+[nPrivate];
   if mGetBit(Lo(Z),01) then Head.netFlag := Head.netFlag+[nCrash];
   if mGetBit(Lo(Z),02) then Head.netFlag := Head.netFlag+[nReceived];
   if mGetBit(Lo(Z),03) then Head.netFlag := Head.netFlag+[nSent];
   if mGetBit(Lo(Z),04) then Head.netFlag := Head.netFlag+[nFileAttached];
   if mGetBit(Lo(Z),05) then Head.netFlag := Head.netFlag+[nInTransit];
   if mGetBit(Lo(Z),06) then Head.netFlag := Head.netFlag+[nOrphan];
   if mGetBit(Lo(Z),07) then Head.netFlag := Head.netFlag+[nKillSent];
   if mGetBit(Hi(Z),00) then Head.netFlag := Head.netFlag+[nLocal];
   if mGetBit(Hi(Z),01) then Head.netFlag := Head.netFlag+[nHold];
   if mGetBit(Hi(Z),02) then Head.netFlag := Head.netFlag+[nUnused];
   if mGetBit(Hi(Z),03) then Head.netFlag := Head.netFlag+[nFileRequest];
   if mGetBit(Hi(Z),04) then Head.netFlag := Head.netFlag+[nReturnReceiptRequest];
   if mGetBit(Hi(Z),05) then Head.netFlag := Head.netFlag+[nIsReturnReceipt];
   if mGetBit(Hi(Z),06) then Head.netFlag := Head.netFlag+[nAuditRequest];
   if mGetBit(Hi(Z),07) then Head.netFlag := Head.netFlag+[nFileUpdateRequest];
   if nPrivate in Head.netFlag then Head.Status := Head.Status+[msgPrivate];
   Head.Replies := 0;
   Close(fT);
   echoImportEchoMail := True;
   oDnLn(1);
end;

procedure echoImportAllEchoMail;
var N, Z, A : Word; Head : tMsgHeaderRec; Txt : tMessage;
begin
   A := User^.curMsgArea;
   logWrite('*Importing all EchoMail.');
   for Z := 1 to numMsgArea do
   begin
      User^.curMsgArea := Z;
      if (maLoad) and (mArea^.areaType = mareaEchoMail) then
      begin
         N := 1;
         while fExists(mArea^.MsgPath+St(N)+extMsgEcho) do
         begin
            echoImportEchoMail(mArea^.MsgPath+St(N)+extMsgEcho,Head,Txt);
            maAddMessage(Txt,Head,True);
            Inc(N,1);
         end;
      end;
   end;
   User^.curMsgArea := A;
   maLoad;
end;

end.