program ansiTest;

uses Global, Crt;

const
   ansiFore : array[0..15] of String[2] = ('30','34','32','36','31','35','33','37',
                                           '30','34','32','36','31','35','33','37');
   ansiBack : array[0..7] of String[2]  = ('40','44','42','46','41','45','43','47');

var fc, Tc : tColorRec;

function emuAnsiCode(F,T : tColorRec) : String;
var S : String; cF, cB, cBl : Boolean;
begin
   cF  := F.Fore  <> T.Fore;
   cB  := F.Back  <> T.Back;
   cBl := F.Blink <> T.Blink;
   emuAnsiCode := '';
   if not (cF or cB or cBl) then Exit;
   S := #27+'[';
   if (cBl and T.Blink) or ((cF) and (F.Fore >= 8) and (T.Fore <= 7)) then
   begin
      S := S+'0;';
      cBl := T.Blink;
      cB := T.Back <> 0;
      cF := T.Fore <> 7;
   end;

   if cF then
   begin
      if (F.Fore <= 7) and (T.Fore >= 8) then
         S := S+'1;'+ansiFore[T.Fore]+';' else
         S := S+ansiFore[T.Fore]+';';
   end;

   if cB then S := S+ansiBack[T.Back]+';';
   if cBl then S := S+'5;';

   S[Ord(S[0])] := 'm';

   emuAnsiCode := S;
end;

begin
   with fc do
   begin
      Fore := 15;
      Back := 4;
      Blink := False;
   end;
   with tc do
   begin
      Fore := 9;
      Back := 2;
      Blink := False;
   end;
   TextMode(co80);
   WriteLn(emuAnsiCode(fc,tc));
   ReadKey;
end.