program emuANSi;

uses Crt, Global, FastIO;

var
   ansiInCode : Boolean;
   ansiCode   : String;
   ansiSaveX  : Byte;
   ansiSaveY  : Byte;

procedure ansiInit;
begin
   ansiInCode := False;
   ansiCode := '';
   ansiSaveX := 1;
   ansiSaveY := 1;
end;

function ansiNum : Word;
var i, j, k : Integer; temp1 : String;
begin
   Val(ansiCode,i,j);
   if j = 0 then ansiCode := '' else
   begin
      temp1 := Copy(ansiCode,1,j-1);
      Delete(ansiCode,1,j);
      Val(temp1,i,j);
   end;
   ansiNum := i;
end;

procedure ansiWriteChar(Ch : Char);
var Col, X, Y : Integer;
begin
   if Ch = #27 then
   begin
      ansiInCode := True;
      ansiCode := '';
   end else
   if ansiInCode then
   begin
      case Ch of
         '0'..'9',
         ';'      : ansiCode := ansiCode+Ch;
         '['      : ;
         'm'      : begin
                       ansiInCode := False;
                       if Ord(ansiCode[0]) = 0 then ansiCode := '0';
                       while Ord(ansiCode[0]) > 0 do
                       begin
                          Col := ansiNum;
                          case Col of
                            0   : ioTextColor(7,0,False);
                            1   : ioHighVideo;
                            5   : ioTextAttr(colAttr or $80);
                          { 7   : Reverse_Video; }
                            30  : ioTextAttr((colAttr and $F8)+0);
                            31  : ioTextAttr((colAttr and $F8)+4);
                            32  : ioTextAttr((colAttr and $F8)+2);
                            33  : ioTextAttr((colAttr and $F8)+6);
                            34  : ioTextAttr((colAttr and $F8)+1);
                            35  : ioTextAttr((colAttr and $F8)+5);
                            36  : ioTextAttr((colAttr and $F8)+3);
                            37  : ioTextAttr((colAttr and $F8)+7);
                            40  : ioTextBack(0);
                            41  : ioTextBack(4);
                            42  : ioTextBack(2);
                            43  : ioTextBack(6);
                            44  : ioTextBack(1);
                            45  : ioTextBack(5);
                            46  : ioTextBack(3);
                            47  : ioTextBack(7);
                          end;
                       end;
                    end;
         'H','f'  : begin
                       ansiInCode := False;
                       Y := ansiNum;
                       if Y > 25 then Y := 25 else if Y < 1 then Y := 1;
                       X := ansiNum;
                       if X > 80 then X := 80 else if X < 1 then X := 1;
                       ioGotoXY(X,Y);
                    end;
         'A'      : begin
                       ansiInCode := False;
                       Y := ansiNum;
                       if Y <> 0 then
                       begin
                          Y := ioWhereY-Y;
                          if Y < 1 then Y := 1;
                          ioGotoXY(ioWhereX,Y);
                       end;
                    end;
         'B'      : begin
                       ansiInCode := False;
                       Y := ansiNum;
                       if Y <> 0 then
                       begin
                          Y := ioWhereY+Y;
                          if Y > 25 then Y := 25;
                          ioGotoXY(ioWhereX,Y);
                       end;
                    end;
         'C'      : begin
                       ansiInCode := False;
                       X := ansiNum;
                       if X <> 0 then
                       begin
                          X := ioWhereX+X;
                          if X > 80 then X := 80;
                          ioGotoXY(X,ioWhereY);
                       end;
                    end;
         'D'      : begin
                       ansiInCode := False;
                       X := ansiNum;
                       if X <> 0 then
                       begin
                          X := ioWhereX-X;
                          if X < 1 then X := 1;
                          ioGotoXY(X,ioWhereY);
                       end;
                    end;
         's'      : begin
                       ansiInCode := False;
                       ansiSaveX := ioWhereX;
                       ansiSaveY := ioWhereY;
                    end;
         'u'      : begin
                       ansiInCode := False;
                       ioGotoXY(ansiSaveX,ansiSaveY);
                    end;
         'J'      : begin
                       ansiInCode := False;
                       ioClrScr;
                    end;
{        'K'      : begin
                       ansiInCode := False;
                       ClrEol;
                    end;}
        else ansiInCode := False;
      end;
   end else ioWriteChar(Ch);
end;

procedure ansiShow(Fn : String);
const ansiBuf = 3072;
var F : file; Buf : array[1..ansiBuf] of Char; X : Word; Size, Read, This : Integer;
begin
   Assign(F,Fn);
   Reset(F,1);
   Size := FileSize(F);
   Read := 0;
   while (ioResult = 0) and (Read < Size) do
   begin
      {$I-}
      BlockRead(F,Buf,ansiBuf,This);
      {$I+}
      Inc(Read,This);
      for X := 1 to This do ansiWriteChar(Buf[X]);
   end;
   Close(F);
end;

begin
   TextMode(Co80);
   ioInitFastIO;
   ansiShow('TEXT\LOG.LAL');
   ReadKey;
end.