{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,D-,L-,N-,E+}
unit AutoSig;

interface

uses Global;

procedure asEditAutoSig(var User : tUserRec; Save : Boolean);
procedure asDeleteAutoSig;
procedure asShowAutoSig;
procedure asUploadAutoSig;

implementation

uses Output, Input, Strings, Misc, Logs, MsgArea, Users, DateTime,
     FsEditor, Emulate;

procedure asEditAutoSig(var User : tUserRec; Save : Boolean);
var Head : ^tMsgHeaderRec; Txt : ^tMessage; X : Word;
begin
   New(Txt);
   New(Head);

   FillChar(Head^,SizeOf(Head^),0);
   Head^.Status := [];
   with Head^.ToInfo do
   begin
      UserNum := 0;
      Alias := 'None';
      RealName := 'None';
      Name := 'n/a';
      UserNote := 'None';
   end;
   Head^.Subject := #10'AutoSignature';
   with Head^.FromInfo do
   begin
      UserNum := User.Number;
      Alias := User.UserName;
      RealName := User.RealName;
      Name := User.UserName;
      UserNote := User.UserNote;
   end;
   Head^.Replies := 0;
   Head^.Date := dtDateTimePacked;

   FillChar(Txt^,SizeOf(Txt^),0);
   for X := 1 to maxSigLines do Txt^[X] := User.AutoSig[X];
   Head^.Size := User.AutoSigLns;
   Head^.sigPos := 0;
   Head^.incFile := 0;

   if fsEdit(Txt^,Head^,False,nil,nil,False,False) then
   begin
      logWrite('Edited autosignature');
      if Head^.Size > 6 then Head^.Size := 6;
      while (Head^.Size > 0) and (CleanUp(Txt^[Head^.Size]) = '') do Dec(Head^.Size);
      User.AutoSigLns := Head^.Size;
      FillChar(User.AutoSig,SizeOf(User.AutoSig),0);
      for X := 1 to Head^.Size do User.AutoSig[X] := Txt^[X];
      if Save then userSave(User);
      oStringLn(strAutoSigChanged);
   end;

   Dispose(Txt);
   Dispose(Head);
end;

procedure asDeleteAutoSig;
begin
   if User^.AutoSigLns = 0 then
   begin
      oStringLn(strAutoSigNone);
      Exit;
   end;
   oString(strAutoSigAskDelete);
   if iYesNo(False) then
   begin
      FillChar(User^.AutoSig,SizeOf(User^.AutoSig),0);
      User^.AutoSigLns := 0;
      userSave(User^);
      oStringLn(strAutoSigDeleted);
   end;
end;

procedure asShowAutoSig;
var X : Word;
begin
   if User^.AutoSigLns = 0 then
   begin
      oStringLn(strAutoSigNone);
      Exit;
   end;
   oStringLn(strAutoSigShow);
   emuANSiInit;
   for X := 1 to User^.AutoSigLns do
      if Pos(#27,User^.AutoSig[X]) = 0 then oStrCtr(User^.AutoSig[X]+#13#10) else oWriteANSi(User^.AutoSig[X]+#13#10);
   oDnLn(1);
end;

procedure asUploadAutoSig;
var Txt : ^tMessage; Lns, X : Word;
begin
   New(Txt);
   FillChar(Txt^,SizeOf(Txt^),0);
   oString(strAutoSigAskUpload);
   if iYesNo(False) then
   begin
      Lns := maImportMessage(Txt^);
      if Lns > 0 then
      begin
         logWrite('Uploaded autosignature');
         if Lns > 6 then Lns := 6;
         while CleanUp(Txt^[Lns]) = '' do Dec(Lns);
         User^.AutoSigLns := Lns;
         FillChar(User^.AutoSig,SizeOf(User^.AutoSig),0);
         for X := 1 to Lns do User^.AutoSig[X] := Txt^[X];
         userSave(User^);
         oStringLn(strAutoSigChanged);
      end;
   end;
   Dispose(Txt);
end;

end.