program DialupToTelnet;

{$R *.RES}

uses
  ComBase, Telnet, W32Sngl, Winsock, SysUtils, Windows;

const
  PROG_VER = 'DialupToTelnet v3.04.27';

var
  // Com And Telnet Objects
  ComObj : PCommObj;
  TelObj : PCommObj;

// Read Procedure For Com Object
procedure ComReadProc(var TempPtr: Pointer);
begin
     PWin32Obj(ComObj)^.Com_DataProc(TempPtr);
end;

// Write Procedure For Com Object
procedure ComWriteProc(var TempPtr: Pointer);
begin
     PWin32Obj(ComObj)^.Com_DataProc(TempPtr);
end;

// Read Procedure For Telnet Object
procedure TelReadProc(var TempPtr: Pointer);
begin
     PTelnetObj(TelObj)^.Com_ReadProc(TempPtr);
end;

// Write Procedure For Telnet Object
procedure TelWriteProc(var TempPtr: Pointer);
begin
     PTelnetObj(TelObj)^.Com_WriteProc(TempPtr);
end;

// Procedure To Parse Command-Line Parameters
procedure ParseCommandLine(var ADialHandle: THandle; var AHost: String; var APort: Word; var ATimeOut: Integer);
var
  Ch : Char;
  I  : Integer;
  S  : String;
begin
     // Loop Through All The Parameters
     for I := 1 to ParamCount do
     begin
          S := ParamStr(I);
          if (S[1] in ['/', '-']) and (Length(S) >= 3) then
          begin
               Ch := S[2];
               Delete(S, 1, 2);

               case UpCase(Ch) of
                    'H': ADialHandle := StrToIntDef(S, INVALID_HANDLE_VALUE);
                    'P': APort := StrToIntDef(S, 23);
                    'S': AHost := S;
                    'T': ATimeOut := StrToIntDef(S, 15);
               end;
          end;
     end;
end;

// Procedure To Show Command Line Parameters
procedure ShowCommandLineParameters;
var
  S: String;
begin
     // Create The Usage String
     S := PROG_VER + #13#10;
     S := S + #13#10;
     S := S + 'USAGE: DialupToTelnet.exe -H [-P] [-S] [-T]' + #13#10;
     S := S + #13#10;
     S := S + 'Parameters In [] Are Optional' + #13#10;
     S := S + #13#10;
     S := S + '  -H<com handle>     ' + #9 + 'Com Handle Of Dialup Connection To Open' + #13#10;
     S := S + '  -P<remote port>    ' + #9 + 'Remote Port To Connect To (default: 23)' + #13#10;
     S := S + '  -S<remote server>  ' + #9 + 'Remote Server To Connect To (default: 127.0.0.1)' + #13#10;
     S := S + '  -T<connect timeout>' + #9 + 'Seconds Before Aborting Connect (default: 15)' + #13#10;
     S := S + #13#10;
     S := S + 'EXAMPLE: DialupToTelnet.exe -H1234 -P23 -Smannsoft.ca -T60' + #13#10;

     // Display A Message Box Showing The DialupToTelnet Usage
     MessageBox(0, PChar(S), PROG_VER, mb_IconInformation + mb_Ok);
end;

// Function To Connect To Given Server:Port And Return Socket Handle
function TelnetConnect(AHost: String; APort: Word; ATimeOut: Integer): TSocket;
const
  // Values Used By IOCtlSocket()
  BLOCKING    : Integer = 0;
  NONBLOCKING : Integer = 1;
var
  FDSet    : TFDSet;
  HostEnt  : PHostEnt;
  SockAddr : TSockAddr;
  TimeVal  : TTimeVal;
  WSAData  : TWSAData;
begin
     // Initialize Winsock DLL
     WSAStartUp($0202, WSAData);

     // Get Host Information
     HostEnt := GetHostByName(PChar(AHost));
     if (HostEnt = nil) then
     begin
          // Should Call WSAGetLastError Here
          Result := INVALID_SOCKET;
     end else
     begin
          // Fill TSockAddr Structure
          FillChar(SockAddr, SizeOf(SockAddr), 0);
          SockAddr.Sin_Family := AF_INET;
          SockAddr.Sin_Port := HToNS(APort);
          SockAddr.Sin_Addr.S_Addr := LongInt(PLongInt(HostEnt^.H_Addr_List^)^);

          // Try To Create The Telnet Socket
          Result := Socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
          if (Result <> INVALID_SOCKET) then
          begin
               // Fill TFDSet And TTimeVal Structures
               FD_Zero(FDSet);
               FD_Set(Result, FDSet);
               TimeVal.TV_Sec := ATimeOut;
               TimeVal.TV_USec := 0;

               // Set Socket To NonBlocking Mode
               IOCtlSocket(Result, FIONBIO, NONBLOCKING);

               // Try To Connect To The Remote Host
               Connect(Result, SockAddr, SizeOf(SockAddr));
               if (Select(0, nil, @FDSet, nil, @TimeVal) = 1) then
               begin
                    // Connect Was Successful, Set Socket Back To Blocking Mode
                    IOCtlSocket(Result, FIONBIO, BLOCKING);
               end else
               begin
                    // Connect Timed Out
                    Result := INVALID_SOCKET;
               end;
          end;
     end;
end;

const
  BUF_SIZE = 5000;
var
  // Com Handle And Telnet Socket
  ComHandle : THandle = INVALID_HANDLE_VALUE;
  TelSocket : TSocket = INVALID_SOCKET;

  // Default Host / Port / TimeOut Values
  Host    : String  = '127.0.0.1';
  Port    : Word    = 23;
  TimeOut : Integer = 15;

  // Variables For Reading / Writing
  Buf        : Array[0..BUF_SIZE - 1] of Char;
  InUsed     : Integer;
  NumRead    : Integer;
  NumWritten : Integer;
begin
     // Parse The Command Line Parameters
     ParseCommandLine(ComHandle, Host, Port, TimeOut);

     if (ComHandle = INVALID_HANDLE_VALUE) then
     begin
          // Com Handle Wasnt Passed, Show List Of Command Line Parameters
          ShowCommandLineParameters;
     end else
     begin
          // Create The Com Object
          ComObj := New(PWin32Obj, Init);
          ComObj^.Com_SetDataProc(@ComReadProc, @ComWriteProc);
          ComObj^.Com_OpenQuick(ComHandle);

          if (ComObj^.Com_Carrier) then
          begin
               // Com Handle Appears Valid, Try Connecting To Remote Server
               ComObj^.Com_SendString(#27 + '[2JConnecting To ' + Host + ':' + IntToStr(Port) + #13#10);
               TelSocket := TelnetConnect(Host, Port, TimeOut);

               if (TelSocket = INVALID_SOCKET) then
               begin
                    // Connection To Remote Server Failed
                    ComObj^.Com_SendString('Unable To Connect To ' + Host + ':' + IntToStr(Port) + #13#10);
               end else
               begin
                    // Successfully Connected To Remote Server
                    ComObj^.Com_SendString('Connected!' + #13#10);

                    // Create The Telnet Object
                    TelObj := New(PTelnetObj, Init);
                    TelObj^.Com_SetDataProc(@TelReadProc, @TelWriteProc);
                    TelObj^.Com_OpenQuick(TelSocket);

                    // Run In A Loop Until Either Side Of The Connection Is Closed
                    repeat
                          // Check If The User Hit A Key
                          if (ComObj^.Com_CharAvail) then
                          begin
                               // Make Sure We Are Still Connected To The Remote Server
                               if (TelObj^.Com_Carrier) then
                               begin
                                    // Read From The Client And Write To The Server
                                    InUsed := PWin32Obj(ComObj)^.InBuffer.BufUsed;
                                    if (InUsed > SizeOf(Buf) - 10) then
                                       InUsed := SizeOf(Buf) - 10;
                                    ComObj^.Com_ReadBlock(Buf, InUsed, NumRead);
                                    TelObj^.Com_SendBlock(Buf, NumRead, NumWritten);
                               end;
                          end;

                          // Check If The Server Sent Some Data
                          if (TelObj^.Com_CharAvail) then
                          begin
                               // Make Sure The User Hasn't Dropped Carrier
                               if (ComObj^.Com_Carrier) then
                               begin
                                    // Read From The Server And Write To The Client
                                    InUsed := PTelnetObj(TelObj)^.InBuffer.BufUsed;
                                    if (InUsed > SizeOf(Buf) - 10) then
                                       InUsed := SizeOf(Buf) - 10;
                                    TelObj^.Com_ReadBlock(Buf, InUsed, NumRead);
                                    ComObj^.Com_SendBlock(Buf, NumRead, NumWritten);
                               end;
                          end;

                          // Make Sure We Don't Eat 100% CPU
                          Sleep(10);
                    until Not(ComObj^.Com_Carrier) or Not(TelObj^.Com_Carrier);

                    // Free The Telnet Object
                    Dispose(TelObj, Done);
               end;
          end;

          // Free The Com Object
          Dispose(ComObj, Done);
     end;
end.
