
'   Program to convert COMMO phone directory to other formats,
'   and to convert several formats to COMMO format.

'   Free from David Rife 11-09-99.

'   Changes are listed at the end of this file.

rem  Edit next line to suit local configuration.
    zocini$ = "c:\zoc4\options\zochosts.ini"

    F1$ = ""
    F3$ = ""

    CLS

    SEL$ = COMMAND$
    IF SEL$ = "" THEN GOTO NOCMD
    SEL$ = UCASE$(SEL$)
    IF INSTR(SEL$, "?") THEN GOTO HELPTEXT
    IF INSTR(SEL$, "HELP") THEN GOTO HELPTEXT

    IF INSTR(SEL$, "COMMO") THEN
        F1$ = SEL$
        GOSUB ISHERE
        GOTO CTOTLX
    END IF

    IF INSTR(SEL$, "TELIX") THEN
        F1$ = SEL$
        GOSUB ISHERE
        GOTO TLXTOC
    END IF

NOCMD:
    PRINT
    PRINT "This program convert will phone directories from one format to another."
    PRINT "Free from David Rife"
    PRINT
    PRINT "    (A)  COMMO   to BananaCom"
    PRINT "    (B)  COMMO   to BOYAN"
    PRINT "    (C)  COMMO   to COM-AND"
    PRINT "    (D)  COMMO   to Lync"
    PRINT "    (E)  COMMO   to mTelnet"
    PRINT "    (F)  COMMO   to MyComm"
    PRINT "    (G)  COMMO   to Procomm"
    PRINT "    (H)  COMMO   to Qmodem"
    PRINT "    (I)  COMMO   to Telemate"
    PRINT "    (J)  COMMO   to Telix"
    PRINT "    (K)  COMMO   to TXZMR"
    PRINT "    (L)  COMMO   to ZOC 4.xx"
    PRINT "    (M)  COMMO   to comma-delimited file"
    PRINT "    (N)  COMMO   to SyncTERM"
    PRINT
    PRINT "    (W)  SyncTERM to COMMO"
    PRINT "    (X)  mTelnet to COMMO"
    PRINT "    (Y)  Telix   to COMMO"
    PRINT "    (Z)  ZOC     to COMMO"
    PRINT
    PRINT "    (?)  Help"
    PRINT
    INPUT "Your selection is"; SEL$

    SEL$ = UCASE$(SEL$)
    IF SEL$ = "A" THEN GOTO BCOM
    IF SEL$ = "B" THEN GOTO BOYAN
    IF SEL$ = "C" THEN GOTO COMAND
    IF SEL$ = "D" THEN GOTO LYNC
    IF SEL$ = "E" THEN GOTO MTELNET
    IF SEL$ = "F" THEN GOTO MYCOMM
    IF SEL$ = "G" THEN GOTO PCPLUS
    IF SEL$ = "H" THEN GOTO QMODEM
    IF SEL$ = "I" THEN GOTO TELEMATE
    IF SEL$ = "J" THEN GOTO CTOTLX
    IF SEL$ = "K" THEN GOTO TXZMR
    IF SEL$ = "L" THEN GOTO CTOZ
    IF SEL$ = "M" THEN GOTO COMMAFILE
    IF SEL$ = "N" THEN GOTO CTOSYNC

    IF SEL$ = "W" THEN GOTO SYNCTOC
    IF SEL$ = "X" THEN GOTO MTELTOC
    IF SEL$ = "Y" THEN GOTO TLXTOC
    IF SEL$ = "Z" THEN GOTO ZTOC

    IF SEL$ = "?" THEN GOTO HELPTEXT

    CLS
    PRINT
    PRINT "Nothing selected."
    SYSTEM
    END

ALLDONE:
    CLOSE
    CLS
    PRINT
    IF F3$ = "" THEN
        PRINT F2$ + " has been created from " + F1$ + "."
    ELSE
        PRINT F2$ + " and " + F3$ + " have been created from " + F1$ + "."
    END IF
    SYSTEM
    END

GETF1:
    IF F1$ <> "" THEN RETURN
    INPUT "Source file (default c:\commo\commo.fon)"; F1$
    IF F1$ = "" THEN F1$ = "C:\COMMO\COMMO.FON"
    RETURN

'   ***** Procomm Plus

PCPLUS:
    GOSUB GETF1
    F2$ = "PCPLUS1.DIR"

    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    OPEN F2$ FOR OUTPUT AS #2

    FOR j = 1 TO 250
        PRINT #2, CHR$(0);
    NEXT j

    M = 0
    M1 = 200

    WHILE NOT EOF(1)
        LINE INPUT #1, L$
        GOSUB PCPLUS1
    WEND

    IF M = M1 THEN GOTO ALLDONE
    FOR K = 1 TO M1 - M
        GOSUB PCPLUS2
    NEXT K

    GOTO ALLDONE

PCPLUS1:
    GOSUB GETPARTS
    IF LEN(NAME$) = 0 THEN RETURN

    M = M + 1
    NAME$ = MID$(NAME$, 1, 24)
    NUMBER$ = MID$(NUMBER$, 1, 20)
    SCRIPT$ = MID$(SCRIPT$, 1, 8)
    PWORD$ = MID$(PWORD$, 1, 10)

    PRINT #2, NAME$;
    IF LEN(NAME$) < 24 THEN
        FOR j = 1 TO 24 - LEN(NAME$)
            PRINT #2, CHR$(0);
        NEXT j
    END IF
    PRINT #2, CHR$(0);

    PRINT #2, NUMBER$;
    IF LEN(NUMBER$) < 20 THEN
        FOR j = 1 TO 20 - LEN(NUMBER$)
            PRINT #2, CHR$(0);
        NEXT j
    END IF

    PRINT #2, CHR$(0); CHR$(8); CHR$(0); CHR$(0);
    PRINT #2, CHR$(8); CHR$(1); CHR$(0);

    PRINT #2, SCRIPT$;
    IF LEN(SCRIPT$) < 8 THEN
        FOR j = 1 TO 8 - LEN(SCRIPT$)
            PRINT #2, CHR$(0);
        NEXT j
    END IF
    PRINT #2, CHR$(0);

    PRINT #2, "00/00/00";

    PRINT #2, CHR$(0); CHR$(0); CHR$(0); CHR$(17);
    PRINT #2, CHR$(6); CHR$(0);

    PRINT #2, PWORD$;
    IF LEN(PWORD$) < 10 THEN
        FOR j = 1 TO 10 - LEN(PWORD$)
            PRINT #2, CHR$(0);
        NEXT j
    END IF
    PRINT #2, CHR$(0);

    FOR j = 87 TO 114
        PRINT #2, CHR$(0);
    NEXT j

    RETURN

PCPLUS2:

    FOR j = 1 TO 46
        PRINT #2, CHR$(0);
    NEXT j

    PRINT #2, CHR$(8); CHR$(0); CHR$(0);
    PRINT #2, CHR$(8); CHR$(1); CHR$(0);

    FOR j = 53 TO 61
        PRINT #2, CHR$(0);
    NEXT j

    PRINT #2, "00/00/00";
    PRINT #2, CHR$(0); CHR$(0); CHR$(0); CHR$(11);
    PRINT #2, CHR$(6); CHR$(0);

    FOR j = 76 TO 114
        PRINT #2, CHR$(0);
    NEXT j

    RETURN


'   ***** COMMO to Telix

CTOTLX:
    GOSUB GETF1
    GOSUB COUNTLINES

    PA = 0                  ' parity
    DA = 8                  ' data bits
    ST = 1                  ' stop bits

    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    F2$ = "TELIX1.FON"
    OPEN F2$ FOR OUTPUT AS #2

'   This is the header, 64 bytes.
    PRINT #2, CHR$(26);
    PRINT #2, CHR$(41);
    PRINT #2, CHR$(43);
    PRINT #2, CHR$(46);
    PRINT #2, CHR$(1);
    PRINT #2, CHR$(0);
    PRINT #2, CHR$(N1);
    PRINT #2, CHR$(N2);
    FOR I = 9 TO 64
        PRINT #2, CHR$(0);
    NEXT I
'   end of header

    M = 0

    WHILE NOT EOF(1)
        LINE INPUT #1, L$
        IF M < M1 THEN GOSUB TLINE
    WEND

    IF M >= M1 THEN GOTO ALLDONE
    FOR j = M + 1 TO M1
        GOSUB TBLANK
    NEXT j
    GOTO ALLDONE

TLINE:
    GOSUB GETPARTS

    SP = 8
    IF SPEED$ = "115200" THEN SP = 8
    IF SPEED$ = "57600" THEN SP = 7
    IF SPEED$ = "38400" THEN SP = 6
    IF SPEED$ = "19200" THEN SP = 5
    IF SPEED$ = "9600" THEN SP = 4
    IF SPEED$ = "4800" THEN SP = 3
    IF SPEED$ = "2400" THEN SP = 2
    IF SPEED$ = "1200" THEN SP = 1
    IF SPEED$ = "300" THEN SP = 0

    IF LEN(NAME$) = 0 THEN      ' prevents writing blank first line
        IF M = 0 THEN
            RETURN
        ELSE
            GOSUB TBLANK
            M = M + 1
            RETURN
        END IF
    END IF

    NAME$ = MID$(NAME$, 1, 25)
    NUMBER$ = MID$(NUMBER$, 1, 17)
    PWORD$ = MID$(PWORD$, 1, 14)
    SCRIPT$ = MID$(SCRIPT$, 1, 12)

    PRINT #2, NAME$;                    ' name
    IF LEN(NAME$) < 25 THEN
        FOR I = 1 TO 25 - LEN(NAME$)
            PRINT #2, CHR$(0);
        NEXT I
    END IF

    PRINT #2, NUMBER$;                  ' number
    IF LEN(NUMBER$) < 17 THEN
        FOR j = 1 TO 17 - LEN(NUMBER$)
            PRINT #2, CHR$(0);
        NEXT j
    END IF

    PRINT #2, CHR$(SP);                 ' speed
    PRINT #2, CHR$(PA);                 ' parity
    PRINT #2, CHR$(DA);                 ' data bits
    PRINT #2, CHR$(ST);                 ' stop bits

    PRINT #2, SCRIPT$;                  ' script name
    IF LEN(SCRIPT$) < 12 THEN
        FOR j = 1 TO 12 - LEN(SCRIPT$)
            PRINT #2, CHR$(0);
        NEXT j
    END IF

    IF LDATE$ = "00/00/00" THEN
        FOR L = 1 TO 7                      ' last call date and number
            PRINT #2, CHR$(0);
        NEXT L
    ELSE
        PRINT #2, MID$(LDATE$, 1, 2);
        PRINT #2, MID$(LDATE$, 4, 2);
        PRINT #2, MID$(LDATE$, 7, 2);
        IF callnum = 0 THEN
            PRINT #2, CHR$(1);
        ELSE
            PRINT #2, CHR$(callnum);        ' number of calls
        END IF
    END IF

    PRINT #2, CHR$(0);

    PRINT #2, CHR$(1);                  ' terminal type

    PRINT #2, "Z";                      ' protocol

'   The next character has value according to strip high bit, BS sends
'   DEL, BS destructive on receive, add LFs, and local echo.
'   Strip high is msb and local echo is lsb.

    PRINT #2, CHR$(0);

    PRINT #2, CHR$(0);                  ' fill
    PRINT #2, CHR$(0);                  ' fill

    PRINT #2, CHR$(prefix);             ' dialing prefix (1, 2, or 3)

    PRINT #2, PWORD$;                   ' password
    IF LEN(PWORD$) < 14 THEN
        FOR j = 1 TO 14 - LEN(PWORD$)
            PRINT #2, CHR$(0);
        NEXT j
    END IF

    M = M + 1

    RETURN

TBLANK:
    FOR L = 1 TO 25         ' name
        PRINT #2, CHR$(0);
    NEXT L
    FOR L = 1 TO 17         ' number
        PRINT #2, CHR$(0);
    NEXT L

    PRINT #2, CHR$(SP);     ' speed
    PRINT #2, CHR$(PA);     ' parity
    PRINT #2, CHR$(DA);     ' data bits
    PRINT #2, CHR$(ST);     ' stop bits

    FOR L = 1 TO 12         ' script name
        PRINT #2, CHR$(0);
    NEXT L

    FOR L = 1 TO 6          ' last call date
        PRINT #2, CHR$(0);
    NEXT L

    PRINT #2, CHR$(0);      ' number of calls
    PRINT #2, CHR$(0);

    PRINT #2, CHR$(1);      ' terminal type

    PRINT #2, "Z";          ' protocol

    PRINT #2, CHR$(0);
    PRINT #2, CHR$(0);
    PRINT #2, CHR$(0);

    PRINT #2, CHR$(1);      ' dialing prefix

    FOR L = 1 TO 14         ' password
        PRINT #2, CHR$(0);
    NEXT L
    RETURN

COUNTLINES:   ' This routine counts the number of entries in COMMO directory.
    M1 = 0
    M2 = 0
    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    WHILE NOT EOF(1)
        LINE INPUT #1, L$
        IF INSTR(L$, "{") THEN M1 = M1 + 1: M2 = 1
        IF LEN(L$) < 2 AND M2 = 1 THEN M1 = M1 + 1   ' ignore leading blanks
    WEND
    CLOSE #1

    IF M1 > 1000 THEN M1 = 1000    '  Prepare Telix entry.
    N2 = INT(M1 / 256)
    N1 = M1 - N2 * 256

    RETURN

'   ***** COMMO to Qmodem   added 01-17-2001

QMODEM:
    GOSUB GETF1
    M1 = 200

    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    F2$ = "QMODEM1.FON"
    OPEN F2$ FOR OUTPUT AS #2

    M = 0

    WHILE NOT EOF(1)
        LINE INPUT #1, L$
        IF M < M1 THEN GOSUB QLINE
    WEND

    IF M >= M1 THEN GOTO ALLDONE
    FOR j = M + 1 TO M1
        GOSUB QBLANK
    NEXT j
    GOTO ALLDONE

QLINE:
    GOSUB GETPARTS
    IF LEN(NAME$) = 0 THEN      ' prevents writing blank first line
        IF M = 0 THEN
            RETURN
        ELSE
            GOSUB QBLANK
            RETURN
        END IF
    END IF

    NAME$ = MID$(NAME$, 1, 27)
    NUMBER$ = MID$(NUMBER$, 1, 19)
    PWORD$ = MID$(PWORD$, 1, 14)
    SCRIPT$ = UCASE$(MID$(SCRIPT$, 1, 8))

    x = LEN(NAME$)
    PRINT #2, CHR$(x);
    PRINT #2, NAME$;                    ' name
    FOR I = 2 + x TO 30
        PRINT #2, CHR$(0);
    NEXT I

    x = LEN(NUMBER$)
    PRINT #2, CHR$(x);
    PRINT #2, NUMBER$;                  ' number
    FOR j = 32 + x TO 52
        PRINT #2, CHR$(0);
    NEXT j

    PRINT #2, CHR$(8);                  ' data bits
    PRINT #2, CHR$(0);
    PRINT #2, CHR$(1);                  ' stop bits
    PRINT #2, CHR$(0);
    PRINT #2, "N";                      ' parity

    x = LEN(SCRIPT$)
    PRINT #2, CHR$(x);
    PRINT #2, SCRIPT$;                  ' script name
    FOR j = 59 + x TO 70
        PRINT #2, CHR$(0);
    NEXT j

    PRINT #2, CHR$(255);
    PRINT #2, CHR$(255);

    FOR L = 73 TO 85
        PRINT #2, CHR$(0);
    NEXT L

    PRINT #2, "Z";                      ' protocol
    PRINT #2, "F";                      ' full duplex

    x = LEN(PWORD$)
    PRINT #2, CHR$(x);
    PRINT #2, PWORD$;                   ' password
    FOR j = 89 + x TO 107
        PRINT #2, CHR$(0);
    NEXT j

    M = M + 1
    PRINT #2, CHR$(M);                  ' entry number
    FOR j = 109 TO 112
        PRINT #2, CHR$(0);
    NEXT j

    PRINT #2, CHR$(194);
    PRINT #2, CHR$(1);

    FOR j = 115 TO 118
        PRINT #2, CHR$(0);
    NEXT j

    RETURN

QBLANK:
    M = M + 1
    FOR L = 1 TO 52
        PRINT #2, CHR$(0);
    NEXT L
    PRINT #2, CHR$(8);
    PRINT #2, CHR$(0);
    PRINT #2, CHR$(1);
    PRINT #2, CHR$(0);
    PRINT #2, "N";
    FOR L = 58 TO 70
        PRINT #2, CHR$(0);
    NEXT L
    PRINT #2, CHR$(255);
    PRINT #2, CHR$(255);
    FOR L = 73 TO 85
        PRINT #2, CHR$(0);
    NEXT L
    PRINT #2, "Z";                      ' protocol
    PRINT #2, "F";                      ' full duplex
    FOR L = 88 TO 107
        PRINT #2, CHR$(0);
    NEXT L
    PRINT #2, CHR$(M);
    FOR L = 109 TO 112
        PRINT #2, CHR$(0);
    NEXT L
    PRINT #2, CHR$(194);
    PRINT #2, CHR$(1);
    FOR L = 115 TO 118
        PRINT #2, CHR$(0);
    NEXT L
    RETURN


' Program to convert COMMO phone book format file to ZOC phone book format.
' by David Rife 03-20-98
' 09-28-98 Changed default B$ to "0".
' 05-07-99 Corrected telnet entries.
' 08-18-99 Added response to "/?" command line.
' 09-12-99 Edited /? response.
' 11-08-99 Changed to use a WHILE statement.

CTOZ:
    GOSUB GETF1
REM      INPUT "Which book number"; BOOK$
    BOOK$ = "4"
rem
rem  Connection devices:
rem    Serial modem    (1)
rem    Telnet          (3)
rem    Named Pipe      (4)
rem    Windows Modems  (7)
rem    Rlogin          (8)
rem    Secure Shell    (9)
rem    Telnet/SSL      (10)
rem

    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    F2$ = "PHONEBK4.INI"
    OPEN F2$ FOR OUTPUT AS #2
    PRINT #2, "ZOC 4.08 // PHONEBOOK"
    PRINT #2, " "
    PRINT #2, "#0000019800002ef40000000b00000000debb20e3000000000000000000000000"

    WHILE NOT EOF(1)
        LINE INPUT #1, L$
        GOSUB ZLINE
    WEND

    GOTO ALLDONE

ZLINE:
    GOSUB GETPARTS
    GOSUB getsecs
    device$ = UCASE$(device$)
    IF device$ = "SERIAL" THEN device = 1
    IF device$ = "SERIAL/MODEM" THEN device = 1
    IF device$ = "TELNET" THEN device = 3
    IF device$ = "RAW" THEN device = 4
    IF device$ = "NAMED PIPE" THEN device = 4
    IF device$ = "MODEM" THEN device = 7
    IF device$ = "WINDOWS MODEMS" THEN device = 7
    IF device$ = "RLOGIN" THEN device = 8
    IF device$ = "RLOGIN REVERSED" THEN device = 8
    IF device$ = "SSH" THEN device = 9
    IF device$ = "SECURE SHELL" THEN device = 9
    IF device$ = "TELNET/SSL" THEN device = 10

    IF NUMBER$ = "" THEN RETURN
    IF (MID$(NUMBER$, 1, 1) = "%") THEN
        U = INSTR(NUMBER$, " ")
        IF U > 0 THEN
            NUMBER$ = LTRIM$(MID$(NUMBER$, U))
        END IF
    END IF

    T$ = PWORD$
    PWORD$ = ""
    FOR I = 1 TO LEN(T$)
        PWORD$ = PWORD$ + HEX$(ASC(MID$(T$, I, 1)))
    NEXT I
    PWORD$ = PWORD$ + STRING$(128, "0")
    PWORD$ = LCASE$(MID$(PWORD$, 1, 128))
    GOSUB ZOCWRITE
    RETURN

ZOCWRITE:
    PRINT #2, ""
    PRINT #2, "[ENTRY]"
    PRINT #2, "book="; BOOK$
    PRINT #2, "name="; CHR$(34); NAME$; CHR$(34)
    PRINT #2, "number="; CHR$(34); NUMBER$; CHR$(34)
    PRINT #2, "password=x'"; PWORD$; "'"
    PRINT #2, "memo="; CHR$(34); CHR$(34)
    PRINT #2, "script="; CHR$(34); CHR$(34)
    PRINT #2, "scriptparm="; CHR$(34); CHR$(34)
    PRINT #2, "waitsend="; CHR$(34); CHR$(34)
    PRINT #2, "username="; CHR$(34); USERNAME$; CHR$(34)

    IF device = 1 THEN PRINT #2, "deviceopts="; CHR$(34); "[1]COM3:115200-8N1|9|250"; CHR$(34)
    IF device = 3 THEN PRINT #2, "deviceopts="; CHR$(34); "[3]0"; CHR$(34)
    IF device = 4 THEN PRINT #2, "deviceopts="; CHR$(34); "[4]0"; CHR$(34)
    IF device = 7 THEN PRINT #2, "deviceopts="; CHR$(34);"[7]565578/1855080687|0|1:"; CHR$(34)
    IF device = 8 THEN PRINT #2, "deviceopts="; CHR$(34);"[8]4||"; CHR$(34)
    IF device = 9 THEN PRINT #2, "deviceopts="; CHR$(34);"[9]0|0|0|0|0|*|"; CHR$(34)
    IF device = 10 THEN PRINT #2, "deviceopts="; CHR$(34);"[10]64:23"; CHR$(34)

    PRINT #2, "optfile="; CHR$(34); "STANDARD.ZOC"; CHR$(34)
    PRINT #2, "logname="; CHR$(34); CHR$(34)

    IF DLPATH$ = "" THEN
        PRINT #2, "dlpath="; CHR$(34); "C:\DOWN"; CHR$(34)
    ELSE
        PRINT #2, "dlpath="; CHR$(34); DLPATH$; CHR$(34)
        ENDIF

    IF ULPATH$ = "" THEN
        PRINT #2, "ulpath="; CHR$(34); "C:\DOWN"; CHR$(34)
    ELSE
        PRINT #2, "ulpath="; CHR$(34); ULPATH$; CHR$(34)
        ENDIF

    PRINT #2, "keyboard="; CHR$(34); "STANDARD.ZKY"; CHR$(34)
    PRINT #2, "translate="; CHR$(34); "STANDARD.ZTR"; CHR$(34)
    PRINT #2, "lastcall=" + NSECS$
    PRINT #2, "dosimpledial=yes"
    PRINT #2, "dialtype=0"
    PRINT #2, "zone=0"
    PRINT #2, "emu=1"
    PRINT #2, "calldue=0"
    PRINT #2, "calls=" + NCALLS$
    PRINT #2, "totaltime=0"
    PRINT #2, "totalmoney=0"
    PRINT #2, "protocol=2"
    PRINT #2, "monthmoney=0"
    PRINT #2, "deviceid=";MID$(STR$(device),2)
    PRINT #2, "qaccess=no"
    PRINT #2, "learn=no"
    PRINT #2, "first=no"
    PRINT #2, "multimaster=no"
    PRINT #2, "IemsiBits=no"
    PRINT #2, "IemsiWanted=no"
    PRINT #2, "[ENDENTRY]"
    RETURN

    END


'   Script to convert COMMO phone directory to TXZMR directory.
'   by David Rife 02-05-2001

TXZMR:
    GOSUB GETF1
    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    F2$ = "TXZMDIAL.DIR"
    OPEN F2$ FOR OUTPUT AS #2
    PRINT #2, ";-----------------------------------------------------------------------"
    PRINT #2, ";  TXZMR Dialing Directory"
    PRINT #2, ";"
    PRINT #2, ";  Enter the numbers you wish to dial beginning in column 1.  Following"
    PRINT #2, ";  each number enter a colon and the name associated with the number."
    PRINT #2, ";  Up to 10 numbers may be entered."
    PRINT #2, ";"
    PRINT #2, ";  You may also specify a modem intialization string and a dial prefix"
    PRINT #2, ";  string using the keywords 'ModemInit' and 'DialPrefix' as shown"
    PRINT #2, ";  below.  The ModemInit string may contain the following special"
    PRINT #2, ";  characters:"
    PRINT #2, ";      ^ Raises DTR     ~ One second delay      | Sends a CR"
    PRINT #2, ";      v Lowers DTR     ` 0.1 second delay      ! Embedded Wait for OK"
    PRINT #2, ";  The special characters are valid ONLY in the ModemInit string.  The"
    PRINT #2, ";  ModemInit string is sent only if a NO CARRIER condition is detected."
    PRINT #2, ";  Any part of the init string that precedes any '!' codes WILL NOT"
    PRINT #2, ";  DISPLAY on the screen when miniterm mode comes up."
    PRINT #2, ";"
    PRINT #2, ";  When TXZMR starts, it looks for an environment variable named TXZMDIAL"
    PRINT #2, ";  and, if it is found, expects it to contain the complete pathname"
    PRINT #2, ";  of this file (ex:  SET TXZMDIAL=C:\COMM\TXZMDIAL.DIR).  If the vari-"
    PRINT #2, ";  able does not exist TXZMR looks for a file named TXZMDIAL.DIR in the"
    PRINT #2, ";  current directory."
    PRINT #2, ";"
    PRINT #2, ";  Your name can be entered where indicated.  F2 will send your name."
    PRINT #2, ";"
    PRINT #2, ";  Put passwords in column 53.  F3 will send current password."
    PRINT #2, ";-----------------------------------------------------------------------"
    PRINT #2, ""
    PRINT #2, "ModemInit               :`ATZ|"
    PRINT #2, "DialPrefix              :ATDT"
    PRINT #2, "YourName                :John Smith"
    PRINT #2, ""
    WHILE NOT EOF(1)
        LINE INPUT #1, L$
        GOSUB TXZMLINE
    WEND
    PRINT #2, ""
    GOTO ALLDONE

TXZMLINE:
    GOSUB GETPARTS
    IF LEN(NAME$) < 2 THEN RETURN
    NAME$ = MID$(NAME$, 1, 24)
    NUMBER$ = MID$(NUMBER$, 1, 22)
    PWORD$ = MID$(PWORD$, 1, 10)

    WHILE INSTR(NUMBER$, CHR$(32)) > 0
        x = INSTR(NUMBER$, CHR$(32))
        IF x > 0 THEN
            N1$ = MID$(NUMBER$, 1, x - 1)
            N2$ = MID$(NUMBER$, x + 1, 14)
            NUMBER$ = N1$ + "-" + N2$
        END IF
    WEND
    PRINT #2, NUMBER$;
    IF LEN(NUMBER$) < 24 THEN
        FOR j = 1 TO 24 - LEN(NUMBER$)
            PRINT #2, CHR$(32);
        NEXT j
    END IF

    PRINT #2, ":";

    PRINT #2, NAME$;
    IF LEN(NAME$) < 27 THEN
        FOR I = 1 TO 27 - LEN(NAME$)
            PRINT #2, CHR$(32);
        NEXT I
    END IF

    PRINT #2, PWORD$;
    IF LEN(PWORD$) < 10 THEN
        FOR j = 1 TO 10 - LEN(PWORD$)
            PRINT #2, CHR$(32);
        NEXT j
    END IF
    PRINT #2, CHR$(32)
    RETURN

'   Program to convert COMMO phone directory to BCOM directory.
'   by David Rife 11-08-99

BCOM:
    GOSUB GETF1
    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    F2$ = "BCOM1.TXT"
    OPEN F2$ FOR OUTPUT AS #2

    PRINT #2, "115200 0 0 0 1 4 3 0"
    PRINT #2, "1"
    PRINT #2, "ATDT"
    PRINT #2, ""

    WHILE NOT EOF(1)
        LINE INPUT #1, L$
        GOSUB BLINE
    WEND

    GOTO ALLDONE

BLINE:

    GOSUB GETPARTS

    IF LEN(NAME$) < 2 THEN RETURN
    LNA = 20
    LPW = 10
    LNU = 18
    NAME$ = MID$(NAME$, 1, LNA)
    PWORD$ = MID$(PWORD$, 1, LPW)
    NUMBER$ = MID$(NUMBER$, 1, LNU)

    PRINT #2, NAME$;
    IF LEN(NAME$) < LNA THEN
        FOR I = 1 TO LNA - LEN(NAME$)
            PRINT #2, CHR$(32);
        NEXT I
    END IF

    PRINT #2, CHR$(32);

    PRINT #2, PWORD$;
    IF LEN(PWORD$) < LPW THEN
        FOR j = 1 TO LPW - LEN(PWORD$)
            PRINT #2, CHR$(32);
        NEXT j
    END IF

    PRINT #2, CHR$(32);

    WHILE INSTR(NUMBER$, CHR$(32)) > 0
        x = INSTR(NUMBER$, CHR$(32))
        IF x > 0 THEN
            N1$ = MID$(NUMBER$, 1, x - 1)
            N2$ = MID$(NUMBER$, x + 1, 14)
            NUMBER$ = N1$ + "-" + N2$
        END IF
    WEND

    IF LEN(NUMBER$) < LNU THEN
        FOR j = 1 TO LNU - LEN(NUMBER$)
            PRINT #2, CHR$(32);
        NEXT j
    END IF

    PRINT #2, NUMBER$;
    PRINT #2, CHR$(32);
    PRINT #2, CHR$(32);
    PRINT #2, CHR$(32)

    RETURN

    END


'   Program to convert COMMO phone directory to MyComm directory.
'   by David Rife 11-09-99

MYCOMM:
    GOSUB GETF1
    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    F2$ = "MYCOMM1.PHN"
    OPEN F2$ FOR OUTPUT AS #2

    WHILE NOT EOF(1)
        LINE INPUT #1, L$
        GOSUB MLINE
    WEND

    GOTO ALLDONE

MLINE:
    GOSUB GETPARTS

    IF LEN(NAME$) < 2 THEN RETURN

    NAME$ = MID$(NAME$, 1, 25)
    NUMBER$ = MID$(NUMBER$, 1, 23)
    PWORD$ = MID$(PWORD$, 1, 8)
    SCRIPT$ = MID$(SCRIPT$, 1, 8)

    PRINT #2, CHR$(6); CHR$(0); CHR$(0);

    PRINT #2, NAME$;
    IF LEN(NAME$) < 25 THEN
        FOR I = 1 TO 25 - LEN(NAME$)
            PRINT #2, CHR$(32);
        NEXT I
    END IF

    PRINT #2, CHR$(0);

    PRINT #2, NUMBER$;
    IF LEN(NUMBER$) < 25 THEN
        FOR j = 1 TO 25 - LEN(NUMBER$)
            PRINT #2, CHR$(32);
        NEXT j
    END IF

    PRINT #2, CHR$(0);
    PRINT #2, CHR$(8);
    PRINT #2, CHR$(8);
    PRINT #2, CHR$(0);
    PRINT #2, CHR$(1);

    PRINT #2, SCRIPT$;
    IF LEN(SCRIPT$) < 8 THEN
        FOR j = 1 TO 8 - LEN(SCRIPT$)
            PRINT #2, CHR$(32);
        NEXT j
    END IF

    PRINT #2, CHR$(0);
    PRINT #2, CHR$(1);
    PRINT #2, CHR$(6);
    PRINT #2, CHR$(0);
    PRINT #2, CHR$(1);
    PRINT #2, CHR$(0);
    PRINT #2, CHR$(0);
    PRINT #2, CHR$(1);
    PRINT #2, CHR$(1);
    PRINT #2, CHR$(0);

    PRINT #2, "David Rife^M";
    PRINT #2, CHR$(32);
    PRINT #2, CHR$(32);
    PRINT #2, CHR$(32);
    PRINT #2, CHR$(32);
    PRINT #2, CHR$(32);
    PRINT #2, CHR$(32);
    PRINT #2, CHR$(32);
    PRINT #2, CHR$(32);
    PRINT #2, CHR$(0);

    PRINT #2, PWORD$; "^M";
    IF LEN(PWORD$) < 8 THEN
        FOR j = 1 TO 8 - LEN(PWORD$)
            PRINT #2, CHR$(32);
        NEXT j
    END IF

    PRINT #2, CHR$(0);
    PRINT #2, "00/00/00";
    PRINT #2, CHR$(0);
    PRINT #2, "00:00";
    PRINT #2, CHR$(0);

    FOR j = 0 TO 48
        PRINT #2, CHR$(32);
    NEXT j

    PRINT #2, CHR$(0);

    M = M + 1

    RETURN


'   Program to convert COMMO phone directory to Lync directory.
'   by David Rife 09-08-99

LYNC:
    GOSUB GETF1
    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    F2$ = "LYNC1.PHN"
    OPEN F2$ FOR OUTPUT AS #2

    PRINT #2, "Lync 3.2 Dialing directory.";
    PRINT #2, CHR$(13); CHR$(10); CHR$(26);

    M = 0
    N1 = 75

    WHILE NOT EOF(1)
        LINE INPUT #1, L$
        GOSUB LLINE
        IF M > (N1 - 1) THEN PRINT "Too many entries.  75 max.": CLOSE : END
    WEND

    IF M < N1 THEN
        FOR K = 1 TO N1 - M
            FOR L = 1 TO 26
                PRINT #2, CHR$(0);
            NEXT L
            PRINT #2, "000-0000";
            FOR L = 1 TO 47
                PRINT #2, CHR$(0);
            NEXT L
            PRINT #2, CHR$(8);
            PRINT #2, CHR$(8);
            PRINT #2, CHR$(0);
            PRINT #2, CHR$(1);
            PRINT #2, CHR$(0);
            PRINT #2, CHR$(0);
            PRINT #2, CHR$(4);
        NEXT K
    END IF

    GOTO ALLDONE

LLINE:
    GOSUB GETPARTS
    IF NAME$ = "" THEN RETURN

    SP = 8
    IF SPEED$ = "115200" THEN SP = 8
    IF SPEED$ = "57600" THEN SP = 7
    IF SPEED$ = "38400" THEN SP = 6
    IF SPEED$ = "19200" THEN SP = 5
    IF SPEED$ = "9600" THEN SP = 4
    IF SPEED$ = "4800" THEN SP = 3
    IF SPEED$ = "2400" THEN SP = 2
    IF SPEED$ = "1200" THEN SP = 1
    IF SPEED$ = "300" THEN SP = 0

    NAME$ = MID$(NAME$, 1, 25)
    NUMBER$ = MID$(NUMBER$, 1, 30)
    PWORD$ = MID$(PWORD$, 1, 10)

    PRINT #2, NAME$;
    IF LEN(NAME$) < 25 THEN
        FOR I = 1 TO 25 - LEN(NAME$)
            PRINT #2, CHR$(0);
        NEXT I
    END IF

    PRINT #2, CHR$(0);

    PRINT #2, NUMBER$;
    IF LEN(NUMBER$) < 30 THEN
        FOR j = 1 TO 30 - LEN(NUMBER$)
            PRINT #2, CHR$(0);
        NEXT j
    END IF

    PRINT #2, CHR$(0);

    PRINT #2, PWORD$;
    IF LEN(PWORD$) < 10 THEN
        FOR j = 1 TO 10 - LEN(PWORD$)
            PRINT #2, CHR$(0);
        NEXT j
    END IF

    FOR j = 1 TO 14
        PRINT #2, CHR$(0);
    NEXT j

    PRINT #2, CHR$(SP);     ' speed
    PRINT #2, CHR$(8);      ' bits
    PRINT #2, CHR$(0);      ' parity
    PRINT #2, CHR$(1);      ' stop bits
    PRINT #2, CHR$(0);      ' echo
    PRINT #2, CHR$(0);      ' line feeds
    PRINT #2, CHR$(4);      ' protocol

    M = M + 1

    RETURN

    END


'                LYNC PHONE DIRECTORY CONTENT.

'     The header consists of the 30-character string:
'     "Lync 3.2 Dialing directory.^M^J^Z".
'     Each succeeding block of 88 characters contains one entry,
'     for a total of 75 entries.  The file size is
'     30 + 75 * 88 = 6630 characters.

'     Character  Content     Note  Number of Characters
'     ---------  ----------  ----  --------------------
'      1-25      name              25
'      26        0                 1
'      27-56     number            30
'      57        0                 1
'      58-67     password          10
'      68        0                 1
'      69-80     macro             12
'      81        0                 1
'      82        speed        1    1
'      83        bits         2    1
'      84        parity       3    1
'      85        stop bits    4    1
'      86        echo         5    1
'      87        line feeds   6    1
'      88        protocol     7    1
'
'  Notes:
'
'      1.  0 = 300
'          1 = 1200
'          2 = 2400
'          3 = 4800
'          4 = 9600
'          5 = 19200
'          6 = 38400
'          7 = 57600
'          8 = 115200
'
'      2.  7 or 8
'
'      3.  0 or 1
'
'      4.  1 or 2
'
'      5.  0 or 1
'
'      6.  0 or 1
'
'      7.  0 = Ascii
'          1 = Xmodem
'          2 = 1-k Xmodem
'          3 = Ymodem
'          4 = Zmodem

COMAND:
    GOSUB GETF1
    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    F2$ = "COM-AND1.DIR"
    OPEN F2$ FOR OUTPUT AS #2

'   This is the header, 150 bytes
    PRINT #2, "ATDT";
    PRINT #2, CHR$(0); CHR$(0);
    FOR j = 7 TO 23
        PRINT #2, CHR$(32);
    NEXT j
    PRINT #2, CHR$(0); CHR$(0); CHR$(0);
    FOR j = 27 TO 49
        PRINT #2, CHR$(32);
    NEXT j
    PRINT #2, CHR$(0); CHR$(0);
    FOR j = 52 TO 74
        PRINT #2, CHR$(32);
    NEXT j
    PRINT #2, CHR$(0); CHR$(0);
    FOR j = 77 TO 99
        PRINT #2, CHR$(32);
    NEXT j
    PRINT #2, CHR$(0); CHR$(0);
    FOR j = 102 TO 124
        PRINT #2, CHR$(32);
    NEXT j
    PRINT #2, CHR$(0); CHR$(0);
    FOR j = 127 TO 149
        PRINT #2, CHR$(32);
    NEXT j
    PRINT #2, CHR$(0);
'   end of header

    M = 0
    M1 = 100

    WHILE NOT EOF(1)
        LINE INPUT #1, L$
        GOSUB CALINE
        IF M > M1 - 1 THEN GOTO ALLDONE
    WEND

    FOR K = 1 TO M1 - M
        GOSUB CABLANK
    NEXT K
    GOTO ALLDONE

CABLANK:
    PRINT #2, "........................";
    PRINT #2, CHR$(0);
    PRINT #2, ". ... ...-....";
    PRINT #2, CHR$(0);
    PRINT #2, "Dft ";
    PRINT #2, CHR$(0);
    PRINT #2, " N81N         ";
    PRINT #2, CHR$(0);
    RETURN

CALINE:

    GOSUB GETPARTS

    IF LEN(NAME$) = 0 THEN      ' prevents writing blank first line
        IF M = 0 THEN
            RETURN
        ELSE
            GOSUB CABLANK
            RETURN
        END IF
    END IF

    NAME$ = MID$(NAME$, 1, 24)
    NUMBER$ = MID$(NUMBER$, 1, 14)
    SCRIPT$ = MID$(SCRIPT$, 1, 8)

CAWRITE:

    Z = LEN(NAME$)
    IF Z = 0 THEN
        GOSUB CABLANK
        M = M + 1
        RETURN
    END IF

    PRINT #2, NAME$;                       ' write name
    PRINT #2, CHR$(0);

    IF Z = 23 THEN PRINT #2, CHR$(0);
    IF Z = 0 THEN
        FOR I = 1 TO 23
            PRINT #2, CHR$(46);
        NEXT I
        PRINT #2, CHR$(0);
        Z = 23
    END IF
    IF Z < 23 THEN
        FOR I = 1 TO 23 - Z
            PRINT #2, CHR$(32);
        NEXT I
        PRINT #2, CHR$(0);
    END IF

    PRINT #2, NUMBER$;                       ' write number
    PRINT #2, CHR$(0);

    Z = LEN(NUMBER$)
    IF Z = 13 THEN PRINT #2, CHR$(0);
    IF Z = 0 THEN
        PRINT #2, ". ... ...-....";
        Z = 13
    END IF
    IF Z < 13 THEN
        FOR j = 1 TO 13 - Z
            PRINT #2, CHR$(32);
        NEXT j
        PRINT #2, CHR$(0);
    END IF

    SP$ = "Dft "
    IF SPEED$ = "115200" THEN SP$ = "115K"
    IF SPEED$ = "57600" THEN SP$ = "57.6"
    IF SPEED$ = "38400" THEN SP$ = "38.4"
    IF SPEED$ = "19200" THEN SP$ = "19.2"
    IF SPEED$ = "14400" THEN SP$ = "14.4"
    IF SPEED$ = "9600" THEN SP$ = "9600"
    IF SPEED$ = "4800" THEN SP$ = "4800"
    IF SPEED$ = "1200" THEN SP$ = "1200"
    IF SPEED$ = "300" THEN SP$ = "300 "
    PRINT #2, SP$;

    PRINT #2, CHR$(0);
    PRINT #2, " N81N";
    PRINT #2, CHR$(0);
    PRINT #2, SCRIPT$;
    IF LEN(SCRIPT$) < 8 THEN
        FOR j = 1 TO 8 - LEN(SCRIPT$)
            PRINT #2, CHR$(32);
        NEXT j
    END IF
    PRINT #2, CHR$(0);

    M = M + 1

    RETURN


BOYAN:
    GOSUB GETF1
    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    F2$ = "BOYAN1.FON"
    OPEN F2$ FOR OUTPUT AS #2
    F3$ = "BOYAN1.PWD"
    OPEN F3$ FOR OUTPUT AS #3

    M = 0
    M1 = 200

    WHILE NOT EOF(1)
        LINE INPUT #1, L$
        GOSUB BOLINE
        IF M > M1 THEN END
    WEND

    IF M = M1 THEN GOTO ALLDONE
    FOR K = 1 TO M1 - M
        GOSUB BOBLANK
    NEXT K
    GOTO ALLDONE

BOBLANK:
    NAME$ = ""
    NUMBER$ = ""
    PWORD$ = ""
    SCRIPT$ = ""
    GOTO BOWRITE

BOLINE:
    GOSUB GETPARTS

    IF LEN(NAME$) <= 2 THEN RETURN        ' prevents writing blank lines

    NAME$ = MID$(NAME$, 1, 29)
    NUMBER$ = MID$(NUMBER$, 1, 16)
    PWORD$ = MID$(PWORD$, 1, 14)
    SCRIPT$ = UCASE$(MID$(SCRIPT$, 1, 8))
    SCRIPT$ = ""

BOWRITE:
    PRINT #2, CHR$(255);

    Z = LEN(NAME$)
    PRINT #2, CHR$(Z);
    PRINT #2, NAME$;
    IF Z < 29 THEN
        FOR j = 1 TO 29 - Z
            PRINT #2, CHR$(32);
        NEXT j
    END IF

    Z = LEN(NUMBER$)
    PRINT #2, CHR$(Z);
    PRINT #2, NUMBER$;
    IF Z < 16 THEN
        FOR j = 1 TO 16 - Z
            PRINT #2, CHR$(32);
        NEXT j
    END IF

    Z = LEN(SCRIPT$)
    PRINT #2, CHR$(Z);
    PRINT #2, SCRIPT$;
    IF Z < 8 THEN
        FOR j = 1 TO 8 - Z
            PRINT #2, CHR$(32);
        NEXT j
    END IF

    PRINT #2, CHR$(9);
    PRINT #2, CHR$(0);
    PRINT #2, "A";
    FOR j = 1 TO 5
        PRINT #2, CHR$(250);
        NEXT j
    PRINT #2, "Z";
    FOR j = 1 TO 4
        PRINT #2, CHR$(0);
    NEXT j

    W = LEN(PWORD$)
    PRINT #3, CHR$(W);
    PRINT #3, PWORD$;
    IF W < 14 THEN
        FOR j = 1 TO 14 - W
            PRINT #3, ".";
        NEXT j
    END IF

    M = M + 1
    RETURN
'   end of Boyan section

'   Telemate

TELEMATE:
    GOSUB GETF1
    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    F2$ = "TM1.FON"
    OPEN F2$ FOR OUTPUT AS #2
    WHILE NOT EOF(1)
        LINE INPUT #1, L$
        GOSUB TMLINE
    WEND
    GOTO ALLDONE

TMBLANK:
        PRINT #2, "-";
        FOR j = 1 TO 84
            PRINT #2, CHR$(32);
        NEXT j
        PRINT #2, "   000N810     0  ..-..-.. AMNNNYNNNN0YN 11Z"
        M = M + 1
        RETURN

TMLINE:
    GOSUB GETPARTS

    IF LEN(NAME$) < 2 THEN
        IF M > 0 THEN
            GOSUB TMBLANK
            RETURN
        ELSE
            RETURN
        END IF
    END IF

    NAME$ = MID$(NAME$, 1, 28)
    NUMBER$ = MID$(NUMBER$, 1, 20)
    PWORD$ = MID$(PWORD$, 1, 16)
    SCRIPT$ = MID$(SCRIPT$, 1, 8)
    SPEED$ = MID$(SPEED$, 1, 6)

    PRINT #2, NAME$;
    IF LEN(NAME$) < 28 THEN
        FOR j = 1 TO 28 - LEN(NAME$)
            PRINT #2, CHR$(32);
        NEXT j
    END IF
    PRINT #2, CHR$(32); CHR$(32);

    PRINT #2, PWORD$;
    IF LEN(PWORD$) < 15 THEN
        FOR j = 1 TO 15 - LEN(PWORD$)
            PRINT #2, CHR$(32);
        NEXT j
    END IF
    PRINT #2, CHR$(32);

    PRINT #2, SCRIPT$;
    IF LEN(SCRIPT$) < 8 THEN
        FOR j = 1 TO 8 - LEN(SCRIPT$)
            PRINT #2, CHR$(32);
        NEXT j
    END IF

    PRINT #2, "          ";

    PRINT #2, NUMBER$;
    IF LEN(NUMBER$) < 20 THEN
        FOR j = 1 TO 20 - LEN(NUMBER$)
            PRINT #2, CHR$(32);
        NEXT j
    END IF

    PRINT #2, CHR$(32);

    x = LEN(SPEED$)
    IF x = 0 THEN
        PRINT #2, "   000N810";
    ELSE
        FOR j = 1 TO 6 - x
            PRINT #2, CHR$(32);
        NEXT j
        PRINT #2, SPEED$;
        PRINT #2, "N810";
    END IF
    PRINT #2, "     0  ..-..-.. AMNNNYNNNN0YN 11Z"
    M = M + 1
    RETURN

'   end of Telemate


'
'   Program to convert TELIX.FON file to COMMO format.
'   by David Rife 11-15-99
'
TLXTOC:
    IF F1$ = "" THEN INPUT "Source file (default c:\telix\telix.fon)"; F1$
    IF F1$ = "" THEN F1$ = "C:\TELIX\TELIX.FON"
    GOSUB ISHERE
    F2$ = "COMMOY.FON"

TOCOMMO:
    OPEN F1$ FOR BINARY AS #1
    FOR K = 1 TO 6
        I$ = INPUT$(1, 1)
    NEXT K
    N1$ = INPUT$(1, 1)
    N2$ = INPUT$(1, 1)
    FOR K = 9 TO 64                 ' discard rest of header
        I$ = INPUT$(1, 1)
    NEXT K

    M1 = 256 * ASC(N2$) + ASC(N1$)

    OPEN F2$ FOR OUTPUT AS #2

    GOSUB CHEADING
    FOR G = 1 TO M1
        NAME$ = ""
        I$ = INPUT$(1, 1)
        IF I$ = "" THEN GOTO ALLDONE
        IF ASC(I$) > 0 THEN
            IF NOT EOF(1) THEN
                GOSUB COMMO1
            ELSE
                GOTO ALLDONE
            END IF
        ELSE
            FOR j = 2 TO 86
                I$ = INPUT$(1, 1)
            NEXT j
            PRINT #2, " "
        END IF
    NEXT G
    GOTO ALLDONE

COMMO1:
    GOSUB CHECKI
    IF I1 > 31 THEN NAME$ = CHR$(32) + I$
    FOR j = 2 TO 25
        I$ = INPUT$(1, 1)
        IF I$ = "" THEN GOTO ALLDONE
        GOSUB CHECKI
        IF I1 > 31 THEN NAME$ = NAME$ + I$
    NEXT j

    NUMBER$ = ""
    FOR j = 26 TO 42
        I$ = INPUT$(1, 1)
        GOSUB CHECKI
        IF I1 > 31 THEN NUMBER$ = NUMBER$ + I$
    NEXT j

    I$ = INPUT$(1, 1)
    SP = ASC(I$)
    IF SP = 0 THEN SPEED$ = "300"
    IF SP = 1 THEN SPEED$ = "1200"
    IF SP = 2 THEN SPEED$ = "2400"
    IF SP = 3 THEN SPEED$ = "4800"
    IF SP = 4 THEN SPEED$ = "9600"
    IF SP = 5 THEN SPEED$ = "19200"
    IF SP = 6 THEN SPEED$ = "38400"
    IF SP = 7 THEN SPEED$ = "57600"
    IF SP = 8 THEN SPEED$ = "115200"

    I$ = INPUT$(1, 1)
    I2 = ASC(I$)
    PARITY$ = "N"
    IF I2 = 0 THEN PARITY$ = "N"
    IF I2 = 1 THEN PARITY$ = "E"
    IF I2 = 2 THEN PARITY$ = "O"
    IF I2 = 3 THEN PARITY$ = "M"
    IF I2 = 4 THEN PARITY$ = "S"

    I$ = INPUT$(1, 1)
    DATA$ = "8"
    I2 = ASC(I$)
    IF I2 = 6 THEN DATA$ = "6"
    IF I2 = 7 THEN DATA$ = "7"
    IF I2 = 8 THEN DATA$ = "8"
    IF I2 = 9 THEN DATA$ = "9"

    I$ = INPUT$(1, 1)
    STOP$ = "1"
    I2 = ASC(I$)
    IF I2 = 1 THEN STOP$ = "1"
    IF I2 = 2 THEN STOP$ = "2"

    MACRO$ = ""
    FOR j = 47 TO 58
        I$ = INPUT$(1, 1)
        MACRO$ = MACRO$ + I$
    NEXT j
    C = INSTR(MACRO$, CHR$(0))
    IF C > 0 THEN
        MACRO$ = MID$(MACRO$, 1, C - 1)
    END IF

    I$ = INPUT$(1, 1): LDATE$ = I$
    I$ = INPUT$(1, 1): LDATE$ = LDATE$ + I$
    LDATE$ = LDATE$ + "/"
    I$ = INPUT$(1, 1): LDATE$ = LDATE$ + I$
    I$ = INPUT$(1, 1): LDATE$ = LDATE$ + I$
    LDATE$ = LDATE$ + "/"
    I$ = INPUT$(1, 1): LDATE$ = LDATE$ + I$
    I$ = INPUT$(1, 1): LDATE$ = LDATE$ + I$

    IF INSTR(LDATE$, CHR$(0)) OR INSTR(LDATE$, CHR$(32)) THEN
        LDATE$ = "00/00/00"
    END IF


    I$ = INPUT$(1, 1)
    callnum = ASC(I$)
    I$ = INPUT$(1, 1)

    I$ = INPUT$(1, 1)
    I3 = ASC(I$)
    TERM$ = "A"
    IF I3 = 0 THEN TERM$ = "T"
    IF I3 = 1 THEN TERM$ = "A"
    IF I3 = 2 THEN TERM$ = "V"
    IF I3 = 5 THEN TERM$ = "A"

    FOR j = 68 TO 71
        I$ = INPUT$(1, 1)
    NEXT j

    prefix$ = "1"
    I$ = INPUT$(1, 1)
    PX = ASC(I$)
    IF PX = 2 THEN prefix$ = "2"
    IF PX = 3 THEN prefix$ = "3"

    PWORD$ = ""
    FOR j = 73 TO 82
        I$ = INPUT$(1, 1)
        GOSUB CHECKI
        IF I1 > 32 THEN PWORD$ = PWORD$ + I$
    NEXT j

    FOR j = 83 TO 86
        I$ = INPUT$(1, 1)
    NEXT j

    GOSUB COMMOLINE

    RETURN

COMMOLINE:
    PRINT #2, NAME$;
    FOR K = 1 TO 38 - LEN(NAME$)
        PRINT #2, CHR$(32);
    NEXT K
    PRINT #2, "{";
    PRINT #2, NUMBER$; "}";
    FOR K = 1 TO 30 - LEN(NUMBER$)
        PRINT #2, CHR$(32);
    NEXT K

    IF LDATE$ = "" THEN LDATE$ = "00/00/00"
    PRINT #2, LDATE$; "    ";

    PRINT #2, "{"; PWORD$; "}";
    FOR K = 1 TO 12 - LEN(PWORD$)
        PRINT #2, CHR$(32);
    NEXT K
    PRINT #2, "{"; MACRO$; "}";
    FOR K = 1 TO 18 - LEN(MACRO$)
        PRINT #2, CHR$(32);
    NEXT K
    IF SPEED$ = "" THEN
        PRINT #2, "{ }";
    ELSE
        PRINT #2, "{";
        PRINT #2, SPEED$; ",";
        PRINT #2, DATA$;
        PRINT #2, PARITY$;
        PRINT #2, STOP$; ",,";
        PRINT #2, TERM$;
        PRINT #2, "}";
    END IF

    IF USERNAME$ = "" THEN
        PRINT #2, " ";
    ELSE
        PRINT #2, " {username,"; USERNAME$; "}";
    END IF

    IF CONTYPE$ <> "" THEN PRINT #2, " {contype,"; CONTYPE$; "}";

    PRINT #2, " {calls,"; LTRIM$(STR$(callnum)); "}";

    IF prefix$ <> "" THEN
        PRINT #2, " {prefix,"; prefix$; "}"
    ELSE
        PRINT #2, " "
    END IF

    RETURN

CHECKI:
    I1 = ASC(I$)
    IF I1 > 31 AND I1 < 58 THEN RETURN
    IF I1 > 40 AND I1 < 91 THEN RETURN
    IF I1 > 96 AND I1 < 123 THEN RETURN
    I1 = 0
    RETURN


'   ***** COMMO to SYNCTERM
CTOSYNC:
    GOSUB GETF1
    GOSUB ISHERE
    F2$ = "SYNCT_RM.LST"


    OPEN F1$ FOR INPUT AS #1
    OPEN F2$ FOR OUTPUT AS #2


    PRINT #2, CHR$(9) + "Port           =23"
    PRINT #2, CHR$(9) + "ConnectionType =Telnet"
    PRINT #2, CHR$(9) + "DownloadPath   ="
    PRINT #2, CHR$(9) + "UploadPath     ="
    PRINT #2, CHR$(9) + "Password       ="
    PRINT #2, CHR$(9) + "ScreenMode     =80x25"
    PRINT #2, CHR$(9) + "NoStatus       =true"
    PRINT #2, CHR$(9) + "ANSIMusic      =1"
    PRINT #2, CHR$(9) + "Font           =Codepage 437 English"

WHILE NOT EOF(1)

    LINE INPUT #1, L$
    GOSUB GETPARTS
    IF NAME$ <> "" THEN
        PRINT #2, " "
        PRINT #2, "[" + NAME$ + "]"
        PRINT #2, CHR$(9) + "Address        =" + NUMBER$
        PRINT #2, CHR$(9) + "NoStatus       =true"
        PRINT #2, CHR$(9) + "Port           =23"

rem  If the number does not contain periods then Modem connection is used.
        IF INSTR(NUMBER$,".") > 0 THEN
            PRINT #2, CHR$(9) + "ConnectionType =Telnet"
        ELSE
            PRINT #2, CHR$(9) + "ConnectionType =Modem"
        ENDIF

        PRINT #2, CHR$(9) + "UserName       =" + USERNAME$
        PRINT #2, CHR$(9) + "Password       =" + PWORD$
        END IF
    WEND
    GOTO ALLDONE


'   ***** COMMO to mTelnet

MTELNET:
    GOSUB GETF1
    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    F2$ = "MTEL1.FON"
    OPEN F2$ FOR OUTPUT AS #2

    M = 0
    M1 = 200

    WHILE NOT EOF(1)
        LINE INPUT #1, L$
        IF M < M1 THEN GOSUB MTLINE
    WEND

    IF M = M1 THEN GOTO ALLDONE
    FOR j = M + 1 TO M1
        GOSUB MTBLANK
    NEXT j
    GOTO ALLDONE

MTLINE:

    GOSUB GETPARTS

    L1 = LEN(NAME$)
    IF L1 = 0 THEN RETURN

    NAME$ = MID$(NAME$, 1, 60)
    NUMBER$ = MID$(NUMBER$, 1, 60)
    PWORD$ = MID$(PWORD$, 1, 30)
    LDATE$ = MID$(LDATE$, 1, 8)
    USERNAME$ = MID$(USERNAME$, 1, 30)

    PRINT #2, CHR$(L1);
    PRINT #2, NAME$;
    IF L1 < 60 THEN
        FOR I = L1 + 1 TO 60
            PRINT #2, CHR$(0);
        NEXT I
    END IF

    L2 = LEN(NUMBER$)
    PRINT #2, CHR$(L2);
    PRINT #2, NUMBER$;
    IF L2 < 60 THEN
        FOR j = L2 + 1 TO 60
            PRINT #2, CHR$(0);
        NEXT j
    END IF

    IF LDATE$ = "00/00/00" THEN
        FOR j = 123 TO 135
            PRINT #2, CHR$(0);
        NEXT j
    ELSE
        PRINT #2, CHR$(8);
        PRINT #2, LDATE$;
        FOR j = 132 TO 135
            PRINT #2, CHR$(0);
        NEXT j
    END IF

    L3 = LEN(PWORD$)
    PRINT #2, CHR$(L3);
    PRINT #2, PWORD$;
    IF L3 < 30 THEN
        FOR j = L3 + 1 TO 30
            PRINT #2, CHR$(0);
        NEXT j
    END IF

    L4 = LEN(USERNAME$)
    PRINT #2, CHR$(L4);
    PRINT #2, USERNAME$;
    IF L4 < 30 THEN
        FOR j = L4 + 1 TO 30
            PRINT #2, CHR$(0);
        NEXT j
    END IF

    M = M + 1

    RETURN

MTBLANK:
    FOR L = 1 TO 197
        PRINT #2, CHR$(0);
    NEXT L
    RETURN

'   ***** end of mTelnet

'   ***** begin comma-delimited file section

COMMAFILE:
    GOSUB GETF1
    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    F2$ = "SITES.TXT"
    OPEN F2$ FOR OUTPUT AS #2

    PRINT #2, "; Comma-delimited file suitable for Terminate to import"
    C$ = "; Format: "
    C$ = C$ + CHR$(34) + "Name" + CHR$(34) + ","
    C$ = C$ + CHR$(34) + "Number" + CHR$(34) + ","
    C$ = C$ + CHR$(34) + "Baud" + CHR$(34) + ","
    C$ = C$ + CHR$(34) + "COM" + CHR$(34) + ","
    C$ = C$ + CHR$(34) + "Password" + CHR$(34) + ","
    C$ = C$ + CHR$(34) + "Username" + CHR$(34) + ","
    C$ = C$ + CHR$(34) + "Comment 2" + CHR$(34)
    PRINT #2, C$
    PRINT #2, " "

    WHILE NOT EOF(1)
        LINE INPUT #1, L$
        GOSUB GETPARTS
        C$ = CHR$(34) + NAME$ + CHR$(34)
        C$ = C$ + "," + CHR$(34) + NUMBER$ + CHR$(34)
        C$ = C$ + "," + CHR$(34) + SPEED$ + CHR$(34)
        C$ = C$ + "," + CHR$(34) + CHR$(34)
        C$ = C$ + "," + CHR$(34) + PWORD$ + CHR$(34)
        C$ = C$ + "," + CHR$(34) + USERNAME$ + CHR$(34)
        C$ = C$ + "," + CHR$(34) + CHR$(34)
        PRINT #2, C$
    WEND

    GOTO ALLDONE

'   ***** end comma-delimited section


'   This routine extracts the parts of a {COMMO} phone directory line.

GETPARTS:
    NAME$ = ""
    NUMBER$ = ""
    LDATE$ = ""
    PWORD$ = ""
    SCRIPT$ = ""
    SPEED$ = ""
    USERNAME$ = ""
    NCALLS$ = "0"
    prefix = 1
    device$ = "Serial"

    x = INSTR(L$, "/")
    IF x > 10 THEN LDATE$ = MID$(L$, x - 2, 8)
    IF MID$(LDATE$, 6, 1) <> "/" THEN LDATE$ = "00/00/00"

    x = 0: Y = 0
    x = INSTR(L$, "{")
    Y = INSTR(L$, "}")
    IF x = 0 THEN RETURN
    IF Y < x + 1 THEN GOTO BADSOURCE

    NAME$ = MID$(L$, 1, x - 1)              ' extract name
    NAME$ = LTRIM$(NAME$)                   ' remove left spaces
    NAME$ = RTRIM$(NAME$)                   ' remove right spaces

    NUMBER$ = MID$(L$, x + 1, Y - x - 1)    ' extract number
    NUMBER$ = LTRIM$(NUMBER$)
    NUMBER$ = RTRIM$(NUMBER$)

    B$ = MID$(L$, Y + 1)
    x = INSTR(B$, "{")
    Y = INSTR(B$, "}")
    IF x = 0 THEN RETURN
    IF Y < x + 1 THEN GOTO BADSOURCE

    PWORD$ = MID$(B$, x + 1, Y - x - 1)     ' extract password
    PWORD$ = LTRIM$(PWORD$)
    PWORD$ = RTRIM$(PWORD$)

    D$ = MID$(B$, Y + 1)
    x = INSTR(D$, "{")
    Y = INSTR(D$, "}")
    IF x = 0 THEN RETURN
    IF Y < x + 1 THEN GOTO BADSOURCE

    SCRIPT$ = MID$(D$, x + 1, Y - x - 1)     ' extract script name
    SCRIPT$ = LTRIM$(SCRIPT$)
    SCRIPT$ = RTRIM$(SCRIPT$)

    SPEED$ = ""
    B$ = MID$(D$, Y + 1)
    x = INSTR(B$, "{")
    Y = INSTR(B$, "}")
    IF x = 0 THEN RETURN
    IF Y < x + 1 THEN GOTO BADSOURCE
    SPEED$ = MID$(B$, x + 1, Y - x - 1)
    x = INSTR(SPEED$, ",")
    IF x > 1 THEN SPEED$ = MID$(SPEED$, 1, x - 1)

    x = INSTR(L$, "{username,")
    IF x > 0 THEN
        Y = INSTR(x, L$, "}")
        USERNAME$ = MID$(L$, x + 10, Y - x - 10)
    END IF

    x = INSTR(L$, "{contype,")
    IF x > 0 THEN
        Y = INSTR(x, L$, "}")
        device$ = MID$(L$, x + 9, Y - x - 9)
    END IF

    x = INSTR(L$, "{calls,")
    IF x > 0 THEN
        Z = x + 7
        Y = INSTR(x, L$, "}")
        NCALLS$ = MID$(L$, Z, Y - Z)
    ELSE
        IF LDATE$ = "00/00/00" THEN
            NCALLS$ = "0"
        ELSE NCALLS$ = "1"
        END IF
    END IF

    x = INSTR(L$, "{prefix,")
    IF x > 0 THEN
        Y = INSTR(x, L$, "}")
        prefix = VAL(MID$(L$, Y - 1, 1))
    END IF

    RETURN

BADSOURCE:
    NAME$ = ""
    NUMBER$ = ""
    PWORD$ = ""
    SCRIPT$ = ""
    SPEED$ = ""
    USERNAME$ = ""
    callnum = 0
    RETURN

'   Program to convert ZOC phonebk to COMMO type directory.
'   by David Rife
'   11-29-99

ZTOC:
    PRINT "Default source file is " + zocini$ +"."
    IF F1$ = "" THEN INPUT "What is source file if not default"; F1$
    IF F1$ = "" THEN F1$ = zocini$
    print F1$
    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    LINE INPUT #1, L$

    IF INSTR(1, L$, "ZOC 6.") THEN
        CLOSE
        PRINT "I cannot read Zoc 6.xx files."
        END
        END IF

    F2$ = "COMMOZ.FON"
    OPEN F2$ FOR OUTPUT AS #2
    GOSUB CHEADING

    IF INSTR(1, L$, "ZOC 3.") OR INSTR(1, L$, "ZOC 4.") THEN
        IF INSTR(1, L$, "ZOC 3.") THEN MAXBOOK = 3
        IF INSTR(1, L$, "ZOC 4.") THEN MAXBOOK = 5
    ELSE
        MAXBOOK = 6
    END IF
    CLOSE #1

    FOR N = 0 TO MAXBOOK
        N$ = "book=" + CHR$(48 + N)
        OPEN F1$ FOR INPUT AS #1
        PRINT #2, " ** Book "; N; "**"
        WHILE NOT EOF(1)
            LINE INPUT #1, L$
            IF (INSTR(1, L$, N$) = 1) THEN
                WHILE NOT L$ = "[ENDENTRY]"
                    LINE INPUT #1, L$
                    GOSUB extract
                WEND
                GOSUB COMMOLINE
            END IF
        WEND
        CLOSE #1
        PRINT #2, " "
    NEXT N
    GOTO ALLDONE
    END

convert:
    IF R$ = "00" THEN R$ = "": RETURN
    U$ = UCASE$(R$)
    x = 0
    FOR S = 1 TO 2
        V$ = MID$(U$, S, 1)
        GOSUB hextodec
        x = x + 16 ^ (2 - S) * V
    NEXT S
    R$ = CHR$(x)
    RETURN

hextodec:
    V = ASC(V$)
    IF V > 64 THEN V = V - 55: RETURN
    V = V - 48
    RETURN

extract:
    IF (INSTR(1, L$, "password=") = 1) THEN
        PWORD$ = ""
        IF (INSTR(1, L$, "password=x") = 1) THEN
            FOR I = 1 TO ((LEN(L$) - 12) / 2) STEP 2
                R$ = MID$(L$, I + 11, 2)
                GOSUB convert
                PWORD$ = PWORD$ + R$
            NEXT I
        END IF
        RETURN
    END IF

    A$ = CHR$(34)
    P1 = INSTR(1, L$, A$)       ' location of first quote symbol in L$
    P2 = INSTR(P1 + 1, L$, A$)  ' location of second quote symbol in L$
    P3 = INSTR(1, L$, "=")      ' location of equals sign in L$

    IF P1 > 0 AND P2 > P1 THEN
        S$ = MID$(L$, P1 + 1, P2 - P1 - 1) ' string between quote symbols
    ELSE
        S$ = MID$(L$, P3 + 1, 80)          ' string after equals sign
    END IF

    IF INSTR(L$, "name=") = 1 THEN
        NAME$ = " " + S$
        RETURN
    END IF

    IF INSTR(L$, "number=") = 1 THEN
        NUMBER$ = S$
        RETURN
    END IF

    IF INSTR(L$, "script=") = 1 THEN
        MACRO$ = S$
        RETURN
    END IF

    IF INSTR(L$, "username=") = 1 THEN
        USERNAME$ = S$
        RETURN
    END IF

    IF INSTR(L$, "deviceid=") = 1 THEN
        IF S$ = "1" THEN CONTYPE$ = "Serial Modem"
        IF S$ = "3" THEN CONTYPE$ = "Telnet"
        IF S$ = "4" THEN CONTYPE$ = "Named Pipe"
        IF S$ = "7" THEN CONTYPE$ = "Windows Modems"
        IF S$ = "8" THEN CONTYPE$ = "Rlogin"
        IF S$ = "9" THEN CONTYPE$ = "Secure Shell"
        IF S$ = "10" THEN CONTYPE$ = "Telnet/SSL"
        RETURN
    END IF


    IF ZVER = 6 THEN
        LDATE$ = "00/00/00"
        NCALLS$ = "0"
        RETURN
    END IF

    IF INSTR(L$, "lastcall=") = 1 THEN
        seconds& = VAL(S$)
        GOSUB getdate
        RETURN
    END IF

    IF INSTR(L$, "calls=") = 1 THEN
        NCALLS$ = S$
        RETURN
    END IF

    RETURN


'   Routine to convert SYNCTERM.LST to COMMOW.FON

SYNCTOC:

    F1$ = ""
    INPUT "Enter file name (default is syncterm.lst) "; F1$
    IF F1$ = "" THEN F1$ = "SYNCTERM.LST"
    F2$ = "COMMOW.FON"
    GOSUB ISHERE
    OPEN F1$ FOR INPUT AS #1
    OPEN F2$ FOR OUTPUT AS #2
    GOSUB CHEADING
    L$ = ""
    WHILE INSTR(L$, "[") = 0
        LINE INPUT #1, L$
    WEND

    WHILE NOT EOF(1)
        NAME$ = "": NUMBER$ = "": USERNAME$ = "": PWORD$ = ""
        NAME$ = MID$(L$, INSTR(L$, "[") + 1)
        NAME$ = MID$(NAME$, 1, INSTR(NAME$, "]") - 1)
        NAME$ = " " + NAME$
        L$ = ""
        WHILE INSTR(L$, "[") = 0 AND NOT EOF(1)
            LINE INPUT #1, L$
            Y = INSTR(L$, "=")
            IF Y > 0 THEN
                IF INSTR(L$, "Address") THEN NUMBER$ = MID$(L$, Y + 1)
                IF INSTR(L$, "UserName") THEN USERNAME$ = MID$(L$, Y + 1)
                IF INSTR(L$, "ConnectionType") THEN CONTYPE$ = MID$(L$, Y + 1)
                IF (INSTR(L$, "Password") > 0) AND (INSTR(L$, "SystemPassword") = 0) THEN PWORD$ = MID$(L$, Y + 1)
            END IF
        WEND
    GOSUB COMMOLINE
    WEND
    GOTO ALLDONE


'   Program to convert MTEL.FON file to COMMO format.
'   by David Rife 04-06-2000

MTELTOC:
    IF F1$ = "" THEN INPUT "Source file (default c:\mtelnet\mtel.fon)"; F1$
    IF F1$ = "" THEN F1$ = "C:\MTELNET\MTEL.FON"

    F2$ = "COMMOX.FON"
    OPEN F1$ FOR BINARY AS #1
    F = LOF(1)                      ' F is the file size in bytes
    IF F = 0 THEN
        CLOSE
        KILL F1$
        PRINT "File "; UCASE$(F1$); " not found."
        END
        END IF

    OPEN F2$ FOR OUTPUT AS #2
    GOSUB CHEADING
    FOR ROW = 1 TO 100
        GOSUB READROW
        IF NAME$ <> "" THEN GOSUB COMMOLINE
    NEXT ROW
    PRINT #2, " "                   ' Put blank line at end of commo2.fon.
    GOTO ALLDONE

READROW:
    NAME$ = ""
    NUMBER$ = ""
    PWORD$ = ""
    USERNAME$ = ""
    LDATE$ = ""
    CONTYPE$ = "telnet"

    I$ = INPUT$(1, 1): Y = ASC(I$)
    IF Y = 0 THEN
        FOR G = 2 TO 197
            I$ = INPUT$(1, 1)
        NEXT G
        RETURN
    ELSE
        NAME$ = " "
        FOR G = 1 TO Y
            I$ = INPUT$(1, 1)
            NAME$ = NAME$ + I$
        NEXT G
        FOR G = 1 TO 60 - Y
            I$ = INPUT$(1, 1)
        NEXT G
    END IF

    I$ = INPUT$(1, 1): Y = ASC(I$)
    IF Y = 0 THEN
        FOR G = 1 TO 60
            I$ = INPUT$(1, 1)
        NEXT G
    ELSE
        FOR G = 1 TO Y
            I$ = INPUT$(1, 1)
            NUMBER$ = NUMBER$ + I$
        NEXT G
        FOR G = 1 TO 60 - Y
            I$ = INPUT$(1, 1)
        NEXT G
    END IF

    I$ = INPUT$(1, 1)
    Y = ASC(I$)
    IF Y = 8 THEN
        FOR G = 1 TO 8
            I$ = INPUT$(1, 1)
            LDATE$ = LDATE$ + I$
        NEXT G
        callnum = 1
        I$ = INPUT$(1, 1)
        I$ = INPUT$(1, 1)
        I$ = INPUT$(1, 1)
        I$ = INPUT$(1, 1)
    ELSE
        FOR G = 1 TO 12
            I$ = INPUT$(1, 1)
        NEXT G
        LDATE$ = "00/00/00"
        callnum = 0
    END IF

    I$ = INPUT$(1, 1): Y = ASC(I$)
    IF Y = 0 THEN
        FOR G = 1 TO 30
            I$ = INPUT$(1, 1)
        NEXT G
    ELSE
        FOR G = 1 TO Y
            I$ = INPUT$(1, 1)
            PWORD$ = PWORD$ + I$
        NEXT G
        FOR G = 1 TO 30 - Y
            I$ = INPUT$(1, 1)
        NEXT G
    END IF

    I$ = INPUT$(1, 1): Y = ASC(I$)
    IF Y = 0 THEN
        FOR G = 1 TO 30
            I$ = INPUT$(1, 1)
        NEXT G
    ELSE
        FOR G = 1 TO Y
            I$ = INPUT$(1, 1)
            USERNAME$ = USERNAME$ + I$
        NEXT G
        FOR G = 1 TO 30 - Y
            I$ = INPUT$(1, 1)
        NEXT G
    END IF

    RETURN

HELPTEXT:
    CLS
    PRINT
    PRINT " This program will convert a COMMO phone directory to BCOM, BOYAN,"
    PRINT " COM-AND, Lync, MyComm, Procomm, Qmodem, Telemate, Telix, TXZMR, ZOC,"
    PRINT " mTelnet, a comma-delimited file, or SyncTERM. Program will also convert"
    PRINT " a SyncTERM, Telix, mTelnet, or ZOC phone directory to COMMO format. If"
    PRINT " no source file name is given, the program presents a menu.  If the"
    PRINT " source file name contains the word telix or commo, then the conversion"
    PRINT " of telix to commo or commo to telix, respectively, will proceed. Free"
    PRINT " from David Rife."

    END

REM  Routine to verify input file, F1$, is present.

ISHERE:
    OPEN F1$ FOR BINARY AS #9
    F = LOF(9)                          ' F is the file size in bytes
    CLOSE #9
    IF F = 0 THEN
        KILL F1$
        PRINT "File " + F1$ + " not found."
        END
    ELSE
        RETURN
    END IF


REM Routine to convert date string to seconds since 1/1/1970.
REM Input: LDATE$ in format mm/dd/yy.
REM Output: NSECS$

getsecs:
    IF LDATE$ = "00/00/00" THEN
        NSECS$ = "0"
        RETURN
        END IF
    M$ = MID$(LDATE$, 1, 2)
    D$ = MID$(LDATE$, 4, 2)
    Y$ = MID$(LDATE$, 7, 2)
    Y1 = VAL(Y$)
    IF Y1 > 69 THEN
        year = 1900 + Y1
    ELSE
        year = 2000 + Y1
    END IF
    M = VAL(M$)
    D = VAL(D$)
    GOSUB yeardays
    GOSUB getdoy
    seconds& = 86400 * (tdays + doy - .5)
    seconds& = INT(seconds&)
    NSECS$ = LTRIM$(STR$(seconds&))
    RETURN

yeardays:
REM   date is in year
REM   input is year
REM   output is tdays days in years from 1970 to year - 1.
    IF year < 1970 THEN PRINT "Year too small.": END
    IF year = 1970 THEN tdays = 0: RETURN
    IF year = 1971 THEN tdays = 365: RETURN
    tdays = 0
    FOR x = 1970 TO year - 1
        GOSUB adddays
    NEXT x
    RETURN

adddays:
    IF x / 400 = INT(x / 400) THEN tdays = tdays + 366: RETURN
    IF x / 100 = INT(x / 100) THEN tdays = tdays + 365: RETURN
    IF x / 4 = INT(x / 4) THEN tdays = tdays + 366: RETURN
    tdays = tdays + 365
    RETURN

getdoy:
    IF M = 1 THEN doy = D: RETURN
    GOSUB isleap
    IF LEAP = 1 THEN days$ = "312931303130313130313031"
    IF LEAP = 0 THEN days$ = "312831303130313130313031"
    IF M > 12 OR M < 1 THEN PRINT "Invalid month.": END
    IF D < 1 THEN PRINT "Invalid day.": END
    L = VAL(MID$(days$, 2 * M - 1, 2))
    IF D > L THEN PRINT "Invalid day.": END
    doy = 0
    IF M > 1 THEN
        FOR I = 1 TO M - 1
            doy = doy + VAL(MID$(days$, 2 * I - 1, 2))
        NEXT I
    END IF
    doy = doy + D
    RETURN

isleap:
    IF year / 400 = INT(year / 400) THEN LEAP = 1: RETURN
    IF year / 100 = INT(year / 100) THEN LEAP = 0: RETURN
    IF year / 4 = INT(year / 4) THEN LEAP = 1: RETURN
    LEAP = 0
    RETURN

getdate:
    IF seconds& = 0 THEN LDATE$ = "00/00/00": RETURN
    days = INT(seconds& / 86400)
    years = days / 365.25
    year = INT(1970 + years)
    GOSUB yeardays
    doy = days - tdays + 1
    GOSUB isleap
    IF LEAP = 1 THEN days$ = "312931303130313130313031"
    IF LEAP = 0 THEN days$ = "312831303130313130313031"
    month = 0
    days1 = 0
    days2 = 0

addmon:
    month = month + 1
    days1 = days2
    days2 = days2 + VAL(MID$(days$, 2 * month - 1, 2))
    IF (doy > days2) THEN GOTO addmon
    day = doy - days1
    year$ = MID$(LTRIM$(STR$(year)), 3, 2)
    IF month < 10 THEN
        month$ = "0" + LTRIM$(STR$(month))
    ELSE
        month$ = LTRIM$(STR$(month))
    END IF
    day$ = LTRIM$(STR$(day))
    IF LEN(day$) < 2 THEN day$ = "0" + day$
    LDATE$ = month$ + "/" + day$ + "/" + year$
    RETURN
    END

CHEADING:
    PRINT #2, " This directory converted from "; F1$; " on "; DATE$; "."
    PRINT #2, " "
    PRINT #2, " Alter these entries or add new ones as desired. Numbers, passwords, macros"
    PRINT #2, " and parameters must be enclosed in curly braces. The file is otherwise free"
    PRINT #2, " form. Password, macro name, and parameters are in columns 83 and higher."
    PRINT #2, ""
    PRINT #2, " NAME                                 NUMBER                          LAST CALL   PASSWORD      MACRO               PARAMETERS"
    PRINT #2, " -----------------------------------  ------------------------------  ---------  "
    RETURN

'   mTel phone directory entries.  Each field is preceded by one
'   character indicating number of used characters in following
'   field.  Five fields with their size characters gives a total of
'   197 characters per line.  The total directory size is always 100
'   entries (100 lines).  Changed to 200 entries in October 2002.
'
'   The directory file can be edited using one of the following
'   command lines:
'
'       e /b197 mtel.fon
'       edit /197 mtel.fon
'       tde -b197 mtel.fon
'
'     Entry = Record
'               Name        : String[60];
'               Number      : String[60];
'               Laston      : String[12];
'               Password    : String[30];
'               Login       : String[30];
'             End;
'

'   RECENT CHANGES

'   09-09-2008 Added SyncTERM to COMMO conversion and added ISHERE routine
'              to check if the input file, F1$, is present.
'   09-10-2008 Added initialization of strings in SYNCTOC routine.  Corrected
'              error in computing size of telix.fon file.
'   09-11-2008 Simplified computation of N2 and N1 in Telix routine.
'   11-04-2008 Added COMMO to SyncTERM conversion.
'   11-05-2008 Edited help text.
'   01-15-2009 Edited to process Zoc version 6.x files.
'   02-04-2009 Changed SyncTerm output from TEMP.FON to SYNCTERM.FON.
'   03-08-2009 Changed default source for zochosts.ini file and added
'              definition to top of this file.
'   03-15-2009 Added "dosimpledial=yes" to ZOC phome directory and corrected
'              cutting of address strings in COMMMZ.FON.  Restored choice of
'              device in COMMO to Zoc conversion.
'   03-22-2009 Minor changes to commo fon output format.
'   04-03-2009 Added contype to commo fon output files and removed duplicate
'              deviceid line in Zoc directory output.
'   04-04-2009 Added zeros to Zoc passwords; should be up to 128.
'   04-17-2009 Added CONTYPE$ to mtelnet-to-commo conversion.
'   05-06-2009 Added abort when input file is in Zoc 6.xx format.
'              The zochosts file format of Zoc 6.xx has too many changes.

