
rem  This programs converts a COMMO compatible file to a SyncTERM phone list.
rem  The output file name is CTOSYNC.LST
rem  The name must be SYNCTERM.LST to be used by SyncTERM.

rem  Free with no warranty from David Rife
rem  11-04-2008

    F$ = ""
    INPUT "What the input file name "; F$
    IF F$ = "" THEN END

    G$ = "CTOSYNC.LST"

    GOSUB ISHERE

    OPEN F$ FOR INPUT AS #1
    OPEN G$ FOR OUTPUT AS #2


    PRINT #2, CHR$(9) + "Port           =23"
    PRINT #2, CHR$(9) + "ConnectionType =Telnet"
    PRINT #2, CHR$(9) + "DownloadPath   ="
    PRINT #2, CHR$(9) + "UploadPath     ="
    PRINT #2, CHR$(9) + "Password       ="
    PRINT #2, CHR$(9) + "ScreenMode     =80x25"
    PRINT #2, CHR$(9) + "NoStatus       =true"
    PRINT #2, CHR$(9) + "ANSIMusic      =1"
    PRINT #2, CHR$(9) + "Font           =Codepage 437 English"

WHILE NOT EOF(1)

    LINE INPUT #1, L$
    GOSUB GETPARTS
    IF NAME$ <> "" THEN
        PRINT #2, " "
        PRINT #2, "[" + NAME$ + "]"
        PRINT #2, CHR$(9) + "Address        =" + NUMBER$
        PRINT #2, CHR$(9) + "NoStatus       =true"
        PRINT #2, CHR$(9) + "Port           =23"

rem  If the number does not contain periods then Modem connection is used.
        IF INSTR(NUMBER$,".") > 0 THEN
            PRINT #2, CHR$(9) + "ConnectionType =Telnet"
        ELSE
            PRINT #2, CHR$(9) + "ConnectionType =Modem"
        ENDIF

        PRINT #2, CHR$(9) + "UserName       =" + USERNAME$
        PRINT #2, CHR$(9) + "Password       =" + PWORD$
        END IF
    WEND

    PRINT G$ + " has been created from " + F$ + "."
    CLOSE
    SYSTEM
    END

'   This routine extracts the parts of a {COMMO} phone directory line.

GETPARTS:
    NAME$ = ""
    NUMBER$ = ""
    LDATE$ = ""
    PWORD$ = ""
    SCRIPT$ = ""
    SPEED$ = ""
    USERNAME$ = ""
    NCALLS$ = "0"
    prefix = 1

    x = INSTR(L$, "/")
    IF x > 10 THEN LDATE$ = MID$(L$, x - 2, 8)
    IF MID$(LDATE$, 6, 1) <> "/" THEN LDATE$ = "00/00/00"

    x = 0: Y = 0
    x = INSTR(L$, "{")
    Y = INSTR(L$, "}")
    IF x = 0 THEN RETURN
    IF Y < x + 1 THEN RETURN

    NAME$ = MID$(L$, 1, x - 1)              ' extract name
    NAME$ = LTRIM$(NAME$)                   ' remove left spaces
    NAME$ = RTRIM$(NAME$)                   ' remove right spaces

    NUMBER$ = MID$(L$, x + 1, Y - x - 1)    ' extract number
    NUMBER$ = LTRIM$(NUMBER$)
    NUMBER$ = RTRIM$(NUMBER$)

    B$ = MID$(L$, Y + 1)
    x = INSTR(B$, "{")
    Y = INSTR(B$, "}")
    IF x = 0 THEN RETURN
    IF Y < x + 1 THEN RETURN

    PWORD$ = MID$(B$, x + 1, Y - x - 1)     ' extract password
    PWORD$ = LTRIM$(PWORD$)
    PWORD$ = RTRIM$(PWORD$)

    D$ = MID$(B$, Y + 1)
    x = INSTR(D$, "{")
    Y = INSTR(D$, "}")
    IF x = 0 THEN RETURN
    IF Y < x + 1 THEN RETURN

    SCRIPT$ = MID$(D$, x + 1, Y - x - 1)     ' extract script name
    SCRIPT$ = LTRIM$(SCRIPT$)
    SCRIPT$ = RTRIM$(SCRIPT$)

    SPEED$ = ""
    B$ = MID$(D$, Y + 1)
    x = INSTR(B$, "{")
    Y = INSTR(B$, "}")
    IF x = 0 THEN RETURN
    IF Y < x + 1 THEN RETURN
    SPEED$ = MID$(B$, x + 1, Y - x - 1)
    x = INSTR(SPEED$, ",")
    IF x > 1 THEN SPEED$ = MID$(SPEED$, 1, x - 1)

    x = INSTR(L$, "{username,")
    IF x > 0 THEN
        Y = INSTR(x, L$, "}")
        USERNAME$ = MID$(L$, x + 10, Y - x - 10)
    END IF

    x = INSTR(L$, "{calls,")
    IF x > 0 THEN
        Z = x + 7
        Y = INSTR(x, L$, "}")
        NCALLS$ = MID$(L$, Z, Y - Z)
    ELSE
        IF LDATE$ = "00/00/00" THEN
            NCALLS$ = "0"
        ELSE NCALLS$ = "1"
        END IF
    END IF

    x = INSTR(L$, "{prefix,")
    IF x > 0 THEN
        Y = INSTR(x, L$, "}")
        prefix = VAL(MID$(L$, Y - 1, 1))
    END IF

    RETURN

REM  Routine to verify input file, F$, is present.

ISHERE:
    OPEN F$ FOR BINARY AS #9
    F = LOF(9)                          ' F is the file size in bytes
    CLOSE #9
    IF F = 0 THEN
        KILL F$
        PRINT "File " + F$ + " not found."
        END
    ELSE
        RETURN
    END IF


