; Template file: UNLINKED.APL
; Type         : AreaMgr
;
; This template generates a two different lists:
;
; 1 - A list of all the areas the system is not connected to
; 2 - A list of all the areas the system does not have access to
;
@assign(@bcount,0)
@assign(@count,0)
@assign(@doneheader,"No")
@areabegin
@test(@echostat,=," ")
@test(@doneheader,=,"No")
  You are not connected to the following fileechos:

  Fileecho      Description                                Avg Kb   Avg Files
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
  @just(@fileecho,L,14)@just(@echodesc,L,39) @just(@avgkb,R,9)   @just(@avgfiles,R,9)
@add(@count,1)
@add(@bcount,1)
@end
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count fileecho(s)
@end


@assign(@count,0)
@assign(@doneheader,"No")
@areabegin
@test(@echostat,=,"-")
@test(@doneheader,=,"No")
  You do not have access to the following fileechos:

  Fileecho      Description                                Avg Kb   Avg Files
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
  @just(@fileecho,L,14)@just(@echodesc,L,39) @just(@avgkb,R,9)   @just(@avgfiles,R,9)
@add(@count,1)
@add(@bcount,1)
@end
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count fileecho(s)
@end
@test(@bcount,=,0)
  You are connected to all available fileechos.
@end

---
 * Origin: use %HELP for help using the AreaMgr in ALLFIX (@akatouse)
