'+--------------------------[ PCBFiles Ver 3.00 ]----------------------------+
'|  Written By Gary Meeker 09/01/90                        Updated 11/11/94  |
'|  SYSOP: SHARP Technical Support Line BBS               Lawrenceville, GA  |
'|         (404) 962-1788                          300-28800 Baud. 24 Hours  |
'+---------------------------------------------------------------------------+
'1.00 : 09/01/90 Initial Coding
'2.00 : 07/12/93 Updated for PCBoard 15.x
'3.00 : 11/11/94 Updated for PCBoard 15.2

DEFINT A-Z

' PDQ Declarations
DECLARE FUNCTION PDQExist% (FileSpec$) ' Replace with whatever you can find
DECLARE FUNCTION PDQParse$ (Work$)
DECLARE FUNCTION PDQValI% (Number$)    ' Replace with VAL() for pure QB
DECLARE FUNCTION PDQValL& (Number$)    ' Replace with VAL() for pure QB
DECLARE SUB PDQRestore ()
DECLARE SUB SetDelimitChar (Char)

' QuickPack Declarations
DECLARE FUNCTION QPStrI$ (IntValue%)   ' Replace with STR$() for pure QB
DECLARE FUNCTION Soundex$ (Work$)
DECLARE FUNCTION TrapInt% (Value%, LoLimit%, HiLimit%)

' Myown Declarations
DECLARE FUNCTION Boolean%(Char$)
DECLARE FUNCTION EndString(Temp$, EndCh$)
DECLARE FUNCTION FindLastCh(St$, BYVAL Ch)
DECLARE FUNCTION UnSignedI% (BYVAL X&)
DECLARE FUNCTION UnSignedL& (BYVAL X%)
DECLARE SUB DEC ALIAS "_dec" (IntVar%)
DECLARE SUB DEC2 ALIAS "_decL" (LongVar&)
DECLARE SUB DecStep(IntVar%, StepVar%)
DECLARE SUB DecStepL(LongVar&, StepVar%)
DECLARE SUB INC ALIAS "_inc" (IntVar%)
DECLARE SUB INC2 ALIAS "_incL" (LongVar&)
DECLARE SUB IncStep(IntVar%, StepVar%)
DECLARE SUB IncStepL(LongVar&, StepVar%)

' Local Declarations
DECLARE FUNCTION EndChar$(St$, EndCh$)
DECLARE FUNCTION MakeExt$(St$, Ext$)
DECLARE FUNCTION FindIndex%(IndexFiles$, UserName$, SoundAlike)
DECLARE FUNCTION JulianInt2Str$(Julian)
DECLARE FUNCTION Str2JulianInt%(St$)
DECLARE FUNCTION ZeroStr$(Num)

CONST FALSE = 0 , TRUE = -1

' $INCLUDE: 'PCBTYPES.INC'

Zero = 0
DIM SHARED Days(0 TO 1, 1 TO 12)
DIM SHARED Command(1 TO 99), Macro$(1 TO 10)
DIM SHARED PCBSys AS PCBSysRecord
DIM SHARED UsersSysHdr AS UsersSysHdrRecord, UsersSys AS UsersSysRecord
DIM SHARED AliasName AS STRING * 26, Address AS UAddressRecord
DIM SHARED Notes AS UNotesRecord, Password AS UPasswordRecord
DIM SHARED Verify AS STRING * 26, Stats AS StatsRecord
DIM SHARED Account AS AccountRecord, QwkConfig AS QwkConfigRecord
DIM SHARED LMR&(Zero)
DIM SHARED ConfName(Zero) AS STRING * 14
DIM SHARED CNamesAt AS CNamesAtRecord, CNamesAdd AS CNamesAddRecord
DIM SHARED Users AS UsersRecord, UsersInf AS UsersInfRecord
DIM SHARED InfHeader AS UsersInfHdrRecord, UsersApp AS UsersAppRecord

' Function to Find User Name in PCBNDX.* files
' IndexFiles$ = Full Drive:\Path\PCBNDX.
' SoundAlike search requires QuickPack Professional SOUNDEX routine.
'            remove that portion of code for pure QB code.

FUNCTION FindIndex%(IndexFiles$, UserName$, SoundAlike)
   DIM PCBNDX AS PCBNDXRECORD
   IndexLen = LEN(PCBNDX)
   IndexFile$ = IndexFiles$ + CHR$(TrapInt(ASC(LEFT$(UserName$, 1)), 65, 90))
   IndexFileNo = FREEFILE
   FindIndex = -1
   IF PDQExist(IndexFile$) THEN
      OPEN IndexFile$ FOR RANDOM ACCESS READ SHARED AS #IndexFileNo LEN = Indexlen
         Indexes = LOF(IndexFileNo) \ IndexLen
         Test = 0
         IF Indexes < 1 THEN
         ELSEIF SoundAlike = 0 THEN         ' just ELSE for QB Code
            Jump = Indexes \ 2 + (Indexes MOD 2): Match = Jump
            DO
               Test = Test - (Jump = 1)
               Jump = Jump \ 2 + (Jump MOD 2)
               Match = TrapInt(Match, 1, Indexes)
               GET #IndexFileNo, Match, PCBNDX
               IF UserName$ = PCBNDX.UserName$ THEN
                  FindIndex = PCBNDX.Index
                  EXIT DO
               ELSEIF UserName$ < PCBNDX.UserName$ THEN
                  DecStep Match, Jump
               ELSE
                  IncStep Match, Jump
               END IF
               IF Test > 1 THEN
                  EXIT DO
               END IF
            LOOP
         ELSE
            X = INSTR(UserName$, " ")
            IF X THEN
               UserNameSnd& = PDQValL&(Soundex$(LEFT$(UserName$, X-1)))
               LastNameSnd& = PDQValL&(Soundex$(MID$(UserName$, X+1)))
            ELSE
               UserNameSnd& = PDQValL&(Soundex$(UserName$))
               LastNameSnd& = 0
            END IF

            FOR Match = SoundAlike To Indexes
               GET #IndexFileNo, Match, PCBNDX
               X = INSTR(PCBNDX.UserName$, " ")
               IF X THEN
                  MatchSnd& = PDQValL&(Soundex$(LEFT$(PCBNDX.UserName$, X-1)))
                  MatchLastSnd& = PDQValL&(Soundex$(MID$(PCBNDX.UserName$, X+1)))
               ELSE
                  MatchSnd& = PDQValL&(Soundex$(PCBNDX.UserName$))
                  MatchLastSnd& = 0
               END IF
               IF UserNameSnd& = MatchSnd& AND LastNameSnd& = MatchLastSnd& THEN
                  UserNameMatch$ = PCBNDX.UserName$
                  FindIndex = PCBNDX.Index
                  SoundAlike = Match+1
                  EXIT FOR
               END IF
            NEXT Match
         END IF
      CLOSE #IndexFileNo
   END IF
END FUNCTION

' Function to make sure a string ends with a particular Character (or string)
'  (useful for checking Paths for '\')

FUNCTION EndChar$(St$, EndCh$) STATIC
   Temp$ = RTRIM$(ST$)
   IF (LEN(Temp$) = 0) OR EndString(Temp$, EndCh$) THEN
      EndChar$ = Temp$
   ELSE
      EndChar$ = Temp$ + EndCh$
   END IF
END FUNCTION

' Function for creating a string with an identical Drive:Path\FileName but
'  with a different extension
'  (useful for obtaining a Configuration filename from the program name)

FUNCTION MakeExt$(St$, Ext$) STATIC
   ExtPos = FindLastCh(St$, 46)
   IF ExtPos THEN
      MakeExt$ = LEFT$(St$, ExtPos) + Ext$
   ELSE
      MakeExt$ = RTRIM$(St$) + "." + Ext$
   END IF
END FUNCTION

' Function to Convert an INTEGER containing the date in Julian to a
'  "MM-DD-YY" STRING

Days(0, 1) =   0   :   Days(1, 1) =   0
Days(0, 2) =  31   :   Days(1, 2) =  31
Days(0, 3) =  59   :   Days(1, 3) =  60
Days(0, 4) =  90   :   Days(1, 4) =  91
Days(0, 5) = 120   :   Days(1, 5) = 121
Days(0, 6) = 151   :   Days(1, 6) = 152
Days(0, 7) = 181   :   Days(1, 7) = 182
Days(0, 8) = 212   :   Days(1, 8) = 213
Days(0, 9) = 243   :   Days(1, 9) = 244
Days(0,10) = 273   :   Days(1,10) = 274
Days(0,11) = 304   :   Days(1,11) = 305
Days(0,12) = 334   :   Days(1,12) = 335

FUNCTION JulianInt2Str$(Julian) STATIC
   IF Julian <> 0 THEN
      Julian& = UnSignedL&(Julian)
      Year   = (100 * Julian&) \ 36525&
      Temp&  = Year * 36525&
      DayofYear = Julian& - (Temp& \ 100)

      IF (Temp& MOD 100) = 0 THEN
         INC DayOfyear
         Leap = 1
      ELSE
         Leap = 0
      END IF
      Month = 1
      FOR Counter = 2 TO 12
         IF Days(Leap, Counter) < DayOfYear THEN
            Month = Counter
         END IF
      NEXT Counter
      Day = DayOfYear - Days(Leap, Month)
   ELSE
      Year = 0
      Month = 0
      Day = 0
   END IF
   JulianInt2Str$ = ZeroStr$(Month) + "-" + ZeroStr$(Day) + "-" + ZeroStr$(Year)
END FUNCTION

' Function to Convert a "MM-DD-YY" STRING to an INTEGER containing the
'  date in Julian.

FUNCTION Str2JulianInt%(St$)
   Year  = PDQValI(RIGHT$(St$, 2)) + 1900
   Month = PDQValI(LEFT$(St$, 2))
   Day   = PDQValI(MID$(St$, 4, 2))
   JDT& = 36525& * Year
   IF (JDT& MOD 100) = 0 AND Month < 3 THEN DEC2 JDT&
   JDT& = (JDT& - (1900 * 36525&)) \ 100
   Str2JulianInt% = JDT& + Days(0, Month) + Day
END FUNCTION

' Function used in JulianInt2Str$ to return a 2 digit '0' padded number

FUNCTION ZeroStr$(Num) STATIC
   ZeroStr$ = RIGHT$("00" + LTRIM$(STR$(Num)), 2)
END FUNCTION


'   Routine to read PCBOARD.DAT file for PCBOARD 15.x

PCB$ = "PCBOARD.DAT"

FileNo = FREEFILE
OPEN PCB$ FOR INPUT ACCESS READ SHARED  AS #FileNo
   LINE INPUT #FileNo, Title$           ' PCBOARD.DAT version identification                                 1
   LINE INPUT #FileNo, SysopFName$      ' SYSOPS Display Name (if answered NO to "Use Real Name")            2
   LINE INPUT #FileNo, SysopPassword1$  ' Sysop Password (from call waiting screen)                          3
   INPUT #FileNo, UseRealName           ' Use Real Name                                                      4
   INPUT #FileNo, UseGraphics           ' Use Graphics (when logging in as the sysop)                        5
   INPUT #FileNo, Command(20)           ' Level Needed to Real All Comments                                  6
   INPUT #FileNo, Command(21)           ' Level Needed to Read All Mail Except Comments                      7
   INPUT #FileNo, Command(22)           ' Sysop Level (for Sysop Menu and F1-Temp-Sysop Upgrade)             8
   INPUT #FileNo, Command(23)           ' Level Needed to Copy or Move Messages Between Areas                9
   FOR X = 1 TO 14                 '                                                                   10
      INPUT #FileNo, Command(X)         ' Security Req'd for Sysop Function  1-14                           ~
   NEXT X                          '                                                                   23
   LINE INPUT #FileNo, HelpPath$        ' Location of Help Files                                            24
   LINE INPUT #FileNo, SecPath$         ' Location of Security Message Files                                25
   LINE INPUT #FileNo, NodeChatPath$    ' Location of NODE CHAT Files                                       26
   LINE INPUT #FileNo, PCBTextPath$     ' Location of PCBTEXT Files                                         27
   LINE INPUT #FileNo, USERSIndexPath$  ' Location of USERS File Index Files                                28
   LINE INPUT #FileNo, UsersFile$       ' Loc/Name of Users File                                            29
   LINE INPUT #FileNo, CallerFile$      ' Loc/Name of Caller Log File                                       30
   LINE INPUT #FileNo, CNamesFile$      ' Loc/Name of Conference Name File                                  31
   LINE INPUT #FileNo, PwrdFile$        ' Loc/Name of Password File                                         32
   LINE INPUT #FileNo, FSecFile$        ' Loc/Name of File Security File                                    33
   LINE INPUT #FileNo, UpSecFile$       ' Loc/Name of UPSEC File                                            34
   LINE INPUT #FileNo, TCanFile$        ' Loc/Name of Trashcan File                                         35
   LINE INPUT #FileNo, WelcomeFile$     ' Loc/Name of Welcome Screen File                                   36
   LINE INPUT #FileNo, NewUserFile$     ' Loc/Name of New User Message File                                 37
   LINE INPUT #FileNo, ClosedFile$      ' Loc/Name of CLOSED File                                           38
   LINE INPUT #FileNo, WarningFile$     ' Loc/Name of WARNING File                                          39
   LINE INPUT #FileNo, ExpiredFile$     ' Loc/Name of EXPIRED File                                          40
   LINE INPUT #FileNo, UserNetFile$     ' Loc/Name of USERNET File                                          41
   LINE INPUT #FileNo, CnfnFile$        ' Loc/Name of Conference Join Menu                                  42
   LINE INPUT #FileNo, NewAskFile$      ' Loc/Name of New Reg. Quest.                                       43
   LINE INPUT #FileNo, NewRegFile$      ' Loc/Name of Answers to New Reg.                                   44
   LINE INPUT #FileNo, PCBProtFile$     ' Loc/Name of Protocol Data File                                    45
   LINE INPUT #FileNo, DownloadFile$    ' Loc/Name of Download Summary File                                 46
   LINE INPUT #FileNo, Script0File$     ' Loc/Name of Script Quest.                                         47
   LINE INPUT #FileNo, Answer0File$     ' Loc/Name of Script Answers                                        48
   LINE INPUT #FileNo, PCBMLFile$       ' Loc/Name of Multi-Lang Data File                                  49
   LINE INPUT #FileNo, GroupFile$       ' Loc/Name of Group Chat Topic File                                 50
   INPUT #FileNo, CarrierWait           ' Seconds to wait for Carrier                                       51
   LINE INPUT #FileNo, CommPort$        ' Comm Port to use (COMx or None)                                   52
   LINE INPUT #FileNo, BaudRate$        ' Initial Port Speed                                                53
   INPUT #FileNo, LockSpeed             ' Lock Opening Speed (Fixed DTE)                                    54
   LINE INPUT #FileNo, ModemInit$       ' Modem Initialization Command String                               55
   LINE INPUT #FileNo, ModemOffHook$    ' Modem Off-Hook Command String                                     56
   INPUT #FileNo, CTSCheck              ' Disable CTS/RTS Checking                                          57
   INPUT #FileNo, HayesV                ' Using a Hayes 9600 V-Series Modem                                 58
   INPUT #FileNo, EVIFastComm           ' Using a EVI/Fastcomm Modem                                        59
   INPUT #FileNo, SoftReset             ' Perform 'Soft' Modem Reset - (ATZ) Command  During Recycle        60
   INPUT #FileNo, OffHook               ' Place Modem 'Off-Hook' During Recycle                             61
   INPUT #FileNo, Packet                ' Running Under PAD (Packet Switched) Environment                   62
   INPUT #FileNo, TrueRing              ' Answer on True Ring Detect                                        63
   INPUT #FileNo, Caller7e1             ' Allow 7,E,1 Callers                                               64
   INPUT #FileNo, AllowLowBaud          ' Allow Low Baud Rates                                              65
   LINE INPUT #FileNo, Start300$        ' Start Time of 300 Baud  (00:00 to 23:59)                          66
   LINE INPUT #FileNo, End300$          ' End Time of 300 Baud    (00:00 to 24:00)                          67
   INPUT #FileNo, MesgScan              ' Disable Message Scan Prompt                                       68
   INPUT #FileNo, ScreenClr             ' Disable 3 Minute Screen Clear                                     69
   INPUT #FileNo, RegEdit               ' Disable Registration Edits                                        70
   INPUT #FileNo, HighFilt              ' Disable High-Ascii Filter                                         71
   INPUT #FileNo, QuickLog              ' Disable Quick Logon Feature                                       72
   INPUT #FileNo, PasswordCheck         ' Disable Password Check (DOS Return)                               73
   INPUT #FileNo, MultLing              ' Multilingual Operation                                            74
   INPUT #FileNo, DenyUpdate            ' Disable Full Record Updating                                      75
   INPUT #FileNo, ClosedBoard           ' Run as a Closed Board                                             76
   INPUT #FileNo, NonGraphics           ' Run Board in Non-Graphics Mode                                    77
   INPUT #FileNo, ExitDos               ' Exit to DOS After Each Call                                       78
   INPUT #FileNo, CityChat              ' Include City in Node CHAT DIsplay                                 79
   INPUT #FileNo, ScrnSnow              ' Eliminate Screen Snow                                             80
   INPUT #FileNo, Subscription          ' Enable Subscription Operation                                     81
   INPUT #FileNo, AllowEsc              ' Allow (Esc) Codes in Messages                                     82
   INPUT #FileNo, CarbonCopy            ' Allow Carbon-Copy Messages                                        83
   INPUT #FileNo, Validate              ' Validate 'To:' Name During (E)nter a Message                      84
   INPUT #FileNo, UpdatePointer         ' (no longer used, was:  Update Msg Ptr after Read)                 85
   INPUT #FileNo, DailyLimit            ' Enforce Daily Time Limit                                          86
   INPUT #FileNo, ShowNews              ' Display NEWS File Only if Changed (-1=YES, 0=NO, 1=ALWAYS)        87
   INPUT #FileNo, CTSDrop               ' Disable CTS/RTS Drop During Disk Write                            88
   INPUT #FileNo, KBTimeout             ' Keyboard Timeout Period (0=disable)                               89
   INPUT #FileNo, Network               ' Running Under a Network / Multitasker System                      90
   INPUT #FileNo, Netnode               ' Network Node Number                                               91
   INPUT #FileNo, NetTimeout            ' Network Timeout Value (20-99 secs)                                92
   INPUT #FileNo, NodeDelay             ' Node CHAT Delay While 'Idle' (once every 5-99 secs)               93
   LINE INPUT #FileNo, BBSName$         ' BBS Name String                                                   94
   LINE INPUT #FileNo, ViewBatFile$     ' Loc/Name of Batch File for viewing files                          95
   LINE INPUT #FileNo, ARCExt$          ' Filename Extension for compressed files                           96
   FOR X = 0 TO 9                  '                                                                   97
      LINE INPUT #FileNo, Macro$(X)     ' Function Key SHIFT-Fn Macro$ 1 to 10                              ~
   NEXT X                          '                                                                  106
   LINE INPUT #FileNo, PubConf$         ' New User OPEN Conference String (not used)                       107
   INPUT #FileNo, ConfCount             ' Number of Highest Conference Desired                             108
   INPUT #FileNo, LineLimit             ' Maximum Lines in the Message Editor                              109
   INPUT #FileNo, TextColor             ' Text ANSI Color (31 - 37)                                        110
   INPUT #FileNo, Attrib                ' Test ANSI Attribute (00 or 01)                                   111
   INPUT #FileNo, EventFlag             ' Is a Timed Event Active                                          112
   LINE INPUT #FileNo, EventTime$       ' Time to Begin Event (military time)                              113
   INPUT #FileNo, EventSuspend          ' Minutes to suspend activity before event                         114
   INPUT #FileNo, AllowUploads          ' Dis-allow Uploads during suspend time                            115
   INPUT #FileNo, SlideEvent            ' Slide Event Time if a User is Online                             116
   INPUT #FileNo, UploadBuffer          ' Upload buffer Size (4-64)                                        117
   INPUT #FileNo, DriveCheck            ' Disable Drive Size Check                                         118
   INPUT #FileNo, ParallelPort          ' Parallel Port Num (1-3, 0=None)                                  119
   INPUT #FileNo, UploadLimit           ' Stop Uploads at Free Space less than xKB                         120
   FOR X = 65 TO 90                '                                                                  121
      INPUT #FileNo, Command(X)         ' Security Level for A to Z                                         ~
   NEXT X                          '                                                                  146
   INPUT #FileNo, Command(91)           ' Security Level for OPEN a DOOR                                   147
   INPUT #FileNo, Command(92)           ' Security Level for CHAT between NODEs                            148
   INPUT #FileNo, SecLevelNew           ' Level Given to Users Who Agree  to Register Security             149
   INPUT #FileNo, SecLevelRefuse        ' Level Given to Users Who Refuse to Register Security             150
   INPUT #FileNo, Command(93)           ' Security Level needed for USERS command                          151
   INPUT #FileNo, Command(94)           ' Security Level needed for WHO command                            152
   INPUT #FileNo, Command(95)           ' Security Level needed for BATCH file transfers                   153
   LINE INPUT #FileNo, ColorDefFile$    ' Name of color definition file (usually PCBFILER.DEF)             154
   INPUT #FileNo, LowBaud               ' Lowest allowed baud rate for callers (was /BAUD:xxxx)            155
   INPUT #FileNo, ModemDelay            ' Modem delay during recycle (was /DELAY:xx)                       156
   INPUT #FileNo, NumRings              ' Number of Rings before answering the phone                       157
   INPUT #FileNo, IRQNum                ' IRQ number of comm port if not COM1 or COM2                      158
   INPUT #FileNo, BaseAddress           ' BASE address of comm port if not COM1 or COM2                    159
   INPUT #FileNo, DropDTR               ' Leave DTR up at drop to DOS (some modems hangup if DTR is down   160
   INPUT #FileNo, ScrollBackBuff        ' Maximum lines in scrollback buffer (was /MAX:xxx)                161
   INPUT #FileNo, PreLoadPCBTEXT        ' Pre-load PCBTEXT file for faster access (uses more memory)       162
   INPUT #FileNo, PreLoadCNAMES         ' Pre-load CNAMES file for faster access (uses more memory)        163
   INPUT #FileNo, Command(96)           ' Security Level required for a caller to use @-variables          164
   INPUT #FileNo, FileUlBy              ' Include "Uploaded By" line in uploaded file descriptions         165
   INPUT #FileNo, ShowStats             ' Show user settings during login (was /INFO)                      166
   INPUT #FileNo, LocalShells           ' Allow local F5 shells to DOS                                     167
   INPUT #FileNo, SlaveCards            ' Use Slave Card updating (v14.2 did, v14.5 is faster without)     168
   INPUT #FileNo, SubLength             ' Default subscription length for new users                        169
   INPUT #FileNo, MaxMsgsCap            ' Maximum messages in a capture file                               170
   INPUT #FileNo, MaxmsgsConf           ' Maximum messages per conference in a capture file                171
   INPUT #FileNo, Mins2StopUl           ' Minutes prior to an event to stop uploads                        172
   INPUT #FileNo, Command(97)           ' Security Level needed to EDIT any message                        173
   INPUT #FileNo, Command(98)           ' Security Level needed to EDIT your own message                   174
   INPUT #FileNo, ShareIRQs             ' Share IRQ's on microchannel buses (for comm ports)               175
   INPUT #FileNo, ScanAllConfs          ' Default to scan ALL conferences at login                         176
   INPUT #FileNo, Command(24)           ' Level Needed to Use the 'Read Only' Command                      177
   INPUT #FileNo, AskNewAsk             ' Use NEWASK questionnaire plus standard new user questions        178
   LINE INPUT #FileNo, TempDir$         ' Location for temporary files                                     179
   LINE INPUT #FileNo, UsersInfFile$    ' Name and location of USERS.INF file                              180
   INPUT #FileNo, QuickScan             ' Default to 'Quick Scan' method on personal message scan          181
   INPUT #FileNo, WarningPeriod         ' Number of DAYS for warning prior to subscription expiration      182
   INPUT #FileNo, OneNameUsers          ' Allow ONE-name users to log onto the system                      183
   INPUT #FileNo, NewExplevel           ' Default 'Expired' Security Level                                 184
   INPUT #FileNo, Command(99)           ' Security Level to use the TEST command                           185
   LINE INPUT #FileNo, CaptureFile$     ' Name of the message CAPTURE file (or blank=caller number)        186
   INPUT #FileNo, VerifyUls             ' Perform file verification on uploads                             187
   INPUT #FileNo, MsgCapStopClk         ' Stop the clock during Message Capture download                   188
   LINE INPUT #FileNo, SysopIn$         ' Start time for sysop pages                                       189
   LINE INPUT #FileNo, SysopOut$        ' Stop time for sysop pages                                        190
   INPUT #FileNo, LogCallNum            ' Write Caller Number to callers log                               191
   INPUT #FileNo, LogConnect            ' Write Connect String to callers log                              192
   INPUT #FileNo, LogSeclevel           ' Write Caller's Security Level to callers log                     193
   INPUT #FileNo, ReadPWRD              ' Read PWRD file upon joining a conference                         194
   INPUT #FileNo, ConfirmCaller         ' Confirm caller name at logon time                                195
   INPUT #FileNo, CommentPWFail         ' Allow password failure comment                                   196
   INPUT #FileNo, LogOffWarning         ' Warning before logoff                                            197
   INPUT #FileNo, Uploadlines           ' Maximum number of lines in upload description                    198
   LINE INPUT #FileNo, ChatFile$        ' Name/Location of CHAT.DAT file                                   199
   LINE INPUT #FileNo, StatsFile$       ' Name/Location of PCBSTATS.DAT file                               200
   LINE INPUT #FileNo, ChatMenu$        ' Name/Location of CHAT menu                                       201
   LINE INPUT #FileNo, NoANSIFile$      ' Name/Location of NOANSI file                                     202
   LINE INPUT #FileNo, SlowDrives$      ' List of slow drive letters                                       203
   LINE INPUT #FileNo, SwapFile$        ' Name/Location of SWAP FILE (when swapping to disk)               204
   INPUT #FileNo, SwapOut               ' Swap out                                                         205
   INPUT #FileNo, NoBatchUl             ' Disable Batch Uploads                                            206
   INPUT #FileNo, CommentsMain          ' Force comments-to-sysop into the Main Board                       207
   INPUT #FileNo, ForeignSys            ' Foreign System - use 0Dh instead of E3h for Line Sep in msgs     208
   INPUT #FileNo, MonitorMissed         ' Monitor modem - record missed connections in callers log         209
   INPUT #FileNo, No16550               ' Force NO 16550 usage                                             210
   INPUT #FileNo, Force16550            ' Force 16550 usage                                                211
   INPUT #FileNo, ResetModemIdle        ' Reset modem while idling at the call waiting screen              212
   INPUT #FileNo, FloadNode             ' Float Node Number via USERNET information                        213
   INPUT #FileNo, UD2UBDB               ' Promote U/D commands to UB/DB when batch protocol is default     214
   INPUT #FileNo, RegPubConf            ' Automatically register new users into public conferences         215
   INPUT #FileNo, Scan4Blts             ' Scan for new bulletins during login sequence                     216
   INPUT #FileNo, CreateMsgs            ' Create MSGS file if it does not exist when joining a conference  217
   INPUT #FileNo, VerifyCDLoss          ' Verify CD Loss before recycling                                  218
   INPUT #FileNo, EncryptUsers          ' Encrypt USERS file                                               219
   INPUT #FileNo, TimeCredit            ' Upload Time Credits (default is 1.0)                             220
   INPUT #FileNo, ByteCredit            ' Upload Byte Credits (default is 0.0)                             221
   INPUT #FileNo, DefaultColor          ' Default Color, range 0-255 (overrides lines 110 and 111)         222
   INPUT #FileNo, MsgHdrLine1Color      ' Message Header Line 1 Color, range 0-255                         223
   INPUT #FileNo, MsgHdrLine2Color      ' Message Header Line 2 Color, range 0-255                         224
   INPUT #FileNo, MsgHdrLine3Color      ' Message Header Line 3 Color, range 0-255                         225
   INPUT #FileNo, MsgHdrLine4Color      ' Message Header Line 4 Color, range 0-255                         226
   INPUT #FileNo, MsgHdrLine5Color      ' Message Header Line 5 Color, range 0-255                         227
   INPUT #FileNo, MsgHdrLine6Color      ' Message Header Line 6 Color, range 0-255                         228
   LINE INPUT #FileNo, Origin$          ' ORIGIN information for netmail routing                           229
   LINE INPUT #FileNo, EventDatFile$    ' Name/Location of EVENT.DAT file                                  230
   LINE INPUT #FileNo, Events$          ' Location of EVENT files                                          231
   LINE INPUT #FileNo, CmdLstFile$      ' Name/Location of CMD.LST file                                    232
   LINE INPUT #FileNo, DOSPassword$     ' Require password to exit to DOS from Call Waiting screen         233
   INPUT #FileNo, Command(15)           ' Security Level to use Sysop Function 15                          234
   INPUT #FileNo, Command(25)           ' Security Level to use BROADCAST command                          235
   INPUT #FileNo, Command(26)           ' Security Level to view the Private Upload directory              236
   INPUT #FileNo, Command(27)           ' Security Level to enter generic messages (@user@, @##@, @##-##@) 237
   INPUT #FileNo, Command(28)           ' Security Level to edit message headers                           238
   INPUT #FileNo, Command(29)           ' Security Level to protect messages                               239
   INPUT #FileNo, Command(30)           ' Security Level to overwrite files on an upload                   240
   INPUT #FileNo, Command(31)           ' Security Level to copy/move a message to a new location          241
   INPUT #FileNo, EnvSize               ' Environment Size when shelling/swapping to DOS                   242
   INPUT #FileNo, Command(32)           ' Security Level to override the Low Baud Rate limit               243
   LINE INPUT #FileNo, AllLstFile$      ' Name/Location of ALLFILES.LST (used in place of DLPATH.LST on upl244
   LINE INPUT #FileNo, Res1$            ' Reserved                                                         245
   LINE INPUT #FileNo, Res2$            ' Reserved                                                         246
   LINE INPUT #FileNo, Res3$            ' Reserved                                                         247
   INPUT #FileNo, ReadNewMail           ' Prompt callers to read new mail                                  248
   LINE INPUT #FileNo, LogonAskFile$    ' Name/Location of LOGON Script Questionnaire                      249
   LINE INPUT #FileNo, LogonAnswerFile$ ' Name/Location of LOGON Script Questionnaire ANSWER File          250
   LINE INPUT #FileNo, QwkPacket$       ' Name of QWK Packet (root name of .QWK and .REP files)            251
   LINE INPUT #FileNo, UlTrashCan$      ' Name/Location of Upload File TRASHCAN (stop uploads of specific) 252
   INPUT #FileNo, Command(33)           ' Security Level to set an pack-out date on a message              253
   INPUT #FileNo, Command(34)           ' Security Level to be able to see Return Receipts not addressed to254
   INPUT #FileNo, SwapOnOffBatch        ' Swap during $$LOGON/$$LOGOFF batch execution                     255
   INPUT #FileNo, CreateUsersSys        ' Create USERS.SYS file for $$LOGON.BAT execution                  256
   INPUT #FileNo, DefaultMode           ' Graphics Mode default                                            257
   LINE INPUT #FileNo, SlowBatch$       ' Name of SLOW DRIVE batch file to execute after copying from slow 258
   INPUT #FileNo, ChangeAliases         ' Allow Aliases to be changed after first selecting them           259
   INPUT #FileNo, ExcludeLocal          ' Exclude local logins/downloads/etc from statistics               260
   INPUT #FileNo, ForcePwDays           ' Number of days to FORCE password change (requires Password PSA)  261
   INPUT #FileNo, WarnPwDays            ' Number of days to WARN before password change (requires Password 262
   INPUT #FileNo, RecordChat            ' Record Group Chat Sessions                                       263
   INPUT #FileNo, ShowAlias             ' Show ALIAS names in USERNET                                      264
   INPUT #FileNo, MinPwLen              ' Minimum length for passwords when the Password PSA is installed  265
   INPUT #FileNo, AllowHandle           ' Allow Handles in Group Chat
   LINE INPUT #FileNo, CmdDispDir$      ' Location of Command Display Files
   INPUT #FileNo, ForceINTRO            ' Force INTRO Display on Conference Join
   INPUT #FileNo, SkipProtcol           ' Skip Protocol Question when Registering a New User
   INPUT #FileNo, SkipAlias             ' Skip Alias Question when Registering a New User
   INPUT #FileNo, Drop2DOSonMC          ' Drop to DOS on Missed Connection
   INPUT #FileNo, OS2API                ' Use OS/2 API to Access COMx:
   INPUT #FileNo, AcctEnable            ' Accounting - Enable Accounting
   INPUT #FileNo, AcctShowCur           ' Accounting - Show Currency
   INPUT #FileNo, AcctConcurrent        ' Accounting - Concurrent Tracking
   LINE INPUT #FileNo, AcctPeakStart    ' Accounting - Peak Usage Start Time
   LINE INPUT #FileNo, AcctPeakStop     ' Accounting - Peak Usage Stop Time
   LINE INPUT #FileNo, AcctCfgFile      ' Accounting - Name/Location of Configuration File
   LINE INPUT #FileNo, AcctInfoFile     ' Accounting - Name/Location of INFO file
   LINE INPUT #FileNo, AcctWarnFile     ' Accounting - Name/Location of WARN File
   LINE INPUT #FileNo, AcctTrackFile    ' Accounting - Name/Location of Tracking file
   LINE INPUT #FileNo, AcctLogoffFile   ' Accounting - Name/Location of LOGOFF File
   LINE INPUT #FileNo, UUCPBasePath     ' UUCP - Base Path
   LINE INPUT #FileNo, UUCPSpoolDir     ' UUCP - Spool Directory
   LINE INPUT #FileNo, UUCPLogFileDir   ' UUCP - Log File Directory
   LINE INPUT #FileNo, UUCPCompress     ' UUCP - Compress Batch File
   LINE INPUT #FileNo, UUCPDeCompress   ' UUCP - Decompress Batch File
   LINE INPUT #FileNo, UUCPName         ' UUCP - Name
   LINE INPUT #FileNo, UUCPDomain       ' UUCP - Domain Name
   LINE INPUT #FileNo, UUCPEMailHost    ' UUCP - Email Host
   LINE INPUT #FileNo, UUCPNewsHost     ' UUCP - News Host
   LINE INPUT #FileNo, UUCPNewsDist     ' UUCP - News Distribution
   LINE INPUT #FileNo, UUCPTimeZone     ' UUCP - Time Zone Offset from GMT
   LINE INPUT #FileNo, UUCPSeparator    ' UUCP - Name Separator
   LINE INPUT #FileNo, UUCPOrg          ' UUCP - Organization
   LINE INPUT #FileNo, UUCPASCII        ' UUCP - High Ascii Filter
   LINE INPUT #FileNo, UUCPEMailConf    ' UUCP - Internet Email Conference
   LINE INPUT #FileNo, UUCPJunkConf     ' UUCP - Usenet Junk Conference
   LINE INPUT #FileNo, UUCPBangDom      ' UUCP - Bang Domain
   LINE INPUT #FileNo, UUCPSubDom       ' UUCP - Sub Domain
   INPUT #FileNo, FidoAllowIncoming     ' Fido - Allow Node to Process Incoming Packets
   INPUT #FileNo, FidoAllowOrphan       ' Fido - Allow Node to Process Orphan Packets
   INPUT #FileNo, FidoExport            ' Fido - Allow Node to Export Mail
   INPUT #FileNo, FidoDialOut           ' Fido - Allow Node to Dial Out
   INPUT #FileNo, FidoScanInbound       ' Fido - Frequency of Scan for Inbound Packets
   INPUT #FileNo, FidoScanExport        ' Fido - Frequency of Scan for Mail to Export
   INPUT #FileNo, FidoScanOutbound      ' Fido - Frequency of Scan for Outbound Packets
   LINE INPUT #FileNo, FidoDialOutStart ' Fido - Allowed Dial Out Start Time
   LINE INPUT #FileNo, FidoDialOutStop  ' Fido - Allowed Dial Out End Time
   LINE INPUT #FileNo, AcctPeakDays     ' Accounting - Peak Days
   LINE INPUT #FileNo, AcctHolidays     ' Accounting - Holidays File
   LINE INPUT #FileNo, UUCPModerator    ' UUCP - Moderator File
   LINE INPUT #FileNo, ModemInit2$      ' Modem Initialization String #2
   LINE INPUT #FileNo, ModemAns$        ' Modem Answer String
CLOSE #FileNo


'   Routine to read PCBOARD.SYS file for PCBOARD 15.x

PSysFile$ = "PCBOARD.SYS"
FileNo = FREEFILE
OPEN SysFile$ FOR ACCESS READ SHARED BINARY AS #FileNo
   GET #FileNo,, PCBSys
   IF ConfCount > 39 THEN               'ConfCount from PCBOARD.DAT Line 108
      ExtConfLen = ((ConfCount + 1) \ 8) - (((ConfCount + 1) MOD 8) <> 0) - 5
      ExtConfJoined$ = STRING$(ExtConfLen, 0)
      ExtConfScaned$ = STRING$(ExtConfLen, 0)
      GET #FileNo, , ExtConfJoined$
      GET #FileNo, , ExtConfScaned$
   END IF
   NodeNum = ASC(PCBSys.NodeNum)
   IF NodeNum = 255 THEN
      GET #FileNo, LOF(FileNo) - 2, NodeNum
   END IF
CLOSE #FileNo


'   Routine to read USERS.SYS file for PCBOARD 15.x

USysFile$ = "USERS.SYS"

FileNo = FREEFILE
OPEN USysFile$ FOR BINARY ACCESS READ WRITE SHARED AS #FileNo
   GET #FileNo, , UsersSysHdr
   GET #FileNo, , UsersSys
   AliasSupport = Boolean(INPUT$(1, #FileNo))
   GET #FileNo, , AliasName
   AddressSupport = Boolean(INPUT$(1, #FileNo))
   GET #FileNo, , Address
   PasswordSupport = Boolean(INPUT$(1, #FileNo))
   GET #FileNo, , Password
   VerifySupport = Boolean(INPUT$(1, #FileNo))
   GET #FileNo, , Verify
   StatsSupport = Boolean(INPUT$(1, #FileNo))
   GET #FileNo, , Stats
   NotesSupport = Boolean(INPUT$(1, #FileNo))
   GET #FileNo, , Notes
   AccountSupport = Boolean(INPUT$(1, #FileNo))
   GET #FileNo, , Account
   QwkSupport = Boolean(INPUT$(1, #FileNo))
   GET #FileNo, , QwkConfig

'  We should be pointing to LMR's but make sure in case things change
   SEEK #FileNo, UsersSysHdr.SizeOfRec + 41

   NumOfAreas& = UnSignedL&(UsersSysHdr.NumOfAreas)
   REDIM LMR&(0 TO NumOfAreas& - 1)
'  To get the Last Message Read Pointers using QB
   FOR X& = 0 TO NumOfAreas& - 1
      GET #FileNo, , LMR&(X&)
   NEXT X&

'  To get the Last Message Read Pointers using QPPRO
'  Handle = FILEATTR(1,2)
'  FGetAH2 Handle, LMR&(0), 4, UsersSysHdr.NumOfAreas

'  If you don't want to read the LMR's you skip them
'  SEEK #FileNo, UsersSysHdr.SizeOfRec + 41 + 4 * NumOfAreas&

   AreaReg$     = STRING$(UsersSysHdr.SizeOfBitFields, 0)
   ExpAreaReg$  = STRING$(UsersSysHdr.SizeOfBitFields, 0)
   UserScan$    = STRING$(UsersSysHdr.SizeOfBitFields, 0)
   ConfSysop$   = STRING$(UsersSysHdr.SizeOfBitFields, 0)
   MailWaiting$ = STRING$(UsersSysHdr.SizeOfBitFields, 0)
   ConfJoined$  = STRING$(UsersSysHdr.SizeOfBitFields, 0)
   ConfScanned$ = STRING$(UsersSysHdr.SizeOfBitFields, 0)
   GET #FileNo, ,AreaReg$
   GET #FileNo, ,ExpAreaReg$
   GET #FileNo, ,UserScan$
   GET #FileNo, ,ConfSysop$
   GET #FileNo, ,MailWaiting$
   GET #FileNo, ,ConfJoined$
   GET #FileNo, ,ConfScanned$

'  Again make sure we know where we are!
   SEEK #FileNo, UsersSysHdr.SizeOfRec + 41 + 4 * NumOfAreas& + _
            UsersSysHdr.NumOfBitFields * UsersSysHdr.SizeOfBitFields

'  TPA Static & Dynamic would be here

CLOSE #FileNo


'   Routine to read Conference names from CNAMES.@@@ for PCBOARD 15.x

' CNamesFile$ from PCBOARD.DAT Line 31

FileNo = FREEFILE
OPEN CNamesFile$ FOR BINARY ACCESS READ SHARED AS #FileNo
   GET #FileNo, 1, CNamesRecLen
   RecLen& = CNamesRecLen
   MsgBases = (LOF(FileNo) - 2) \ CNamesRecLen
   REDIM ConfName(0 TO MsgBases - 1) AS STRING * 14
   FOR X = 0 TO MsgBases - 1
      GET #FileNo, X * RecLen& + 3, ConfName$(X)
   NEXT X
CLOSE #FileNo


'   Routine to read CNAMES.@@@ & CNAMES.ADD files for PCBOARD 15.x

' ConfNum would contain the desired Conference to read/Write

FileNo = FREEFILE
OPEN CNamesAtFile$ FOR BINARY ACCESS READ WRITE SHARED AS #FileNo
   GET #FileNo, 1, CNamesRecLen
   GET #FileNo, UnSignedL&(ConfNum) * CNamesRecLen + 3, CNamesAt
'  PUT #FileNo, UnSignedL&(ConfNum) * CNamesRecLen + 3, CNamesAt
CLOSE #FileNo

PRINT "ConferenceName: "; CNamesAt.ConfName$

FileNo = FREEFILE
OPEN CNamesAddFile$ FOR RANDOM ACCESS READ WRITE SHARED AS #FileNo LEN = 256
   GET #FileNo, ConfNum + 1, CNamesAdd
'  PUT #FileNo, ConfNum + 1, CNamesAdd
CLOSE #FileNo

PRINT "Conference Intro File: "; CNamesAdd.Intro$


'   Routine to read USERS & USERS.INF files for PCBOARD 15.x

' UserNum would contain the desired User record to read/Write

' UsersFile$ from PCBOARD.DAT Line 29
' UsersInfFile$ from PCBOARD.DAT Line 180


UsersLen    = LEN(Users)
FileNo = FREEFILE
OPEN UsersFile$ FOR RANDOM ACCESS READ WRITE SHARED AS #FileNo LEN = UsersLen
   Recs = CINT(LOF(FileNo) \ UsersLen)
   GET #FileNo, UserNum, Users
'  PUT #FileNo, UserNum, Users
CLOSE #FileNo

FileNo = FREEFILE
OPEN UsersInfFile$ FOR BINARY ACCESS READ WRITE SHARED AS #FileNo
   GET #FileNo, 1, InfHeader
   NumofApps& = UnSignedL&(InfHeader.NumofApps)
   HeaderSize& = NumofApps& * LEN(UsersApp) + LEN(InfHeader) + 1&
   Pointer& = HeaderSize& + (Users.UsersInfPointer& - 1&) * InfHeader.TotalRecSize&
   GET #FileNo, Pointer&, UsersInf
'  PUT #FileNo, Pointer&, UsersInf
CLOSE #FileNo


'   Routine to read PWRD file for PCBOARD 15.x

SetDelimitChar 44       ' Set delimiter to commas
FileNo = FREEFILE
OPEN PCB$ FOR INPUT ACCESS READ SHARED AS #FileNo
   TimeLimit = 0
   DO WHILE NOT EOF(FileNo)
      LINE INPUT #FileNo, A$
      PDQRestore
      Password$ = PDQPares$(A$)
      SecLev = PDQValI(PDQPares$(A$))
      IF SecLev = UserSecLev AND (Password$ = TargetPassword$ OR (LEN(Password$) = 0)) THEN
         TimeLimit& = PDQValL&(PDQPares$(A$))
         DailyKByteLimit& = PDQValL&(PDQPares$(A$))
         BaseBaudRate& = PDQValL&(PDQPares$(A$))
         BatchLimit = PDQValI(PDQPares$(A$))
         FileRatio = PDQValI(PDQPares$(A$))
         ByteRatio& = PDQValL&(PDQPares$(A$))
         TotalFileLimit = PDQValI(PDQPares$(A$))
         TotalKByteLimit& = PDQValL&(PDQPares$(A$))
         EnforceTimeLimit = Boolean((PDQPares$(A$))
         AllowAlias = Boolean((PDQPares$(A$))
         ForceRead = Boolean((PDQPares$(A$))
         MultipleUsers = Boolean((PDQPares$(A$))
         VerifyCaller = Boolean((PDQPares$(A$))
         FileRatioCredits = PDQValI(PDQPares$(A$))
         KByteRatioCredits& = PDQValL&(PDQPares$(A$))
         AcctEnabled$ = PDQParse$(A$)   '(Y = yes, N = No, T = Tracking Only)
         EXIT DO
      END IF
   LOOP
CLOSE #FileNo

IF TimeLimit& = 0 THEN
   ' Do whatever
END IF
