(*-------------------------------------------------------------------*)
(*  Santronics Software, Co.                                         *)
(*  30034 SW 153 Ct.                                                 *)
(*  Leisure City, FL  33033                                          *)
(*  hector@santronics.com                                            *)
(*                                                                   *)
(*           Silver Xpress OPX Mail Packet Specifications            *)
(*                                                                   *)
(*        (C) Copyright 1988-2000, Santronics Software, Inc          *)
(*                     All Rights Reserved                           *)
(*                                                                   *)
(* These data structures are owned by SSI and no change can be made  *)
(* with the consent and permission from SSI.  The specification is   *)
(* release to the public domain for commercial and non-commercial    *)
(* usage.  No legal request is required to use these formats for     *)
(* OPX implementation. However, all implementations must retain a    *)
(* SSI copyright in their source code indicating the copyrighted     *)
(* usage of the OPX specification.                                   *)
(*-------------------------------------------------------------------*)

{$A-}   {byte aligned}

unit opxlib;

interface

uses fidofmt;

(* OPX Mail Structure *)

(*
  This are Max limits. Most are still used but there might be situations
  where there are no limits, like the _maxAKA is used only for backward
  compatibility with 228 readers. But other methods may are used to get
  more AKAs for newer OPX formats.
*)

Const _maxAka       = 5;      (* MUST BE FIVE FOR 2.28 Reader support *)
      _maxgroups    = 10;     (* maximum # of groups                  *)
      _maxkeywords  = 20;     (* maximum # of keywords                *)
      _MaxArchivers = 10;
      _MaxProtocols = 10;
      _MaxBulletins = 10;
      _MaxFreq      = 10;
      _MaxFatt      = 10;
      _MaxServices  = 10;

(*
   List of bulletins sent by the SX mail door
*)

Type
     TBullFileName  = string[12];
     TBullListType  = array[1.._maxbulletins] of TBullFileName;

(*
   Structure of Element Record used in Virtual Memory File (VMF)
   MAIL.FDX.   The VMF API is based on a Turbo Pascal 16 bit API.
   When creating an VMF, you provide the "size" of the array
   element. i.e, sizeof(TMailFDXType). and the API has functions
   to SetElement(row,column,Data), PutElement(row,column,Data).
   C programmers, see the MAILFDX.C example program.
*)

Type TMailFDXType = Record
      iarea   : word;      (* area number *)
      inum    : word;      (* msg number (or index) *)
      istype  : char;      (* 'D' Direct, 'K' Keyword, or ' ' *)
      response: byte;      (* response flags, see below *)
      flags   : byte;      (* see _mailgrp_XXXXX flags *)
      fpos    : longint;   (* offset to MAIL.DAT TMailHdrType Records *)
     end;

(*
  Fast Lookup index file to the BEGINNING Of each area.  This will
  only work when the SX mail door creates MAIL.DAT in "Conference
  Sorted Order".
*)

Type TMailIdxType = Record                    (* MAIL.IDX *)
      Area      :  word;
      Fpos      :  longint;
      reserved  :  array[1..8] of byte;
     end;

(*
    Message Header for each Message in MAIL.DAT.   MAIL.DAT is
    structured as follows:

            TMailHdrType             msg 1
              TFidoMsgType
              message body
            TMailHdrType             msg 2
              TFidoMsgType
              message body
            .
            .
            TMailHdrType             msg N
              TFidoMsgType
              message body
*)

Type  TMailHdrType  =    record
       inum        : word;       (* msg number (or index) *)
       iarea       : word;       (* area number *)
       fsize       : word;       (* size of msg *)
       reserved1   : byte;
       istype      : char;       (* 'D' Direct, 'K' Keyword, or ' ' *)
       reserved2   : longint;
       reserved3   : word;
      end;

Type TBrdInfoExtraType = record
       KillYear             : byte;
       KillMonth            : byte;
       Killday              : byte;
       Regcode              : string[10];
       registered           : boolean;
       force_clone          : boolean;
       msg_limit            : word;
       attempts             : word;
       FaxArea              : Integer;
       TimeStamp            : Longint;
       BBSModelID           : string[5];
       Extended_Zone_fields : Boolean;
       Times                : Word;
       AkaZone              : Array[1.._MaxAka] of Word;
       AkaNet               : Array[1.._MaxAka] of Word;
       AkaNode              : Array[1.._MaxAka] of Word;
       AkaPoint             : Array[1.._MaxAka] of Word;
       AkaDomain            : Array[1.._MaxAka] of String[15];
       Forwarding_Allowed   : boolean;      (* Reader 2.29 *)
       Dnload_Allowed       : Byte;
       Upload_Allowed       : Byte;
       rdrpassword          : string[10];
       doorpassword         : string[10];
       urdrbits             : byte;
       MHSUserName          : string[8];
       NewRegCode           : longint;
       __reserved1          : array[1..5] of byte;
       __reserved2          : array[1..9] of byte;
       offline_support      : boolean;
       Alias                : String[35];  (* RESERVED 211 *)
       XAM_Available        : Boolean;     (* RESERVED 211 *)
       Credit               : Word;        (* RESERVED 211 *)
       Debit                : Word;        (* RESERVED 211 *)
       Use_Extended_Areas   : Boolean;
       No_Sysop_Convert     : Boolean;
       DoorVersion          : String[10];
       NetMailFlags         : Word;
       BBSPhone             : String[20];
       uucp_zone            : word;        (* UUCP routing fido host *)
       uucp_net             : word;
       uucp_node            : word;
       Attribute            : longint;
       BBSPackage           : String[25];
       reserved             : array[1..98] of byte;
      end;


(* structure of fix header in BRDINFO.DAT *)

Type TBrdInfoType = Record
       checksum              : longint;      (* can be ignored *)
       Door_Version          : string[10];
       BBS_Version           : string[20];
       packet_id             : String[8];
       BBS_Name              : string[60];
       sysop_name            : string[50];
       origin                : string[80];
       zone_str              : string[6];
       net_str               : string[6];
       node_str              : string[6];
       brdinfo_extra         : TBrdInfoExtraType;
       UsrName               : string[35];
       access_level          : word;
       TimeZone              : String[18];
       total_areas           : word;
       freq_limit            : byte;
       allow_taglines        : boolean;
       total_msg_allowed     : word;
       total_bulletins       : byte;
     end;

Type  TBrdMailIdxType = Record         (* last part of BRDINFO.DAT  *)
       iarea    : word;
       Inumber  : word;
       istype   : char;
      end;

Type TConfRecType = Record               (* conference information record *)
       access   : word;                 (* access level *)
       oldarea  : byte;                 (* area number. old *)
       title    : string[70];           (* short/long title *)
       extarea  : integer;              (* area number if not -1 *)
       reserved : byte;
       xpattrib : word;                 (* Xpress Attrib Translation   *)
       attribnew: word;                 (* NEW ATTRIBUTES FOR MAX/OPUS *)
       rdrselect: boolean;              (* for reader selection *)
       RdrBits  : Byte;                 (* door misc settings. see below*)
       Xflags   : Byte;                 (* AreaXpress Flags. See Below *)
       selected : boolean;              (* if selected by user *)
       attrib   : byte;                 (* type of area. OLD Fido Attribute *)
                                        (* Will always have LO(attribnew) *)
     end;

implementation
end.
