//********************************************************
// (c) Copyright 1999-2000 Santronics Software, Inc.
//               All Rights Reserved.
//********************************************************
//
// File Name : mailfdx.c
// Date      : 01/27/2000
// Author    : SSI
//
// Virtual Memory File Structures and reading example for
// the Silver Xpress's MAIL.FDX file
//
// example usage:  mailfdx mail.fdx
//
//********************************************************

#include <stdio.h>

#pragma pack(1)

#define byte  unsigned char
#define word  unsigned short
#define ulong unsigned long

/* VASHEADER: The following is the header for a MAIL.FDX file */

typedef struct _VASHEADER {
  word RowsInPage;       // number of VAS records
  word ColsInPage;       // always 1
  word PagesDown;        // number of pages
  word PagesAcross;      // number of pages across
  word ElSize;           // size of element, ie, sizeof(MAILFDXTYPE)
  word PageSize;         // bytes of data in one page
  word PageCount;        // number of pages in entire array
  ulong NextAvail;       // Next file position for new page
  byte ID[7];            // MUST BE  0x06VARRAY
} VASHEADER, *PVASHEADER;

/*
  MAILFDXTYPE: each record is a direct 1 to 1 correspondence
               to the MAIL.DAT file.
*/


typedef struct _MAILFDXTYPE {
  word iarea;             // area number msg belongs too
  word inum;              // msg number
  char istype;            // 'D' Direct, 'K' Keyword, or ' '
  byte resp;              // response, see flags below
  byte flags;             // see action flags below
  ulong fpos;             // byte offset to MAIL.DAT Xpress header
} MAILFDXTYPE, *PMAILFDXTYPE;

/* response flags */

#define _already_read  0x01  // set when read by reader
#define _reply_exist   0x02  // set if reader create a reply
#define _search_msg    0x04  // set if this is a message is a search hit

/* action flags - used internally for search system */

#define  _mailgrp_kill   0x01
#define  _mailgrp_file   0x02
#define  _mailgrp_print  0x04
#define  _mailgrp_read   0x08
#define  _mailgrp_urgent 0x10
#define  _mailgrp_tagged 0x20
#define  _mailgrp_dos    0x40

void main (int argc, char *argv[])
 {
   FILE         *fv;
   VASHEADER    VAShdr;
   MAILFDXTYPE  mailfdx;
   ulong        pofs;
   int          i,j;

   printf("sizeof of VASHDR [%d]\n",sizeof(VASHEADER));


   if ( (fv=fopen(argv[1],"r+b")) == NULL ) {
     printf("File [%s] not found",argv[1]);
     return;
   }
   fread(&VAShdr,sizeof(VAShdr),1,fv);

   if (VAShdr.ID[0] != 0x06) {
     printf("NOT A XPRESS MAIL.FDX FILE [%2X]",VAShdr.ID[0]);
     fclose(fv);
     return;
   }

   printf("RowsInPage  [%4u]\n",VAShdr.RowsInPage);
   printf("ColsInPage  [%4u]\n",VAShdr.ColsInPage);
   printf("PagesDown   [%4u]\n",VAShdr.PagesDown);
   printf("PagesAcross [%4u]\n",VAShdr.PagesAcross);
   printf("ElSize      [%4u]\n",VAShdr.ElSize);
   printf("PageSize    [%4u]\n",VAShdr.PageSize);
   printf("PageCount   [%4u]\n",VAShdr.PageCount);
   printf("NextAvail   [%4lu]\n\n",VAShdr.NextAvail);

   for (i=0;i<VAShdr.PageCount;i++) {
     fseek(fv,sizeof(VASHEADER)+(long)4*i,SEEK_SET);
     fread(&pofs,1,4,fv);
     fseek(fv,pofs,SEEK_SET);
     for (j=0;j<VAShdr.RowsInPage;j++) {
     fread(&mailfdx,sizeof(MAILFDXTYPE),1,fv);
     printf("area [%4d] msg# [%4d] type [%c] resp [%04X]" //
            " flags [%04X] fpos [%5lu]\n",
            mailfdx.iarea,
            mailfdx.inum,
            mailfdx.istype,
            mailfdx.resp,
            mailfdx.flags,
            mailfdx.fpos
           );
     }
   }
 }

