{$A-}
UNIT FIDOFMT;

INTERFACE

type  char35  = array[0..35] of char;
      char71  = array[0..71] of char;
      char19  = array[0..19] of char;

Type TFidoMsgType =
    record
      from         : char35;     (* 0                                     *)
      towhom       : char35;     (* 35                                    *)
      subject      : char71;     (* 71                                    *)
      date         : char19;     (* 142 ASCII date information            *)
      dest_zone    : word;       (* 164 DEST ZONE                    !SX! *)
      dest_node    : word;       (* 166 Destination node                  *)
      orig_node    : word;       (* 168 Origination node number           *)
      orig_zone    : word;       (* 170 ORIG ZONE.                   !SX! *)
      orig_net     : word;       (* 172 Origination network number        *)
      dest_net     : word;       (* 174 Destination network number        *)
      date_written : longint;    (* 176 When user wrote the msg           *)
      date_arrived : longint;    (* 180 When msg arrived on-line          *)
      reply        : word;       (* 184 msg is a reply to this msg #      *)
      attr         : word;       (* 186 Attribute (behavior) of the msg   *)
      up           : word;       (* 188 Next message in the thread        *)
    end;

(*--------------------------------------------------------------------------*)
(* Message attributes                                                       *)
(*--------------------------------------------------------------------------*)

Const MSGPRIVATE  = $0001; (* For addressee *ONLY*    * 0000 0000 0000 0001 *)
Const MSGCRASH    = $0002; (* High priority           * 0000 0000 0000 0010 *)
Const MSGREAD     = $0004; (* Was read by addressee   * 0000 0000 0000 0100 *)
Const MSGSENT     = $0008; (* Was sent by FidoMail      0000 0000 0000 1000 *)
Const MSGFILE     = $0010; (* SUBJ=file(s) to send    * 0000 0000 0001 0000 *)
Const MSGFWD      = $0020; (* Msg from & to elsewhere   0000 0000 0010 0000 *)
Const MSGORPHAN   = $0040; (* Msg destination unknown   0000 0000 0100 0000 *)
Const MSGKILL     = $0080; (* Delete after sending    * 0000 0000 1000 0000 *)
Const MSGLOCAL    = $0100; (* Msg is Local, not Net     0000 0001 0000 0000 *)
Const MSGHOLD     = $0200; (* Hold msg for pickup     * 0000 0010 0000 0000 *)
Const MSGJUNKMAIL = $0400; (* SX: JunkMail           X? 0000 0100 0000 0000 *)
Const MSGFRQ      = $0800; (* SUBJ=file(s) to get     * 0000 1000 0000 0000 *)
Const MSGRRQ      = $1000; (* Msg Receipt requested  X* 0001 0000 0000 0000 *)
Const MSGCPT      = $2000; (* Msg is a Msg Receipt   X* 0010 0000 0000 0000 *)
Const MSGARQ      = $4000; (* Audit Trail requested  X* 0100 0000 0000 0000 *)
Const MSGSXFORM   = $4000; (* SX FORM MESSAGE         ? 0100 0000 0000 0000 *)
Const MSGURQ      = $8000; (* SUBJ=files(s) to UPD   X* 1000 0000 0000 0000 *)
                                                 (*------------------------*)
                                                 (* ^^                     *)
                                                 (* ||                     *)
                                                 (* ||* = preserved by     *)
                                                 (* ||    the network      *)
                                                 (* ||? = stripped by the  *)
                                                 (* |     net (FTSC spec)  *)
                                                 (* |     but preserved    *)
                                                 (* |     by seadog<tm>    *)
                                                 (* |X  = not used by Opus *)
                                                 (*------------------------*)

(*--------------------------------------------------------------------------*)
(* Area attributes (limit or describe the behavior of an area)              *)
(*--------------------------------------------------------------------------*)

Const  SYSMAIL      = $0001; (* is a mail area                                *)
Const  P_REP        = $0002; (* OPUS: Net mail private echomail back. NOT USED*)
Const  ALLOW_RECEIPT= $0002; (* SX:   allow receipts to be generated          *)
Const  NOPUBLIC     = $0004; (* OPUS: Disallow public messages                *)
Const  NOPRIVATE    = $0008; (* OPUS: Disallow private messages               *)
Const  ANON_OK      = $0010; (* OPUS: Enable anonymous messages               *)
Const  ECHOMAIL     = $0020; (* OPUS: Set=Echomail Clear=Not Echomail         *)
Const  OPUS_UALIAS  = $0040; (* OPUS170: Use user's alias in this area        *)
Const  HIGHBIT      = $0040; (* MAX:  Allow high-bit chars in this area       *)
Const  PASSTHROUGH  = $0080; (* OPUS170: Passthough Area only                 *)
Const  INBOUND      = $0100; (* OPUS170: Inbound Only area                    *)
Const  NREALNAME    = $0200; (* MAX:  Don't use ^aREALNAME for this area      *)
Const  USEREALNAME  = $0400; (* MAX:  Use usr.name instead of alias           *)
Const  CONF         = $0800; (* MAX:  Conference-type area (no origin/sb's)   *)
Const  MAX_UALIAS   = $1000; (* MAX:  Use usr.alias instead of usr.name       *)

IMPLEMENTATION

END.
