(* Example #1

  Search for a particular Conference and display the TO field for
  each message in the conference.

*)

Uses FidoFmt,
     OpxLib;

Var fvx  : file of TMailIdxType;
    fv   : file;
    mx   : TMailIdxType;
    mh   : TMailHdrType;
    mhdr : TFidoMsgType;
    w    : integer;

Const
    SearchArea  : word = 10;

begin

  assign(fvx,'mail.idx');
  reset(fvx);

  assign(fv,'mail.dat');
  reset(fv,1);

  while not eof(fvx) do
     begin
       read(fvx,mx);
       if mx.area = SearchArea then
          begin
            writeln('Conference area : ',mx.area);
            seek(fv,mx.fpos);
            while not eof(fv) do
               begin
                 (* read mail.dat header, double check conference # *)

                 blockread(fv,mh,sizeof(mh),w);
                 if mh.iarea <> SearchArea then break;

                 (* read message header *)

                 blockread(fv,mhdr,sizeof(mhdr),w);
                 writeln('TO : ',Mhdr.ToWhom);

                 (* go to next header *)
                 seek(fv,filepos(fv)+mh.fsize-sizeof(mhdr));

               end;
            break;
          end;
     end;

  close(fv);
  close(fvx);

end.
