#include "loadcfg.h"
#include <direct.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <stdio.h>
#include <string.h>
#include <sys\stat.h>
#include <sys\types.h>

void InitCfg()
 {
  char buf[512] ;

  getcurdir(0,buf) ;
  sprintf(Config.MainDir,"%c:\\%s",getdisk()+'A',buf) ;
  sprintf(Config.WorkDir,"%s\\WORK",Config.MainDir) ;
  sprintf(Config.PKTInDir,"%s\\PKTIN",Config.MainDir) ;
  sprintf(Config.PKTOutDir,"%s\\PKTOUT",Config.MainDir) ;
  sprintf(Config.UserFile,"%s\\NEWSGATE.USR",Config.MainDir) ;
  sprintf(Config.LogFile,"%s\\NEWSGATE.LOG",Config.MainDir) ;
  sprintf(Config.BadGuys,"%s\\NEWSGATE.BAD",Config.MainDir) ;
  Config.MsgSize = 2048 ;
  Config.SplitSize = 16 ;
  Config.FirstNo = 30 ;
  Config.FidoFlags = FIDOFL_SEENBY|FIDOFL_ORIGIN ;
  Config.LogItems = LOG_ERR|LOG_WAR|LOG_TRA|LOG_INF ;
  Config.RasFlags = RASFL_BEFWAIT|RASFL_MINIM ;
  Config.Retries = 1 ;
  Config.BadFlags = BADFL_ASTERISK ;
 }

SaveCfg()
 {
  struct NwsgHdr nh ;
  struct NNTPServer *nntp ;
  struct Group *grp ;
  int file ;

  memset(&nh,0,sizeof(nh)) ;
  nh.Version = VERSION ;
  nh.CfgSize = sizeof(struct NwsgCfg)-sizeof(struct NNTPServer *) ;
  nh.NNTPSize = sizeof(struct NNTPServer)-sizeof(struct NNTPServer *)-
                sizeof(struct Group *) ;
  nh.GroupSize = sizeof(struct Group)-sizeof(struct Group *) ;
  nh.Magic = CONFIG_MAGIC ;

  Config.NNTPNo = 0 ;
  nntp = Config.NNTP ;
  while(nntp)
   {
    nntp->GroupsNo = 0 ;
    grp = nntp->GroupList ;
    while(grp)
     {
      nntp->GroupsNo++ ;
      grp = grp->Next ;
     }
    Config.NNTPNo++ ;
    nntp = nntp->Next ;
   }
  file = _open("NEWSGATE.CFG",_O_CREAT|_O_BINARY|_O_TRUNC|_O_WRONLY,_S_IWRITE|_S_IREAD) ;
  if(file == -1)
   return(0) ;
  if(_write(file,&nh,sizeof(nh)) != sizeof(nh))
   {
    _close(file) ;
    return(0) ;
   }
  if(_write(file,&Config,nh.CfgSize) != nh.CfgSize)
   {
    _close(file) ;
    return(0) ;
   }
  nntp = Config.NNTP ;
  while(nntp)
   {
    if(_write(file,nntp,nh.NNTPSize) != nh.NNTPSize)
     {
      _close(file) ;
      return(0) ;
     }
    grp = nntp->GroupList ;
    while(grp)
     {
      if(_write(file,grp,nh.GroupSize) != nh.GroupSize)
       {
        _close(file) ;
        return(0) ;
       }
      grp = grp->Next ;
     }
    nntp = nntp->Next ;
   }
  _close(file) ;
  return(1) ;
 }
