#define LOG_ALL  1
#define LOG_WAR  2
#define LOG_TRA  4
#define LOG_INF  8
#define LOG_ERR  16

#define FIDOFL_PATH     1
#define FIDOFL_SEENBY   2
#define FIDOFL_ORIGIN   4

#define NNTPFL_ACTIVE   1
#define NNTPFL_NEWNEWS  2
#define NNTPFL_FASTRECV 4

#define GRPFL_UNACTIVE  1
#define GRPFL_LIMITON   2
#define GRPFL_BADGUYS   4
#define GRPFL_8BIT      8
#define GRPFL_WINDOWS   16

#define RASFL_HIDEDLG   1
#define RASFL_AFTER     2
#define RASFL_BEFWAIT   4
#define RASFL_BEFORE    8 
#define RASFL_MINIM     16

#define BADFL_ENABLE    1
#define BADFL_ASTERISK  2

#define CFGFL_BUSY      1

struct Group
 {
  char Name[80], FidoTag[80] ;
  short MaxLines, DupeBoard, Flags ;
  struct Group *Next ;
 } ;

struct NNTPServer
 {
  char Address[80], User[80], Pass[80] ;
  short Port, Flags, TimeOut ;

  short GroupsNo ;
  struct NNTPServer *Next ;
  struct Group *GroupList ;
 } ;

struct NwsgCfg
 {
  char LogItems ;
  char MainDir[512], WorkDir[512], PKTInDir[512] ;
  char PKTOutDir[512], UserFile[512], LogFile[512] ;
  unsigned short GateZ,GateN,GateF,GateP ;
  unsigned short RouteZ,RouteN,RouteF,RouteP ;
  unsigned short MsgSize, SplitSize, FirstNo, FidoFlags ;
  char PktPass[9], Origin[51] ;

  short NNTPNo ;
  short Retries, RasFlags ;
  char External[512], RasEntry[256] ;
  char BadGuys[512] ;
  short BadFlags ;
  char Header[512], Footer[512], Organization[80], Identifier[80] ;
  short Flags, Crosspost ;
  char UUCPName[36] ;
  short UUCPZ, UUCPN, UUCPF, UUCPP ;
  struct NNTPServer *NNTP ;
 } ;

#define CONFIG_MAGIC 0x4EF67BA1
#define VERSION 1

struct NwsgHdr
 {
  unsigned long Magic ;
  short Version ;
  short CfgSize, NNTPSize, GroupSize ;
  short Reserved[12] ;
 } ;

extern struct NwsgCfg Config ;
extern SaveCfg(), LoadCfg() ;
extern void InitCfg() ;
