#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\stat.h>
#include <sys\types.h>

#include "loadcfg.h"

struct NwsgCfg Config ;

void FreeCfg()
 {
  struct NNTPServer *nntp,*nntp2 ;
  struct Group *grp,*grp2 ;

  nntp = Config.NNTP ;
  while(nntp)
   {
    grp = nntp->GroupList ;
    while(grp)
     {
      grp2 = grp->Next ;
      free(grp) ;
      grp = grp2 ;
     }
    nntp2 = nntp->Next ;
    free(nntp) ;
    nntp = nntp2 ;
   }
 }

LoadCfg()
 {
  struct NwsgHdr nh ;
  struct NNTPServer *nntp ;
  struct Group *grp ;
  int file,i,j ;

  memset(&nh,0,sizeof(nh)) ;
  file = _open("NEWSGATE.CFG",_O_BINARY|_O_RDONLY,_S_IWRITE|_S_IREAD) ;
  if(file == -1)
   return(0) ;
  if(_read(file,&nh,sizeof(nh)) != sizeof(nh))
   {
    _close(file) ;
    return(0) ;
   }
  if((nh.Version > VERSION) || (nh.Magic != CONFIG_MAGIC))
   {
    _close(file) ;
    return(0) ;
   }
#ifndef SAVECFG
  memset(&Config,0,sizeof(Config)) ;
#endif
  if(_read(file,&Config,nh.CfgSize) != nh.CfgSize)
   {
    _close(file) ;
    return(0) ;
   }
  for(i = 0 ; i < Config.NNTPNo ; i++)
   {
    nntp = malloc(sizeof(struct NNTPServer)) ;
    if(nntp == NULL)
     {
      FreeCfg() ;
      _close(file) ;
      return(-1) ;
     }
    memset(nntp,0,sizeof(struct NNTPServer)) ;
    if(_read(file,nntp,nh.NNTPSize) != nh.NNTPSize)
     {
      FreeCfg() ;
      _close(file) ;
      return(0) ;
     }
    for(j = 0 ; j < nntp->GroupsNo ; j++)
     {
      grp = malloc(sizeof(struct Group)) ;
      if(grp == NULL)
       {
        FreeCfg() ;
        _close(file) ;
        return(-1) ;
       }
      memset(grp,0,sizeof(struct Group)) ;
      if(_read(file,grp,nh.GroupSize) != nh.GroupSize)
       {
        FreeCfg() ;
        _close(file) ;
        return(0) ;
       }
      grp->Next = nntp->GroupList ;
      nntp->GroupList = grp ;
     }
    nntp->Next = Config.NNTP ;
    Config.NNTP = nntp ;
   }
  _close(file) ;
  return(1) ;
 }
