// Email Validator for Webv4 
// by ~mortifis 2020/10/07
// $Id: emailval.js,v 1.7 2019/07/15 04:41:35 rswindell Exp $
/*******************************************************************************
Originally based on:
FILE: emailval.js v0.2
BY  : Michael J. Ryan (http://tracker1.info/)
ON  : 2005-02-14

TABS: 4 character tabstops.

--------------------------------------------------------------------------------
This is a simple telnet email validation script.

This script has been modified for use with sbbs webv4.
put it in your .../webv4/pages and save as emailval.ssjs


Installation instructions for emailval.js (requires SBBS 3.12a+)

STEP 1:
First, make sure that you have two Security Levels setup in order to use the
Email validation system.. one setting for new users (unvalidated) and another
that is intended for validated users.

STEP 2:
Edit ctrl/modopts.ini in a text editor and edit the following values in the
[emailval] section (create if it necessary) to match your pre-validation and
post-validation security levels.
        level_before_validation (default: 50)
		level_after_validation (default: 60)
		flags1_after_validation (default: no change)
		flags2_after_validation (default: no change)
		flags3_after_validation (default: no change)
		flags4_after_validation (default: no change)
		exemptions_after_validation (default: no change)
		restrictions_after_validation (default: no change)
		expiration_after_validation (default: false)
		expiration_days_after_validation (default: no change)

Note: the flags, exemptions, and restrictions .ini values support 'A' through
      'Z' with the optional '+' (add) and '-' (remove) modifiers.
	      e.g. "+A-B" to add the A flag and remove the B flag
	      e.g. "AB" to change the flag set to just "AB"
	  Numeric values are supported for assignment (not modification).
	      e.g. 0 = no flags, 1 = A, 2 = B, 4 = C, 8 = D, etc.

STEP 3:
add the following to the [logon] section of your ctrl/modopts.ini file:
    email_validation = true

or, if using logon.bin/src
    EXEC "?emailval.js"
    
    

That's it!
*******************************************************************************/

var options = load("modopts.js", "emailval");
if(!options)
	options = {};
if(options.level_before_validation === undefined)
	options.level_before_validation = 20;
if(options.level_after_validation === undefined)
	options.level_after_validation = 50;

//other constants, shouldn't need changing.
var cValChars='ACDEFHJKLMNPQRTUVWXY23456789!@#$%&*';
var cPrevalText = "telvalcode";
var cValCodeLen = 10;
// use ../text/menu/telval.msg
var useAnsi = false;

//include SBBS Definition constants
require("sbbsdefs.js", 'NET_NONE'); 

//gets the validation code in use, if any, otherwise sets/returns a new code.
function GetValidationCode() {
	var val = user.comment;
	if (val.indexOf(cPrevalText) == -1)
		return SetValidationCode(); //return a new code.
	
	//parse/return the existing code.
	return val.substr(val.indexOf(cPrevalText) + cPrevalText.length + 1, cValCodeLen);
}

//sets/returns a new validation code.
function SetValidationCode() {
	var val='';

	for (var i=0;i<cValCodeLen;i++)
		val+=cValChars.substr(parseInt(Math.random() * cValChars.length), 1);
		
	user.comment = cPrevalText + ":" + val;
	return val;
}

function refresh() {
	writeln('<meta http-equiv="refresh" content="2; url=?page=emailval.ssjs">');
	exit(0);
}

function SendValidationEmail() {
	var val = GetValidationCode(); //reuses the last code emailed, if available.
	
	/* Generate and send email */
	var hdrs = new Object();
	hdrs.to=user.name;
	hdrs.to_net_type=netaddr_type(user.netmail);
	if(hdrs.to_net_type!=NET_NONE) {
		hdrs.to_net_addr=user.netmail;
	} else {
		writeln("<br>Cannot send validation code to new email address!<br><br>");
		refresh();
	}
	hdrs.from=system.name;
	hdrs.from_net_addr='sysop@'+system.inet_addr;
	hdrs.from_net_type=NET_INTERNET;
	hdrs.subject="Email validation for " + system.name;
	var msgbase = new MsgBase("mail");
	if(msgbase.open!=undefined && msgbase.open()==false) {
		writeln("<br><font color=red>ERROR:" + msgbase.last_error + "</font><br>");		
		msgbase.close();
		refresh();
	}
	var msg="CODE: " + val + "\n\n";
	msg += "You may now return to " + system.name + " and validate your account.";

	if(!msgbase.save_msg(hdrs,msg))  {
		writeln("<br><font color=red>ERROR: " + msgbase.last_error + "</font><br>");
		
		msgbase.close();
		refresh();
	}

	msgbase.close();
	writeln("Validation code sent to " + user.netmail + "<br><br>");
	writeln("If you do not recieve your validation code, please report ");
	writeln("to sysop@alleycat.synchro.net<br><br>");
	mswait(1000);
	refresh();
}

function update_email() {
	writeln('Updating Email Address to ' + http_request.query['new_email'][0]+'<br>Resetting Validation Code.<br><br>');
	user.netmail = http_request.query['new_email'][0];
	var old_val = SetValidationCode() 
	writeln('<meta http-equiv="refresh" content="2; url=?page=emailval.ssjs">');
}

function ChangeEmailAddress() {
	writeln('<form action="?page=emailval.ssjs" method="post">');
	writeln('New Email Address: <input type="text" name="new_email" value="'+user.netmail+'" size=25>');
	writeln("<input type=submit value=\'Update Email Address\'> ");
	writeln('<input type="hidden" name="opt" value="update_email">');
	writeln('</form>');
}

function validate_code() {
	var val = GetValidationCode(); //SHOULD get the validation code sent.
	var valu = http_request.query['code'][0].toUpperCase();
	
		if (val.toUpperCase() == valu.toUpperCase()) {
			writeln("<br><br><font color=green>Validated!</font><br><br>");
			user.security.level = options.level_after_validation;
			if(options.flags1_after_validation !== undefined)
				user.security.flags1 = options.flags1_after_validation;
			if(options.flags2_after_validation !== undefined)
				user.security.flags2 = options.flags2_after_validation;
			if(options.flags3_after_validation !== undefined)
				user.security.flags3 = options.flags3_after_validation;
			if(options.flags4_after_validation !== undefined)
				user.security.flags4 = options.flags4_after_validation;
			if(options.exemptions_after_validation !== undefined)
				user.security.exemptions = options.exemptions_after_validation;
			if(options.restrictions_after_validation !== undefined)
				user.security.restrictions = options.restrictions_after_validation;
			if(options.expiration_after_validation == true) {
				if(options.expiration_days_after_validation)
					user.security.expiration_date = time() + options.expiration_days_after_validation * 24 * 60 * 60;
			} else
				user.security.expiration_date = 0;
			
			user.comment = cPrevalText + ":" + val + " validated on " + (new Date());
		} else {
			writeln("<br><br><font color=red>Code doesn't match!</font><br><br>");
		}
	refresh();
}

function EnterValidationCode() {	
	writeln("<form action='?page=emailval.ssjs' method='post'>");
	writeln("Enter the validation code: <input type='text' size=15 name='code'><br><br>");
	writeln('<input type=hidden name="opt" value="validate_code"><input type=submit value="Validate"></form>');
}


function CheckValidation() {
		writeln("Telnet validation for <font color=green>" + user.alias + " #" + user.number + "</font><br><br>");
		writeln("You have created an account with an email address that must be validated.<br><br>")
		writeln('<form action="?page=emailval.ssjs" method="post">');
		writeln("<input type = \'radio\' name=\'opt\' value=\'send_val\'> Send validation code to <font color=green> " + user.netmail + "</font><br>");
		writeln("<input type = \'radio\' name=\'opt\' value=\'validate\'> Validate your account<br>");
		writeln("<input type = \'radio\' name=\'opt\' value=\'update\'> Update/Edit email address: "+user.netmail+"<br>");
		writeln("<input type = \'radio\' name=\'opt\' value=\'send_sysop\'> Send Feedback to: <font color=green>"+system.operator+'</font><br><br>');
		writeln("<input type=submit value=\'Your Selection\'> ");
		writeln('</form>');		
}

function send_feedback() {
	var sysop = new User(1);
	
	writeln('Sending Feedback to: '+sysop.alias+'<br><br>');
	writeln('Netmail Address: '+sysop.netmail+'<br><br>');
	
	/* Generate and send sysop feedback */
	var hdrs = new Object();
	hdrs.to=system.operator;
	hdrs.to_net_type=netaddr_type(sysop.netmail);
	if(hdrs.to_net_type!=NET_NONE) {
		hdrs.to_net_addr=sysop.netmail;
	} else {
		writeln("<br>Cannot send Feedback to '+system.operator+'!<br><br>");
		exit(0);
		refresh();
	}
	hdrs.from=user.name;
	hdrs.from_net_addr=user.netmail;
	hdrs.from_net_type=NET_INTERNET;
	hdrs.subject="webv4 Email Validation Feedback from " + system.name;
	var msgbase = new MsgBase("mail");
	if(msgbase.open!=undefined && msgbase.open()==false) {
		writeln("<br><font color=red>ERROR:" + msgbase.last_error + "</font><br>");		
		msgbase.close();
		refresh();
	}
	
	msg = '\r\n\r\n'+http_request.query['feedback'][0];

	if(!msgbase.save_msg(hdrs,msg))  {
		writeln("<br><font color=red>ERROR: " + msgbase.last_error + "</font><br>");
		
		msgbase.close();
		refresh();
	}

	msgbase.close();
	writeln("Feedback sent to " + system.operator + "<br><br>");
	writeln("If you do not recieve a reply within 2 days, please report to "+ system.operator+"@"+system.inet_addr+"<br><br>");	
	mswait(1000);
	refresh();	
	
}
	
writeln('<font color=green size=+2>Some kind of email validator thingy</font><br><br>');

if(user.alias === 'Guest') {
	writeln('<font size=+3 color=red>Guest must login in order to be Vaildated</font><br><br>');
	exit(0);
}

if(user.security.level >= options.level_after_validation) {
	writeln('<font size=+2 color=green>You are already Validated!</font><br>');
		writeln('<meta http-equiv="refresh" content="2; url=?page=index.xjs">');
	exit(0);
}

if(!http_request.query['opt']) {
		http_request.query['opt'] = 'do_shit';		
}

if(http_request.query['opt'][0] === 'send_feedback' ) {
		send_feedback();
}


if(http_request.query['opt'][0] === 'update' ) {
		ChangeEmailAddress();
}

if(http_request.query['opt'][0] === 'update_email' ) {
		update_email();
}

if(http_request.query['opt'][0] === 'validate_code' ) {
		validate_code();
}

if(http_request.query['opt'][0] === 'validate' ) {
	EnterValidationCode()
}

if(http_request.query['opt'][0] === 'send_sysop') {	
		
		writeln('Feedback to '+system.operator+'<br><br>');
		writeln('<form action="?page=emailval.ssjs" method="post">');
		writeln('Message: <br><textarea name="feedback" rows=5 cols=50 autofocus></textarea><br><br>');
		writeln("<input type=submit value=\'Send Feedback\'> ");
		writeln('<input type="hidden" name="opt" value="send_feedback">');
		writeln('</form>');
		
}

if(http_request.query['opt'][0] === 'send_val' ) {
		SendValidationEmail()
}


if(http_request.query['opt'] === 'do_shit')
	CheckValidation(); 