
		
(function () {
    try {	
    		// Your 5 Day Weather
		load("sbbsdefs.js");
		var path = '/sbbs/temp/';
		var num_deleted = 0;
		var match_file = 'openweathermap';
		if (path.indexOf('*')<0 && path.indexOf('?')<0) path += "*";
		 dir = directory(path,GLOB_PERIOD);	    
		    for (i in dir)  {
			if(dir[i].match(match_file)) {
				 var f = new File(dir[i])
				f.remove();
				num_deleted +=1;				
			}
		    }
		load('geoip.js');
		var geoip = get_geoip( http_request.header['x-forwarded-for'] || http_request.remote_ip);
		require('openweathermap.js', 'OpenWeatherMap');
		var owm = new OpenWeatherMap();
		var wq = { units: 'metric', mode: 'json' };	
		
		if (geoip.latitude && geoip.longitude) {
            		wq.lat = geoip.latitude;
            		wq.lon = geoip.longitude;
        	} else 
		if (geoip.cityName) {
            		wq.q = geoip.cityName;
        	}

		var city = geoip.cityName + ', ' + geoip.countryName; // For Display Only
	
		var fc = owm.call_api('forecast', wq);

		writeln('<center>OpenWeatherMap 5 Day/3 Hour Forecast for ' + city  + '</center><hr><br>');

		fc.list.forEach(function (e) {
			var ts = Math.round((new Date()).getTime() / 1000);
			if(e.dt >= ts-84600) { // Doesn't list weather 15 minutes prior to next 3 hour block
				writeln(system.timestr(e.dt) + ': <br>');
				writeln('<img src=http://openweathermap.org/img/wn/'+e.weather[0].icon+'@2x.png height=50 width=50>');
				writeln(e.main.temp_max+'&#176;C, ' );    
    				writeln(e.weather[0].main + ', ' + e.weather[0].description);		    
    				writeln(e.clouds.all + '% clouds');
    			//	writeln('seconds left until tomorrow '+ secsLeft(e.dt));
				    
    				print("<br><br><br>");
    			}
	});
}
catch (err) {
        	writeln('ERROR: ' + err + '<br><br>');		
 	    }
}) ();

