/* Country Of Origin Blocking v.01 ~mortifis 11-14-2019 */
/*
	Uses modopts.ini 
	[coob]
		enabled = false;
		ip.can = false;
		block = A1,A2,01,CN
		
	to use this, put coob.js in your /sbbs/exec directory
	(or /sbbs/exec/load, or /sbbs/mods)
	edit your exec/login.js and add the line  load('coob.js');	
	right after bbs.nodesync(); (line 32 in current login.js version)
	then add the above [coob] entries in your modopts.ini file,
	editing for Country Code as needed (all on one line no spaces)
	see: https://dev.maxmind.com/geoip/legacy/codes/iso3166/ for Country Codes
			
*/

var block = load({}, 'modopts.js', 'coob');
var countries = load('modopts.js', 'coob', 'block');

load('geoip.js', true);
var coob =  get_geoip(client.ip_address, true);

if(!block.quiet) log('COOB v0.1 Validating Country Code ' + coob.countryCode);

if(countries != undefined) var twit = countries.split(',');

if (block && block.enabled && twit != undefined) {
	if(!block.quiet) log('Reading COOB for '+coob.countryCode + '...');
	
	for(var i=0; i < twit.length; i++) {
		if(!block.quiet) if(coob.countryCode.toUpperCase() === twit[i].toUpperCase()) {
			if(!block.quiet) log('Country '+twit[i].toUpperCase() + ' Blocked');
						
			console.writeln('\r\n\1rAccess Denied ... Hanging Up!');
			console.writeln("");
			
			if(block.ip_can) {
				if(!block.quiet) log('Adding Blocked Country IP to ip.can'); 
				system.filter_ip(client.protocol, 'Country Assess Denied'+twit[i], client.host_name, client.ip_address);
				mswait(1000);
			}
					
			 bbs.hangup();
			 exit(0);
		}
	}	
}
else
{
	if(!block.quiet) log('COOB Disabled, ignoring GeoIP Location for '+client.ip_address);
}
