/* Last Callers for Synchronet BBS 3.14a or higher.
 * 
 * Version: 1.0
 * Created: 2008-05-26
 * Author: Mark Zolton (mark@zolton.org)
 * Credit: tracker1 (theroughnecks.net) - 
 *         For the methodology used to retieve the last callers. 
 */

/* Includes */
load("sbbsdefs.js");
load("date.js");

/* Constants */
var MAX_CALLERS = 10;
var HEADER_FILE = "lastcallers";

/* Returns a list of users sorted by their laston_date (descending). */
function getLastCallers()
{
    var users = new Array(); // The list of users.
    var lastUser = system.lastuser; // The last user.
    
    // Callback function to sort by last on date.
    var byLastOn = function(a, b)
    {
        if (a.stats.laston_date < b.stats.laston_date){ return -1 };
        if (a.stats.laston_date > b.stats.laston_date){ return 1 };
        if (a.stats.laston_date == b.stats.laston_date){ return 0 };
    }
    
    for(var i = 1; i <= lastUser; i++)
    {
        var user = new User(i);
    
        // Make sure the user has logged on, isn't a guest, and isn't deleted.
        if ((user.stats.total_logons > 0) && 
        (user.compare_ars("NOT GUEST")) &&
        ((user.settings & USER_DELETED) != USER_DELETED))
        {
            users.push(user);
        }
    }
     
    // Sort users by last on date.
    users.sort(byLastOn);
    
    // Descending
    users.reverse();
    
    return users;
}

/* Displays the header file. */
function displayHeader()
{
    console.clear();
    bbs.menu(HEADER_FILE);
    console.gotoxy(0,20);
}

/* Display the first n users in the given array. */
function displayLastCallers(users, limit)
{
    for(var i = 0; (i < users.length) && (i < limit); i++)
    {
        var alias = formatString(users[i].alias, 16);
            alias = colorizeString(alias);
        var location = formatString(users[i].location, 20);
            location = colorizeString(location);
        var lastOn = formatDate(new Date(system.timestr(users[i].stats.laston_date)), "NNN. dd, y hh:mma");
            lastOn = formatString(lastOn, 22);
            lastOn = colorizeString(lastOn);
        var mode = formatString(users[i].connection, 8); 
            mode = colorizeString(mode);
           
        var age = users[i].age;
        if(users[i].age <= 0) 
        { 
            age = "   "; 
        }
        else 
        { 
            age = formatString(age, 3); 
            age = colorizeString(age);
        }
        
        var lastCallerStr = alias + " " + age + " " + location + " " + lastOn + " " + mode;
           
        console.gotoxy(4, 8 + i); 
        console.print(lastCallerStr);
    }
}

/* Formats the given string to the specified length, padding if necessary. */
function formatString(str, length)
{
    var padding = "                                        ";
    
    str = str + padding;
    str = str.substring(0, length);
    
    return str;
}

/* Returns a colorized version of the specified string. */
function colorizeString(str)
{   
    str = str.replace(/(\W)/g, "\1h\1w$1\1n\1c");
    str = str.replace(/(^[a-z0-9])/ig, "\1h\1c$1\1n\1c");   
    return "\1n\1c" + str;
}

/* Main */
function main()
{
    displayHeader();
    displayLastCallers(getLastCallers(), MAX_CALLERS);
  
    console.gotoxy(0,21);
    console.pause();
    console.clear();
}

main();