SystemOrganization addCategory: #Gopher!

Object subclass: #GopherBrowser
	instanceVariableNames: 'page book'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gopher'!

!GopherBrowser commentStamp: 'ck 9/17/2018 17:22' prior: 0!
A GopherBrowser is an interface for browsing gopher pages.

It uses a BookMorph to do its job.

Update: 
(HTTPClient httpGet: 'http://pestilenz.org/~ckeen/Gopher.st') fileIn
GopherBrowser new.

TODOs: resize events and textmorph size is not quite correct.!

!GopherBrowser methodsFor: 'as yet unclassified' stamp: 'ck 9/18/2018 13:34'!
initialize
	| window |
	window := BookMorph new.
	window maintainsUniformPageSize: true.
	window pageSize: 600@1000.
	page := GopherPage
				getPage: '/ckeen'
				as: $1
				model: self
				selector: #newPageFor:
				fromHost: 'vernunftzentrum.de'
				port: 70.
	window openInWorld.
	book := window.! !

!GopherBrowser methodsFor: 'as yet unclassified' stamp: 'ck 9/18/2018 11:11'!
newPageFor: aPage
	| morph |
	morph := aPage asMorph.
	book insertPage: morph pageSize: morph extent.! !

!GopherBrowser methodsFor: 'as yet unclassified' stamp: 'ck 9/15/2018 18:48'!
reload
	page reload! !

!GopherBrowser methodsFor: 'as yet unclassified' stamp: 'ck 9/18/2018 14:27'!
url: aGopherUrlString
	| parts page hostport host port scheme selector type |
	selector := ''.
	type := $1.
	parts := aGopherUrlString findTokens: '/'.
	scheme := parts at: 1.
	(scheme = 'gopher:')  ifTrue: [ parts := parts allButFirst].
	hostport := (parts at: 1) findTokens: ':'.
	host := hostport at:1.
	(hostport size = 2) 
		ifTrue: [ port := (hostport at: 2) asNumber ]
		ifFalse: [ port := 70 ].
      (parts size = 3)
		ifTrue: [ type := (parts at: 2) asCharacter.
				selector := parts at: 3.].
	(parts size = 2)
		ifTrue: [ type := (parts at: 2) first.
				selector:=(parts at: 2) allButFirst ].

	page := GopherPage
				getPage: selector
				as: type
				model: self
				selector: #newPageFor:
				fromHost: host
				port: port.
! !

Object subclass: #GopherItem
	instanceVariableNames: 'description port item host selector raw controller'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gopher'!

GopherItem subclass: #FileItem
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gopher'!

!FileItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:48'!
initialize
	super initialize.
	self item: $0! !

!FileItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 16:09'!
printOn: aStream
aStream 
	nextPutAll: '[ f ] ';
	nextPutAll: (self description);
	cr;
	endEntry.! !

GopherItem subclass: #GifItem
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gopher'!

!GifItem methodsFor: 'as yet unclassified' stamp: 'ck 9/18/2018 11:38'!
initialize
	super initialize.
	self item: $g! !

!GopherItem class methodsFor: 'as yet unclassified' stamp: 'ck 9/18/2018 13:31'!
fromString: aString
| t item|
t := OrderedCollection new. 
aString tabDelimitedFieldsDo: [:f | t add: f].
item _ (t at: 1) first.
^(self newClassFor: item)	
	description: (t at: 1) allButFirst;
	selector: (t at: 2);
	host: (t at: 3 ifAbsentPut: '');
	port: (t at: 4 ifAbsentPut: 0);
	raw: aString.
! !

!GopherItem class methodsFor: 'as yet unclassified' stamp: 'ck 9/18/2018 11:38'!
newClassFor: anItem
 | types |
types _ Dictionary newFrom:
	  	{ 
		$i -> #InfoItem.
		$1 -> #MenuItem.
		$0 -> #FileItem.
		$I -> #ImageItem.
		$g ->#GifItem.
		}.
^ ((GopherItem subclasses select: [ :c | c name == (types at: anItem ifAbsent: [ ^GopherItem new ])]) at: 1) new.! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/15/2018 17:07'!
asText
| link |
link := PluggableTextAttribute new
	evalBlock: [self controller loadItem: self].
^ (Text new)
	append: (self description);
	addAttribute: link;
	append: String cr.! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/15/2018 16:05'!
controller
^ controller! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/15/2018 16:06'!
controller: aGopherBrowser
controller := aGopherBrowser! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:44'!
description
^ description ! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:45'!
description: aString
description := aString! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:45'!
host
^ host! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:45'!
host: aString
host := aString! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:45'!
item
^ item! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:45'!
item: anItem
item := anItem! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:45'!
port
^ port! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:45'!
port: aNumber
port := aNumber ! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:46'!
printOn: aStream
aStream 
	nextPutAll: '[ ';
	nextPut: $?;
	nextPutAll: ' ] ';
	nextPutAll: (self description);
	newLine.! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/15/2018 15:38'!
raw
^ raw! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/15/2018 15:38'!
raw: aString
raw := aString! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:46'!
selector
^ selector! !

!GopherItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:46'!
selector: aString
selector := aString! !

GopherItem subclass: #ImageItem
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gopher'!

!ImageItem methodsFor: 'as yet unclassified' stamp: 'ck 9/18/2018 11:36'!
initialize
	super initialize.
	self item: $I! !

GopherItem subclass: #InfoItem
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gopher'!

!InfoItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 22:43'!
asText
^ Text fromString: (self description), String cr.! !

!InfoItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:48'!
initialize
	super initialize.
	self item: $i! !

!InfoItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 16:27'!
printOn: aStream
aStream 
	nextPutAll: (self description);
	cr.! !

GopherItem subclass: #MenuItem
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gopher'!

!MenuItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:49'!
initialize
	super initialize.
	self item: $1! !

!MenuItem methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 23:52'!
printOn: aStream
aStream nextPutAll: '-> ';
	nextPutAll: (self description);
	cr.! !

Object subclass: #GopherPage
	instanceVariableNames: 'host port selector gopherSelector type rawData target model'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gopher'!

GopherPage class
	instanceVariableNames: 'controller'!

GopherPage class
	instanceVariableNames: 'controller'!

!GopherPage class methodsFor: 'as yet unclassified' stamp: 'ck 9/15/2018 18:40'!
getPage: aSelectorString as: aType for: aModel fromHost: aString port: aNumber
"initialise a GopherPage"

^ (GopherPage new)
	host: aString;
	port: aNumber;
	pageType: aType;
	model: aModel;
	pageSelector: aSelectorString;
	reload;
	yourself.! !

!GopherPage class methodsFor: 'as yet unclassified' stamp: 'ck 9/17/2018 16:29'!
getPage: aSelectorString as: aType model: aModel selector: aSelector fromHost: aString port: aNumber
"initialise a GopherPage"

^ (GopherPage new)
	host: aString;
	port: aNumber;
	pageType: aType;
	model: aModel;
	selector: aSelector;
	pageSelector: aSelectorString;
	reload;
	yourself.! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/15/2018 21:56'!
asFileItem
| t r |
t := rawData findTokens: String crlf.
t := t allButLast.
r := Text new.
t do: [ :s | r append: ((GopherItem fromString: s) controller: self controller; asText)].
^ r.! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/15/2018 21:56'!
asMenu
| t r |
t := rawData findTokens: String crlf.
t := t allButLast.
r := Text new.
t do: [ :s | r append: ((GopherItem fromString: s) controller: self controller; asText)].
^ r.! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/18/2018 13:14'!
asMorph
	| morph |
	((self pageType == $I) or: (self pageType == $g))
	 	ifTrue: [|form|
			form := Form fromBinaryStream: (RWBinaryOrTextStream on: self rawData from: 1 to: self rawData size) binary.
			morph:= ImageMorph new image: form ]
	ifFalse: [morph := PluggableTextMorph new.
		morph setText: self asText.
		morph textMorph font: TextStyle defaultFixedFont.].
	^morph.! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/15/2018 22:00'!
asText
(self pageType == $1) ifTrue: [^ self asMenu].
^ self rawData asText.! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/15/2018 16:31'!
controller
	^ self! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:39'!
host
^ host! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:39'!
host: aString
host := aString.! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:37'!
initialize
	"set instance vars to defaults"

host := 'localhost'.
port := 70.
selector := ''.
rawData  := OrderedCollection new.
^self.! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/17/2018 16:45'!
loadItem: aGopherItem
host := aGopherItem host.
port:= aGopherItem port asInteger.
gopherSelector:= aGopherItem selector.
type := aGopherItem item.
self reload.! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/15/2018 18:41'!
model
^ model! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/15/2018 18:41'!
model: aModel
model := aModel! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/17/2018 16:34'!
pageSelector
^ gopherSelector ! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/17/2018 16:34'!
pageSelector: aString
gopherSelector := aString! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:43'!
pageType
^ type! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:43'!
pageType: aSymbol
type := aSymbol.! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:43'!
port
^ port! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:44'!
port: aNumber
port := aNumber.! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:44'!
rawData
^ rawData ! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/14/2018 15:44'!
rawData: anOrderedCollection
rawData := anOrderedCollection ! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/17/2018 16:44'!
reload
| stream  |

[stream := SocketStream openConnectionToHostNamed: (self host) port: (self port).
[[stream nextPutAll: (self pageSelector), String crlf; flush.
	self rawData: stream upToEnd.
	self model perform: (self selector) with: self]
	ensure: [stream close]]
		on: ConnectionTimedOut
		do: [:ex | Transcript show: ex asString; newLine. ex resume]] fork! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/17/2018 16:34'!
selector
^selector! !

!GopherPage methodsFor: 'as yet unclassified' stamp: 'ck 9/17/2018 16:33'!
selector: aSelector
selector := aSelector! !
